#! /bin/sh

if [ "$1" = "frame" -o -z "$1" ]; then
echo "Testing frame"
ds9 -debug -zscale img-32.fits img-32.fits -tile -lock frame wcs -mode pan
fi

if [ "$1" = "crosshair" -o -z "$1" ]; then
echo "Testing crosshair"
ds9 -debug -zscale img-32.fits img-32.fits -tile -lock crosshair wcs -mode crosshair
fi

if [ "$1" = "crop" -o -z "$1" ]; then
echo "Testing crop"
ds9 -debug -zscale img-32.fits -rgb img-32.fits -green img-32.fits -blue img-32.fits -tile -lock crop wcs -crop open -mode crop -rgb lock crop yes
ds9 -debug -zscale 3d.fits -3d 3d.fits -3d vp 45 30 -tile -lock crop wcs -mode crop
fi

if [ "$1" = "slice" -o -z "$1" ]; then
echo "Testing slice"
ds9 -debug -zscale 3d.fits -3d 3d.fits -3d vp 45 30 -tile -lock slice
fi

if [ "$1" = "bin" -o -z "$1" ]; then
echo "Testing bin"
ds9 -debug -zscale table.fits -rgb table.fits -green table.fits -blue table.fits -tile -lock bin -bin open -rgb lock bin yes
fi

if [ "$1" = "scale" -o -z "$1" ]; then
echo "Testing scale"
ds9 -debug -zscale img-32.fits -rgb img-32.fits -green img-32.fits -blue img-32.fits -tile -lock scale -scale open -rgb lock scale yes
fi

if [ "$1" = "color" -o -z "$1" ]; then
echo "Testing color"
ds9 -debug -zscale img-32.fits img-32.fits -rgb -red img-32.fits -green img-32.fits -blue img-32.fits -rgb lock colorbar yes -rgb -red img-32.fits -green img-32.fits -blue img-32.fits  -rgb lock colorbar yes -tile -lock colorbar yes -cmap open
fi

echo "Done"
