
#ifndef IIRBASE_ELEMENT_DECLARATION_HH
#define IIRBASE_ELEMENT_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_ElementDeclaration.hh,v 1.3 1999/05/19 19:04:13 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_ObjectDeclaration.hh"

class IIR_TypeDefinition;

class IIRBase_ElementDeclaration : public IIR_ObjectDeclaration {

public:
  IIR_Kind get_kind() {return IIR_ELEMENT_DECLARATION;}
  IIR_Char *get_kind_text() {return "IIR_ElementDeclaration";}

  void set_subtype( IIR_TypeDefinition *subtype );
  IIR_TypeDefinition *get_subtype();

protected:
  IIRBase_ElementDeclaration();
  virtual ~IIRBase_ElementDeclaration() = 0;
    
private:
  IIR_TypeDefinition *subtype;
};
#endif
