
#ifndef IIRBASE_INTERFACE_DECLARATION_HH
#define IIRBASE_INTERFACE_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_InterfaceDeclaration.hh,v 1.2 1999/03/09 20:50:37 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_ObjectDeclaration.hh"
#include "IIR_AttributeSpecificationList.hh"

class IIR_TypeDefinition;

class IIRBase_InterfaceDeclaration : public IIR_ObjectDeclaration {

public:

  IIR_Kind get_kind() {return IIR_INTERFACE_DECLARATION;}
  IIR_Char *get_kind_text() {return "IIR_InterfaceDeclaration";}

  void set_mode(IIR_Mode mode);
  IIR_Mode get_mode();

  void set_value(IIR* value);
  IIR* get_value();

protected:
  
  IIRBase_InterfaceDeclaration();
  virtual ~IIRBase_InterfaceDeclaration() = 0;
    
private:

  IIR* value;
  IIR_Mode mode;

};
#endif
