// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Allocator.cc,v 1.2 1999/03/09 20:52:48 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_Allocator.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_AccessTypeDefinition.hh"
#include "symbol_table.hh"
#include "set.hh"

IIRScram_Allocator::~IIRScram_Allocator() {}


void 
IIRScram_Allocator::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << "new ";
  get_type_mark()->_publish_vhdl(_vhdl_out);
  
  if( get_value() != NULL ){
    ASSERT( get_value()->_is_resolved() == TRUE );

    _vhdl_out << "'( ";
    get_value()->_publish_vhdl( _vhdl_out );
    _vhdl_out << " )";    
  }
}

ostream &
IIRScram_Allocator::_print( ostream &os ){
  os << "new ";
  os << *get_type_mark();

  return os;
}

set<IIR_TypeDefinition> *
IIRScram_Allocator::_get_rval_set( IIR_Boolean (IIR::*constraint_function)() ){
  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>();
  
  set<IIR_AccessTypeDefinition> *access_types;
  access_types = _get_symbol_table()->get_in_scope_access_types();
  
  IIR_TypeDefinition *current = access_types->get_element();
  while( current != NULL ){
    retval->add( current );
    current = access_types->get_next_element();
  }

  return retval;
}

void
IIRScram_Allocator::_type_check( set<IIR_TypeDefinition> * ){
  // Don't need to do anything...
}

void
IIRScram_Allocator::_publish_cc() {
  _cc_out << " *(new ";
  get_type_mark()->_publish_cc_type_name();
  _cc_out << "(ObjectBase::VARIABLE";
  if(get_type_mark()->_is_array_type() == TRUE) {
    get_type_mark()->_publish_cc_constructor_args();
    if (get_type_mark()->_is_unconstrained_array_type() == TRUE) {
      _cc_out << ", ";
      get_value()->_publish_cc_range();
    }
  }
  if(get_value() != NULL){
    _cc_out << ", ";
    get_value()->_publish_cc_initialization_value();
  }
  else {// don't know if this is entirly correct
    if(get_type_mark()->_is_scalar_type() == TRUE) {
      _cc_out << ", ";
      get_type_mark()->_publish_cc_type_name();
      _cc_out << "::LEFT()";
    }
  }
  _cc_out << "))";
}

void 
IIRScram_Allocator::_add_decl_into_cgen_symbol_table(){
  if(get_value() != NULL){
    get_value()->_add_decl_into_cgen_symbol_table();
  }
}
  
void
IIRScram_Allocator::_publish_cc_initialization_value(){
  if(get_value() != NULL){
    //_cc_out << ", ";
    if (get_value()->_get_subtype()->_is_scalar_type() == TRUE ||
	this->_get_subtype()->_is_access_type() == TRUE) {
      _cc_out << "*(";
      get_value()->_publish_cc_state_object_init();
      _cc_out << ")";
    }
    else {
      get_value()->_publish_cc_state_object_init();
    }
  }
  else {
    _cc_out << " *(";
    _cc_out << " new ";
    get_type_mark()->_publish_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE";
    if(get_type_mark()->_is_array_type() == TRUE) {
      get_type_mark()->_publish_cc_constructor_args();
    }
    _cc_out << "))";
  }
}

IIR_Boolean 
IIRScram_Allocator::_is_resolved(){
  ASSERT( get_type_mark() != NULL );
  return get_type_mark()->_is_resolved();
}

IIR_Boolean 
IIRScram_Allocator::_is_globally_static_primary(){
  ASSERT( get_type_mark() != NULL );
  return get_type_mark()->_is_globally_static();
}
