#ifndef IIRSCRAM_ARCHITECTURE_DECLARATION_HH
#define IIRSCRAM_ARCHITECTURE_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ArchitectureDeclaration.hh,v 1.4 1999/04/12 18:18:46 ssubrama Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_ArchitectureDeclaration.hh"

class IIRScram_ArchitectureDeclaration : public IIRBase_ArchitectureDeclaration {
public:
  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_binding_name(ostream &);
  void _publish_vhdl_with_library_name(ostream &);

  declaration_type _get_type();
  IIR_EntityDeclaration* _get_entity();

  void _publish_cc();
  void _publish_cc_declarations();
  void _publish_cc_elaborate();
  void _publish_cc_object_pointers_init();
  void _publish_cc_binding_name(ostream& outstream = _cc_out);
  void _publish_cc_signal_objects_init(int flag);
  void _publish_cc_scoping_prefix(IIR *, IIR *, ostream& = _cc_out);
  void _publish_cc_implicit_signals(IIR_DeclarationList *);
  
  set<IIR_Declaration> *_find_declarations( IIR_Name * );

#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, IIR_DeclarationList*,
			 char*);
  void _combine();
#endif

  void _make_interface_visible( symbol_table * );

  void _type_check();
  IIR_PortList *_get_port_list();
  IIR_GenericList *_get_generic_list();
  IIR_List *_get_statement_list();

  IIR_Boolean _is_iir_architecture_declaration(){ return TRUE; }
  IIR_Boolean _is_secondary_unit(){ return TRUE; }

  // This list holds the component declarations in this architectures
  // declarative region.  It will be used to post process
  // configuration specficiations such that ALL and OTHERS can be
  // resolved, and so that labels that are not declared until the
  // statement part can be resolved as well.
  IIR_DeclarationList *_get_component_declarations();
  void _set_component_declarations(   IIR_DeclarationList * );

  void _set_configuration_specifications( IIR_DeclarationList * );
  IIR_DeclarationList *_get_configuration_specifications();

  IIR_TypeDefinition *_get_subtype(){
    return NULL;
  }
  
  IIR_DeclarationList* _get_declaration_list();

  IIR* _get_enclosing_scope() { return NULL; }
  
protected:
  IIRScram_ArchitectureDeclaration();
  virtual ~IIRScram_ArchitectureDeclaration() = 0;
    
private:
  //These functions are used for generating code that is useful for doing 
  //dynamic elaboration
  void _publish_cc_class();
  void _publish_cc_headerfile();
  void _publish_cc_ccfile();
  void _publish_cc_constructor();
  void _publish_cc_constructor_with_no_arguments();
  void _publish_cc_constructor_with_arguments();
  void _publish_cc_instantiate();
  void _publish_cc_createNetInfo();
  void _publish_cc_connect();
  void _publish_cc_headerfiles_for_cc();

  void _publish_cc_blocks_elaborate();
#ifdef PROCESS_GRAPH
  void _publish_cc_driver_info();
#endif
};
#endif


