#ifndef IIRSCRAM_ARRAY_TYPE_DEFINITION_HH
#define IIRSCRAM_ARRAY_TYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ArrayTypeDefinition.hh,v 1.3 1999/08/02 12:49:58 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ArrayTypeDefinition.hh"
#include "set.hh"

class IIR_ScalarTypeDefinition;
class IIR_ArraySubtypeDefinition;

class IIRScram_ArrayTypeDefinition : public IIRBase_ArrayTypeDefinition {
  friend class StandardPackage;

public:
  void _publish_vhdl_subtype_decl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl(ostream &);
  virtual ostream& _print(ostream &);
  void _publish_cc();
  void _publish_cc_left();
  void _publish_cc_composite_init();
  void _publish_cc_init_signal();
  void _publish_cc_range();
  void _publish_cc_universal_type();
  
  void _publish_cc_bounds();


  virtual void _publish_cc_class_event();
  virtual void _publish_cc_decl_class_event_constructor();
  virtual void _publish_cc_decl_class_event_destructor();
  virtual void _publish_cc_class_event_constructor_with_no_value();
  virtual void _publish_cc_class_event_constructor_with_aggregates();
  virtual void _publish_cc_event_constructor_ranges();
  virtual void _publish_cc_event_constructor_array_allocation();

  virtual void _publish_cc_class_last_event();
  virtual void _publish_cc_decl_class_last_event_constructor();
  virtual void _publish_cc_decl_class_last_event_destructor();
  virtual void _publish_cc_class_last_event_constructor_with_no_value();
  virtual void _publish_cc_class_last_event_constructor_with_aggregates();
  virtual void _publish_cc_last_event_constructor_ranges();
  virtual void _publish_cc_last_event_constructor_array_allocation();

  virtual void _publish_cc_decl_operator_equalto();
  virtual void _publish_cc_decl_operator_subscript();

  virtual void _publish_cc_constructor_prototypes();
  virtual void _publish_cc_decl_constructors();
  virtual void _publish_cc_define_constructors();
  virtual void _publish_cc_decl_destructors();

  virtual void _publish_cc_constructor_args();

  virtual void _publish_cc_range_args();
  virtual void _publish_cc_constructor_ranges();

  virtual void _publish_cc_constructor_array_allocation();
  virtual void _publish_cc_constructor_aggregate_init();
  virtual void _publish_cc_vector_instantiation();

  virtual void _publish_cc_necessary_decl_in_state();
  
  virtual void _publish_cc_headers();
  virtual void _publish_cc_kernel_type();

  void _publish_cc_decl_cc();
  virtual void _publish_cc_subelement_type();
  virtual void _publish_cc_anonymous_type_name();

  virtual void _publish_cc_decl_type_attributes();
  virtual void _publish_cc_decl_array_type_attributes();
  virtual void _publish_cc_define_type_attributes();

  void _publish_cc_define_object_attribute_begin( const char *type, const char *uppercase );
  void _publish_cc_define_object_attribute_end( const char *lowercase, const char *left,
						const char *right );
  void _publish_cc_define_object_attribute_dir( const char *lowercase, const char *uppercase );
  
  virtual void _publish_cc_define_object_attribute_left();
  virtual void _publish_cc_define_object_attribute_right();
  virtual void _publish_cc_define_object_attribute_low();
  virtual void _publish_cc_define_object_attribute_high();
  virtual void _publish_cc_define_object_attribute_length();
  virtual void _publish_cc_define_object_attribute_ascending();
  virtual void _publish_cc_define_array_type_attributes();
  void _publish_cc_extern_type_info();
  void _publish_cc_type_info();
  void _publish_cc_type_name();
  
  virtual void _publish_cc_constructor_for_multidimension_alias_init();
  
  virtual void _publish_cc_data_members() {};

  IIR_Boolean _is_array_type() { return TRUE; }

  IIR_TypeDefinition* _get_base_type();
  
  //_is_character_type() is TRUE for an Enumeration type, that has atleast
  //one character literal in its set of enumerations.
  //But scram/code-generator overloads this function for single dimensional 
  //array types whose element is a scalar type and is a character type
  IIR_Boolean _is_character_type(){
    return ((get_element_subtype()->_is_character_type() == TRUE) &&
	    (get_element_subtype()->_is_scalar_type() == TRUE));
  }

  IIR_Boolean _is_iir_array_type_definition() { return TRUE; }
  IIR_Boolean _is_single_dimensional_array_type();

  virtual IIR_Boolean _is_unconstrained_array_type( );
  virtual IIR_Boolean _has_access_type();
  IIR_Boolean _is_discrete_type();
  IIR_Int32 _get_num_indexes();

  IIR_TypeDefinition *_get_element_subtype();
  void _set_element_subtype( IIR_TypeDefinition * );

  // Due to the complexities of the IIR, sometimes _get_element_subtype()
  // doesn't actually return the element subtype.  This is the case for
  // multidimensional arrays, for instance.  _get_final_subtype() _will_
  // return the _real_ element subtype.
  virtual IIR_TypeDefinition *_get_final_subtype();

  virtual IIR_ScalarTypeDefinition *_get_index_subtype();
  void _set_index_subtype( IIR_ScalarTypeDefinition * );

  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  void _publish_cc_decl_operators();
  void _publish_cc_concatenation_operator();

  void _add_decl_into_cgen_symbol_table();

  // This method takes the range passed in, applies the semantic rules given
  // in LRM ('93) section 3.2.1.1, and returns the proper type.
  static IIR_ScalarTypeDefinition *_build_proper_index( IIR_RangeTypeDefinition * );

  // This method builds a new array subtype by index constraining this one.
  IIR_ArraySubtypeDefinition *_index_constrain_array( IIR_ScalarTypeDefinition * );

  IIR_TypeDefinition *_get_new_subtype();

  IIR_TypeDefinition *
  _construct_new_subtype( IIR_Name *resolution_function,
			  IIR_ScalarTypeDefinition *new_constraint );  

  static IIR_ArrayTypeDefinition *_construct_array_type( IIR_ScalarTypeDefinition *index_subtype,
							 IIR_TypeDefinition *element_subtype );

  IIR *_clone();
  void _clone( IIR_ArrayTypeDefinition *my_clone );

  IIR_Boolean _is_element(){ return is_element(); };

protected:
  IIRScram_ArrayTypeDefinition();
  virtual ~IIRScram_ArrayTypeDefinition() = 0;

  virtual void _publish_cc_constructor_with_no_value();
  virtual void _publish_cc_constructor_with_value();
  virtual void _publish_cc_copy_constructor();
  virtual void _publish_cc_constructor_with_string();
  virtual void _publish_cc_constructor_with_aggregates();
  virtual void _publish_cc_constructor_for_alias_init();

  //The following function returns TRUE if the element of the
  //array is a restriction of an unconstrained array
  IIR_Boolean _is_element_unconstrained_subtype();
  void _publish_cc_set_element_range_info();
  void  _publish_cc_restore_range_info();
  void _publish_cc_event_vector_instantiation();
  void _publish_cc_last_event_vector_instantiation();

  void _come_into_scope( symbol_table *sym_tab, IIR_TypeDeclaration * );
  void _come_out_of_scope( symbol_table *sym_tab );
  void _build_implicit_operators( set<IIR_Declaration> * );

private:  
  static IIR_ArraySubtypeDefinition *_construct_constrained(IIR_ScalarTypeDefinition *index_subtype,
							     IIR_TypeDefinition *element_subtype );

  static IIR_ArrayTypeDefinition *_construct_unconstrained(IIR_ScalarTypeDefinition *index_subtype,
							   IIR_TypeDefinition *element_subtype );

  IIR_TypeDefinition* _get_element_type();
};
#endif
