
#ifndef IIRSCRAM_BLOCK_CONFIGURATION_HH
#define IIRSCRAM_BLOCK_CONFIGURATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kuamr V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_BlockConfiguration.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_BlockConfiguration.hh"

class IIR_ConfigurationDeclaration;
class IIR_ComponentConfiguration;
class IIR_BlockConfiguration;

class IIRScram_BlockConfiguration : public IIRBase_BlockConfiguration {

public:

  void _publish_vhdl(ostream &);
  void _publish_cc_headers();
  void _publish_cc_object_pointers_init();
  void _publish_cc_configure_block(IIR_Boolean = FALSE);

  void _type_check_configuration_item( IIR_List &, IIR * );
  ostream &_print( ostream &os );

protected:
  
  IIRScram_BlockConfiguration() {};
  virtual ~IIRScram_BlockConfiguration() = 0;
    
private:
  void _type_check_block_specification( IIR_List &, IIR * );
  void _resolve_specification_inside_configuration_declaration( IIR_ConfigurationDeclaration * );
  void _resolve_specification_inside_component_configuration( IIR_ComponentConfiguration * );
  void _resolve_specification_inside_block_configuration(  IIR_List &, IIR_BlockConfiguration * );
};

#endif
