#ifndef IIRSCRAM_CASE_STATEMENT_HH
#define IIRSCRAM_CASE_STATEMENT_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_CaseStatement.hh,v 1.2 1999/03/09 20:53:13 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_CaseStatement.hh"

//class IIR_DesignatorList;
template <class type> class set;
class IIR_List;

class IIRScram_CaseStatement : public IIRBase_CaseStatement {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  void _build_wait_list(dl_list<IIRScram_WaitStatement>* );
  void _build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement>*);
  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _get_signal_source_info(set<IIR_Declaration>* siginfo);

  IIR_Boolean _type_check_return_statements( set<IIR_TypeDefinition> *, 
					     IIR_SubprogramDeclaration * );
  
  IIR_Boolean _has_statement_list(){
    return TRUE;
  }

  void _type_check();

  IIR_Boolean _is_resolved();
  
  IIR *_get_case_statement_expression();
  void _set_case_statement_expression( IIR * );
  IIR *_clone();

protected:
  IIRScram_CaseStatement() {}
  virtual ~IIRScram_CaseStatement() = 0;
    
private:
  // Handle error reporting in a function for both expressions and
  // alternatives.
  IIR *_handle_reconciliation( set<IIR_TypeDefinition> *rval_set,
			      IIR *node_in_consideration,
			      char *error_part );
};
#endif
