
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ComponentConfiguration.cc,v 1.2 1999/03/09 20:53:25 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ComponentConfiguration.hh"
#include "IIR_LibraryUnit.hh"
#include "IIR_Name.hh"
#include "IIR_LibraryUnitList.hh"
#include "IIR_BlockConfiguration.hh"
#include "IIR_AssociationList.hh"
#include "IIR_AssociationElement.hh"
#include "IIR_Designator.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_Label.hh"
#include "IIR_Statement.hh"
#include "error_func.hh"
#include "IIR_ConfigurationDeclaration.hh"
#include "IIR_ArchitectureDeclaration.hh"

IIRScram_ComponentConfiguration::~IIRScram_ComponentConfiguration(){}

void 
IIRScram_ComponentConfiguration::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_component_name()->_is_resolved() == TRUE);
  _vhdl_out << " for ";
  instantiation_list._publish_vhdl(_vhdl_out);
  _vhdl_out << " : ";
  get_component_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "\n";
  if(get_entity_aspect() != NULL) {
    _vhdl_out << " use ";
    get_entity_aspect()->_publish_vhdl_with_library_name(_vhdl_out);
  }
  if(generic_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n generic map ( ";
    generic_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";
  }
  if(port_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n port map ( ";
    port_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";
  }
  
  if ( get_entity_aspect() != NULL || generic_map_aspect.num_elements() > 0 || port_map_aspect.num_elements() > 0 ){
    _vhdl_out << ";\n";
  }
  if ( get_block_configuration() != NULL ){
    get_block_configuration()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << "end for;\n";  
}

void
IIRScram_ComponentConfiguration::_publish_cc_headers(){
  _cc_out << "#include \"";
  get_component_name()->_publish_cc_binding_name();
  _cc_out << "_elab.hh\"" << endl;
  if(get_entity_aspect() != NULL) {
    _cc_out << "#include \"";
    get_entity_aspect()->_publish_cc_binding_name();
    _cc_out << "_elab.hh\"" << endl;
  }
  if ( get_block_configuration() != NULL ){
    get_block_configuration()->_publish_cc_headers();
  }
}


void
IIRScram_ComponentConfiguration::_publish_cc_configure_block(IIR_Boolean _is_within_generate_for) {

  IIR_Char* scratch1_ptr = NULL;
  IIR_Char* scratch2_ptr = NULL;
  IIR_Char* referenceStr = NULL;
  
  IIR_Designator* designator = instantiation_list.first();

  while(designator != NULL) { 
    ostrstream scratch1;
    ostrstream scratch2;
    
    scratch1_ptr = NULL;
    scratch2_ptr = NULL;
    
    if((designator->get_kind() == IIR_DESIGNATOR_BY_ALL) ||
       (designator->get_kind() == IIR_DESIGNATOR_BY_OTHERS)) {
      cerr << "IIR_DESIGNATOR_BY_ALL/ IIR_DESIGNATOR_BY_OTHERS not yet handled" << endl;
      break;
    }

    ASSERT(designator->get_kind() == IIR_DESIGNATOR_EXPLICIT);
    ASSERT(designator->_get_name()->get_kind() == IIR_LABEL);
    IIR_Label* label = (IIR_Label*)designator->_get_name();
    ASSERT(label->_is_resolved() == TRUE);
    scratch1 << "enclosingArch->";
    if(label->get_statement() == NULL) {
      label->_get_declarator()->_print(scratch1);
    }
    else {
      label->get_statement()->_get_label()->_get_declarator()->_print(scratch1);
    }
    scratch1 << "_elab_obj";

    if (_is_within_generate_for == TRUE) {
      scratch1 << "[generateConstant]";
      referenceStr = ".";
    }
    else {
      referenceStr = "->";
    }
      
    scratch1 << ends;
    
    scratch1_ptr = scratch1.str();

    scratch2 << "enclosingArch1->";
    if(label->get_statement() == NULL) {
      label->_get_declarator()->_print(scratch2);
    }
    else {
      label->get_statement()->_get_label()->_get_declarator()->_print(scratch2);
    }
    scratch2 << "_elab_obj";
    if (_is_within_generate_for == TRUE) {
      scratch2 << "[generateConstant]";
    }
   
    scratch2 << ends;
    scratch2_ptr = scratch2.str();

    ASSERT(get_component_name()->_is_resolved() == TRUE);

    if(get_entity_aspect() != NULL) {
      _cc_out << "if(" << scratch1_ptr << referenceStr
	      << "boundedEntity != NULL) {" << endl
	      << " delete " << scratch1_ptr << referenceStr
	      << "boundedEntity;\n" 
	      << "}" << endl
	      << scratch1_ptr << referenceStr << "boundedEntity = "
	      << " new ";
      get_entity_aspect()->_publish_cc_binding_name();
      _cc_out << "_elab(" << endl;
      if(generic_map_aspect.num_elements() > 0) {
	IIR* tempNode = _current_publish_node;
	_current_publish_node = designator->_get_name();
	generic_map_aspect._publish_cc_generic_map_aspect();
	_current_publish_node = tempNode;
      }
      _cc_out << ");" << endl;
      if(port_map_aspect.num_elements() > 0) {
	_cc_out << "{" << endl;
	get_component_name()->_publish_cc_binding_name();
	_cc_out << "_elab* logicalEntity = ";
	if (_is_within_generate_for == TRUE)  {
	  _cc_out << "&";
	}
	
	_cc_out << scratch1_ptr << ";" << endl;
	if(get_entity_aspect()->get_kind() == IIR_CONFIGURATION_DECLARATION) {
	  IIR_ConfigurationDeclaration* config_decl = (IIR_ConfigurationDeclaration*)get_entity_aspect();
	  config_decl->_get_configured_architecture()->_publish_cc_binding_name();
	  _cc_out << "_elab* realEntity = ((";
	  config_decl->_get_configured_architecture()->_publish_cc_binding_name();
	  _cc_out << "_elab*)";
	  _cc_out << "((";
	  get_entity_aspect()->_publish_cc_binding_name();
	  _cc_out << "_elab*)";
	  _cc_out << "logicalEntity->boundedEntity)->configuredEntity);" << endl;
	}
	else {
	  get_entity_aspect()->_publish_cc_binding_name();
	  _cc_out << "_elab* realEntity = (";
	  get_entity_aspect()->_publish_cc_binding_name();
	  _cc_out << "_elab*) logicalEntity->boundedEntity;" << endl;
	}
	_cc_out << "PortMap* tmpPortMap = &(realEntity->portMapAspect);" << endl;
	port_map_aspect._publish_cc_port_map_associations();
	_cc_out << "};" << endl;
      }
    }
    if ( get_block_configuration() != NULL ){
      get_entity_aspect()->_publish_cc_binding_name();
      _cc_out << "_elab* enclosingArch = (";
      get_entity_aspect()->_publish_cc_binding_name();
      _cc_out << "_elab*)" << scratch2_ptr << "->boundedEntity;" << endl;
      get_entity_aspect()->_publish_cc_binding_name();
      _cc_out << "_elab* enclosingArch1 = enclosingArch;" << endl;
      _cc_out << "{" << endl;
      get_block_configuration()->_publish_cc_configure_block();
      _cc_out << "};" << endl;
    }
    delete [] scratch1_ptr;
    delete [] scratch2_ptr;
    designator = instantiation_list.successor(designator);
  }
}

void
IIRScram_ComponentConfiguration::_type_check_configuration_item( IIR_List &statement_list,
								 IIR *enclosing_region ){
  ASSERT( enclosing_region != NULL );
  ASSERT( enclosing_region->get_kind() == IIR_BLOCK_CONFIGURATION );
  IIR_BlockConfiguration *enclosing_config = (IIR_BlockConfiguration *)enclosing_region;

  ASSERT( enclosing_config->get_block_specification() != NULL );

  // These lines cause many billowitch failures (tc840, for example)
  //   ASSERT( enclosing_config->get_block_specification()->_is_iir_library_unit() == TRUE );
  //   set_entity_aspect( (IIR_LibraryUnit *)enclosing_config->get_block_specification() );

  _type_check_configuration( port_map_aspect, generic_map_aspect );
  
  if( get_block_configuration() != NULL ){
    get_block_configuration()->_type_check_configuration_item( statement_list, this );
  }

  instantiation_list._type_check_as_instantiation_list( get_component_name(), 
							statement_list,
							this );
}

IIR *
IIRScram_ComponentConfiguration::_get_component_name( ){
  return get_component_name();
}

void 
IIRScram_ComponentConfiguration::_set_component_name( IIR *name ){
  set_component_name( name );
}

IIR_LibraryUnit *
IIRScram_ComponentConfiguration::_get_entity_aspect(){
  return get_entity_aspect();
}
