// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ececs.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConfigurationDeclaration.cc,v 1.3 1999/05/25 17:37:40 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_ConfigurationDeclaration.hh"
#include "IIR_BlockConfiguration.hh"
#include "IIR_EntityDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_ConcurrentStatementList.hh"

IIRScram_ConfigurationDeclaration::~IIRScram_ConfigurationDeclaration() {}


void 
IIRScram_ConfigurationDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  context_items._publish_vhdl(_vhdl_out);

  _vhdl_out << " configuration ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " of ";
  get_entity()->get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";
  configuration_declarative_part._publish_vhdl_decl(_vhdl_out);
  get_block_configuration()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " end configuration ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " ;\n";
}


IIRScram_Declaration::declaration_type 
IIRScram_ConfigurationDeclaration::_get_type(){
   return CONFIGURATION;
}

void
IIRScram_ConfigurationDeclaration::_publish_vhdl_binding_name(ostream &_vhdl_out){
  _vhdl_out << " configuration ";
  get_declarator()->_publish_vhdl(_vhdl_out);
}

void
IIRScram_ConfigurationDeclaration::_publish_vhdl_with_library_name(ostream &_vhdl_out){
  _vhdl_out << " configuration ";
  ASSERT(_get_declarative_region() != NULL);
  ASSERT(_get_declarative_region()->get_kind() == IIR_LIBRARY_DECLARATION);
  _get_declarative_region()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ".";
  get_declarator()->_publish_vhdl(_vhdl_out);
}


void
IIRScram_ConfigurationDeclaration::_publish_cc_elaborate() {
  _set_currently_publishing_unit(CONFIGURATION_DECLARATION);
  _current_entity_name = get_entity()->_get_declarator()->_convert_to_c_string();
  _current_configuration_name = _get_declarator()->_convert_to_c_string();
  _current_architecture_name = _get_configured_architecture()->_get_declarator()->_convert_to_c_string();
  _publish_cc_headerfile();
  _publish_cc_ccfile();
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_headerfile() {
  char buf[512];
  ostrstream filename(buf, 512, ios::out);

  filename << "SCFG";
  _get_declarator()->_print(filename);
  filename << "_";
  get_entity()->_get_declarator()->_print(filename);
  filename << "_";
  _get_configured_architecture()->_get_declarator()->_print(filename);
  filename << ends;
  
  //Publishing the .hh file
  _cc_out.set_file(TRUE, buf, "_elab.hh");
  _cc_out << "#ifndef " << buf <<"_HH\n";
  _cc_out << "#define " << buf <<"_HH\n";
  _cc_out << "//Header files needed for this architecture\n";
  _publish_cc_headers();
  _cc_out << "\n//Forward reference classes needed for this architecture\n";
  _publish_cc_class_includes();
  _cc_out << "\n//Elaboration Class for the this architecture\n";
  _publish_cc_class();
  _cc_out << "#endif" << endl;
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_headers() {
  char *ent_name = get_entity()->_get_declarator()->_convert_to_c_string();
  _cc_out << "#include \"" << ent_name << "_decls.hh\"\n";
  delete [] ent_name;
  get_block_configuration()->_publish_cc_headers();
  configuration_declarative_part._publish_cc_headers();
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_class_includes() {
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_class() {
  _cc_out << "class ";
  _publish_cc_binding_name();
  _cc_out << "_elab : public ";
  _cc_out << "_savant_entity_elab {\n";
  _cc_out << "public:\n";

  //Publishing the constructor and destructor
  this->_publish_cc_binding_name();
  _cc_out << "_elab();\n";

  IIR_EntityDeclaration* entitydecl = get_entity();
  if(entitydecl->generic_clause.num_elements() > 0) {
    this->_publish_cc_binding_name();    
    _cc_out << "_elab(\n";
    entitydecl->generic_clause._publish_generic_parameter_list();
    _cc_out << " );\n";
  }

  _cc_out << "~";
  this->_publish_cc_binding_name();
  _cc_out << "_elab();\n";
  
  _cc_out << "void instantiate();\n";
  _cc_out << "void createNetInfo();\n";
  _cc_out << "void connect(int, int, ...);\n";
  _cc_out << "void getBoundEntityInfo();" << endl;
  _cc_out << "void partition() {}\n";

  get_entity()->generic_clause._publish_cc_elaborate();

  //Publishing the pointers to processes and objects used in this architecture
  _publish_cc_object_pointers();

  _cc_out << "};\n";
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_object_pointers() {
  _get_configured_architecture()->_publish_cc_binding_name();
  _cc_out << "_elab* configuredEntity;" << endl;
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_ccfile() {

  char buf[512];
  ostrstream filename(buf, 512, ios::out);

  filename << "SCFG";
  _get_declarator()->_print(filename);
  filename << "_";
  get_entity()->_get_declarator()->_print(filename);
  filename << "_";
  _get_configured_architecture()->_get_declarator()->_print(filename);
  filename << ends;

  //Publishing the .hh file
  _cc_out.set_file(TRUE, buf, "_elab.cc");
  _cc_out << "#include \"" << buf << "_elab.hh\"\n";
  _cc_out << "#ifdef SEQUENTIAL" << endl;
  _cc_out << "#include \"BaseSequential.hh\" " << endl;
  _cc_out << "#define OBJTYPE BaseSequential" << endl;
  _cc_out << "#else" << endl;
  _cc_out << "#include \"BasicTimeWarp.hh\" " << endl;
  _cc_out << "#define OBJTYPE BasicTimeWarp" << endl;
  _cc_out << "#endif" << endl;

  _publish_cc_headerfiles_for_cc();
  _cc_out << "extern OBJTYPE* proc_array[];\n";
  _publish_cc_constructor();
  _publish_cc_destructor();
  _publish_cc_instantiate();
  _publish_cc_createNetInfo();
  _publish_cc_connect();
  _publish_cc_getboundentityinfo();
  //  _publish_cc_partition();
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_constructor() {
  _publish_cc_constructor_with_no_arguments();
  if (get_entity()->generic_clause.num_elements() > 0) {
    _publish_cc_constructor_with_arguments();
  }
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_constructor_with_no_arguments() {
  int numGenericClause = get_entity()->generic_clause.num_elements();
  this->_publish_cc_binding_name();
  _cc_out << "_elab";
  _cc_out << "::";
  this->_publish_cc_binding_name();
  _cc_out << "_elab()";

  if(numGenericClause > 0) {
    _cc_out << ":\n";
    get_entity()->generic_clause._publish_generic_init();
  }
  _cc_out << " {\n";
  _publish_cc_object_pointers_init();
  _cc_out << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_constructor_with_arguments() {
  int numGenericClause = get_entity()->generic_clause.num_elements();
  this->_publish_cc_binding_name();
  _cc_out << "_elab::";
  this->_publish_cc_binding_name();
  _cc_out << "_elab(\n";
  get_entity()->generic_clause._publish_generic_parameter_list();
  _cc_out << " )";

  if(numGenericClause > 0) {
    _cc_out << ":\n";
    get_entity()->generic_clause._publish_generic_init_by_arguments();
  }
  _cc_out << " {\n";
  _publish_cc_object_pointers_init();
  _cc_out << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_object_pointers_init() {
  _cc_out << "configuredEntity = new ";
  _get_configured_architecture()->_publish_cc_binding_name();
  _cc_out << "_elab(";

//   tempNode = _current_publish_node;
//   _current_publish_node = _get_configured_architecture();
//   get_entity()->generic_map_aspect._publish_cc_generic_map_aspect();

  _cc_out << ");\n";

//   _cc_out << "{" << endl;
//   _get_configured_architecture()->_publish_cc_binding_name();
//   _cc_out << "_elab* enclosingArch = configuredEntity;" << endl;  
//   _get_configured_architecture()->_publish_cc_binding_name();
//   _cc_out << "_elab* enclosingArch1 = enclosingArch;" << endl;  
//   _cc_out << "{" << endl;

  get_block_configuration()->_publish_cc_object_pointers_init();

//   _cc_out << "}" << endl;
//   _cc_out << "}" << endl;
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_destructor() {
  this->_publish_cc_binding_name();
  _cc_out << "_elab::~";
  this->_publish_cc_binding_name();
  _cc_out << "_elab() {\n";
  _cc_out << "   delete configuredEntity;" << endl;
  _cc_out << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_instantiate() {
  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::instantiate() {\n";
  _cc_out << "if(configuredEntity != NULL) {" << endl;
  _cc_out << "  configuredEntity->instantiate();\n";
  _cc_out << "}" << endl;
  _cc_out << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_createNetInfo() {
  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::createNetInfo() {\n";
  _cc_out << "if(configuredEntity != NULL) {" << endl;
  _cc_out << "  configuredEntity->createNetInfo();\n";
  _cc_out << "}" << endl;
  _cc_out << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_connect() {

  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::connect(int inputsignals, int outputsignals, ...) {\n";
  _cc_out << "int NoofSignals = inputsignals + outputsignals;";
  _cc_out << "va_list ap;\n";
  _cc_out << "opFanoutinfo = (VHDLType**)new char[NoofSignals * sizeof(VHDLType*)];\n";
  _cc_out << "va_start(ap, outputsignals);\n";
  _cc_out << "for(int i=0; i <NoofSignals; i++) {\n";
  _cc_out << "  opFanoutinfo[i] = va_arg(ap, VHDLType*);\n";
  _cc_out << "}\n";
  _cc_out << "va_end(ap);\n";

  //Pass on the output connection  inforamtion to its output signals
  IIR_EntityDeclaration* entitydecl = get_entity();
  IIR_SignalInterfaceDeclaration* portelement = NULL;
  IIR_Mode mode;
  int index = 0;

  _cc_out << "if(inputsignals > 0) {\n";

  portelement = entitydecl->port_clause.first();
  for(; portelement != NULL; ) {
    mode = portelement->get_mode();
    if(mode == IIR_IN_MODE ) {
      _cc_out << "setSourceInfo(";
      _cc_out << "configuredEntity->";
      portelement->_publish_cc_elaborate(); 
      _cc_out << ",*(opFanoutinfo[";
      _cc_out << index << "]));\n";
      index++;
    }
    portelement = entitydecl->port_clause.successor(portelement);
  }
  _cc_out << "}\n";

  _cc_out << "if(outputsignals > 0) {\n";

  portelement = entitydecl->port_clause.first();
  for(; portelement != NULL; ) {
    mode = portelement->get_mode();
    if(mode == IIR_INOUT_MODE || mode == IIR_OUT_MODE) {
      _cc_out << "Add(";
      _cc_out << "configuredEntity->";
      portelement->_publish_cc_elaborate(); 
      _cc_out << ",*(opFanoutinfo[";
      _cc_out << index << "]));\n";
      
      if (mode != IIR_OUT_MODE){
      _cc_out << "setSourceInfo(";
      _cc_out << "configuredEntity->";
      portelement->_publish_cc_elaborate(); 
      _cc_out << ",*(opFanoutinfo[";
      _cc_out << index << "]));\n";
      }
      index++;
      
    }
    portelement = entitydecl->port_clause.successor(portelement);
  }
  _cc_out << "}\n";
  _cc_out << "configuredEntity->connect(0,0);" << endl;
  _cc_out << "}\n";
}


void
IIRScram_ConfigurationDeclaration::_publish_cc_getboundentityinfo() {
  _cc_out << "void\n";
  this->_publish_cc_binding_name();
  _cc_out << "_elab::getBoundEntityInfo() {\n";
  _cc_out << "if(configuredEntity != NULL) {" << endl
	  << "  configuredEntity->getBoundEntityInfo();" << endl
	  << "}" << endl;
  _cc_out << "}" << endl;
}

void
IIRScram_ConfigurationDeclaration::_publish_cc() {
  // Nothing to be done here.
  // Just to keep the warning message in IIRScram.cc from popping up
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_binding_name(ostream& outstream) {
  outstream << "SCFG";
  _get_declarator()->_print(outstream);
  outstream << "_";
  get_entity()->_get_declarator()->_print(outstream);
  outstream << "_";
  _get_configured_architecture()->_get_declarator()->_print(outstream);
}

IIR_ArchitectureDeclaration*
IIRScram_ConfigurationDeclaration::_get_configured_architecture() {
  IIR* tmp_node = get_block_configuration()->get_block_specification();
  ASSERT(tmp_node->get_kind() == IIR_ARCHITECTURE_DECLARATION);
  IIR_ArchitectureDeclaration* arch_ptr = ((IIR_ArchitectureDeclaration*)tmp_node);  
  return arch_ptr;
}

void 
IIRScram_ConfigurationDeclaration::_make_interface_visible( symbol_table *sym_tab ){
  // get_entity()->_make_interface_visible( sym_tab );
}

void 
IIRScram_ConfigurationDeclaration::_type_check(){
  IIR_ConcurrentStatementList empty_list;

  if( get_block_configuration() != NULL ){
    get_block_configuration()->_type_check_configuration_item( empty_list, this );
  }
  
  configuration_declarative_part._type_check_configuration_specifications( empty_list );
  configuration_declarative_part._type_check_attribute_specifications( empty_list );
}
