#ifndef IIRSCRAM_DESIGN_FILE_HH
#define IIRSCRAM_DESIGN_FILE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_DesignFile.hh,v 1.3 1999/03/25 02:57:27 tmcbraye Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_DesignFile.hh"
#include "dl_list.hh"

class IIRScram_DesignFile : public IIRBase_DesignFile {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  void _publish_cc_makefile();
  void _publish_cc_main();
  void _publish_cc_design_library_makefile();
  void _publish_cc_library_path();
  void _publish_cc_phony_library();
  void _publish_cc_target_design_library();
  void _publish_cc_additional_library();
  void _publish_cc_depend_library();
  void _publish_cc_clean_library();
  void _publish_cc_library_series();
  
#ifdef PROCESS_COMBINATION
  IIR_ArchitectureDeclaration *_static_elaborate_design();
#endif

  static dl_list<char> use_list;
  IIR_Char* _get_top_level_design_unit_name();
  //This is a temporary function, eventually will be chaned to _publish_cc_main
  void _publish_cc_mainNew();

  void _set_file_name( char *new_file_name );

  void _set_parser( scram *new_parser ){
    ASSERT( _my_parser == NULL );
    _my_parser = new_parser;
  }
  
  symbol_table *_get_symbol_table();

protected:
  IIRScram_DesignFile(){ 
    _my_parser = NULL;
  }

  virtual ~IIRScram_DesignFile() = 0;
    
private:
  scram *_my_parser;
};
#endif
