#ifndef IIRSCRAM_DYADIC_OPERATOR_HH
#define IIRSCRAM_DYADIC_OPERATOR_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_DyadicOperator.hh,v 1.2 1999/03/09 20:54:08 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_DyadicOperator.hh"

class IIRScram_DyadicOperator : public IIRBase_DyadicOperator {
public:
  void _publish_vhdl(ostream &);
  
  // This method publishes the name of the operator, derive from
  // DyadicOperator.  For example, AndOperator will publish savantAnd.
  virtual void _publish_cc_operator_name();
  void _publish_cc();
  void _publish_cc_headers();
  virtual void _publish_cc_initialization_value();
  void _publish_cc_wait_data();

  virtual void _publish_cc_short_circuit();
  virtual void _publish_cc_wait_data_short_circuit();

  //This function returns TRUE if the operation is a short circuit
  //operation.  As per section 7.2 of LRM: The logical operations "and",
  //"or", "nand" and "nor" defined for types BIT and BOOLEAN are all
  //short-circuit operations; furthermore, these are the only
  //short-circuit operations.
  virtual IIR_Boolean _is_short_circuit();

  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  IIR  *_transmute();
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);

  char *_get_function_name();

  IIR_Boolean _is_resolved();

  void _resolve_operands( IIR_TypeDefinition *left_type, IIR_TypeDefinition *right_type );

  void _resolve_operand( IIR *(IIRScram_DyadicOperator::*get_method)(), 
			 void (IIRScram_DyadicOperator::*set_method)( IIR *),
			 IIR_TypeDefinition *operand_type );

  virtual void _add_decl_into_cgen_symbol_table();

  void _clone(IIRScram_DyadicOperator*);
  virtual bool _is_associative(IIR_Kind oper_kind) {return TRUE;}
  virtual IIR_Boolean _is_left_associative(){ return TRUE; }
  virtual IIR_Boolean _is_logical_operator() { return FALSE ;}
  IIR_Boolean _is_static_expression();
  IIR_Boolean _is_operator();
  IIR_Boolean _is_locally_static_primary();

protected:
  IIR_Int32 _get_num_args(){ return 2; }
  IIR_AssociationList *_build_argument_list();

  IIRScram_DyadicOperator() {};
  virtual ~IIRScram_DyadicOperator() = 0;

  void _type_check_operands( );
  
private:
};

#endif
