// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ExponentiationOperator.cc,v 1.2 1999/03/09 20:54:25 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_ExponentiationOperator.hh"
#include "error_func.hh"
#include "set.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include <strstream.h>
#include "StandardPackage.hh"
#include "resolution_func.hh"

IIRScram_ExponentiationOperator::~IIRScram_ExponentiationOperator() {}

void 
IIRScram_ExponentiationOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " ** ";
}

void 
IIRScram_ExponentiationOperator::_publish_cc_operator_name() {
  _cc_out << "savantPow";
}


IIR*
IIRScram_ExponentiationOperator::_clone() {
  IIR_ExponentiationOperator *clone = new IIR_ExponentiationOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_ExponentiationOperator::_get_operator_precedence(){
  return IIRScram::MISCELLANEOUS_OPERATOR;
}

bool
IIRScram_ExponentiationOperator::_is_associative(IIR_Kind oper_kind) {
  switch(oper_kind) {                         
  case IIR_ABSOLUTE_OPERATOR:                
    return FALSE;                             
  default:
    return TRUE;                                                             
  }
}
