// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FileDeclaration.cc,v 1.2 1999/03/09 20:54:28 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_FileDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_SimpleName.hh"
#include "IIR_Identifier.hh"
#include "symbol_table.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "IIR_Attribute.hh"
extern symbol_table* cgen_sym_tab_ptr;

IIRScram_FileDeclaration::~IIRScram_FileDeclaration() {}


void 
IIRScram_FileDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "file ";
  IIRScram_ObjectDeclaration::_publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);

  if (get_file_open_expression() != NULL) {
    _vhdl_out << " open ";
    get_file_open_expression()->_publish_vhdl(_vhdl_out);
  }
  
  if (get_file_logical_name() != NULL) {
    _vhdl_out << " is ";
    get_file_logical_name()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << ";\n";
}

void 
IIRScram_FileDeclaration::_publish_cc() {
  ASSERT (cgen_sym_tab_ptr != NULL);

  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }

  _set_scoping_prefix();
  
  ASSERT(get_file_logical_name() != NULL);
  _publish_cc_prefix_string();
  _get_declarator()->_publish_cc();
  // _cc_out << "_" << this;

  _reset_scoping_prefix();
}

void
IIRScram_FileDeclaration::_publish_cc_decl() {
  get_subtype()->_publish_cc();
  _cc_out << " ";
  _get_declarator()->_publish_cc();

  if (_is_currently_publishing_subprogram()) {
    _cc_out << "(processPtr, ";
    get_file_logical_name()->_publish_cc();
    _cc_out << ", _savant_file_open_kind(";

    IIR_SimpleName *expr = (IIR_SimpleName*)get_file_open_expression();
    
    if (!IIR_Identifier::_cmp((IIR_Identifier*)(expr->get_prefix()), "read_mode")) {
      _cc_out << "READ_MODE";
    }
    else if (!IIR_Identifier::_cmp((IIR_Identifier*)(expr->get_prefix()), "write_mode")){
      _cc_out << "WRITE_MODE";
    }
    else {
      _cc_out << "APPEND_MODE";
    }
    
    _cc_out << "))";
  }
  
  _cc_out << ";\n";
}

IIR_Boolean
IIRScram_FileDeclaration::_is_read_file() {
  ASSERT(get_file_open_expression()->get_kind() == IIR_SIMPLE_NAME);

  IIR_SimpleName* expr = (IIR_SimpleName*)get_file_open_expression();

  if (!IIR_Identifier::_cmp((IIR_Identifier*)expr->get_prefix(), "read_mode")){
    return true;
  }
  else {
    return false;
  }
}

IIR_Boolean
IIRScram_FileDeclaration::_is_write_file() {
  ASSERT(get_file_open_expression()->get_kind() == IIR_SIMPLE_NAME);

  IIR_SimpleName* expr = (IIR_SimpleName*)get_file_open_expression();

  if (!IIR_Identifier::_cmp((IIR_Identifier*)expr->get_prefix(),"write_mode")||
     !IIR_Identifier::_cmp((IIR_Identifier*)expr->get_prefix(),"append_mode")){
    return true;
  }
  else {
    return false;
  }
}

IIRScram_Declaration::declaration_type 
IIRScram_FileDeclaration::_get_type() {
  return S_FILE;
}

IIR*
IIRScram_FileDeclaration::_clone() {
  if (_my_clone == NULL) {
    _my_clone = new IIR_FileDeclaration();
    IIRScram_ObjectDeclaration::_clone(_my_clone);

    _my_clone->set_file_open_expression(get_file_open_expression());
    _my_clone->set_file_logical_name(get_file_logical_name());
  }
  return _my_clone;
}
