#ifndef IIRSCRAM_GENERIC_LIST_HH
#define IIRSCRAM_GENERIC_LIST_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_GenericList.hh,v 1.2 1999/03/09 20:54:42 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_GenericList.hh"

class IIRScram_GenericList : public IIRBase_GenericList {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc_elaborate();
  void _publish_cc_elaborate_as_pointers(IIR_Boolean publishDefinition = TRUE);
  void _publish_cc_copy_generics_to_globals();
  void _publish_generic_parameter_list();
  void _publish_generic_parameters_notypes();
  void _publish_generic_init();
  void _publish_generic_init_by_arguments();

protected:
  IIRScram_GenericList() {};
  virtual ~IIRScram_GenericList() = 0;
    
private:
};
#endif
