#ifndef IIRSCRAM_LENGTH_ATTRIBUTE_HH
#define IIRSCRAM_LENGTH_ATTRIBUTE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LengthAttribute.hh,v 1.2 1999/03/09 20:55:17 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_LengthAttribute.hh"

class IIRScram_LengthAttribute : public IIRBase_LengthAttribute {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
 
  IIR_TextLiteral *_build_attribute_name();
  IIR_TypeDefinition *_get_subtype();
  IIR_Declaration *_get_implicit_declaration( char *, IIR_TypeDefinition * );

  IIR_Boolean _has_suffix(){ return TRUE; }
  void _set_suffix( IIR *new_suffix ){ set_suffix( new_suffix ); }

  IIR *_clone();

  IIR_Boolean _is_value_attribute(){ return TRUE; }

protected:
  void _resolve_suffix_special();

  IIRScram_LengthAttribute() {}
  virtual ~IIRScram_LengthAttribute() = 0;
    
private:
};
#endif
