#ifndef IIRSCRAM_LIBRARY_DECLARATION_HH
#define IIRSCRAM_LIBRARY_DECLARATION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LibraryDeclaration.hh,v 1.2 1999/03/09 20:55:21 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_LibraryDeclaration.hh"

class IIR_List ;

class IIRScram_LibraryDeclaration : public IIRBase_LibraryDeclaration {

public:
  set<IIR_Declaration> *_find_declarations( IIR_Name * );
  declaration_type _get_type();
  IIR_TypeDefinition *_get_subtype( ){ return NULL; }

  IIR_Boolean _is_iir_library_declaration(){ return TRUE; }

  void _publish_vhdl_decl( ostream & );

  void _add_to_declarative_region( set<IIR_Declaration> * );

  void _set_path_to_directory( char *new_path ){ path_to_directory = new_path; }
  char *_get_path_to_directory(){ return path_to_directory; }

  // If we're parsing with -logical-library-name foo, then a library with
  // declarator "work" will be created that points foo "foo._savant_lib".
  // (things inside this library HAVE to have "work.something" point into
  // the right direcotry.)  The code generator wants to know the "real"
  // library name, though.  It can get to it through this method.
  void _set_logical_name( IIR_TextLiteral *ln ){ _my_logical_name = ln; }
  IIR_TextLiteral *_get_logical_name(){ return _my_logical_name; }

protected:
  IIRScram_LibraryDeclaration(){ path_to_directory = NULL; _my_logical_name = NULL; }
  virtual ~IIRScram_LibraryDeclaration() = 0;
    
private:
  // This is a path (either relative or absolute, depending on how the
  // library manager was able to find it) to the directory that this declaration
  // is representing...
  char *path_to_directory;
  IIR_TextLiteral *_my_logical_name;
};
#endif
