#ifndef IIRSCRAM_LIBRARY_UNIT_HH
#define IIRSCRAM_LIBRARY_UNIT_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LibraryUnit.hh,v 1.2 1999/03/09 20:55:22 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_LibraryUnit.hh"
class IIR_EntityDeclaration;

class IIRScram_LibraryUnit : public IIRBase_LibraryUnit {

public:
  virtual void _publish_vhdl_binding_name(ostream &);
  virtual void _publish_vhdl_with_library_name(ostream &_vhdl_out);
  virtual IIR_EntityDeclaration* _get_entity();
  virtual void _publish_cc_binding_name(ostream& outstream = _cc_out);

  IIR_Boolean _is_library_unit() { return TRUE; }
  IIR_Boolean _is_iir_library_unit(){ return TRUE; }
  IIR_Boolean _is_homograph_of( IIR_Declaration * );

  void _clone(IIR*);

  IIR_AttributeSpecificationList* _get_attribute_specification_list() { return &attributes; }

protected:
  IIRScram_LibraryUnit() {}
  virtual ~IIRScram_LibraryUnit() = 0;
  
private:
};
#endif

