// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajaske@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Name.cc,v 1.3 1999/08/26 13:47:07 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_Name.hh"
#include "IIR_ConcurrentStatement.hh"
#include "IIR_DesignatorList.hh"
#include "IIR_DesignatorExplicit.hh"
#include "set.hh"

IIRScram_Name::~IIRScram_Name() {}

void 
IIRScram_Name::_publish_vhdl(ostream &_vhdl_out) {
  _report_undefined_scram_fn("_publish_vhdl(ostream &)");
}

IIR_Boolean
IIRScram_Name::_is_name(){
  return TRUE;
}

IIR_Boolean
IIRScram_Name::_is_object(){
  return get_prefix()->_is_object();
}

IIR_Boolean
IIRScram_Name::_is_array_type(){
  ASSERT(_get_subtype() != NULL);
  return _get_subtype()->_is_array_type();
}

IIR_Boolean
IIRScram_Name::_is_signal(){
  return get_prefix()->_is_signal();
}

IIR_Boolean
IIRScram_Name::_is_variable(){
  return get_prefix()->_is_variable();
}

IIR_Boolean
IIRScram_Name::_is_static_expression() {
  if(_get_suffix() != NULL) {
    return (get_prefix()->_is_static_expression() == TRUE &&
	    _get_suffix()->_is_static_expression() == TRUE);
  } else {
    return (get_prefix()->_is_static_expression() == TRUE);
  }    
}

IIR_Boolean
IIRScram_Name::_is_longest_static_prefix() {
  if(_get_suffix() == NULL) {
    return (get_prefix()->_is_iir_declaration() == TRUE ||
	    get_prefix()->_is_longest_static_prefix());
  } else {
    if(_get_suffix()->_is_static_expression() == TRUE) {
      if(get_prefix()->_is_iir_declaration() == TRUE) {
	return TRUE;
      } else {
	return get_prefix()->_is_longest_static_prefix();
      }
    } else {
      return FALSE;
    }
  }
}
    

IIR_Boolean
IIRScram_Name::_is_composite_resolved_signal() {
  IIR_TypeDefinition* type_def = _get_subtype();

  if(_is_signal() == FALSE) {
    return FALSE;
  }
  else {
    if(type_def != NULL) {
      if((type_def->_get_resolution_function() != NULL) &&
	 ((type_def->_is_array_type() == TRUE)|| 
	  (type_def->_is_record_type() == TRUE))) {
	return TRUE;
      }
      else {
	return FALSE;
      }  
    }
    else {
      return FALSE;
    }
  }
}

IIR_TypeDefinition *
IIRScram_Name::_get_subtype(){
  ASSERT( _is_resolved() == TRUE );
  return _get_subtype();
}

//This function is used to publish the type of the
//name, i.e.
// Signal a: bitvector(1, to 3),
// then a(3) has the type bit.
//Currently this need is in the elaboration code
//presume needed in future
//#####This function needs a lot of work and thought

void
IIRScram_Name::_publish_cc_type_name() {
  IIR_TypeDefinition* type_def = _get_subtype();
  if(type_def != NULL) {
    type_def->_publish_cc_type_name();
  }
}

void 
IIRScram_Name::_set_subtype( IIR_TypeDefinition * ){
  _report_undefined_scram_fn("_set_subtype");
}


IIR_TypeDefinition*
IIRScram_Name::_get_name_type(){
  _report_undefined_scram_fn("_get_name_type()");
  return get_prefix()->_get_subtype();
}


void
IIRScram_Name::_publish_cc_addChild() {
  ASSERT(_is_signal() == TRUE);
  ASSERT(_current_publish_name != NULL);
  char *ptr = _current_publish_name; // Set in IIRScram_ProcessStatement
  IIR_TypeDefinition* type_def = _get_subtype();
  
  if(_is_resolved_signal() == TRUE || 
     _get_prefix_declaration()->_have_added_driver() == FALSE) {
    _cc_out << "{" << endl;
    _cc_out << "VHDLType* ptr = new ";
    if (this->_get_subtype()->_is_scalar_type() == TRUE && 
	this->_get_subtype()->_is_kernel_type() == FALSE &&
	this->_get_subtype()->_is_anonymous() == FALSE){
      this->_get_subtype()->_publish_cc_kernel_type();
    }
    else {
      _publish_cc_type_name();
    }
    if(_get_subtype() != NULL) {
      _cc_out << "(ObjectBase::VARIABLE";

      
      //Yet to take care of unconstrained arrays
      if (_get_subtype()->_is_array_type() == TRUE)  {
	if (_get_subtype()->_is_anonymous() == TRUE) {
	  _cc_out << ", ";
	  _get_subtype()->_publish_cc_range();
	}
      }
      else if (type_def->_is_scalar_type() == TRUE || type_def->_is_record_type() == TRUE ){
	//nothing to be done.
      }
      else if ( type_def != NULL) {
        _cc_out << ",";
	type_def->_publish_cc_constructor_args();
      }
    }
    else {
      //This part needs work, assumes name is always scalr type
      //but not necessarily true
      _cc_out << "(ObjectBase::VARIABLE";
    }
    _cc_out << ");" << endl;
    if(_is_composite_resolved_signal() == TRUE) {
      _cc_out << "ptr->setParentCompositeType(ptr);" << endl;
    }
    _cc_out << "addChild(";
    if ((_current_publish_node != NULL ) && (_current_publish_node->_is_concurrent_statement() == TRUE )){
      ((IIR_ConcurrentStatement *)_current_publish_node)->_publish_cc_scoping_prefix(_get_prefix_declaration()->_get_declarative_region(), _current_publish_node);
    }
    _publish_cc_elaborate();
    _cc_out << ", *(ptr)";
    _cc_out << ptr;
    _cc_out << "};" << endl;
  }
}

void
IIRScram_Name::_publish_cc_binding_name(ostream& outstream) {
  get_prefix()->_publish_cc_binding_name(outstream);
}

ostream &
IIRScram_Name::_print( ostream &os ){

  get_prefix()->_print( os );
  
  return os;
}

set<IIR_Declaration> *
IIRScram_Name::_symbol_lookup(){
  _report_undefined_scram_fn("_symbol_lookup()");
  return NULL;
}

set<IIR_Declaration> *
IIRScram_Name::_symbol_lookup( IIR_Declaration *decl ){
  return decl->_find_declarations( (IIR_Name *)this );
}

set<IIR_Declaration> *
IIRScram_Name::_symbol_lookup( set<IIR_Declaration> * ){
  _report_undefined_scram_fn("_symbol_lookup( set<IIR_Declaration> *");
  
  return NULL;
}

set<IIR_Declaration> *
IIRScram_Name::_symbol_lookup( IIR_Boolean (IIR::*constraint_function)() ){
  return IIR::_symbol_lookup( constraint_function );
}

IIR_TextLiteral *
IIRScram_Name::_get_prefix_string(){
  return get_prefix()->_get_prefix_string();
}


IIR_TextLiteral *
IIRScram_Name::_get_declarator() {
  return get_prefix()->_get_declarator();
}

void 
IIRScram_Name::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  if(_is_signal() == FALSE) {
    return;
  }
  if(_is_longest_static_prefix() == TRUE) {
    IIR_Designator *node = sensitivity_list->first();
    while (node != NULL) {
      ASSERT(node->get_kind() == IIR_DESIGNATOR_EXPLICIT);
      if (((IIR_DesignatorExplicit*)node)->get_name() == this) { break; }
      node = sensitivity_list->successor(node);
    }
    if (node == NULL) {
      IIR_DesignatorExplicit *new_designator = new IIR_DesignatorExplicit;
      copy_location( this, new_designator );
      new_designator->set_name(this);
      sensitivity_list->append(new_designator);
    }
  }
  else {
    get_prefix()->_build_sensitivity_list(sensitivity_list);
  }
}

void
IIRScram_Name::_get_signal_source_info(set<IIR_Declaration>* siginfo) {
  if(_is_longest_static_prefix() == TRUE) {
    siginfo->add((IIR_Declaration*)this);
  }
  else {
    get_prefix()->_get_signal_source_info(siginfo);
  }
}

void
IIRScram_Name::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  if ( _is_signal() == TRUE && _is_longest_static_prefix() == TRUE ){
    list->add((IIR_Declaration *)this);
  }
  else if(get_prefix()->_is_signal() == TRUE) {
    get_prefix()->_get_list_of_input_signals(list);
  }
  
  if(_get_suffix() != NULL) {
    if(_get_suffix()->_is_signal() == TRUE) {
      _get_suffix()->_get_list_of_input_signals(list);
    }
  }
}

IIR_SignalKind 
IIRScram_Name::_get_signal_kind(){
  return get_prefix()->_get_signal_kind();
}

IIR_TextLiteral *
IIRScram_Name::_get_string(){
  _report_undefined_scram_fn("IIR_TextLiteral *_get_string()");
  
  return NULL;
}

set<IIR_TypeDefinition> *
IIRScram_Name::_get_rval_set( set<IIR_TypeDefinition> *search_in,
			      IIR_Boolean (IIR::*constraint_function)() ){
  ASSERT( search_in != NULL );

  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>;
  
  IIR_TypeDefinition *current = search_in->get_element();
  while( current != NULL ){
    set<IIR_Declaration> *found = current->_find_declarations( (IIR_Name *)this );
    if( found != NULL ){
      IIR_Declaration *symbol = found->get_element();
      while( symbol != NULL ){
	if( symbol != NULL ){
	  retval->add( symbol->_get_subtype() );
	}
	symbol = found->get_next_element();
      }
      delete found;
    }
    current = search_in->get_next_element();
  }

  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }

  return retval;
}

set<IIR_TypeDefinition> *
IIRScram_Name::_get_rval_set( set<IIR_Declaration> *search_in,
			      IIR_Boolean (IIR::*constraint_function)() ){
  ASSERT( search_in != NULL );

  set<IIR_TypeDefinition> *retval = new set<IIR_TypeDefinition>;
  
  IIR_Declaration *current = search_in->get_element();

  while( current != NULL ){
    set<IIR_Declaration> *found = current->_find_declarations( (IIR_Name *)this );
    if( found != NULL ){
      IIR_Declaration *symbol = found->get_element();
      while( symbol != NULL ){
	if( _get_suffix() != NULL ){
	  set<IIR_Declaration> temp_set( symbol );
	  retval->add( _get_suffix()->_get_rval_set( &temp_set ) );
	}
	else{
	  retval->add( symbol->_get_subtype() );
	}
	symbol = found->get_next_element();
      }
      delete found;
    }
    current = search_in->get_next_element();
  }

  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }

  return retval;
}


char *
IIRScram_Name::_convert_to_library_name(){
  _report_undefined_scram_fn("_convert_to_library_name");
  
  return NULL;
}

void 
IIRScram_Name::_set_suffix(IIR *suffix){
  _report_undefined_scram_fn("_set_suffix");
}

void
IIRScram_Name::_clone(IIR_Name *clone) {
  IIR::_clone(clone);
  IIR *prefix = get_prefix()->_clone();
  clone->set_prefix(prefix);
}

void 
IIRScram_Name::_build_lib( IIR_LibraryUnit * ){
  _report_undefined_scram_fn("IIRScram_Name::_build_lib");
}
