#ifndef IIRSCRAM_OR_OPERATOR_HH
#define IIRSCRAM_OR_OPERATOR_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_OrOperator.hh,v 1.2 1999/03/09 20:55:45 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_OrOperator.hh"

class IIRScram_OrOperator : public IIRBase_OrOperator {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl_operator(ostream &);
  void _publish_cc_operator_name();
  void _publish_cc_wait_data();
  void _publish_cc_short_circuit();
  void _publish_cc_wait_data_short_circuit();
  IIR *_clone();
  IIRScram::OperatorPrecedenceLevel  _get_operator_precedence();
  bool _is_associative(IIR_Kind);
  IIR_Boolean _is_logical_operator();

protected:
  IIRScram_OrOperator() {}
  virtual ~IIRScram_OrOperator() = 0;
    
private:
};
#endif
