// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PosAttribute.cc,v 1.2 1999/03/09 20:55:56 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_PosAttribute.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "IIR_FunctionDeclaration.hh"
#include "IIR_VariableInterfaceDeclaration.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include <strstream.h>
#include "set.hh"
#include "StandardPackage.hh"

IIRScram_PosAttribute::~IIRScram_PosAttribute() {}

void 
IIRScram_PosAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL && get_suffix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'POS ";

  _vhdl_out << "(";
  get_suffix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ") ";
}

void 
IIRScram_PosAttribute::_publish_cc() {
  _publish_cc_type_attribute("POS", TRUE);
}

IIR_TextLiteral *
IIRScram_PosAttribute::_build_attribute_name() {
  char *name = "pos";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_PosAttribute::_get_subtype(){
  return StandardPackage::savant_universal_integer;
}

IIR_Declaration *
IIRScram_PosAttribute::_get_implicit_declaration( char *decl_name,
						  IIR_TypeDefinition *decl_type ){
  
  IIR_Declaration *retval = NULL;


  set<IIR_Declaration> *prefix_decls = get_prefix()->_symbol_lookup();
  IIR_Declaration *current_decl = prefix_decls->get_element();
  while( current_decl != NULL ){
    if( current_decl->_is_type() == FALSE ){
      prefix_decls->remove( current_decl );
    }
    current_decl = prefix_decls->get_next_element();
  }
  
  switch( prefix_decls->num_elements() ){
  case 0:{
    ostrstream err;
    err << "|" << *get_prefix() << "| was not declared as a discrete or physical type" << ends;
    report_error( this, err );
    break;
  }
  case 1:{
    retval = _build_function_declaration( decl_name, decl_type,
					  prefix_decls->get_element()->_get_subtype() );

    break;
  }
  default:
    report_ambiguous_error( get_prefix(), prefix_decls );
  }

  return retval;
}

void 
IIRScram_PosAttribute::_resolve_suffix_special(){
  _resolve_suffix_base_type_of_prefix();
}

