// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SelectedWaveform.cc,v 1.2 1999/03/09 20:56:27 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_SelectedWaveform.hh"
#include "IIR_List.hh"
#include "IIR_ChoiceList.hh"
#include "IIR_Choice.hh"
#include "IIR_WaveformList.hh"
#include "IIR_WaveformElement.hh"

IIRScram_SelectedWaveform::~IIRScram_SelectedWaveform() {}

void 
IIRScram_SelectedWaveform::_publish_vhdl(ostream &_vhdl_out) {
  waveform._publish_vhdl(_vhdl_out);
  _vhdl_out << " ";
  get_choice()->_publish_vhdl(_vhdl_out);
}

void
IIRScram_SelectedWaveform::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  
  // It would be like:
  // case k is
  //   when false    => NULL;
  //   when true   => NULL;
  //     kk := 5;
  // end case;
  
  // And then assuming that true and false might need to be in the sensitivity list.

  waveform._build_sensitivity_list(sensitivity_list);
}

IIR_Boolean
IIRScram_SelectedWaveform::_is_resolved(){
  IIR_Boolean retval = TRUE;
  if( get_choice()->_is_resolved() == FALSE ){
    retval = FALSE;
  }
  
  if( waveform._is_resolved() == FALSE ){
    retval = FALSE;
  }

  return retval;
}
