// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_VariableDeclaration.cc,v 1.2 1999/03/09 20:57:09 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_VariableDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "symbol_table.hh"

extern symbol_table *cgen_sym_tab_ptr;


IIRScram_VariableDeclaration::IIRScram_VariableDeclaration() {
  _my_clone = NULL;
}


IIRScram_VariableDeclaration::~IIRScram_VariableDeclaration() {}


void 
IIRScram_VariableDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "variable ";
  IIRScram_ObjectDeclaration::_publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_subtype_indication_with_expression(_vhdl_out);
}


void 
IIRScram_VariableDeclaration::_publish_cc() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    if (get_value() != NULL) {
      get_value()->_add_decl_into_cgen_symbol_table();
    }
    cgen_sym_tab_ptr->add_declaration(this);
  }

  IIRScram_Declaration::_set_scoping_prefix();
  IIRScram::_publish_cc_prefix_string();
  if (_get_currently_publishing_unit() == IIRScram::TYPE) {
    _publish_cc_value();
  }
  else {
    _get_declarator()->_publish_cc();
  }
  IIRScram_Declaration::_reset_scoping_prefix();
}


// ASSUMPTION: This method is called for publishing of ranges only, which
// are decided according to the initialization value at compile time.
void
IIRScram_VariableDeclaration::_publish_cc_value() {
  if (get_value() != NULL) {
    get_value()->_publish_cc_value();
  } 
  else {
    if (_get_subtype()->_is_iir_scalar_type_definition() == TRUE){ 
      IIR_ScalarTypeDefinition *typeDef = 
	(IIR_ScalarTypeDefinition *)_get_subtype();
      typeDef->get_left()->_publish_cc_value();
    }
  }
}


void 
IIRScram_VariableDeclaration::_publish_cc_universal_value() {
  if (get_value() != NULL) {
    get_value()->_publish_cc_universal_value();
  }
  else {
    if (_get_subtype()->_is_iir_scalar_type_definition() == TRUE){
      IIR_ScalarTypeDefinition *typeDef = 
	(IIR_ScalarTypeDefinition *)_get_subtype();
      typeDef->get_left()->_publish_cc_universal_value();
    }
  }
}


void 
IIRScram_VariableDeclaration::_publish_cc_decl() {
  switch (get_subtype()->get_kind()) {
  case IIR_ACCESS_TYPE_DEFINITION:
  case IIR_ACCESS_SUBTYPE_DEFINITION:
    get_subtype()->_publish_cc_type_name();
    _cc_out <<  " ";
    _get_declarator()->_publish_cc();
    _cc_out << ";\n";
    break;
  case IIR_FILE_TYPE_DEFINITION:
    get_subtype()->_publish_cc();
    break;
  default:
    if (_get_subtype()->_is_scalar_type() == TRUE) {
      _get_subtype()->_publish_cc_kernel_type();
    }
    else {
      get_subtype()->_publish_cc();
    }
    _cc_out << " ";
    _get_declarator()->_publish_cc();
    _cc_out << ";\n";
    break;
  }
}


void 
IIRScram_VariableDeclaration::_publish_cc_init() {
  if (get_value() == NULL) {
    switch(get_subtype()->get_kind()) {
    case IIR_ARRAY_TYPE_DEFINITION:
    case IIR_ARRAY_SUBTYPE_DEFINITION:
      if (get_subtype()->_has_access_type() == FALSE) {
	_publish_cc_composite_init();
      }
      break;
    case IIR_RECORD_TYPE_DEFINITION:
      _publish_cc_composite_init();
      break;
    case IIR_ACCESS_TYPE_DEFINITION:
    case IIR_ACCESS_SUBTYPE_DEFINITION:
      _publish_cc_access_init();
      break;
    case IIR_FILE_TYPE_DEFINITION:
      _publish_cc_file_init();
      break;
    default:
      _publish_cc_scalar_init();
      break;
    }
  }
}


void
IIRScram_VariableDeclaration::_publish_cc_scalar_init() {
  _cc_out << "assignVariable(";
  _get_declarator()->_publish_cc();
  _cc_out << ", ";
  get_subtype()->_publish_cc_left();
  _cc_out << ", defaultInfo, defaultInfo);\n";
}


void 
IIRScram_VariableDeclaration::_publish_cc_data() {
  _cc_out << "state->current->";
  _get_declarator()->_publish_cc();
}


IIRScram_Declaration::declaration_type 
IIRScram_VariableDeclaration::_get_type() {
  return VARIABLE;
}


void 
IIRScram_VariableDeclaration::_publish_cc_wait_data() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "s->";
  _get_declarator()->_publish_cc();
}


void
IIRScram_VariableDeclaration::_publish_cc_composite_init() {
  ostrstream labelstr;
  char *procname = _current_publish_name;
  IIR* temporaryNode = _current_publish_node;

  //Reset the index counter since a new variable declaration is initialized
  _index_level = 0;

  _get_declarator()->_print(labelstr);
  labelstr << ends;
  _current_publish_name = labelstr.str();
  _current_publish_node = this;
  _cc_out << "{\n";//begin dummy block for scoping
  get_subtype()->_publish_cc_composite_init();
  _cc_out << "}\n";//end dummy block

  delete [] _current_publish_name;
  _current_publish_name = procname;
  _current_publish_node = temporaryNode;
}


void
IIRScram_VariableDeclaration::_publish_cc_access_init() {
  _get_declarator()->_publish_cc();
  _cc_out << ".val = NULL;\n";
}


void
IIRScram_VariableDeclaration::_publish_cc_file_init() {
  //Yet to do file declarations
  //I don't know if this function will ever be entered
  cerr << "Mystery abort in IIRScram_VariableDeclaration::_publish_cc_file_init()!\n";
  abort();
}


// Note: This function is also used in
// IIRScram_SubprogramDeclaration::_publish_cc_declarations().  I did not
// want to copy the same code to another function. -- SK
void
IIRScram_VariableDeclaration::_publish_cc_state_object_init() {
  _get_declarator()->_publish_cc();
  _publish_cc_constructor_args();
  _cc_out << ", ";

}

void
IIRScram_VariableDeclaration::_publish_cc_object_type() {
  _cc_out << "VARIABLE";
}


void
IIRScram_VariableDeclaration::_publish_cc_kernel_type() {
  get_subtype()->_publish_cc_kernel_type();
}


void
IIRScram_VariableDeclaration::_publish_cc_headers() {
  _cc_out << "#include \"";
  get_subtype()->_publish_cc_type_name();
  _cc_out << ".hh\"\n";
  get_subtype()->_publish_cc_headers();
}

IIR*
IIRScram_VariableDeclaration::_clone() {
  if ( _my_clone == NULL ) {
    _my_clone = new IIR_VariableDeclaration;
    IIRScram_ObjectDeclaration::_clone(_my_clone);

    _my_clone->set_value( get_value() );
  }
  return _my_clone;
}
