// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_VariableInterfaceDeclaration.cc,v 1.2 1999/03/09 20:57:11 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include <strstream.h>
#include "IIRScram_VariableInterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "error_func.hh"
#include "symbol_table.hh"
extern symbol_table *cgen_sym_tab_ptr;

IIRScram_VariableInterfaceDeclaration::~IIRScram_VariableInterfaceDeclaration(){}

void 
IIRScram_VariableInterfaceDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " variable ";
  IIRScram_ObjectDeclaration::_publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_mode(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);
  _publish_vhdl_expression(_vhdl_out);
}

IIRScram_Declaration::declaration_type 
IIRScram_VariableInterfaceDeclaration::_get_type(){
   return INTERFACE_VARIABLE;
}

void 
IIRScram_VariableInterfaceDeclaration::_publish_cc() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }

  IIRScram::_publish_cc_prefix_string();
  _get_declarator()->_publish_cc();
}


void 
IIRScram_VariableInterfaceDeclaration::_publish_cc_decl() {
  switch(get_subtype()->get_kind()) {
  case IIR_ARRAY_TYPE_DEFINITION :
  case IIR_ARRAY_SUBTYPE_DEFINITION:
  case IIR_RECORD_TYPE_DEFINITION:
    get_subtype()->_publish_cc();
    _cc_out << " ";
    _get_declarator()->_publish_cc();
    _cc_out << ";\n";
    break;
  case IIR_ACCESS_TYPE_DEFINITION:
  case IIR_ACCESS_SUBTYPE_DEFINITION:
    //This will be called eventually
    //get_subtype()->_publish_cc();
    _cc_out << "  AccessVariable<char*> ";
    // _cc_out <<  " " << *get_declarator();
    _cc_out << " ";
    _get_declarator()->_publish_cc();
    _cc_out << ";\n";
    break;
  case IIR_FILE_TYPE_DEFINITION:
    get_subtype()->_publish_cc();
    break;
  default:
    get_subtype()->_publish_cc();
    // _cc_out <<  " " << *get_declarator();
    _cc_out << " ";
    _get_declarator()->_publish_cc();
    _cc_out << ";\n";
    break;
  };
}


void 
IIRScram_VariableInterfaceDeclaration::_publish_cc_init() {
  if (get_value() == NULL) {
    switch(get_subtype()->get_kind()) {
    case IIR_ARRAY_TYPE_DEFINITION :
    case IIR_ARRAY_SUBTYPE_DEFINITION:
    case IIR_RECORD_TYPE_DEFINITION:
      _publish_cc_composite_init();
      break;
    case IIR_ACCESS_TYPE_DEFINITION:
    case IIR_ACCESS_SUBTYPE_DEFINITION:
      _publish_cc_access_init();
      break;
    case IIR_FILE_TYPE_DEFINITION:
      _publish_cc_file_init();
      break;
    default:
      _publish_cc_scalar_init();
    };
  }
}


void
IIRScram_VariableInterfaceDeclaration::_publish_cc_scalar_init() {
  _cc_out << "  " << "((Variable<";
  get_subtype()->_publish_cc_universal_type();
  _cc_out << ">*)";
  // _cc_out << *get_declarator() << ".object)->val = ";
  _get_declarator()->_publish_cc();
  _cc_out << ".object)->val = ";
  get_subtype()->_publish_cc_left();
  _cc_out << ";\n";
}

void
IIRScram_VariableInterfaceDeclaration::_publish_cc_composite_init() {
  if(get_value() != NULL) {
    _get_declarator()->_publish_cc(); 
    //The following line will be added eventually
    //_cc_out << ".val";
    _cc_out << " = ";
    get_value()->_publish_cc();
  }
  _cc_out << ";\n";
}

void
IIRScram_VariableInterfaceDeclaration::_publish_cc_access_init() {
  _get_declarator()->_publish_cc();
  _cc_out << ".val = ";
  _cc_out << "NULL";
  _cc_out << ";\n";
}

void
IIRScram_VariableInterfaceDeclaration::_publish_cc_file_init() {
  //Yet to do file declarations
  //I don't know if this function will ever be entered
  abort();
}

void 
IIRScram_VariableInterfaceDeclaration::_publish_cc_data() {
  // _cc_out << "state.current->" << *get_declarator();
  _cc_out << "state->current->";
  _get_declarator()->_publish_cc();
}


void 
IIRScram_VariableInterfaceDeclaration::_publish_cc_wait_data() {
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  // _cc_out << "s->" << *get_declarator();
  _cc_out << "s->";
  _get_declarator()->_publish_cc();
}

IIR_Boolean
IIRScram_VariableInterfaceDeclaration::_is_variable() {
  return TRUE;
}

void
IIRScram_VariableInterfaceDeclaration::_publish_cc_state_object_init() {
// Initialization not required for access types.
  if(get_subtype()->get_kind() == IIR_ACCESS_TYPE_DEFINITION ||
     get_subtype()->get_kind() == IIR_ACCESS_SUBTYPE_DEFINITION) {
    return;
  }
  _get_declarator()->_publish_cc();
  _publish_cc_constructor_args();
  _cc_out << ", ";
}

void
IIRScram_VariableInterfaceDeclaration::_publish_cc_object_type() {
  _cc_out << "VARIABLE";
}

IIR*
IIRScram_VariableInterfaceDeclaration::_clone() {
  return this;
}


void 
IIRScram_VariableInterfaceDeclaration::_type_check( IIRScram_InterfaceDeclaration::_InterfaceListType ){
  IIR_InterfaceDeclaration::_type_check();
  if( get_mode() != IIR_IN_MODE && get_value() != NULL ){
    ostrstream err;
    err << "Formal variable parameter |" << *get_declarator() << "| has mode IN and "
	<< "therefore may not have a default expression." << ends;
    report_error( this, err );
  }
}
