%option yyclass="VHDLLexer"

%{

// Copyright (c) 1996-97 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: VHDLLexer.flex,v 1.2 1999/07/23 21:08:17 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "VHDLLexer.hh"
#include "VHDLTokenTypes.hh"
#include <ctype.h>

#include "bool.hh"
// global flag for parse errors
extern bool parse_error;

// define type signature and name for scanner
#undef YY_DECL
#define YY_DECL ANTLRAbstractToken *VHDLLexer::getToken()

%}

%s ATTR

%%

[\t\v\f\r ]*\-\-.*\n	|

[\t\v\f\r ]*\n	{
    _LineNo = _LineNo + 1;
    _LineOffset = 1;
    _FileOffset = _FileOffset + YYLeng();
}

[\t\v\f\r ]+		{advanceOffsets( YYLeng() );}

<ATTR>active		{BEGIN(INITIAL); return buildToken( ACTIVE, yyleng );}
<ATTR>ascending		{BEGIN(INITIAL); return buildToken( ASCENDING, yyleng );}
<ATTR>base		{BEGIN(INITIAL); return buildToken( BASE, yyleng );}
<ATTR>delayed		{BEGIN(INITIAL); return buildToken( DELAYED, yyleng );}
<ATTR>driving_value	{BEGIN(INITIAL); return buildToken( DRIVING_VALUE, yyleng );}
<ATTR>driving		{BEGIN(INITIAL); return buildToken( DRIVING, yyleng );}
<ATTR>event    		{BEGIN(INITIAL); return buildToken( EVENT, yyleng );}
<ATTR>high		{BEGIN(INITIAL); return buildToken( HIGH, yyleng );}
<ATTR>image		{BEGIN(INITIAL); return buildToken( IMAGE, yyleng );}
<ATTR>instance_name	{BEGIN(INITIAL); return buildToken( INSTANCE_NAME, yyleng );}
<ATTR>last_active	{BEGIN(INITIAL); return buildToken( LAST_ACTIVE, yyleng );}
<ATTR>last_event	{BEGIN(INITIAL); return buildToken( LAST_EVENT, yyleng );}
<ATTR>last_value	{BEGIN(INITIAL); return buildToken( LAST_VALUE, yyleng );}
<ATTR>leftof		{BEGIN(INITIAL); return buildToken( LEFTOF, yyleng );}
<ATTR>left		{BEGIN(INITIAL); return buildToken( LEFT, yyleng );}
<ATTR>length		{BEGIN(INITIAL); return buildToken( LENGTH, yyleng );}
<ATTR>low		{BEGIN(INITIAL); return buildToken( LOW, yyleng );}
<ATTR>path_name		{BEGIN(INITIAL); return buildToken( PATH_NAME, yyleng );}
<ATTR>pos		{BEGIN(INITIAL); return buildToken( POS, yyleng );}
<ATTR>pred		{BEGIN(INITIAL); return buildToken( PRED, yyleng );}
<ATTR>rightof		{BEGIN(INITIAL); return buildToken( RIGHTOF, yyleng );}
<ATTR>right		{BEGIN(INITIAL); return buildToken( RIGHT, yyleng );}
<ATTR>reverse_range	{BEGIN(INITIAL); return buildToken( REVERSE_RANGE, yyleng );}
<ATTR>simple_name	{BEGIN(INITIAL); return buildToken( SIMPLE_NAME, yyleng );}
<ATTR>stable		{BEGIN(INITIAL); return buildToken( STABLE, yyleng );}
<ATTR>succ		{BEGIN(INITIAL); return buildToken( SUCC, yyleng );}
<ATTR>transaction	{BEGIN(INITIAL); return buildToken( TRANSACTION, yyleng );}
<ATTR>quiet		{BEGIN(INITIAL); return buildToken( QUIET, yyleng );}
<ATTR>value		{BEGIN(INITIAL); return buildToken( VALUE, yyleng );}
<ATTR>val		{BEGIN(INITIAL); return buildToken( VAL, yyleng );}


&		{BEGIN(INITIAL); return buildToken( AMPERSAND, yyleng );}
\(		{BEGIN(INITIAL); return buildToken( L_PAREN, yyleng );}
\)		{BEGIN(INITIAL); return buildToken( R_PAREN, yyleng );}
\[		{BEGIN(INITIAL); return buildToken( L_BRACKET, yyleng );}
\]		{BEGIN(INITIAL); return buildToken( R_BRACKET, yyleng );}
,		{BEGIN(INITIAL); return buildToken( COMMA, yyleng );}

:=		{BEGIN(INITIAL); return buildToken( COLON_EQUAL, yyleng );}
:		{BEGIN(INITIAL); return buildToken( COLON, yyleng );}
;		{BEGIN(INITIAL); return buildToken( SEMI_COLON, yyleng );}
\<\>		{BEGIN(INITIAL); return buildToken( LESS_GREATER, yyleng );}
\<=		{BEGIN(INITIAL); return buildToken( LESS_EQUAL, yyleng );}
\<		{BEGIN(INITIAL); return buildToken( LESS, yyleng );}
=\>		{BEGIN(INITIAL); return buildToken( EQUAL_GREATER, yyleng );}
=		{BEGIN(INITIAL); return buildToken( EQUAL, yyleng );}
\>=		{BEGIN(INITIAL); return buildToken( GREATER_EQUAL, yyleng );}
\>		{BEGIN(INITIAL); return buildToken( GREATER, yyleng );}
\|		{BEGIN(INITIAL); return buildToken( CHOICE1, yyleng );}
\!		{BEGIN(INITIAL); return buildToken( CHOICE2, yyleng );}
\/=		{BEGIN(INITIAL); return buildToken( NOT_EQUAL, yyleng );}
\.		{BEGIN(INITIAL); return buildToken( DOT, yyleng );}

\*\*		{BEGIN(INITIAL); return buildToken( EXPONENT, yyleng );}
\*		{BEGIN(INITIAL); return buildToken( MULTIPLY, yyleng );}
\/		{BEGIN(INITIAL); return buildToken( DIVIDE, yyleng );}
\+		{BEGIN(INITIAL); return buildToken( PLUS, yyleng );}
\-		{BEGIN(INITIAL); return buildToken( MINUS, yyleng );}


abs		{BEGIN(INITIAL); return buildToken( ABS, yyleng );}
access		{BEGIN(INITIAL); return buildToken( ACCESS, yyleng );}
after		{BEGIN(INITIAL); return buildToken( AFTER, yyleng );}
alias		{BEGIN(INITIAL); return buildToken( ALIAS, yyleng );}
all		{BEGIN(INITIAL); return buildToken( ALL, yyleng );}
and		{BEGIN(INITIAL); return buildToken( AND, yyleng );}
architecture	{BEGIN(INITIAL); return buildToken( ARCHITECTURE, yyleng );}
array		{BEGIN(INITIAL); return buildToken( ARRAY, yyleng );}
assert		{BEGIN(INITIAL); return buildToken( ASSERT, yyleng );}
attribute	{BEGIN(INITIAL); return buildToken( ATTRIBUTE, yyleng );}
begin		{BEGIN(INITIAL); return buildToken( BEGIN_, yyleng );}
block		{BEGIN(INITIAL); return buildToken( BLOCK, yyleng );}
body		{BEGIN(INITIAL); return buildToken( BODY, yyleng );}
buffer		{BEGIN(INITIAL); return buildToken( BUFFER, yyleng );}
bus		{BEGIN(INITIAL); return buildToken( BUS, yyleng );}
case		{BEGIN(INITIAL); return buildToken( CASE, yyleng );}
component	{BEGIN(INITIAL); return buildToken( COMPONENT, yyleng );}
configuration	{BEGIN(INITIAL); return buildToken( CONFIGURATION, yyleng );}
constant	{BEGIN(INITIAL); return buildToken( CONSTANT, yyleng );}
disconnect	{BEGIN(INITIAL); return buildToken( DISCONNECT, yyleng );}
downto		{BEGIN(INITIAL); return buildToken( DOWNTO, yyleng );}
else		{BEGIN(INITIAL); return buildToken( ELSE, yyleng );}
elsif		{BEGIN(INITIAL); return buildToken( ELSIF, yyleng );}
end		{BEGIN(INITIAL); return buildToken( END, yyleng );}
entity		{BEGIN(INITIAL); return buildToken( ENTITY, yyleng );}
exit		{BEGIN(INITIAL); return buildToken( EXIT, yyleng );}
file		{BEGIN(INITIAL); return buildToken( FILE_, yyleng );}
for		{BEGIN(INITIAL); return buildToken( FOR, yyleng );}
function	{BEGIN(INITIAL); return buildToken( FUNCTION, yyleng );}
generate	{BEGIN(INITIAL); return buildToken( GENERATE, yyleng );}
generic		{BEGIN(INITIAL); return buildToken( GENERIC, yyleng );}
group		{BEGIN(INITIAL); return buildToken( GROUP, yyleng );}
guarded		{BEGIN(INITIAL); return buildToken( GUARDED, yyleng );}
if		{BEGIN(INITIAL); return buildToken( IF, yyleng );}
impure		{BEGIN(INITIAL); return buildToken( IMPURE, yyleng );}
inertial	{BEGIN(INITIAL); return buildToken( INERTIAL, yyleng );}
inout		{BEGIN(INITIAL); return buildToken( INOUT, yyleng );}
in		{BEGIN(INITIAL); return buildToken( IN, yyleng );}
is		{BEGIN(INITIAL); return buildToken( IS, yyleng );}
label		{BEGIN(INITIAL); return buildToken( LABEL, yyleng );}
library		{BEGIN(INITIAL); return buildToken( LIBRARY, yyleng );}
linkage		{BEGIN(INITIAL); return buildToken( LINKAGE, yyleng );}
literal		{BEGIN(INITIAL); return buildToken( LITERAL, yyleng );}
loop		{BEGIN(INITIAL); return buildToken( LOOP, yyleng );}
map		{BEGIN(INITIAL); return buildToken( MAP, yyleng );}
mod		{BEGIN(INITIAL); return buildToken( MOD, yyleng );}
nand		{BEGIN(INITIAL); return buildToken( NAND, yyleng );}
new		{BEGIN(INITIAL); return buildToken( NEW, yyleng );}
next		{BEGIN(INITIAL); return buildToken( NEXT, yyleng );}
nor		{BEGIN(INITIAL); return buildToken( NOR, yyleng );}
not		{BEGIN(INITIAL); return buildToken( NOT, yyleng );}
null		{BEGIN(INITIAL); return buildToken( NULL_, yyleng );}
of		{BEGIN(INITIAL); return buildToken( OF, yyleng );}
on		{BEGIN(INITIAL); return buildToken( ON, yyleng );}
open		{BEGIN(INITIAL); return buildToken( OPEN, yyleng );}
or		{BEGIN(INITIAL); return buildToken( OR, yyleng );}
others		{BEGIN(INITIAL); return buildToken( OTHERS, yyleng );}
out		{BEGIN(INITIAL); return buildToken( OUT, yyleng );}
package		{BEGIN(INITIAL); return buildToken( PACKAGE, yyleng );}
port		{BEGIN(INITIAL); return buildToken( PORT, yyleng );}
postponed	{BEGIN(INITIAL); return buildToken( POSTPONED, yyleng );}
procedure	{BEGIN(INITIAL); return buildToken( PROCEDURE, yyleng );}
process		{BEGIN(INITIAL); return buildToken( PROCESS, yyleng );}
pure		{BEGIN(INITIAL); return buildToken( PURE, yyleng );}
range		{BEGIN(INITIAL); return buildToken( RANGE, yyleng );}
record		{BEGIN(INITIAL); return buildToken( RECORD, yyleng );}
register	{BEGIN(INITIAL); return buildToken( REGISTER, yyleng );}
reject		{BEGIN(INITIAL); return buildToken( REJECT_, yyleng );}
rem		{BEGIN(INITIAL); return buildToken( REM, yyleng );}
report		{BEGIN(INITIAL); return buildToken( REPORT, yyleng );}
return		{BEGIN(INITIAL); return buildToken( RETURN, yyleng );}
rol		{BEGIN(INITIAL); return buildToken( ROL, yyleng );}
ror		{BEGIN(INITIAL); return buildToken( ROR, yyleng );}
select		{BEGIN(INITIAL); return buildToken( SELECT, yyleng );}
severity	{BEGIN(INITIAL); return buildToken( SEVERITY, yyleng );}
sla		{BEGIN(INITIAL); return buildToken( SLA, yyleng );}
sll		{BEGIN(INITIAL); return buildToken( SLL, yyleng );}
sra		{BEGIN(INITIAL); return buildToken( SRA, yyleng );}
srl		{BEGIN(INITIAL); return buildToken( SRL, yyleng );}
shared		{BEGIN(INITIAL); return buildToken( SHARED, yyleng );}
signal		{BEGIN(INITIAL); return buildToken( SIGNAL, yyleng );}
subtype		{BEGIN(INITIAL); return buildToken( SUBTYPE, yyleng );}
then		{BEGIN(INITIAL); return buildToken( THEN, yyleng );}
to		{BEGIN(INITIAL); return buildToken( TO, yyleng );}
transport	{BEGIN(INITIAL); return buildToken( TRANSPORT, yyleng );}
type		{BEGIN(INITIAL); return buildToken( TYPE, yyleng );}
units		{BEGIN(INITIAL); return buildToken( UNITS, yyleng );}
until		{BEGIN(INITIAL); return buildToken( UNTIL, yyleng );}
unaffected	{BEGIN(INITIAL); return buildToken( UNAFFECTED, yyleng );}
use		{BEGIN(INITIAL); return buildToken( USE, yyleng );}
variable	{BEGIN(INITIAL); return buildToken( VARIABLE, yyleng );}
wait		{BEGIN(INITIAL); return buildToken( WAIT, yyleng );}
when		{BEGIN(INITIAL); return buildToken( WHEN, yyleng );}
while		{BEGIN(INITIAL); return buildToken( WHILE, yyleng );}
with		{BEGIN(INITIAL); return buildToken( WITH, yyleng );}
xor		{BEGIN(INITIAL); return buildToken( XOR, yyleng );}
xnor		{BEGIN(INITIAL); return buildToken( XNOR, yyleng );}


[a-z----](_?[a-z----0-9]+)*	{
    int j;

    BEGIN(INITIAL); 

    // downcase the identifier
    for (j = 0; j <= yyleng; j++) {yytext[j] = tolower(yytext[j]);};

    return buildIdentifierToken( BASIC_IDENTIFIER, yytext, yyleng );
}

\\([^\\\000-\037\177-\237]|\\\\)+\\	{BEGIN(INITIAL); return buildIdentifierToken( EXTENDED_IDENTIFIER, (char *)YYText(), yyleng );}


((0[_0]*)?2\#[0-1](_?[0-1]+)*\.[0-1](_?[0-1]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?2\:[0-1](_?[0-1]+)*\.[0-1](_?[0-1]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?2\#[0-1](_?[0-1]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?2\:[0-1](_?[0-1]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?3\#[0-2](_?[0-2]+)*\.[0-2](_?[0-2]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?3\:[0-2](_?[0-2]+)*\.[0-2](_?[0-2]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?3\#[0-2](_?[0-2]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?3\:[0-2](_?[0-2]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?4\#[0-3](_?[0-3]+)*\.[0-3](_?[0-3]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?4\:[0-3](_?[0-3]+)*\.[0-3](_?[0-3]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?4\#[0-3](_?[0-3]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?4\:[0-3](_?[0-3]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?5\#[0-4](_?[0-4]+)*\.[0-4](_?[0-4]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?5\:[0-4](_?[0-4]+)*\.[0-4](_?[0-4]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?5\#[0-4](_?[0-4]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?5\:[0-4](_?[0-4]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?6\#[0-5](_?[0-5]+)*\.[0-5](_?[0-5]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?6\:[0-5](_?[0-5]+)*\.[0-5](_?[0-5]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?6\#[0-5](_?[0-5]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?6\:[0-5](_?[0-5]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL); 
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?7\#[0-6](_?[0-6]+)*\.[0-6](_?[0-6]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?7\:[0-6](_?[0-6]+)*\.[0-6](_?[0-6]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?7\#[0-6](_?[0-6]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?7\:[0-6](_?[0-6]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?8\#[0-7](_?[0-7]+)*\.[0-7](_?[0-7]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?8\:[0-7](_?[0-7]+)*\.[0-7](_?[0-7]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?8\#[0-7](_?[0-7]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?8\:[0-7](_?[0-7]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?9\#[0-8](_?[0-8]+)*\.[0-8](_?[0-8]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?9\:[0-8](_?[0-8]+)*\.[0-8](_?[0-8]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?9\#[0-8](_?[0-8]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?9\:[0-8](_?[0-8]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?0\#[0-9](_?[0-9]+)*\.[0-9](_?[0-9]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?0\:[0-9](_?[0-9]+)*\.[0-9](_?[0-9]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?0\#[0-9](_?[0-9]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?0\:[0-9](_?[0-9]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?1\#[0-9a](_?[0-9a]+)*\.[0-9a](_?[0-9a]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?1\:[0-9a](_?[0-9a]+)*\.[0-9a](_?[0-9a]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?1\#[0-9a](_?[0-9a]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?1\:[0-9a](_?[0-9a]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?2\#[0-9a-b](_?[0-9a-b]+)*\.[0-9a-b](_?[0-9a-b]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?2\:[0-9a-b](_?[0-9a-b]+)*\.[0-9a-b](_?[0-9a-b]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?2\#[0-9a-b](_?[0-9a-b]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?2\:[0-9a-b](_?[0-9a-b]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?3\#[0-9a-c](_?[0-9a-c]+)*\.[0-9a-c](_?[0-9a-c]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?3\:[0-9a-c](_?[0-9a-c]+)*\.[0-9a-c](_?[0-9a-c]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?3\#[0-9a-c](_?[0-9a-c]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?3\:[0-9a-c](_?[0-9a-c]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?4\#[0-9a-d](_?[0-9a-d]+)*\.[0-9a-d](_?[0-9a-d]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?4\:[0-9a-d](_?[0-9a-d]+)*\.[0-9a-d](_?[0-9a-d]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?4\#[0-9a-d](_?[0-9a-d]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?4\:[0-9a-d](_?[0-9a-d]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?5\#[0-9a-e](_?[0-9a-e]+)*\.[0-9a-e](_?[0-9a-e]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?5\:[0-9a-e](_?[0-9a-e]+)*\.[0-9a-e](_?[0-9a-e]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?5\#[0-9a-e](_?[0-9a-e]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?5\:[0-9a-e](_?[0-9a-e]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?6\#[0-9a-f](_?[0-9a-f]+)*\.[0-9a-f](_?[0-9a-f]+)*\#(e(\+|\-)?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?6\:[0-9a-f](_?[0-9a-f]+)*\.[0-9a-f](_?[0-9a-f]+)*\:(e(\+|\-)?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedFloatToken( (char *)YYText(), yyleng );
}

((0[_0]*)?1_?6\#[0-9a-f](_?[0-9a-f]+)*\#(e\+?[0-9](_?[0-9]+)*)?|(0[_0]*)?1_?6\:[0-9a-f](_?[0-9a-f]+)*\:(e\+?[0-9](_?[0-9]+)*)?) {
	BEGIN(INITIAL);
	return buildBasedIntToken( (char *)YYText(), yyleng );
}

((0[_0]*)?(2|3|4|5|6|7|8|9|(1_?0)|(1_?1)|(1_?2)|(1_?3)|(1_?4)|(1_?5)|(1_?6))\#[0-9a-f](_?[0-9a-f]+)*\#(e\-[0-9](_?[0-9]+)*)?|(0[_0]*)?(2|3|4|5|6|7|8|9|(1_?0)|(1_?1)|(1_?2)|(1_?3)|(1_?4)|(1_?5)|(1_?6))\:[0-9a-f](_?[0-9a-f]+)*\:(e\-[0-9](_?[0-9]+)*)?) {
	cerr 
	     << "file: "
	     << _FileName
	     << "line: " 
	     << _LineNo
	     << ": Illegal based integer literal "
             << yytext
             << ".  Negative exponent not allowed."
             << endl;
	parse_error = TRUE;
	BEGIN(INITIAL);
	return buildBasedIntToken( "2#00#", 5 ); // default for continuing parse
}


b\"[0-1](_?[0-1]+)*\"|b\%[0-1](_?[0-1]+)*\%|o\"[0-7](_?[0-7]+)*\"|o\%[0-7](_?[0-7]+)*\%|x\"[0-9a-f](_?[0-9a-f]+)*\"|x\%[0-9a-f](_?[0-9a-f]+)*\% {
	BEGIN(INITIAL); 
	return buildLiteralToken( BIT_STRING_LITERAL, (char *)YYText(), yyleng );
}

[0-9](_?[0-9]+)*\.[0-9](_?[0-9]+)*(e(\+|\-)?[0-9](_?[0-9]+)*)? {
	BEGIN(INITIAL); 
	return buildDecimalFloatToken( (char *)YYText(), yyleng );
}

[0-9](_?[0-9]+)*(e\+?[0-9](_?[0-9]+)*)? {
	BEGIN(INITIAL); 
	return buildDecimalIntToken( (char *)YYText(), yyleng );
}

[0-9](_?[0-9]+)*(e\-?[0-9](_?[0-9]+)*)? {
	cerr 
	     << "file: "
	     << _FileName
	     << "line: " 
	     << _LineNo
	     << ": Illegal integer literal "
             << yytext
             << ".  Negative exponent not allowed."
             << endl;
	parse_error = TRUE;
	BEGIN(INITIAL); 
	return buildDecimalIntToken( "0", 1 ); // default to continue parse
}

(\"([0-9a-z\ \#\&\;\(\)\*\+\,\-\.\/\:\;\<\=\>\_\|\!\$\%\@\?\[\\\]\^\`\'\{\}\~]|(\"\"))*\"|\%([0-9a-z\ \#\&\;\(\)\*\+\,\-\.\/\:\;\<\=\>\_\|\!\$\@\?\[\\\]\^\`\'\{\}\~]|(\%\%))*\%) {
	BEGIN(INITIAL); 
	return buildLiteralToken( STRING_LITERAL, (char *)YYText(), yyleng );
}

\%([0-9a-z\ \#\&\;\(\)\*\+\,\-\.\/\:\;\<\=\>\_\|\!\$\@\?\[\\\]\^\`\'\{\}\~]|(\%\%))*\"([0-9a-z\ \#\&\;\(\)\*\+\,\-\.\/\:\;\<\=\>\_\|\!\$\"\@\?\[\\\]\^\`\'\{\}\~]|(\%\%))*\% {
	cerr 
	     << "file: "
	     << _FileName
	     << " line: " 
	     << _LineNo
	     << " Illegal quote character (\") encountered in percent (%) bounded string literal:"
	     << endl << "    " << yytext << endl
	     << "seen.  Matching zero length string literal (%%)." << endl;
	parse_error = TRUE;
	BEGIN(INITIAL); 
	return buildLiteralToken( STRING_LITERAL, "%%", 1 );
}

\'\(\'(,\'.\')+	{
	yyless(3);
	BEGIN(INITIAL);
	return buildLiteralToken(CHARACTER_LITERAL, (char *)YYText(), yyleng );
}

\'\(\'.\'	{
	yyless(1);
	BEGIN(INITIAL);
	return buildToken( QUOTE, 1 );
}

\'.\'		{BEGIN(INITIAL); return buildLiteralToken(CHARACTER_LITERAL, (char *)YYText(), yyleng );}

\'\(		{
	yyless(1);
	BEGIN(INITIAL);
	return buildToken( QUOTE, 1 );
}

\'		{BEGIN(ATTR); return buildToken( QUOTE, 1 );}


.	{
	cerr 
	     << "file: "
	     << _FileName
	     << " line: " 
	     << _LineNo
	     << " Illegal character '"
	     << yytext
	     << "' seen.  Ignored" << endl;
	parse_error = TRUE;
}

<<EOF>>	{BEGIN(INITIAL); return buildToken( ENDFILE, 0 );}

%%

int yywrap() {return 1;}
