#ifndef LIST_OBJECT_HH
#define LIST_OBJECT_HH
#include <stdlib.h>

#ifndef NULL
#define NULL 0
#endif

class list_object {
  friend class iterator;
  friend class list;

public:
  inline list_object(){
    next = NULL;
    previous = NULL;
  }

  inline list_object( list_object *previous_object, list_object *next_object ){
    previous = previous_object;
    next = next_object;
  }

  virtual ~list_object() = 0;
  

protected:

  inline void 
  put_between( list_object *prev_object, list_object *next_object ){
    set_previous( prev_object );
    set_next( next_object );
  }

  inline list_object *get_next(){
    return next;
  }

  inline void set_next( list_object *new_next ){
    next = new_next;
  }


  inline list_object *get_previous(){
    return previous;
  }

  inline void set_previous( list_object *new_prev ){
    previous = new_prev;
  }

  list_object *previous;
  list_object *next;
};

inline list_object::~list_object(){}
#endif
