
#ifndef IIRBASE_ARCHITECTURE_DECLARATION_HH
#define IIRBASE_ARCHITECTURE_DECLARATION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer

//---------------------------------------------------------------------------

#include "IIR_LibraryUnit.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_ArchitectureStatementList.hh"

class IIR_EntityDeclaration;

class IIRBase_ArchitectureDeclaration : public IIR_LibraryUnit {

public:
  IIR_Kind get_kind() const {return IIR_ARCHITECTURE_DECLARATION;}
  IIR_Char *get_kind_text() const {return "IIR_ArchitectureDeclaration";}

  void associate(IIR_EntityDeclaration *);
  void set_entity(IIR_EntityDeclaration *);
  IIR_EntityDeclaration* get_entity();

  IIR_DeclarationList           architecture_declarative_part;
  IIR_ArchitectureStatementList architecture_statement_part;

protected:
  IIRBase_ArchitectureDeclaration();
  virtual ~IIRBase_ArchitectureDeclaration() = 0;
    
private:
  IIR_EntityDeclaration* entity;
};
#endif
