
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Sivakumar Gowrisankar             gowriss@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ArrayNatureDefinition.hh"

IIRBase_ArrayNatureDefinition::IIRBase_ArrayNatureDefinition() {
  index_subtype = NULL;
  element_subtype = NULL;
  my_is_element = false;
}

IIRBase_ArrayNatureDefinition::~IIRBase_ArrayNatureDefinition() {}

IIR_NatureDefinition *
IIRBase_ArrayNatureDefinition::get_element_subtype(){
  return element_subtype;
}

IIR_ScalarTypeDefinition *
IIRBase_ArrayNatureDefinition::get_index_subtype(){
  return index_subtype;
}
 
IIR_Boolean
IIRBase_ArrayNatureDefinition::is_element(){
  return my_is_element;
}
 
void
IIRBase_ArrayNatureDefinition::set_element_subtype( IIR_NatureDefinition *new_element_type ){
  element_subtype = new_element_type;
}
 
void
IIRBase_ArrayNatureDefinition::set_index_subtype( IIR_ScalarTypeDefinition *new_index_type ){
  index_subtype = new_index_type;
}

void
IIRBase_ArrayNatureDefinition::set_is_element( IIR_Boolean is_element ){
  my_is_element = is_element;
}
