
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_DesignatorList.hh"
#include "IIR_Designator.hh"
#include "savant.hh"


IIRBase_DesignatorList::IIRBase_DesignatorList() {
}


IIRBase_DesignatorList::~IIRBase_DesignatorList() {}


IIR_Designator *
IIRBase_DesignatorList::first(){
  IIR_Designator *retval = (IIR_Designator*)dl_list<IIR>::first();
#ifdef DEVELOPER_ASSERTIONS
  if (retval != NULL) {
    ASSERT( retval->_is_designator() == TRUE );
  }
#endif
  return retval;
}


IIR_Designator *
IIRBase_DesignatorList::successor(IIR_Designator *to_succeed){
  ASSERT( to_succeed->_is_designator() == TRUE );

  IIR_Designator *retval;
  retval = (IIR_Designator*)dl_list<IIR>::successor(to_succeed);

#ifdef DEVELOPER_ASSERTIONS  
  if( retval != NULL ){
    ASSERT(retval->_is_designator() == TRUE );
  }
#endif
  return retval;
}

void 
IIRBase_DesignatorList::append( IIR_Designator *to_append ){
  ASSERT( to_append->_is_designator() == TRUE );

  dl_list<IIR>::append( to_append );
}



