// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Swaminathan Subramanian ssurama@ececs.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIR_AliasDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDefinition.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "symbol_table.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


extern symbol_table *cgen_sym_tab_ptr;

IIRScram_AliasDeclaration::~IIRScram_AliasDeclaration() {}


void 
IIRScram_AliasDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "alias ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  if (get_subtype() != NULL) {
    _vhdl_out << " : ";
    get_subtype()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << " is ";
  get_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}


void 
IIRScram_AliasDeclaration::_publish_cc_elaborate_alias_init( published_file &_cc_out ) {
  IIR_Int32 noofdimensions;

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_elaborate_alias_init" );
  
  if(get_name()->_is_object() && get_name()->_is_signal()) {
    if(get_name()->_is_array_type()) {
      noofdimensions = _get_num_indexes();
      if(noofdimensions == 1) {
	_publish_cc_elaborate( _cc_out );
	_cc_out.open_scope( "(true," );
	_cc_out << "ObjectBase::SIGNAL, ";
	if(get_subtype() != NULL) {
	  get_subtype()->_publish_cc_range( _cc_out );
	}
	else {
	  get_name()->get_subtype()->_publish_cc_range( _cc_out );
	}
        //	get_subtype()->_publish_cc_range( _cc_out );
	_cc_out << ", " << NL();
	get_name()->_publish_cc_name_elaborate( _cc_out );
	_cc_out << ", " << NL();
        if (get_name()->get_kind() == IIR_INDEXED_NAME)  {
          _cc_out << "nullInfo";
        }
        else  {
	  get_name()->_publish_cc_bounds( _cc_out );
        }
	_cc_out.close_scope( ")" );
      }
      else {
	cerr << "ILLEGAL definition of ALIAS Declarations\n";
	cerr << "Only One dimensional array objects can be aliased\n";
	cerr << "for array types\n";
      }
    }
    else {    //This has to be a scalar type
      _publish_cc_elaborate( _cc_out );
      _cc_out << "(true,";
      _cc_out << "(" << get_name()->get_subtype()->_get_cc_type_name();
      _cc_out << " &)";
      get_name()->_publish_cc_elaborate( _cc_out );
      _cc_out << ")" << NL();
    }
  }
}


void 
IIRScram_AliasDeclaration::_publish_cc_elaborate_alias_definition( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_elaborate_alias_definition" );
  
  if(get_name()->_is_object() && get_name()->_is_signal()) {
    if(get_subtype() != NULL) {
      _cc_out << get_subtype()->_get_cc_type_name();
    }
    else {
      _cc_out << get_name()->get_subtype()->_get_cc_type_name( );
    }
    _cc_out << " ";
    _publish_cc_elaborate( _cc_out );
    _cc_out << ";\n";
  }
}


void 
IIRScram_AliasDeclaration::_publish_cc_constructor_args( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_constructor_args" );
  
  if(get_name()->_is_object() == TRUE) {
    get_name()->_publish_cc_constructor_args( _cc_out );
  }
}

void
IIRScram_AliasDeclaration::_publish_cc_universal_type( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_universal_type" );
  
  ASSERT ( get_name() != NULL );
  ASSERT ( get_name()->get_subtype() != NULL );

  get_name()->get_subtype()->_publish_cc_universal_type( _cc_out );
}

void 
IIRScram_AliasDeclaration::_publish_cc_elaborate( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_elaborate" );
  
  if (get_name()->_is_object()) {
    _get_declarator()->_publish_cc_elaborate( _cc_out );
    _cc_out << "_info";
  }
}


void 
IIRScram_AliasDeclaration::_publish_cc_headers( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_headers" );
  
  if(get_name()->_is_object()){
    if(get_subtype() != NULL) {
      get_subtype()->_publish_cc_headers( _cc_out );
      get_subtype()->_publish_cc_include( _cc_out );
    }
  }
}


const string
IIRScram_AliasDeclaration::_get_cc_type_name( ){
  if(get_name()->_is_object()){
    if(get_subtype() != NULL) {
      return get_subtype()->_get_cc_type_name();
    }
  }
  return "";
}


void 
IIRScram_AliasDeclaration::_publish_cc_bounds( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_bounds" );
  
  if(get_name()->_is_object()) {
    if(get_subtype() != NULL) {
      get_subtype()->_publish_cc_bounds( _cc_out );
    }
    else {
      get_name()->get_subtype()->_publish_cc_bounds( _cc_out );
    }  
  }
}


void
IIRScram_AliasDeclaration::_add_necessary_decls_into_cgen_symbol_table() {
  IIRScram_AliasDeclaration *tempAliasDecl;
  IIR_Declaration           *tempDecl;
  
  ASSERT ( cgen_sym_tab_ptr != NULL );

  if (get_name()->get_kind() == IIR_ALIAS_DECLARATION) {
    tempAliasDecl = (IIR_AliasDeclaration *) get_name();
    ASSERT ( tempAliasDecl->get_kind() == IIR_ALIAS_DECLARATION );
    tempAliasDecl->_add_necessary_decls_into_cgen_symbol_table();
  }
  else {
    if (get_name()->_is_iir_declaration() == TRUE) {
      tempDecl = (IIR_Declaration *) get_name();
      if (!cgen_sym_tab_ptr->in_scope(tempDecl)) {
	cgen_sym_tab_ptr->add_declaration(tempDecl);
      }
    }
    
    if (get_name()->_is_name() == TRUE) {
      tempDecl = (IIR_Declaration *) get_name()->_get_prefix_declaration();
      ASSERT ( tempDecl != NULL );
      ASSERT ( tempDecl->_is_iir_declaration() == TRUE );
      if (tempDecl->get_kind() == IIR_ALIAS_DECLARATION) {
	tempAliasDecl = (IIR_AliasDeclaration *) tempDecl;
	tempAliasDecl->_add_necessary_decls_into_cgen_symbol_table();
      }

      if (!cgen_sym_tab_ptr->in_scope(tempDecl)) {
	cgen_sym_tab_ptr->add_declaration(tempDecl);
      }
    }
  }
  
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
}


void 
IIRScram_AliasDeclaration::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc" );
  ASSERT( cgen_sym_tab_ptr != NULL );
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );
  _add_necessary_decls_into_cgen_symbol_table();
  get_name()->_publish_cc_lvalue( _cc_out );
}


void 
IIRScram_AliasDeclaration::_publish_cc_decl_original_object( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_decl_original_object" );
  
  // Check for original object in Scope.  If the original object is not in
  // scope, bring it in scope and publish its declaration.
  if(get_name()->_is_iir_declaration()) {
    if (!cgen_sym_tab_ptr->in_scope((IIR_Declaration*)get_name())) {
      cgen_sym_tab_ptr->add_declaration((IIR_Declaration*)get_name());
      get_name()->_publish_cc_decl( _cc_out );
    }
  }
  else {
    if(get_name()->_is_name()) {
      IIR_Declaration* declname = get_name()->_get_prefix_declaration();
      ASSERT(declname != NULL);
      ASSERT(declname->_is_iir_declaration()==TRUE);
      if (!cgen_sym_tab_ptr->in_scope((IIR_Declaration*)declname)) {
	cgen_sym_tab_ptr->add_declaration((IIR_Declaration*)declname);
	declname->_publish_cc_decl( _cc_out );
      }
    }
  }
}


void 
IIRScram_AliasDeclaration::_publish_cc_decl( published_file &_cc_out ) {
  IIR_Int32 noofdimensions;

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_decl" );
  
  if(get_name()->_is_object()) {
    if(get_name()->_is_array_type()) {
      noofdimensions = _get_num_indexes();
      if(noofdimensions == 1) {
	_publish_cc_decl_original_object( _cc_out );
	if(get_subtype() != NULL) {
	  _cc_out << get_subtype()->_get_cc_type_name( );
	}
	else {
	  _cc_out << get_name()->get_subtype()->_get_cc_type_name();
	}
	_cc_out << " ";
	_get_declarator()->_publish_cc_lvalue( _cc_out.get_stream() );
      }
      else {
	cerr << "ILLEGAL definition of ALIAS Declarations\n";
	cerr << "Only One dimensional array objects can be aliased\n";
	cerr << "for array types\n";
      }
    }
    else {
      _publish_cc_decl_original_object( _cc_out );
      if(get_subtype() != NULL) {
	if (get_subtype()->_is_scalar_type() == TRUE &&
	    get_subtype()->_is_kernel_type() == FALSE &&
	    get_subtype()->_is_anonymous() == FALSE){
	  get_subtype()->_publish_cc_kernel_type( _cc_out.get_stream() );
	}
	else {
	  _cc_out << get_subtype()->_get_cc_type_name();
	}
      }
      else {
	if (get_name()->get_subtype()->_is_scalar_type() == TRUE &&
	    get_name()->get_subtype()->_is_kernel_type() == FALSE &&
	    get_name()->get_subtype()->_is_anonymous() == FALSE){
	  get_name()->get_subtype()->_publish_cc_kernel_type( _cc_out.get_stream() );
	}
	else {
	  _cc_out << get_name()->get_subtype()->_get_cc_type_name();
	}
      }
      _cc_out << " ";
      _get_declarator()->_publish_cc_lvalue( _cc_out.get_stream() );
    }
    _cc_out << ";\n";
  }
}


void 
IIRScram_AliasDeclaration::_publish_cc_alias_object_init( published_file &_cc_out ) {
  IIR_Int32 noofdimensions;
  IIR_Boolean flag = FALSE;
  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_alias_object_init" );
  if( get_name()->_is_object() ){
    _get_declarator()->_publish_cc_lvalue( _cc_out.get_stream() );
    _cc_out.open_scope( "(true," );
    if(get_subtype() != NULL) {
      flag = get_subtype()->_is_array_type();
    }
    else {
      flag = get_name()->_is_array_type();
    }
    if(flag == TRUE) {
      noofdimensions = get_subtype()->_get_num_indexes();
      if(noofdimensions == 1) {
	if(get_name()->_is_signal()) {
	  _cc_out << "ObjectBase::SIGNAL,";
	}
	else {
	  _cc_out << "ObjectBase::VARIABLE,";
	}
	_cc_out << NL();
	if(get_subtype() != NULL) {
	  get_subtype()->_publish_cc_range( _cc_out );
	}
	else {
	  get_name()->get_subtype()->_publish_cc_range( _cc_out );
	}
	_cc_out << ", " << NL();
	get_name()->_publish_cc_lvalue( _cc_out );
	_cc_out << ", " << NL();
	if(get_name()->get_kind() == IIR_INDEXED_NAME) {
	  _cc_out << "nullInfo";
	}
	else {
	  get_name()->_publish_cc_bounds( _cc_out );
	}
	_cc_out << NL();
      }
      else {
	cerr << "ILLEGAL definition of ALIAS Declarations\n";
	cerr << "Only One dimensional array objects can be aliased\n";
	cerr << "for array types\n";
	abort();
      }
    }
    else {    //This has to be a scalar type
      get_name()->_publish_cc_object_name( _cc_out );
    }
    _cc_out.close_scope( ")" );
  }
}


void 
IIRScram_AliasDeclaration::_publish_cc_state_object_init( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AliasDeclaration::_publish_cc_state_object_init" );
  
  if(get_name()->_is_object()) {
    _publish_cc_alias_object_init( _cc_out );
    _cc_out << "," << NL();
  }
}


IIR_AttributeSpecificationList* 
IIRScram_AliasDeclaration::_get_attribute_specification_list() {
  ASSERT(get_name() != NULL);
  ASSERT(_is_iir_declaration() == TRUE);
  return ((IIR_Declaration*)get_name())->_get_attribute_specification_list();
}


IIRScram_Declaration::declaration_type 
IIRScram_AliasDeclaration::_get_type(){
  return ALIAS;
}


IIR_Boolean 
IIRScram_AliasDeclaration::_is_object(){
  ASSERT( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_object();
}


IIR_Boolean 
IIRScram_AliasDeclaration::_is_signal(){
  ASSERT( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_signal();
}

IIR_Boolean 
IIRScram_AliasDeclaration::_is_variable(){
  ASSERT( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_variable();
}

IIR_Boolean 
IIRScram_AliasDeclaration::_is_readable(){
  ASSERT( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_readable();  
}


IIR_Boolean 
IIRScram_AliasDeclaration::_is_writable(){
  ASSERT( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_writable();  
}


IIR_Boolean
IIRScram_AliasDeclaration::_is_array_type(){
  ASSERT ( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_array_type();
}


IIR_Boolean
IIRScram_AliasDeclaration::_is_type(){
  ASSERT ( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_type();
}

IIR_Boolean 
IIRScram_AliasDeclaration::_is_locally_static_primary(){
  ASSERT ( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_locally_static_primary();
}

IIR_Boolean 
IIRScram_AliasDeclaration::_is_globally_static_primary(){
  ASSERT ( get_name()->_is_resolved() == TRUE );
  return get_name()->_is_globally_static_primary();
}

IIR_TypeDefinition *
IIRScram_AliasDeclaration::_get_type_of_element( int index ){
  ASSERT( get_name()->_is_resolved() == TRUE );
  return get_name()->_get_type_of_element( index );
}


IIR_Int32
IIRScram_AliasDeclaration::_get_num_indexes( ){
  ASSERT( get_name()->_is_resolved() == TRUE );
  return get_name()->get_subtype()->_get_num_indexes( );
}


void 
IIRScram_AliasDeclaration::_type_check(){
  ASSERT( get_name() != NULL );

  set<IIR_TypeDefinition> *name_rvals = get_name()->_get_rval_set();
  if( name_rvals == NULL ){
    report_undefined_symbol( get_name() );
    return;
  }

  if( get_subtype() != NULL ){
    set<IIR_TypeDefinition> *subtype_rvals = new set<IIR_TypeDefinition>( get_subtype() );

    reconcile_sets( name_rvals, subtype_rvals );
    delete subtype_rvals;

    if( name_rvals->num_elements() == 0 ){
      ostringstream err;
      err << "|" << *get_name() << "| is not of type |" << *get_subtype() << "| - illegal alias"
	  << " declaration.";
      report_error( this, err.str() );
      return;
    }

  }

  switch( name_rvals->num_elements() ){
  case 0:{
    ostringstream err;
    err << "Internal error in IIRScram_AliasDeclaration::_type_check - got 0 elements for"
	<< " name |" << *get_name() << "|.";
    report_error( this, err.str() );
    break;
  }
  case 1:{
    IIR_TypeDefinition *my_type = name_rvals->get_element();

    if( get_subtype() == NULL ){
      set_subtype( my_type );
    }

    set_name( get_name()->_semantic_transform( get_subtype() ) );
    get_name()->_type_check( get_subtype() );
    set_name( get_name()->_rval_to_decl( get_subtype() ) );
    
    break;
  }
  default:{
    report_ambiguous_error( get_name(), name_rvals );
    break;
  }
  }
  
}


const IIR_Char*
IIRScram_AliasDeclaration::_get_mangling_prefix() {
  return "";
}	  

IIR_Declaration*
IIRScram_AliasDeclaration::_get_prefix_declaration() {
  return this;
}

void 
IIRScram_AliasDeclaration::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  get_name()->_build_sensitivity_list(sensitivity_list);
}


void 
IIRScram_AliasDeclaration::_set_driver_addition_flag(IIR_Boolean flag) {
  if(get_name()->_is_signal() == TRUE) {
    IIR_Declaration* signal_decl = (IIR_Declaration*)get_name();
    signal_decl->_set_driver_addition_flag(flag);
  }
}


void
IIRScram_AliasDeclaration::_add_decl_into_cgen_symbol_table() {
  if(get_name()->_is_object()) {
    get_name()->_add_decl_into_cgen_symbol_table();
  }
  if(get_subtype() != NULL) {
    get_subtype()->_add_decl_into_cgen_symbol_table();
  }
}


void
IIRScram_AliasDeclaration::_add_declarations_in_initializations() {
  _add_decl_into_cgen_symbol_table();
}


IIR*
IIRScram_AliasDeclaration::_clone() {
  if (_my_clone == NULL) {
    _my_clone = new IIR_AliasDeclaration();
    IIRScram_Declaration::_clone(_my_clone);

    _my_clone->set_name(get_name());
    _my_clone->set_subtype(get_subtype());
  }
  return _my_clone;
}

void 
IIRScram_AliasDeclaration::_come_into_scope( symbol_table *sym_tab ){
  ASSERT( get_name()->_is_resolved() == TRUE );
  get_name()->_come_into_scope( sym_tab );
}

void 
IIRScram_AliasDeclaration::_come_out_of_scope( symbol_table *sym_tab ){
  get_name()->_come_out_of_scope( sym_tab );
}

visitor_return_type *IIRScram_AliasDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_AliasDeclaration(this, arg);
};
