
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//	    Magnus Danielson	cfmd@swipnet.se

#include "IIR_CaseStatement.hh"
#include "IIR_CaseStatementAlternative.hh"
#include "IIR_CaseStatementAlternativeList.hh"
#include "IIR_Identifier.hh"
#include "IIR_AboveAttribute.hh"
#include "IIR_Label.hh"
#include "error_func.hh"
#include "set.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"

IIRScram_CaseStatement::~IIRScram_CaseStatement(){}

void 
IIRScram_CaseStatement::_publish_vhdl(ostream &_vhdl_out) {

  PublishedUnit oldUnit = _get_currently_publishing_vhdl_unit();
  _set_currently_publishing_vhdl_unit(IIRScram::CASE_STATEMENT);
  ASSERT(get_expression() != NULL);

  _publish_vhdl_stmt_label(_vhdl_out);

  _vhdl_out << "case ";
  ASSERT( get_expression()->_is_resolved() == TRUE );
  get_expression()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";

  case_statement_alternatives._publish_vhdl(_vhdl_out);
  _vhdl_out << "end case";

  if (get_label() != NULL) {
    _vhdl_out << " ";
    get_label()->_publish_vhdl(_vhdl_out);
  }

  _set_currently_publishing_vhdl_unit(oldUnit);
}

void
IIRScram_CaseStatement::_publish_cc( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_CaseStatement::_publish_cc" );
  if (get_label() != NULL) {
    get_label()->_publish_cc_lvalue( _cc_out );
    _cc_out << ":" << NL();
  }

  IIR* save_node = _get_current_publish_node();
  _set_current_publish_node( get_expression() );
  _cc_out << "if( false ){}" << NL();
  case_statement_alternatives._publish_cc( _cc_out );
  _set_current_publish_node( save_node );
  _cc_out << NL();
}

void
IIRScram_CaseStatement::_publish_cc_decl_for_loop_iterator(published_file &_cc_out) {

  SCRAM_CC_REF(_cc_out, "IIRScram_CaseStatement::_publish_cc_decl_for_loop_iterator");

  case_statement_alternatives._publish_cc_decl_for_loop_iterator( _cc_out );
}

void
IIRScram_CaseStatement::
_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  case_statement_alternatives._build_wait_list(list);
}

void 
IIRScram_CaseStatement::
_build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *list){
  IIR_CaseStatementAlternative *alt;
  for (alt = case_statement_alternatives.first();
       alt != NULL;
       alt = case_statement_alternatives.successor(alt)) {
    alt->sequence_of_statements._build_procedure_call_stmt_list(list);
  }
}

void
IIRScram_CaseStatement::_type_check(){
  _type_check_case_statement_expression( &case_statement_alternatives );
  ASSERT( _is_resolved() == TRUE );
}

IIR *
IIRScram_CaseStatement::
_handle_reconciliation( set<IIR_TypeDefinition> *rval_set, 
			IIR *node_in_consideration, char *error_part ){
  IIR *retval = NULL;

  switch( rval_set->num_elements() ){
  case 0:{
    ostringstream err;
    err << "|" << *node_in_consideration << "| is not a valid " << error_part 
	<< " in a case statement.";
    report_error( this, err.str() );
    break;
  }
  case 1:{
    IIR_TypeDefinition *rval =  rval_set->get_element();
    retval = node_in_consideration->_rval_to_decl( rval );
    break;
  }
  default:{
    report_ambiguous_error( node_in_consideration, rval_set );
    break;
  }
  }
  return retval;
}

IIR_Boolean 
IIRScram_CaseStatement::
_type_check_return_statements(set<IIR_TypeDefinition> *context_set, 
			      IIR_SubprogramDeclaration *subprogram_decl ){
  IIR_Boolean retval = FALSE;
  
  IIR_CaseStatementAlternative *alternative;
  alternative = case_statement_alternatives.first();
  while( alternative != NULL ){
    IIR_Boolean found_one;
    found_one = alternative->_type_check_return_statements( context_set,
							    subprogram_decl );
    if( found_one == TRUE ){
      retval = TRUE;
    }

    alternative = case_statement_alternatives.successor( alternative );
  }
  return retval;
}

void
IIRScram_CaseStatement::_get_list_of_input_signals( set<IIR> *list ){
  get_expression()->_get_list_of_input_signals(list);
  case_statement_alternatives._get_list_of_input_signals(list);
}

void
IIRScram_CaseStatement::_get_signal_source_info( set<IIR> *siginfo ){
  case_statement_alternatives._get_signal_source_info(siginfo);
}

IIR_Boolean
IIRScram_CaseStatement::_is_resolved(){
  IIR_Boolean retval = TRUE;
  if( get_expression()->_is_resolved() == FALSE ){
    retval = FALSE;
  }
  if( case_statement_alternatives._is_resolved() == FALSE ){
    retval = FALSE;
  }
  return retval;
}

IIR *
IIRScram_CaseStatement::_get_case_statement_expression(){
  return get_expression();
}

void 
IIRScram_CaseStatement::_set_case_statement_expression( IIR *new_expression ){
  set_expression( new_expression );
}

IIR_Boolean
IIRScram_CaseStatement::_is_above_attribute_found() {
  IIR_Boolean retval = FALSE;
  retval = retval || get_expression()->_is_above_attribute_found();
  retval = retval || case_statement_alternatives._is_above_attribute_found();
  return retval;
}

void
IIRScram_CaseStatement::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  get_expression()->_build_above_attribute_set(to_build);
  case_statement_alternatives._build_above_attribute_set(to_build);
}

IIR *
IIRScram_CaseStatement::_clone(){
  IIR *expr;
  IIR_CaseStatementAlternative *alt, *altclone;
  IIR_CaseStatement *clone = new IIR_CaseStatement();
  IIR_SequentialStatement::_clone(clone);

  expr = get_expression()->_clone();
  clone->set_expression(expr);
  
  alt = case_statement_alternatives.first();
  while (alt != NULL) {
    altclone = (IIR_CaseStatementAlternative*)alt->_clone();
    clone->case_statement_alternatives.append(altclone);
    alt = case_statement_alternatives.successor(alt);
  }
  return clone;
}

visitor_return_type *IIRScram_CaseStatement::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_CaseStatement(this, arg);
};
