#ifndef IIRSCRAM_CONCATENATION_OPERATOR_HH
#define IIRSCRAM_CONCATENATION_OPERATOR_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_ConcatenationOperator.hh"

class IIRScram_ConcatenationOperator : public IIRBase_ConcatenationOperator {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_operator(ostream &);
  void _publish_cc_xvalue( published_file &_cc_out,
			   void (IIR::*_publish_function)( published_file & ) );
  void _publish_cc_bounds( published_file &_cc_out );

  const string &_get_cc_operator_name() const;
  
  IIR *_clone();
  
  IIRScram::OperatorPrecedenceLevel  _get_operator_precedence();

protected:
  IIRScram_ConcatenationOperator() {}
  virtual ~IIRScram_ConcatenationOperator() = 0;
    
private:
  // Removes types that aren't dimensional arrays from the set passed in.
  void _remove_non_one_d_array_types( set<IIR_TypeDefinition> *remove_from );
};
#endif
