// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram_ConfigurationSpecification.hh"
#include "IIR_AssociationElementByExpression.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_ComponentDeclaration.hh"
#include "IIR_ComponentInstantiationStatement.hh"
#include "IIR_ConfigurationDeclaration.hh"
#include "IIR_Label.hh"
#include "IIR_TextLiteral.hh"
#include "published_file.hh"

IIRScram_ConfigurationSpecification::~IIRScram_ConfigurationSpecification() {}


void 
IIRScram_ConfigurationSpecification::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "for ";

  if (instantiation_list.first() != NULL) {
    instantiation_list._publish_vhdl(_vhdl_out);
  }
  else {
    _vhdl_out << "all";
    // This can happen if we have a configuration specification with for all
    // clause but there is no component instantiation for this component.
  }
  
  _vhdl_out << ": ";
  get_component_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " use";
  if(get_entity_aspect() != NULL) {
    get_entity_aspect()->_publish_vhdl_with_library_name(_vhdl_out);
  }
  else{
    _vhdl_out << " open";
  }

  if(generic_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n  generic map ( ";
    generic_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";    
  }
  if(port_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n  port map ( ";
    port_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";
  }
  _vhdl_out << ";\n";
}  


void 
IIRScram_ConfigurationSpecification::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << "for ";
  instantiation_list._publish_vhdl(_vhdl_out);
  _vhdl_out << " : ";
  get_component_name()->_publish_vhdl(_vhdl_out);
  if(get_entity_aspect() != NULL) {
    _vhdl_out << " use ";
    get_entity_aspect()->_publish_vhdl(_vhdl_out);
  }
  if(generic_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n  generic map ( ";
    generic_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";    
  }
  if(port_map_aspect.num_elements() != 0) {
    _vhdl_out << "\n  port map ( ";
    port_map_aspect._publish_vhdl(_vhdl_out);
    _vhdl_out << " )";
  }
}


IIR_DesignatorList * 
IIRScram_ConfigurationSpecification::_get_instantiation_list() {
  return &instantiation_list;
}


#ifdef PROCESS_COMBINATION
void
IIRScram_ConfigurationSpecification::
_static_elaborate(IIR_ArchitectureDeclaration *arch, 
		  IIR_DeclarationList *cfglist, 
		  char *hier_location) {
  get_entity_aspect()->_static_elaborate(arch, cfglist, hier_location);
}
#endif


void 
IIRScram_ConfigurationSpecification::_type_check( IIR_List &statement_list,
						  type_check_mode mode ) {
  // This doesn't type check the instantiation list...
  _type_check_configuration( port_map_aspect, generic_map_aspect, mode );
  // This does.
  instantiation_list._type_check_as_instantiation_list( get_component_name(), 
							statement_list, 
							this );
}


void
IIRScram_ConfigurationSpecification::_publish_cc_port_map_aspect( published_file &_cc_out ) {
  ASSERT( _get_current_publish_node() != NULL );
  ASSERT( _get_current_publish_node()->_is_iir_concurrent_statement() == TRUE );
  IIR_ConcurrentStatement* concurrent_stmt = 
    (IIR_ConcurrentStatement*) _get_current_publish_node();
  IIR_AssociationElement* actual_clause = NULL;

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationSpecification::_publish_cc_port_map_aspect" );
  if(port_map_aspect.num_elements() > 0) {
    _cc_out << OS("{");
    _cc_out.insert_comment( "Alias instantiated component as \"component\"" );
    _cc_out << concurrent_stmt->get_instantiated_unit()->_get_cc_elaboration_class_name()
	    << " *component = ";
    if (_get_currently_publishing_unit() == GENERATE_FOR) {
      _cc_out << "(";
      concurrent_stmt->_get_label()->_publish_cc_elaborate( _cc_out.get_stream() );
      _cc_out << "_elab_obj + i);" << NL();
    }
    else {
      concurrent_stmt->_get_label()->_publish_cc_elaborate( _cc_out.get_stream() );
      _cc_out << "_elab_obj;" << NL();
    }

    _cc_out.insert_comment( "Alias architecture as \"architecture\"" );    
    if( get_entity_aspect()->get_kind() == IIR_CONFIGURATION_DECLARATION ){
      IIR_ConfigurationDeclaration* config_decl = (IIR_ConfigurationDeclaration*)get_entity_aspect();
      _cc_out << config_decl->_get_configured_architecture()->_get_cc_elaboration_class_name()
	      << " *architecture = (("
	      << config_decl->_get_configured_architecture()->_get_cc_elaboration_class_name()
	      << "*)(("
	      << get_entity_aspect()->_get_cc_elaboration_class_name() << "*)"
	      << "component->boundedEntity)->configuredEntity);" << NL();
    }
    else {
      _cc_out << get_entity_aspect()->_get_cc_elaboration_class_name()
	      << " *architecture = ("
	      << get_entity_aspect()->_get_cc_elaboration_class_name()
	      << " *)"
	      << "component->boundedEntity;" << NL();
    }
    
    _cc_out.insert_comment( "Add a port association - order is actual, formal" );
    _cc_out << "PortMap *tmpPortMap = &(architecture->portMapAspect);" << NL();
    port_map_aspect._publish_cc_port_map_associations( _cc_out );
    actual_clause = port_map_aspect.first();
    while( actual_clause != NULL ){
      _cc_out << "component->";
      actual_clause->_get_actual()->_publish_cc_elaborate( _cc_out );
      _cc_out << ".copyId( architecture->";
      actual_clause->get_formal()->_publish_cc_elaborate( _cc_out );
      _cc_out << ");" << NL();
      actual_clause = port_map_aspect.successor(actual_clause);
    }
      
    _cc_out << CS("}");
  }
}


IIR *
IIRScram_ConfigurationSpecification::_get_component_name( ){
  return get_component_name();
}


void 
IIRScram_ConfigurationSpecification::_set_component_name( IIR *name  ){
  set_component_name( name );
}


IIR_LibraryUnit *
IIRScram_ConfigurationSpecification::_get_entity_aspect(){
  return get_entity_aspect();
}


IIR_Boolean
IIRScram_ConfigurationSpecification::_has_same_component(IIR_ComponentInstantiationStatement* conc_stmt) {
  IIR_ComponentDeclaration* componentname = (IIR_ComponentDeclaration *) conc_stmt->get_instantiated_unit();
  ASSERT(componentname->_is_iir_component_declaration() == TRUE);
  IIR_TextLiteral* local_componentname = componentname->get_declarator();
  ASSERT( get_component_name()->_is_iir_declaration() == TRUE );
  IIR_Declaration* decl = (IIR_Declaration*)get_component_name();
  IIR_TextLiteral* binding_componentname = decl->get_declarator();
  if(0 == IIR_TextLiteral::_cmp(local_componentname, 
				binding_componentname)) {
    return TRUE;
  }
  return FALSE;
}


IIR_Boolean
IIRScram_ConfigurationSpecification::_configures_this_component(IIR_ComponentInstantiationStatement* conc_stmt) {
  return this->instantiation_list._is_component_in_the_list(conc_stmt->get_label()->get_declarator());
}

visitor_return_type *IIRScram_ConfigurationSpecification::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ConfigurationSpecification(this, arg);
};
