
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Timothy J. McBrayer 

#include "IIR_Identifier.hh"
#include "IIR_Name.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "published_file.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_Identifier::~IIRScram_Identifier() {}

void 
IIRScram_Identifier::_publish_cc_data( published_file &_cc_out ) {
  set<IIR_Declaration> *decl_set;
  IIR_Declaration *decl = NULL;
  
  ASSERT(cgen_sym_tab_ptr != NULL);
  
  decl_set = cgen_sym_tab_ptr->find_set( this );
  switch (decl_set->num_elements()) {
  case 0:
    // not in cgen table, find it in global table
    decl_set = _get_symbol_table()->find_set( this );
    if (decl_set->num_elements() == 1) {
      decl = decl_set->get_element();
    }
    else {
      cout << "IIRScram_Identifier::_publish_cc_data: I can't resolve myself!"
  	   << endl;
      abort();
    }
    if (!cgen_sym_tab_ptr->in_scope(decl)) {
      cgen_sym_tab_ptr->add_declaration(decl);
    }
    break;
  case 1:
    decl = decl_set->get_element();
    break;
  default:
    cout << "IIRScram_Identifier::_publish_cc_data: symbol multiply defined"
  	 << endl;
    abort();
  }
  _cc_out << "currentState->" << *this;
  if (decl->get_kind() == IIR_SIGNAL_DECLARATION ||
      decl->get_kind() == IIR_SIGNAL_INTERFACE_DECLARATION ||
      decl->get_kind() == IIR_SIMPLE_NAME) {
  }
  else if (decl->get_kind() == IIR_VARIABLE_DECLARATION ||
	   decl->get_kind() == IIR_VARIABLE_INTERFACE_DECLARATION) {
  }
}

void 
IIRScram_Identifier::_publish_cc_bounds( published_file &_cc_out ) {
    set<IIR_Declaration> *decl_set;
    IIR_Declaration *decl = NULL;
    ASSERT(cgen_sym_tab_ptr != NULL);

    decl_set = cgen_sym_tab_ptr->find_set( this );
    switch (decl_set->num_elements()) {
    case 0:
    // not in cgen table, find it in global table
      decl_set = _get_symbol_table()->find_set( this );
      if (decl_set->num_elements() == 1) {
        decl = decl_set->get_element();
      }
      else {
        cout << "IIRScram_Identifier::_publish_cc_bounds: I can't resolve myself!"
     << endl;
        abort();
      }
      if (!cgen_sym_tab_ptr->in_scope(decl)) {
        cgen_sym_tab_ptr->add_declaration(decl);
      }
      break;
    case 1:
      decl = decl_set->get_element();
      break;
    default:
      cout << "IIRScram_Identifier::_publish_cc_bounds: symbol multiply defined"
  	 << endl;
      abort();
    }
  decl->_publish_cc_bounds( _cc_out );
}

void
IIRScram_Identifier::_publish_cc_object_name( published_file &_cc_out ){
  _cc_out << *this;
}

void
IIRScram_Identifier::_publish_cc_elaborate( published_file &_cc_out ){
  _publish_cc_object_name( _cc_out );
}

IIR*
IIRScram_Identifier::_clone() {
  IIR_Identifier *clone = get( text->get_text() );
  return clone;
}

visitor_return_type *IIRScram_Identifier::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_Identifier(this, arg);
};
