#ifndef IIRSCRAM_VARIABLE_INTERFACE_DECLARATION_HH
#define IIRSCRAM_VARIABLE_INTERFACE_DECLARATION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_VariableInterfaceDeclaration.hh"

class IIR_List;

class IIRScram_VariableInterfaceDeclaration : public IIRBase_VariableInterfaceDeclaration {



public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_init( published_file &_cc_out );
  void _publish_cc_data( published_file &_cc_out );
  void _publish_cc_wait_data( published_file &_cc_out );  
  void  _publish_cc_scalar_init( published_file &_cc_out );
  void _publish_cc_composite_init( published_file &_cc_out );
  void _publish_cc_access_init( published_file &_cc_out );
  void _publish_cc_file_init( published_file &_cc_out );
  const string _get_cc_object_type();
  IIR_Boolean _is_variable();
  IIR *_clone();
  void _type_check( IIRScram_InterfaceDeclaration::_InterfaceListType );

  declaration_type _get_type();

protected:
  IIRScram_VariableInterfaceDeclaration() {}
  virtual ~IIRScram_VariableInterfaceDeclaration() = 0;
    
private:
};
#endif
