
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Prashanth Cherukuri cherukps@ececs.uc.edu

//---------------------------------------------------------------------------
	
#include "IIRScram_ZTFAttribute.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_TypeDeclaration.hh"
#include "IIR_Declaration.hh"
#include "IIR_Identifier.hh"
#include "resolution_func.hh"
#include "IIR_BranchQuantityDeclaration.hh"
#include "IIR_FreeQuantityDeclaration.hh"
#include "error_func.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"

extern symbol_table sym_tab;
extern symbol_table *cgen_sym_tab_ptr;//add

IIRScram_ZTFAttribute::~IIRScram_ZTFAttribute() {}

void
IIRScram_ZTFAttribute::_publish_vhdl(ostream& _vhdl_out) {
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'ZTF ( " ;
  get_num()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " , ";
  get_den()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " , ";
  get_t()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " , ";
  get_initial_delay()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " ) ";
}

IIR_TextLiteral *
 IIRScram_ZTFAttribute::_build_attribute_name()
 {
   char *name = "ztf";
   return IIR_Identifier::get(name, strlen(name));
 }

IIR_TypeDefinition *
IIRScram_ZTFAttribute::get_subtype() {
  set<IIR_Declaration> *prefix_decls = get_prefix()->_symbol_lookup();
  if( prefix_decls == NULL ) {
    report_undefined_symbol( get_prefix() );
    return NULL;
  }

  IIR_Declaration *current_decl;
  current_decl = prefix_decls->get_element();
  while( current_decl != NULL ) {
    if( current_decl->_is_quantity() == FALSE ) {
      prefix_decls->remove( current_decl );
    }
    current_decl = prefix_decls->get_next_element();
  }

  switch( prefix_decls->num_elements() ) {
  case 0: {
    ostringstream err;
    err << "|" << _get_attribute_name() << "| may only be applied to quantities." << endl;
    return NULL;
  }
  case 1: {
    set_prefix( prefix_decls->get_element() );

    break;
  }
  default: {
    report_ambiguous_error( get_prefix(), prefix_decls );
    return NULL;
  }
  }
  return get_prefix()->get_subtype();
}

IIR_Declaration *
IIRScram_ZTFAttribute::_get_implicit_declaration( const string &decl_name,
                                                     IIR_TypeDefinition *decl_nature ) {
 return (IIR_Declaration*)_build_free_quantity_declaration( decl_name, decl_nature );
}

void
IIRScram_ZTFAttribute::_publish_cc_decl(published_file & _cc_out) {}

void
IIRScram_ZTFAttribute::_publish_cc(published_file & _cc_out) {}

void 
IIRScram_ZTFAttribute::_set_stmt_qty_index(IIR_Int32 *index, set<IIR_Declaration> 
					   *quantity_set) {
  if(!cgen_sym_tab_ptr->in_scope((IIR_Declaration*)get_prefix()))
    cgen_sym_tab_ptr->add_declaration((IIR_Declaration*)get_prefix());
  ((IIR_Attribute*)this)->get_prefix()->_set_stmt_qty_index(index,quantity_set);
}

IIR_Int32
IIRScram_ZTFAttribute::_get_stmt_qty_index() {
  return ((IIR_Attribute*)this)->//_get_implicit_declaration()->_get_stmt_qty_index();
  get_prefix()->_get_stmt_qty_index();
}

void
IIRScram_ZTFAttribute::_flush_stmt_index() {
  ((IIR_Attribute*)this)->get_prefix()->_flush_stmt_index();
}

void
IIRScram_ZTFAttribute::_publish_cc_ams_function(published_file & _cc_out) {}

void
IIRScram_ZTFAttribute::_resolve_attribute_parameters() {

  ASSERT( get_num() != NULL && get_den() != NULL);
  ASSERT( get_t() != NULL && get_initial_delay() != NULL);

  // processing for the numerator part of this attribute's suffix ...
  set<IIR_TypeDefinition> *numerator_rvals = get_num()->_get_rval_set();
      
  if( numerator_rvals == NULL ) {
    report_undefined_symbol( get_num() );
  }
  switch( numerator_rvals->num_elements() ) {
  case 0: {
    ostringstream err;
    err << "|" << *get_num() << "| was not declared in this scope." << endl;
    break;
  }
  case 1: {
    IIR_TypeDefinition *my_rval = numerator_rvals->get_element();
    
    set_num( get_num()->_semantic_transform( my_rval ) );
    get_num()->_type_check( my_rval );
    set_num( get_num()->_rval_to_decl( my_rval ) );
    
    break;
  }
  default: {
    report_ambiguous_error( get_num(), numerator_rvals );
  }
  }

  // now process for the denominator part of the attribute's suffix
  set<IIR_TypeDefinition> *denominator_rvals = get_den()->_get_rval_set();
      
  if( denominator_rvals == NULL ) {
    report_undefined_symbol( get_den() );
  }
  switch( denominator_rvals->num_elements() ) {
  case 0: {
    ostringstream err;
    err << "|" << *get_den() << "| was not declared in this scope." << endl;
    break;
  }
  case 1: {
    IIR_TypeDefinition *my_rval = denominator_rvals->get_element();
    
    set_den( get_den()->_semantic_transform( my_rval ) );
    get_den()->_type_check( my_rval );
    set_den( get_den()->_rval_to_decl( my_rval ) );
    
    break;
  }
  default: {
    report_ambiguous_error( get_den(), denominator_rvals );
  }
  }

  // now process for the time parameter ....
  set<IIR_TypeDefinition> *time_rvals = get_t()->_get_rval_set();
      
  if( time_rvals == NULL ) {
    report_undefined_symbol( get_t() );
  }
  switch( time_rvals->num_elements() ) {
  case 0: {
    ostringstream err;
    err << "|" << *get_t() << "| was not declared in this scope." << endl;
    break;
  }
  case 1: {
    IIR_TypeDefinition *my_rval = time_rvals->get_element();
    
    set_t( get_t()->_semantic_transform( my_rval ) );
    get_t()->_type_check( my_rval );
    set_t( get_t()->_rval_to_decl( my_rval ) );
    
    break;
  }
  default: {
    report_ambiguous_error( get_t(), time_rvals );
  }
  }

  // process for the initial delay parameter ....
  set<IIR_TypeDefinition> *initial_delay_rvals = get_initial_delay()->_get_rval_set();
      
  if( initial_delay_rvals == NULL ) {
    report_undefined_symbol( get_initial_delay() );
  }
  switch( initial_delay_rvals->num_elements() ) {
  case 0: {
    ostringstream err;
    err << "|" << *get_initial_delay() << "| was not declared in this scope." << endl;
    break;
  }
  case 1: {
    IIR_TypeDefinition *my_rval = initial_delay_rvals->get_element();
    
    set_initial_delay( get_initial_delay()->_semantic_transform( my_rval ) );
    get_initial_delay()->_type_check( my_rval );
    set_initial_delay( get_initial_delay()->_rval_to_decl( my_rval ) );
    
    break;
  }
  default: {
    report_ambiguous_error( get_initial_delay(), initial_delay_rvals );
  }
  }
}
