/*
 * A n t l r  T r a n s l a t i o n  H e a d e r
 *
 * Terence Parr, Will Cohen, and Hank Dietz: 1989-2001
 * Purdue University Electrical Engineering
 * With AHPCRC, University of Minnesota
 * ANTLR Version 1.33MR32
 *
 *   /usr/bin/antlr -gx -k 2 -CC -ft VHDLTokenTypes.hh ../../../../../oss/savant/src/analyzer/vhdl.gg -o ../../src/analyzer
 *
 */

#define ANTLR_VERSION	13332
#include "pcctscfg.h"
#include "pccts_stdio.h"
#include "VHDLTokenTypes.hh"

#include <FlexLexer.h>
#include "vhdl.hh"
#include "VHDLToken.hh"
#include "ATokPtr.h"
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "scram.hh"
#include "stack.hh"
#include "StandardPackage.hh"
#include "language_processing_control.hh"
#include "sstream-wrap.hh"

#ifndef SCRAM_HEADER_DEFS
#define SCRAM_HEADER_DEFS

enum InterfaceListObjectType {
  ILOT_UNSPECIFIED,
  ILOT_FILE,
  ILOT_CONSTANT,
  ILOT_VARIABLE,
  ILOT_SIGNAL,
  ILOT_TERMINAL,
  ILOT_QUANTITY
};

struct scram_binding_info_t {
  IIR_LibraryUnit *entity_aspect;
  IIR_AssociationList *generic_map_aspect;
  IIR_AssociationList *port_map_aspect;
  
  // why not have self initializing structs?
  scram_binding_info_t(){
    entity_aspect = NULL;
    generic_map_aspect = NULL;
    port_map_aspect = NULL;
  }
};

#endif
#include "AParser.h"
#include "VHDLParser.h"
#include "ATokPtr.h"

/* MR23 In order to remove calls to PURIFY use the antlr -nopurify option */

#ifndef PCCTS_PURIFY
#define PCCTS_PURIFY(r,s) memset((char *) &(r),'\0',(s));
#endif


#include "VHDLLexer.hh"
#include "symbol_table.hh"
#include "scram_func.hh"

symbol_table *cgen_sym_tab_ptr;	// pointer to process symbol table, for publish_cc declarations
symbol_table *cgen_arch_sym_tab_ptr;

// Capture comments in a design file if the capture_comments flag is true.
// The global variable design_file_comment_list will be used to capture
// comments in the lexer. 
extern bool *capture_comments;
IIR_CommentList *design_file_comment_list = NULL;

bool need_to_write_libraries;
extern bool debug_symbol_table;
extern language_processing_control *lang_proc;
stack<IIR_SequentialStatement> loop_statements;

void
VHDLParser::design_file(IIR_DesignFile * file,symbol_table * sym_tab,IIR_LibraryDeclaration * new_lib_decl,bool need_to_write_libraries)
{
  zzRULE;
  
  my_design_file = file;
  my_symbol_table = sym_tab;
  ASSERT( new_lib_decl != NULL );
  {
    int zzcnt=1;
    do {
      design_unit(  &file->library_units, new_lib_decl, need_to_write_libraries  );
    } while ( (setwd1[LA(1)]&0x1) );
  }
  zzmatch(ENDFILE);
  if ( !guessing ) {
  ASSERT( loop_statements.get_top_of_stack() == 0 );
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd1, 0x2);
}

void
VHDLParser::design_unit(IIR_LibraryUnitList * liblist,IIR_LibraryDeclaration * library_decl,bool need_to_write_libraries)
{
  zzRULE;
  
  IIR_LibraryUnit *unit = NULL;
  IIR_DeclarationList *context_list = NULL;
  if ( !guessing ) {
  
  context_list = new IIR_DeclarationList;
  my_symbol_table->open_scope( library_decl );
  }
  context_clauses( context_list );
  if ( !guessing ) {
     unit  = library_unit(  library_decl  );

  } else {
    library_unit(  library_decl  );
  }
  if ( !guessing ) {
  
  IIR::copy_location( unit, liblist );
  IIR::copy_location( unit, &unit->context_items );
  // Take the temporary context_list, and put the elements into the unit's
  // context_items.
  unit->context_items = *context_list;
  delete context_list; // all elements moved to unit->context_items
  
    if( library_decl->primary_units.in_list( library_decl ) == false ){
  library_decl->primary_units.append( unit );
}

    if( need_to_write_libraries == true && parse_error == false ){
library_manager::instance()->parse_into_work_dir( unit );
}

    my_symbol_table->close_scope( library_decl );
liblist->append(unit);
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd1, 0x4);
}

IIR_LibraryUnit *
VHDLParser::library_unit(IIR_LibraryDeclaration * library)
{
  IIR_LibraryUnit *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_LibraryUnit *  ))
  _retv = NULL;
  if ( (setwd1[LA(1)]&0x8) && (setwd1[LA(2)]&0x10) ) {
    if ( !guessing ) {
       _retv  = primary_unit(  library  );

    } else {
      primary_unit(  library  );
    }
  }
  else {
    if ( (setwd1[LA(1)]&0x20) && (setwd1[LA(2)]&0x40) ) {
      if ( !guessing ) {
         _retv  = secondary_unit(  library  );

      } else {
        secondary_unit(  library  );
      }
    }
    else {FAIL(2,err1,err2,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd1, 0x80);
  return _retv;
}

IIR_LibraryUnit *
VHDLParser::primary_unit(IIR_LibraryDeclaration * library)
{
  IIR_LibraryUnit *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_LibraryUnit *  ))
  _retv = NULL;
  if ( (LA(1)==ENTITY) ) {
    if ( !guessing ) {
       _retv  = entity_declaration();

    } else {
      entity_declaration();
    }
  }
  else {
    if ( (LA(1)==CONFIGURATION)
 ) {
      if ( !guessing ) {
         _retv  = configuration_declaration(  library  );

      } else {
        configuration_declaration(  library  );
      }
    }
    else {
      if ( (LA(1)==PACKAGE_) ) {
        if ( !guessing ) {
           _retv  = package_declaration();

        } else {
          package_declaration();
        }
      }
      else {FAIL(1,err3,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd2, 0x1);
  return _retv;
}

IIR_LibraryUnit *
VHDLParser::secondary_unit(IIR_LibraryDeclaration * library)
{
  IIR_LibraryUnit *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_LibraryUnit *  ))
  _retv = NULL;
  if ( (LA(1)==ARCHITECTURE) ) {
    if ( !guessing ) {
       _retv  = architecture_body(  library  );

    } else {
      architecture_body(  library  );
    }
  }
  else {
    if ( (LA(1)==PACKAGE_) ) {
      if ( !guessing ) {
         _retv  = package_body(  library  );

      } else {
        package_body(  library  );
      }
    }
    else {FAIL(1,err4,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd2, 0x2);
  return _retv;
}

void
VHDLParser::library_clause(IIR_DeclarationList * list)
{
  zzRULE;
  zzmatch(LIBRARY); consume();
  logical_library_name_list(  list );
  zzmatch(SEMI_COLON); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd2, 0x4);
}

void
VHDLParser::logical_library_name_list(IIR_DeclarationList * list)
{
  zzRULE;
  
  IIR_LibraryClause *lib = NULL;
  IIR_Identifier *name = NULL;
  if ( !guessing ) {
     name  = logical_name();

  } else {
    logical_name();
  }
  if ( !guessing ) {
  
  lib = new IIR_LibraryClause();
  IIR::copy_location( name, lib );
  lib->set_logical_name( name );
  lib->_type_check();
  list->append(lib);
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         name  = logical_name();

      } else {
        logical_name();
      }
      if ( !guessing ) {
      
      lib = new IIR_LibraryClause();
      IIR::copy_location( name, lib );
      lib->set_logical_name( name );
      lib->_type_check();
      list->append(lib);
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd2, 0x8);
}

IIR_Identifier *
VHDLParser::logical_name(void)
{
  IIR_Identifier *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Identifier *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = identifier();

  } else {
    identifier();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd2, 0x10);
  return _retv;
}

void
VHDLParser::context_clauses(IIR_DeclarationList * list)
{
  zzRULE;
  {
    while ( (setwd2[LA(1)]&0x20)
 ) {
      context_item(  list );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd2, 0x40);
}

void
VHDLParser::context_item(IIR_DeclarationList * list)
{
  zzRULE;
  if ( (LA(1)==LIBRARY) ) {
    library_clause( list );
  }
  else {
    if ( (LA(1)==USE) ) {
      use_clause( list );
    }
    else {FAIL(1,err5,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd2, 0x80);
}

IIR_EntityDeclaration *
VHDLParser::entity_declaration(void)
{
  IIR_EntityDeclaration *   _retv;
  zzRULE;
  ANTLRTokenPtr entity=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_EntityDeclaration *  ))
  
  _retv = NULL;
  IIR_Identifier *entity_designator = NULL;
  IIR_SimpleName *end_designator = NULL;
  zzmatch(ENTITY);
  if ( !guessing ) {
    entity = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     entity_designator  = identifier();

  } else {
    identifier();
  }
  zzmatch(IS);
  if ( !guessing ) {
  
  _retv = new IIR_EntityDeclaration();
  _retv->set_declarator( entity_designator );
  copy_location( entity, _retv );
  _retv->_add_declaration_and_open_scope();
  }
 consume();
  entity_header( _retv );
  entity_declarative_part( &_retv->entity_declarative_part );
  if ( !guessing ) {
  
  IIR::copy_location( _retv, &_retv->entity_declarative_part );
  IIR::copy_location( _retv, &_retv->entity_statement_part );
  }
  {
    if ( (LA(1)==BEGIN_) ) {
      zzmatch(BEGIN_); consume();
      entity_statement_part( &_retv->entity_statement_part );
    }
    else {
      if ( (LA(1)==END) ) {
      }
      else {FAIL(1,err6,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(END); consume();
  {
    if ( (LA(1)==ENTITY)
 ) {
      zzmatch(ENTITY); consume();
    }
    else {
      if ( (setwd3[LA(1)]&0x1) ) {
      }
      else {FAIL(1,err7,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (setwd3[LA(1)]&0x2) ) {
      if ( !guessing ) {
         end_designator  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( entity_designator, end_designator, "entity" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err8,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv->_type_check();
  my_symbol_table->close_scope( _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd3, 0x4);
  return _retv;
}

void
VHDLParser::entity_header(IIR_EntityDeclaration * entity)
{
  zzRULE;
  {
    if ( (LA(1)==GENERIC) ) {
      generic_clause(  &entity->generic_clause  );
    }
    else {
      if ( (setwd3[LA(1)]&0x8)
 ) {
      }
      else {FAIL(1,err9,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==PORT) ) {
      port_clause( &entity->port_clause );
    }
    else {
      if ( (setwd3[LA(1)]&0x10) ) {
      }
      else {FAIL(1,err10,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd3, 0x20);
}

void
VHDLParser::entity_declarative_part(IIR_DeclarationList * decl_list)
{
  zzRULE;
  {
    while ( (setwd3[LA(1)]&0x40) ) {
      entity_declarative_item(  decl_list );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd3, 0x80);
}

void
VHDLParser::entity_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  zzGUESS_BLOCK
  if ( (setwd4[LA(1)]&0x1) ) {
    subprogram(  decl_list  );
  }
  else {
    if ( (LA(1)==TYPE)
 ) {
      type_declaration(  decl_list  );
    }
    else {
      if ( (LA(1)==SUBTYPE) ) {
        subtype_declaration(  decl_list  );
      }
      else {
        if ( (LA(1)==CONSTANT) ) {
          constant_declaration(  decl_list  );
        }
        else {
          if ( (LA(1)==SIGNAL) ) {
            signal_declaration(  decl_list  );
          }
          else {
            if ( (LA(1)==SHARED) ) {
              shared_variable_declaration(  decl_list  );
            }
            else {
              if ( (LA(1)==FILE_)
 ) {
                file_declaration(  decl_list  );
              }
              else {
                if ( (LA(1)==ALIAS) ) {
                  alias_declaration(  decl_list  );
                }
                else {
                  if ( (LA(1)==ATTRIBUTE) ) {
                    attribute_declarative_item(  decl_list  );
                  }
                  else {
                    if ( (LA(1)==DISCONNECT) ) {
                      disconnection_specification(  decl_list  );
                    }
                    else {
                      if ( (LA(1)==USE) ) {
                        use_clause(  decl_list  );
                      }
                      else {
                        zzGUESS
                        if ( !zzrv && (setwd4[LA(1)]&0x2)
 ) {
                          {
                            if ( (LA(1)==LIMIT) ) {
                              zzmatch(LIMIT); consume();
                            }
                            else {
                              if ( (LA(1)==NATURE) ) {
                                zzmatch(NATURE); consume();
                              }
                              else {
                                if ( (LA(1)==SUBNATURE) ) {
                                  zzmatch(SUBNATURE); consume();
                                }
                                else {
                                  if ( (LA(1)==QUANTITY) ) {
                                    zzmatch(QUANTITY); consume();
                                  }
                                  else {
                                    if ( (LA(1)==TERMINAL)
 ) {
                                      zzmatch(TERMINAL); consume();
                                    }
                                    else {FAIL(1,err11,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                  }
                                }
                              }
                            }
                          }
                          zzGUESS_DONE
                          if (!(lang_proc->processing_vhdl_ams())                            ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
                          {
                            if ( (LA(1)==LIMIT) ) {
                              step_limit_specification(  decl_list  );
                            }
                            else {
                              if ( (LA(1)==NATURE) ) {
                                nature_declaration(  decl_list  );
                              }
                              else {
                                if ( (LA(1)==SUBNATURE) ) {
                                  subnature_declaration(  decl_list  );
                                }
                                else {
                                  if ( (LA(1)==QUANTITY) ) {
                                    quantity_declaration(  decl_list  );
                                  }
                                  else {
                                    if ( (LA(1)==TERMINAL)
 ) {
                                      terminal_declaration(  decl_list  );
                                    }
                                    else {FAIL(1,err12,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                  }
                                }
                              }
                            }
                          }
                        }
                        else {
                          if ( !zzrv ) zzGUESS_DONE;
                          zzGUESS
                          if ( !zzrv && (LA(1)==GROUP) && (setwd4[LA(2)]&0x4) ) {
                            {
                              zzmatch(GROUP); consume();
                              zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset); consume();
                              zzmatch(COLON); consume();
                            }
                            zzGUESS_DONE
                            group_declaration(  decl_list  );
                          }
                          else {
                            if ( !zzrv ) zzGUESS_DONE;
                            if ( (LA(1)==GROUP) && (setwd4[LA(2)]&0x8) ) {
                              group_template_declaration(  decl_list  );
                            }
                            else {FAIL(2,err15,err16,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd4, 0x10);
}

void
VHDLParser::entity_statement_part(IIR_ArchitectureStatementList * stmt_list)
{
  zzRULE;
  IIR_ConcurrentStatement *stmt = NULL;
  {
    while ( (setwd4[LA(1)]&0x20) ) {
      if ( !guessing ) {
         stmt  = entity_statement();

      } else {
        entity_statement();
      }
      if ( !guessing ) {
      stmt_list->append(stmt);
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd4, 0x40);
}

IIR_ConcurrentStatement *
VHDLParser::entity_statement(void)
{
  IIR_ConcurrentStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentStatement *  ))
  
  _retv = NULL;
  IIR_Label *label = NULL;
  IIR_Boolean postpone = false;
  {
    if ( (setwd4[LA(1)]&0x80) && (LA(2)==COLON) ) {
      if ( !guessing ) {
         label  = stmt_label();

      } else {
        stmt_label();
      }
    }
    else {
      if ( (setwd5[LA(1)]&0x1) && 
(setwd5[LA(2)]&0x2) ) {
      }
      else {FAIL(2,err17,err18,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==POSTPONED) ) {
      zzmatch(POSTPONED);
      if ( !guessing ) {
      postpone = true;
      }
 consume();
    }
    else {
      if ( (setwd5[LA(1)]&0x4) ) {
      }
      else {FAIL(1,err19,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
     _retv  = entity_stmt(  postpone, label  );

  } else {
    entity_stmt(  postpone, label  );
  }
  if ( !guessing ) {
  if( label != NULL ){ _retv->set_label( label ); }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd5, 0x8);
  return _retv;
}

IIR_ConcurrentStatement *
VHDLParser::entity_stmt(IIR_Boolean postpone,IIR_Label * label)
{
  IIR_ConcurrentStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentStatement *  ))
  _retv = NULL;
  if ( (LA(1)==ASSERT) ) {
    if ( !guessing ) {
       _retv  = concurrent_assertion_statement(  label  );

    } else {
      concurrent_assertion_statement(  label  );
    }
    if ( !guessing ) {
    ((IIR_ConcurrentAssertionStatement*)_retv)->set_postponed(postpone);
    }
  }
  else {
    if ( (setwd5[LA(1)]&0x10) ) {
      if ( !guessing ) {
         _retv  = concurrent_procedure_call(  label  );

      } else {
        concurrent_procedure_call(  label  );
      }
      if ( !guessing ) {
      ((IIR_ConcurrentProcedureCallStatement*)_retv)->set_postponed(postpone);
      }
    }
    else {
      if ( (LA(1)==PROCESS)
 ) {
        if ( !guessing ) {
           _retv  = process_statement(  label  );

        } else {
          process_statement(  label  );
        }
        if ( !guessing ) {
        ((IIR_ProcessStatement*)_retv)->set_postponed(postpone);
        }
      }
      else {FAIL(1,err20,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd5, 0x20);
  return _retv;
}

IIR_ConcurrentStatement *
VHDLParser::concurrent_procedure_call(IIR_Label * label)
{
  IIR_ConcurrentStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentStatement *  ))
  
  _retv = NULL;
  IIR_ConcurrentProcedureCallStatement *proc_call_statement = NULL;
  IIR_ComponentInstantiationStatement *comp_instantiation_statement = NULL;
  IIR *temp_name = NULL;
  
    bool found_procedure = false;
  bool found_component = false;
  if ( !guessing ) {
     temp_name  = complex_name();

  } else {
    complex_name();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  // This could be a component instantiaion statement too.  We need to
  // figure out which it is.
  set<IIR_Declaration> *procedure_decls = NULL;
  if( temp_name->get_kind() == IIR_INDEXED_NAME ){
    procedure_decls = ((IIR_IndexedName *)temp_name)->get_prefix()->_symbol_lookup();
  }
  else{
    procedure_decls = temp_name->_symbol_lookup();
  }
  if( procedure_decls == NULL ){
    report_undefined_symbol( temp_name );
  }
  else{
    IIR_Declaration *current_decl = procedure_decls->get_element();
    while( current_decl != NULL ){
      if( current_decl->get_kind() == IIR_PROCEDURE_DECLARATION ){
        found_procedure = true;
      }
      else if( current_decl->get_kind() == IIR_COMPONENT_DECLARATION ){
        found_component = true;
      }
      current_decl = procedure_decls->get_next_element();
    }
  }
  
    if( found_procedure == true && found_component == true ){
    report_ambiguous_error( temp_name, procedure_decls );
  }
  else if ( found_procedure == true && found_component == false ){
    proc_call_statement = new IIR_ConcurrentProcedureCallStatement();
    IIR::copy_location( temp_name, proc_call_statement );
    proc_call_statement->set_label( label );
    proc_call_statement->set_procedure_name(temp_name);      
    _retv = proc_call_statement;
    _retv->_type_check();
  }
  else if ( found_procedure == false && found_component == true ){
    comp_instantiation_statement = new IIR_ComponentInstantiationStatement();
    IIR::copy_location( temp_name, comp_instantiation_statement );
    comp_instantiation_statement->set_instantiated_unit( temp_name );
    comp_instantiation_statement->set_label( label );
    comp_instantiation_statement->_type_check_instantiated_unit();
    _retv = comp_instantiation_statement;
  }
  else{
    ostringstream err;
    err << "|" << *temp_name << "| was declared neither as a component or procedure";
    report_error( temp_name, err.str() );
  }
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd5, 0x40);
  return _retv;
}

IIR_ArchitectureDeclaration *
VHDLParser::architecture_body(IIR_LibraryDeclaration * library)
{
  IIR_ArchitectureDeclaration *   _retv;
  zzRULE;
  ANTLRTokenPtr architecture=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ArchitectureDeclaration *  ))
  
  _retv = NULL;
  IIR_SimpleName *end_name = NULL;
  IIR_Identifier *name = NULL;
  IIR_Name *entity_name = NULL;
  IIR_ArchitectureDeclaration *new_arch = NULL;
  zzmatch(ARCHITECTURE);
  if ( !guessing ) {
    architecture = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     name  = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  
  new_arch = new IIR_ArchitectureDeclaration();
  new_arch->set_declarator( name );
  
    copy_location( architecture, new_arch );
  new_arch->_add_declaration();
  }
  zzmatch(OF); consume();
  if ( !guessing ) {
     entity_name  = selected_or_simple_name();

  } else {
    selected_or_simple_name();
  }
  if ( !guessing ) {
  
  my_symbol_table->open_scope(new_arch);
  IIR_EntityDeclaration *entity_decl = 
  library_manager::instance()->lookup_entity( TRUE, entity_name, library );
  if( entity_decl != NULL ){
    new_arch->set_entity( entity_decl );
    if( debug_symbol_table == true ){
      cerr << "Parsing architecture |" << *name 
      << "| - going to make entity |" << *entity_name << "| visible." << endl;
    }
    ((IIR_Declaration *)entity_decl)->_make_interface_visible( my_symbol_table );
  }
  }
  zzmatch(IS); consume();
  architecture_declarative_part( &new_arch->architecture_declarative_part );
  zzmatch(BEGIN_); consume();
  architecture_statement_part( &new_arch->architecture_statement_part );
  zzmatch(END); consume();
  {
    if ( (LA(1)==ARCHITECTURE) ) {
      zzmatch(ARCHITECTURE); consume();
    }
    else {
      if ( (setwd5[LA(1)]&0x80) ) {
      }
      else {FAIL(1,err21,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (setwd6[LA(1)]&0x1) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( name, end_name, "architecture" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err22,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv = new_arch;
  _retv->_type_check();
  my_symbol_table->close_scope( new_arch );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd6, 0x2);
  return _retv;
}

void
VHDLParser::architecture_declarative_part(IIR_DeclarationList * decl_list)
{
  zzRULE;
  {
    while ( (setwd6[LA(1)]&0x4)
 ) {
      block_declarative_item( decl_list );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd6, 0x8);
}

void
VHDLParser::architecture_statement_part(IIR_ArchitectureStatementList * stmt_list)
{
  zzRULE;
  {
    while ( (setwd6[LA(1)]&0x10) ) {
      architecture_statement_element(  stmt_list );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd6, 0x20);
}

void
VHDLParser::architecture_statement_element(IIR_ArchitectureStatementList * stmt_list)
{
  zzRULE;
  zzGUESS_BLOCK
  
  IIR *cond = NULL;
  IIR *dummy_expr = NULL;
  zzGUESS
  if ( !zzrv && (setwd6[LA(1)]&0x40) && (setwd6[LA(2)]&0x80) ) {
    {
      if ( (LA(1)==CASE) ) {
        zzmatch(CASE); consume();
      }
      else {
        if ( (LA(1)==NULL_) ) {
          zzmatch(NULL_); consume();
        }
        else {
          if ( (LA(1)==PROCEDURAL)
 ) {
            zzmatch(PROCEDURAL); consume();
          }
          else {
            if ( (LA(1)==IF) ) {
              zzmatch(IF); consume();
              if ( !guessing ) {
                 cond  = condition();

              } else {
                condition();
              }
              zzmatch(USE); consume();
            }
            else {
              if ( (setwd7[LA(1)]&0x1) && (setwd7[LA(2)]&0x2) ) {
                if ( !guessing ) {
                   dummy_expr  = simple_expression();

                } else {
                  simple_expression();
                }
                zzmatch(EQUAL_EQUAL); consume();
              }
              else {FAIL(2,err23,err24,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
            }
          }
        }
      }
    }
    zzGUESS_DONE
    if (!(lang_proc->processing_vhdl_ams())      ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
    simultaneous_statement(  stmt_list );
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd7[LA(1)]&0x4) && (setwd7[LA(2)]&0x8) ) {
      concurrent_statement(  stmt_list );
    }
    else {FAIL(2,err25,err26,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd7, 0x10);
}

IIR_ConfigurationDeclaration *
VHDLParser::configuration_declaration(IIR_LibraryDeclaration * library)
{
  IIR_ConfigurationDeclaration *   _retv;
  zzRULE;
  ANTLRTokenPtr configuration=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConfigurationDeclaration *  ))
  
  _retv = NULL;
  IIR_SimpleName *end_name = NULL;
  IIR_Identifier *name = NULL;
  IIR_Name *entity_name = NULL;
  IIR_BlockConfiguration *block_config = NULL;
  IIR_ConfigurationDeclaration *new_configuration_decl = NULL;
  zzmatch(CONFIGURATION);
  if ( !guessing ) {
    configuration = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     name  = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  
  new_configuration_decl = new IIR_ConfigurationDeclaration();
  new_configuration_decl->set_declarator( name );
  
    copy_location( configuration, new_configuration_decl );
  new_configuration_decl->_add_declaration_and_open_scope();
  }
  zzmatch(OF); consume();
  if ( !guessing ) {
     entity_name  = selected_or_simple_name();

  } else {
    selected_or_simple_name();
  }
  if ( !guessing ) {
  
  IIR_EntityDeclaration *entity_decl = NULL;
  entity_decl = library_manager::instance()->lookup_entity( TRUE, entity_name, library );
  if( entity_decl != NULL ){
    // This means we can't reproduce the qualified name...
    new_configuration_decl->set_entity( entity_decl );
    if( debug_symbol_table == true ){
    cerr << "Parsing configuration |" << *name << "| - making entity |" 
    << *entity_name << "| visible." << endl;
  }
  ((IIR_Declaration *)entity_decl)->_make_interface_visible( my_symbol_table );
}
  }
  zzmatch(IS); consume();
  configuration_declarative_part(  &new_configuration_decl->configuration_declarative_part  );
  if ( !guessing ) {
      block_config   = block_configuration();

  } else {
    block_configuration();
  }
  if ( !guessing ) {
  new_configuration_decl->set_block_configuration( block_config );
  }
  zzmatch(END); consume();
  {
    if ( (LA(1)==CONFIGURATION) ) {
      zzmatch(CONFIGURATION); consume();
    }
    else {
      if ( (setwd7[LA(1)]&0x20)
 ) {
      }
      else {FAIL(1,err27,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (setwd7[LA(1)]&0x40) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( name, end_name, "configuration" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err28,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv = new_configuration_decl;
  _retv->_type_check();
  my_symbol_table->close_scope( new_configuration_decl );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd7, 0x80);
  return _retv;
}

void
VHDLParser::configuration_declarative_part(IIR_DeclarationList * decl_list)
{
  zzRULE;
  {
    while ( (setwd8[LA(1)]&0x1) ) {
      configuration_declarative_item(   decl_list  );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd8, 0x2);
}

void
VHDLParser::configuration_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  if ( (LA(1)==USE) ) {
    use_clause(  decl_list  );
  }
  else {
    if ( (LA(1)==ATTRIBUTE)
 ) {
      attribute_specification(  decl_list  );
    }
    else {
      if ( (LA(1)==GROUP) ) {
        group_declaration(  decl_list  );
      }
      else {FAIL(1,err29,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd8, 0x4);
}

IIR_BlockConfiguration *
VHDLParser::block_configuration(void)
{
  IIR_BlockConfiguration *   _retv;
  zzRULE;
  ANTLRTokenPtr for_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_BlockConfiguration *  ))
  
  _retv = NULL;
  IIR_ConfigurationItem *config_item = NULL;
  IIR *block_spec = NULL;
  if ( !guessing ) {
  
  // If we get an architecture, we make it's declarative region visible.
  // We'll open and close a scope so that we can get rid of that stuff,
  // too. 
  _retv = new IIR_BlockConfiguration();
  my_symbol_table->open_scope( _retv );
  }
  zzmatch(FOR);
  if ( !guessing ) {
    for_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
      block_spec   = block_specification();

  } else {
    block_specification();
  }
  if ( !guessing ) {
  
  _retv->set_block_specification( block_spec );
  IIR::copy_location( block_spec, _retv );
  }
  {
    while ( (LA(1)==USE) ) {
      use_clause(  &_retv->use_clause_list  );
    }
  }
  {
    while ( (LA(1)==FOR) ) {
      if ( !guessing ) {
          config_item   = configuration_item();

      } else {
        configuration_item();
      }
      if ( !guessing ) {
      _retv->configuration_item_list.append( config_item );
      }
    }
  }
  zzmatch(END); consume();
  zzmatch(FOR); consume();
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  my_symbol_table->close_scope( _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd8, 0x8);
  return _retv;
}

IIR_Name *
VHDLParser::block_specification(void)
{
  IIR_Name *   _retv;
  zzRULE;
  ANTLRTokenPtr line_info=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  
  _retv = NULL;
  IIR_IndexedName *with_index_specification = NULL;
  IIR *index_spec = NULL;
  if ( !guessing ) {
      _retv   = selected_or_simple_name();

  } else {
    selected_or_simple_name();
  }
  {
    if ( (LA(1)==L_PAREN) ) {
      zzmatch(L_PAREN);
      if ( !guessing ) {
            line_info = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
          index_spec   = index_specifier();

      } else {
        index_specifier();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      
      with_index_specification = new IIR_IndexedName();
      copy_location( line_info, with_index_specification );
      with_index_specification->set_prefix( _retv );
      with_index_specification->set_suffix( index_spec );
      _retv = with_index_specification;
      }
 consume();
    }
    else {
      if ( (setwd8[LA(1)]&0x10)
 ) {
      }
      else {FAIL(1,err30,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd8, 0x20);
  return _retv;
}

IIR_ConfigurationItem *
VHDLParser::configuration_item(void)
{
  IIR_ConfigurationItem *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConfigurationItem *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  zzGUESS
  if ( !zzrv && (LA(1)==FOR) && (setwd8[LA(2)]&0x40) ) {
    {
      if ( !guessing ) {
          _retv   = component_configuration();

      } else {
        component_configuration();
      }
    }
    zzGUESS_DONE
    {
      if ( !guessing ) {
          _retv   = component_configuration();

      } else {
        component_configuration();
      }
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (LA(1)==FOR) && (setwd8[LA(2)]&0x80) ) {
      if ( !guessing ) {
          _retv   = block_configuration();

      } else {
        block_configuration();
      }
    }
    else {FAIL(2,err31,err32,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd9, 0x1);
  return _retv;
}

IIR_ComponentConfiguration *
VHDLParser::component_configuration(void)
{
  IIR_ComponentConfiguration *   _retv;
  zzRULE;
  ANTLRTokenPtr for_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ComponentConfiguration *  ))
  
  _retv = new IIR_ComponentConfiguration();
  IIR_Name *component_name = NULL;
  IIR_BlockConfiguration *block_config = NULL;
  scram_binding_info_t *binding_info = NULL;
  zzmatch(FOR);
  if ( !guessing ) {
    for_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
      component_name   = component_specification(  &_retv->instantiation_list  );

  } else {
    component_specification(  &_retv->instantiation_list  );
  }
  if ( !guessing ) {
  
  IIR::copy_location( component_name, _retv );
  _retv->set_component_name( component_name );
  }
  {
    if ( (setwd9[LA(1)]&0x2) ) {
      if ( !guessing ) {
          binding_info   = binding_indication();

      } else {
        binding_indication();
      }
      if ( !guessing ) {
      
      if( binding_info != NULL ){
        _retv->set_entity_aspect( binding_info->entity_aspect );
        if( binding_info->generic_map_aspect != NULL ){
          _retv->generic_map_aspect = *binding_info->generic_map_aspect;
        }
        if( binding_info->port_map_aspect != NULL ){
          _retv->port_map_aspect = *binding_info->port_map_aspect;
        }
      }
      }
      zzmatch(SEMI_COLON); consume();
    }
    else {
      if ( (setwd9[LA(1)]&0x4) ) {
      }
      else {FAIL(1,err33,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==FOR)
 ) {
      if ( !guessing ) {
          block_config   = block_configuration();

      } else {
        block_configuration();
      }
      if ( !guessing ) {
      _retv->set_block_configuration( block_config );
      }
    }
    else {
      if ( (LA(1)==END) ) {
      }
      else {FAIL(1,err34,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(END); consume();
  zzmatch(FOR); consume();
  zzmatch(SEMI_COLON); consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd9, 0x8);
  return _retv;
}

void
VHDLParser::concurrent_statement(IIR_ArchitectureStatementList * stmts)
{
  zzRULE;
  
  IIR_ArchitectureStatement *new_stmt = NULL; 
  IIR_Label *label = NULL;;
  {
    if ( (setwd9[LA(1)]&0x10) && (LA(2)==COLON) ) {
      if ( !guessing ) {
         label  = stmt_label();

      } else {
        stmt_label();
      }
    }
    else {
      if ( (setwd9[LA(1)]&0x20) && (setwd9[LA(2)]&0x40) ) {
      }
      else {FAIL(2,err35,err36,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
     new_stmt  = concurrent_stmt( label );

  } else {
    concurrent_stmt( label );
  }
  if ( !guessing ) {
  stmts->append(new_stmt);
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd9, 0x80);
}

IIR_ArchitectureStatement *
VHDLParser::concurrent_stmt(IIR_Label * label)
{
  IIR_ArchitectureStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ArchitectureStatement *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR_Boolean postpone = false;
  IIR_Expression *cond = NULL;
  IIR *dummy_expr = NULL;
  zzGUESS
  if ( !zzrv && (setwd10[LA(1)]&0x1) && (setwd10[LA(2)]&0x2) ) {
    {
      if ( (LA(1)==BLOCK)
 ) {
        zzmatch(BLOCK); consume();
      }
      else {
        if ( (LA(1)==FOR) ) {
          zzmatch(FOR); consume();
        }
        else {
          if ( (LA(1)==IF) ) {
            zzmatch(IF); consume();
          }
          else {
            if ( (LA(1)==BREAK) ) {
              zzmatch(BREAK); consume();
            }
            else {
              if ( (LA(1)==CASE) ) {
                zzmatch(CASE); consume();
              }
              else {
                if ( (LA(1)==NULL_)
 ) {
                  zzmatch(NULL_); consume();
                }
                else {
                  if ( (LA(1)==PROCEDURAL) ) {
                    zzmatch(PROCEDURAL); consume();
                  }
                  else {
                    if ( (setwd10[LA(1)]&0x4) && (setwd10[LA(2)]&0x8) ) {
                      if ( !guessing ) {
                         dummy_expr  = simple_expression();

                      } else {
                        simple_expression();
                      }
                      zzmatch(EQUAL_EQUAL); consume();
                    }
                    else {FAIL(2,err37,err38,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                  }
                }
              }
            }
          }
        }
      }
    }
    zzGUESS_DONE
    if ( !guessing ) {
       _retv  = not_postponeable(  label  );

    } else {
      not_postponeable(  label  );
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd10[LA(1)]&0x10) && (setwd10[LA(2)]&0x20) ) {
      {
        if ( (LA(1)==POSTPONED) ) {
          zzmatch(POSTPONED);
          if ( !guessing ) {
          postpone = true;
          }
 consume();
        }
        else {
          if ( (setwd10[LA(1)]&0x40)
 ) {
          }
          else {FAIL(1,err39,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      if ( !guessing ) {
         _retv  = postponeable(  postpone, label  );

      } else {
        postponeable(  postpone, label  );
      }
    }
    else {FAIL(2,err40,err41,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd10, 0x80);
  return _retv;
}

IIR_ArchitectureStatement *
VHDLParser::not_postponeable(IIR_Label * label)
{
  IIR_ArchitectureStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ArchitectureStatement *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR *dummy_expr = NULL;
  if ( (LA(1)==BLOCK) ) {
    if ( !guessing ) {
       _retv  = block_statement(  label  );

    } else {
      block_statement(  label  );
    }
  }
  else {
    zzGUESS
    if ( !zzrv && (setwd11[LA(1)]&0x1) && (setwd11[LA(2)]&0x2) ) {
      {
        if ( !guessing ) {
           _retv  = generate_scheme(  label  );

        } else {
          generate_scheme(  label  );
        }
        zzmatch(GENERATE); consume();
      }
      zzGUESS_DONE
      if ( !guessing ) {
         _retv  = generate_statement(  label  );

      } else {
        generate_statement(  label  );
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      zzGUESS
      if ( !zzrv && (setwd11[LA(1)]&0x4) && (setwd11[LA(2)]&0x8) ) {
        {
          if ( (LA(1)==IF) ) {
            zzmatch(IF); consume();
          }
          else {
            if ( (LA(1)==CASE)
 ) {
              zzmatch(CASE); consume();
            }
            else {
              if ( (LA(1)==NULL_) ) {
                zzmatch(NULL_); consume();
              }
              else {
                if ( (LA(1)==PROCEDURAL) ) {
                  zzmatch(PROCEDURAL); consume();
                }
                else {
                  if ( (setwd11[LA(1)]&0x10) && (setwd11[LA(2)]&0x20) ) {
                    if ( !guessing ) {
                       dummy_expr  = simple_expression();

                    } else {
                      simple_expression();
                    }
                    zzmatch(EQUAL_EQUAL); consume();
                  }
                  else {FAIL(2,err42,err43,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                }
              }
            }
          }
        }
        zzGUESS_DONE
        if (!(lang_proc->processing_vhdl_ams())          ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
        if ( !guessing ) {
           _retv  = simultaneous_stmt( label );

        } else {
          simultaneous_stmt( label );
        }
      }
      else {
        if ( !zzrv ) zzGUESS_DONE;
        if ( (LA(1)==BREAK) ) {
          if (!(lang_proc->processing_vhdl_ams())            ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
          if ( !guessing ) {
             _retv  = concurrent_break_statement( label );

          } else {
            concurrent_break_statement( label );
          }
        }
        else {FAIL(2,err44,err45,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd11, 0x40);
  return _retv;
}

IIR_ConcurrentStatement *
VHDLParser::postponeable(IIR_Boolean postpone,IIR_Label * label)
{
  IIR_ConcurrentStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentStatement *  ))
  zzGUESS_BLOCK
  
  IIR *name = NULL;
  IIR_Name *dummy = NULL;
  
    // Here are the different types of stamtements.
  IIR_ProcessStatement *proc_stmt = NULL;
  IIR_ConcurrentAssertionStatement *conc_assert_stmt = NULL;
  IIR_ConcurrentSelectedSignalAssignment *conc_selected_sig_assign = NULL;
  if ( (LA(1)==PROCESS)
 ) {
    if ( !guessing ) {
        proc_stmt   = process_statement(  label  );

    } else {
      process_statement(  label  );
    }
    if ( !guessing ) {
    
    proc_stmt->set_postponed( postpone );
    _retv = proc_stmt;
    }
  }
  else {
    if ( (LA(1)==ASSERT) ) {
      if ( !guessing ) {
          conc_assert_stmt   = concurrent_assertion_statement(  label  );

      } else {
        concurrent_assertion_statement(  label  );
      }
      if ( !guessing ) {
      
      conc_assert_stmt->set_postponed( postpone );
      _retv = conc_assert_stmt;
      }
    }
    else {
      if ( (LA(1)==WITH) ) {
        if ( !guessing ) {
            conc_selected_sig_assign   = selected_signal_assignment_statement(  label  );

        } else {
          selected_signal_assignment_statement(  label  );
        }
        if ( !guessing ) {
        
        conc_selected_sig_assign->set_postponed( postpone );
        _retv = conc_selected_sig_assign;
        }
      }
      else {
        zzGUESS
        if ( !zzrv && (setwd11[LA(1)]&0x80) && (setwd12[LA(2)]&0x1) ) {
          {
            if ( !guessing ) {
               name  = target();

            } else {
              target();
            }
            zzmatch(LESS_EQUAL); consume();
          }
          zzGUESS_DONE
          if ( !guessing ) {
             _retv  = conditional_signal_assignment(  label  );

          } else {
            conditional_signal_assignment(  label  );
          }
        }
        else {
          if ( !zzrv ) zzGUESS_DONE;
          zzGUESS
          if ( !zzrv && (setwd12[LA(1)]&0x2) && (setwd12[LA(2)]&0x4) ) {
            {
              if ( (LA(1)==COMPONENT)
 ) {
                zzmatch(COMPONENT); consume();
              }
              else {
                if ( (LA(1)==ENTITY) ) {
                  zzmatch(ENTITY); consume();
                }
                else {
                  if ( (LA(1)==CONFIGURATION) ) {
                    zzmatch(CONFIGURATION); consume();
                  }
                  else {
                    if ( (setwd12[LA(1)]&0x8) ) {
                      if ( !guessing ) {
                         dummy  = complex_name();

                      } else {
                        complex_name();
                      }
                      {
                        IIR_AssociationList dummy1;
                        if ( (LA(1)==GENERIC) ) {
                          generic_map_aspect( &dummy1 );
                        }
                        else {
                          if ( (LA(1)==PORT)
 ) {
                            port_map_aspect( &dummy1 );
                          }
                          else {FAIL(1,err46,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                        }
                      }
                    }
                    else {FAIL(1,err47,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                  }
                }
              }
            }
            zzGUESS_DONE
            if ( !guessing ) {
               _retv  = instantiate_statement(  label  );

            } else {
              instantiate_statement(  label  );
            }
          }
          else {
            if ( !zzrv ) zzGUESS_DONE;
            if ( (setwd12[LA(1)]&0x10) && (setwd12[LA(2)]&0x20) ) {
              if ( !guessing ) {
                 _retv  = concurrent_procedure_call(  label  );

              } else {
                concurrent_procedure_call(  label  );
              }
            }
            else {FAIL(2,err48,err49,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd12, 0x40);
  return _retv;
}

IIR_BlockStatement *
VHDLParser::block_statement(IIR_Label * label)
{
  IIR_BlockStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr block_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_BlockStatement *  ))
  
  _retv = NULL;
  IIR_SimpleName *end_name = NULL;
  IIR *guard_expr = NULL;
  zzmatch(BLOCK);
  if ( !guessing ) {
    block_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_BlockStatement();
  _retv->set_label( label );
  copy_location( block_, _retv );
  my_symbol_table->open_scope( _retv );
  }
 consume();
  {
    if ( (LA(1)==L_PAREN) ) {
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         guard_expr  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      
      _retv->set_guard_expression(guard_expr);
      IIR_SignalDeclaration *guard_signal = new IIR_SignalDeclaration();
      IIR::copy_location( guard_expr, guard_signal );
      // This is building the implicit declaration required for the guarded
      // expression as per the LRM.
      guard_signal->set_declarator( IIR_Identifier::get( "guard", strlen("guard") ) );
      IIR_TypeDefinition *bool_type = StandardPackage::get_boolean_type();
      guard_signal->set_subtype( bool_type );
      _retv->_set_implicit_guard_signal( guard_signal );
      guard_signal->_add_declaration( );
      }
 consume();
    }
    else {
      if ( (setwd12[LA(1)]&0x80) ) {
      }
      else {FAIL(1,err50,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==IS) ) {
      zzmatch(IS); consume();
    }
    else {
      if ( (setwd13[LA(1)]&0x1)
 ) {
      }
      else {FAIL(1,err51,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  block_header( _retv );
  block_declarative_part( &_retv->block_declarative_part );
  zzmatch(BEGIN_); consume();
  architecture_statement_part( &_retv->block_statement_part );
  zzmatch(END); consume();
  zzmatch(BLOCK); consume();
  {
    if ( (setwd13[LA(1)]&0x2) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( _retv->get_label(), end_name, "block" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err52,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv->_type_check();
  my_symbol_table->close_scope( _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd13, 0x4);
  return _retv;
}

void
VHDLParser::block_header(IIR_BlockStatement * block)
{
  zzRULE;
  {
    if ( (LA(1)==GENERIC) ) {
      generic_clause( & block->generic_clause );
      {
        if ( (LA(1)==GENERIC) ) {
          generic_map_aspect( & block->generic_map_aspect );
          zzmatch(SEMI_COLON); consume();
        }
        else {
          if ( (setwd13[LA(1)]&0x8)
 ) {
          }
          else {FAIL(1,err53,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
    else {
      if ( (setwd13[LA(1)]&0x10) ) {
      }
      else {FAIL(1,err54,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==PORT) ) {
      port_clause( & block->port_clause );
      {
        if ( (LA(1)==PORT) ) {
          port_map_aspect( & block->port_map_aspect );
          zzmatch(SEMI_COLON); consume();
        }
        else {
          if ( (setwd13[LA(1)]&0x20) ) {
          }
          else {FAIL(1,err55,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
    else {
      if ( (setwd13[LA(1)]&0x40)
 ) {
      }
      else {FAIL(1,err56,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd13, 0x80);
}

void
VHDLParser::block_declarative_part(IIR_DeclarationList * dl)
{
  zzRULE;
  {
    while ( (setwd14[LA(1)]&0x1) ) {
      block_declarative_item(  dl );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd14, 0x2);
}

void
VHDLParser::block_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  zzGUESS_BLOCK
  if ( (setwd14[LA(1)]&0x4) ) {
    subprogram(  decl_list  );
  }
  else {
    if ( (LA(1)==TYPE) ) {
      type_declaration(  decl_list  );
    }
    else {
      if ( (LA(1)==SUBTYPE) ) {
        subtype_declaration(  decl_list  );
      }
      else {
        if ( (LA(1)==CONSTANT)
 ) {
          constant_declaration(  decl_list  );
        }
        else {
          if ( (LA(1)==SIGNAL) ) {
            signal_declaration(  decl_list  );
          }
          else {
            if ( (LA(1)==SHARED) ) {
              shared_variable_declaration(  decl_list  );
            }
            else {
              if ( (LA(1)==FILE_) ) {
                file_declaration(  decl_list  );
              }
              else {
                if ( (LA(1)==ALIAS) ) {
                  alias_declaration(  decl_list  );
                }
                else {
                  if ( (LA(1)==COMPONENT)
 ) {
                    component_declaration(  decl_list  );
                  }
                  else {
                    if ( (LA(1)==DISCONNECT) ) {
                      disconnection_specification(  decl_list  );
                    }
                    else {
                      if ( (LA(1)==ATTRIBUTE) ) {
                        attribute_declarative_item(  decl_list  );
                      }
                      else {
                        if ( (LA(1)==FOR) ) {
                          configuration_specification(  decl_list  );
                        }
                        else {
                          if ( (LA(1)==USE) ) {
                            use_clause(  decl_list  );
                          }
                          else {
                            zzGUESS
                            if ( !zzrv && (setwd14[LA(1)]&0x8)
 ) {
                              {
                                if ( (LA(1)==LIMIT) ) {
                                  zzmatch(LIMIT); consume();
                                }
                                else {
                                  if ( (LA(1)==NATURE) ) {
                                    zzmatch(NATURE); consume();
                                  }
                                  else {
                                    if ( (LA(1)==SUBNATURE) ) {
                                      zzmatch(SUBNATURE); consume();
                                    }
                                    else {
                                      if ( (LA(1)==QUANTITY) ) {
                                        zzmatch(QUANTITY); consume();
                                      }
                                      else {
                                        if ( (LA(1)==TERMINAL)
 ) {
                                          zzmatch(TERMINAL); consume();
                                        }
                                        else {FAIL(1,err57,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                      }
                                    }
                                  }
                                }
                              }
                              zzGUESS_DONE
                              if (!(lang_proc->processing_vhdl_ams())                                ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
                              {
                                if ( (LA(1)==LIMIT) ) {
                                  step_limit_specification(  decl_list  );
                                }
                                else {
                                  if ( (LA(1)==NATURE) ) {
                                    nature_declaration(  decl_list  );
                                  }
                                  else {
                                    if ( (LA(1)==SUBNATURE) ) {
                                      subnature_declaration(  decl_list  );
                                    }
                                    else {
                                      if ( (LA(1)==QUANTITY) ) {
                                        quantity_declaration(  decl_list  );
                                      }
                                      else {
                                        if ( (LA(1)==TERMINAL)
 ) {
                                          terminal_declaration(  decl_list  );
                                        }
                                        else {FAIL(1,err58,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                      }
                                    }
                                  }
                                }
                              }
                            }
                            else {
                              if ( !zzrv ) zzGUESS_DONE;
                              zzGUESS
                              if ( !zzrv && (LA(1)==GROUP) && (setwd14[LA(2)]&0x10) ) {
                                {
                                  zzmatch(GROUP); consume();
                                  zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset); consume();
                                  zzmatch(COLON); consume();
                                }
                                zzGUESS_DONE
                                group_declaration(  decl_list  );
                              }
                              else {
                                if ( !zzrv ) zzGUESS_DONE;
                                if ( (LA(1)==GROUP) && (setwd14[LA(2)]&0x20) ) {
                                  group_template_declaration(  decl_list  );
                                }
                                else {FAIL(2,err59,err60,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd14, 0x40);
}

IIR_ProcessStatement *
VHDLParser::process_statement(IIR_Label * label)
{
  IIR_ProcessStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr process=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ProcessStatement *  ))
  
  _retv = NULL;
  IIR_ProcessStatement *process_stmt = NULL;
  IIR_SimpleName *end_name = NULL;
  IIR_SensitizedProcessStatement *sensitive_process_stmt = NULL;
  zzmatch(PROCESS);
  if ( !guessing ) {
    process = (ANTLRTokenPtr)LT(1);
  }
   consume();
  {
    if ( (LA(1)==L_PAREN) ) {
      zzmatch(L_PAREN);
      if ( !guessing ) {
      
      sensitive_process_stmt = new IIR_SensitizedProcessStatement();
      my_symbol_table->open_scope( sensitive_process_stmt );   
      sensitive_process_stmt->set_label( label );
      
      copy_location( process, sensitive_process_stmt );
      process_stmt = sensitive_process_stmt;
      }
 consume();
      sensitivity_list( &sensitive_process_stmt->sensitivity_list );
      zzmatch(R_PAREN); consume();
    }
    else {
      if ( (setwd14[LA(1)]&0x80) ) {
      }
      else {FAIL(1,err61,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  if (process_stmt == NULL) {
    process_stmt = new IIR_ProcessStatement();
    my_symbol_table->open_scope( process_stmt );   
    process_stmt->set_label( label );
    
      copy_location( process, process_stmt );
  }
  process_stmt->set_postponed( FALSE );
  }
  {
    if ( (LA(1)==IS)
 ) {
      zzmatch(IS); consume();
    }
    else {
      if ( (setwd15[LA(1)]&0x1) ) {
      }
      else {FAIL(1,err62,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  process_declarative_part(  &process_stmt->process_declarative_part  );
  zzmatch(BEGIN_); consume();
  sequence_of_statements( &process_stmt->process_statement_part );
  zzmatch(END); consume();
  {
    if ( (LA(1)==POSTPONED) ) {
      zzmatch(POSTPONED);
      if ( !guessing ) {
      process_stmt->set_postponed( TRUE );
      }
 consume();
    }
    else {
      if ( (LA(1)==PROCESS) ) {
      }
      else {FAIL(1,err63,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(PROCESS); consume();
  {
    if ( (setwd15[LA(1)]&0x2) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( process_stmt->get_label(), end_name, "process" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON)
 ) {
      }
      else {FAIL(1,err64,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv = process_stmt;
  _retv->_type_check();
  my_symbol_table->close_scope( _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd15, 0x4);
  return _retv;
}

void
VHDLParser::process_declarative_part(IIR_DeclarationList * dl)
{
  zzRULE;
  {
    while ( (setwd15[LA(1)]&0x8) ) {
      process_declarative_item(   dl  );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd15, 0x10);
}

void
VHDLParser::process_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  zzGUESS_BLOCK
  if ( (setwd15[LA(1)]&0x20) ) {
    subprogram(  decl_list  );
  }
  else {
    if ( (LA(1)==TYPE) ) {
      type_declaration(  decl_list  );
    }
    else {
      if ( (LA(1)==SUBTYPE) ) {
        subtype_declaration(  decl_list  );
      }
      else {
        if ( (LA(1)==CONSTANT)
 ) {
          constant_declaration(  decl_list  );
        }
        else {
          if ( (setwd15[LA(1)]&0x40) ) {
            variable_declaration(  decl_list  );
          }
          else {
            if ( (LA(1)==FILE_) ) {
              file_declaration(  decl_list  );
            }
            else {
              if ( (LA(1)==ALIAS) ) {
                alias_declaration(  decl_list  );
              }
              else {
                if ( (LA(1)==ATTRIBUTE) ) {
                  attribute_declarative_item(  decl_list  );
                }
                else {
                  if ( (LA(1)==USE)
 ) {
                    use_clause(  decl_list  );
                  }
                  else {
                    zzGUESS
                    if ( !zzrv && (LA(1)==GROUP) && (setwd15[LA(2)]&0x80) ) {
                      {
                        zzmatch(GROUP); consume();
                        zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset); consume();
                        zzmatch(COLON); consume();
                      }
                      zzGUESS_DONE
                      group_declaration(  decl_list  );
                    }
                    else {
                      if ( !zzrv ) zzGUESS_DONE;
                      if ( (LA(1)==GROUP) && (setwd16[LA(2)]&0x1) ) {
                        group_template_declaration(  decl_list  );
                      }
                      else {FAIL(2,err65,err66,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd16, 0x2);
}

IIR_ConcurrentAssertionStatement *
VHDLParser::concurrent_assertion_statement(IIR_Label * label)
{
  IIR_ConcurrentAssertionStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentAssertionStatement *  ))
  
  _retv = NULL;
  IIR_AssertionStatement *assert_stmt = NULL;
  if ( !guessing ) {
      assert_stmt   = assertion(  label  );

  } else {
    assertion(  label  );
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv = new IIR_ConcurrentAssertionStatement();
  _retv->set_label( label );
  _retv->set_assertion_condition( assert_stmt->get_assertion_condition() );
  _retv->set_report_expression( assert_stmt->get_report_expression() );
  _retv->set_severity_expression(assert_stmt->get_severity_expression() );
  
    IIR::copy_location( assert_stmt, _retv );
  
    delete assert_stmt;
  // The type checking occured when we parsed it as a sequential statement.
  // $retval->_type_check();
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd16, 0x4);
  return _retv;
}

IIR_ConcurrentProcedureCallStatement *
VHDLParser::concurrent_call_statement(IIR_Label * label)
{
  IIR_ConcurrentProcedureCallStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentProcedureCallStatement *  ))
  IIR_Name *procedure_name = NULL;
  if ( !guessing ) {
  
  _retv = new IIR_ConcurrentProcedureCallStatement();
  _retv->set_label( label );
  }
  if ( !guessing ) {
     procedure_name  = complex_name();

  } else {
    complex_name();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv->set_procedure_name( procedure_name );
  _retv->_type_check();
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd16, 0x8);
  return _retv;
}

IIR_ComponentInstantiationStatement *
VHDLParser::instantiate_statement(IIR_Label * label)
{
  IIR_ComponentInstantiationStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr token_text1=NULL, token_text2=NULL, token_text3=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ComponentInstantiationStatement *  ))
  
  _retv = NULL;
  IIR_Name *component_name = NULL;
  if ( (setwd16[LA(1)]&0x10) ) {
    {
      if ( (LA(1)==COMPONENT) ) {
        zzmatch(COMPONENT); consume();
      }
      else {
        if ( (setwd16[LA(1)]&0x20)
 ) {
        }
        else {FAIL(1,err67,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
    if ( !guessing ) {
       component_name  = complex_name();

    } else {
      complex_name();
    }
    if ( !guessing ) {
    
    _retv = new IIR_ComponentInstantiationStatement();
    _retv->set_label( label );
    my_symbol_table->open_scope( _retv );   
    _retv->set_instantiated_unit( component_name );
    _retv->_set_instantiation_type( IIR_COMPONENT_DECLARATION );
    }
    {
      if ( (LA(1)==GENERIC) ) {
        generic_map_aspect( &_retv->generic_map_aspect );
      }
      else {
        if ( (setwd16[LA(1)]&0x40) ) {
        }
        else {FAIL(1,err68,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
    {
      if ( (LA(1)==PORT) ) {
        port_map_aspect( &_retv->port_map_aspect );
      }
      else {
        if ( (LA(1)==SEMI_COLON) ) {
        }
        else {FAIL(1,err69,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
    zzmatch(SEMI_COLON);
    if ( !guessing ) {
        token_text1 = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    copy_location( token_text1, _retv );
    //  We have to do this on the second pass, since configuration
    //  specifications haven't yet been type checked.
    _retv->_type_check_instantiated_unit();
    my_symbol_table->close_scope( _retv );
    }
 consume();
  }
  else {
    if ( (LA(1)==ENTITY)
 ) {
      zzmatch(ENTITY);
      if ( !guessing ) {
            token_text2 = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = new IIR_ComponentInstantiationStatement();
      copy_location( token_text2, _retv );    
      _retv->set_label( label );
      my_symbol_table->open_scope( _retv );   
      
    _retv->_set_instantiation_type( IIR_ENTITY_DECLARATION );
      }
 consume();
      if ( !guessing ) {
         component_name  = complex_name();

      } else {
        complex_name();
      }
      if ( !guessing ) {
      
      _retv->set_instantiated_unit( component_name );
      }
      {
        if ( (LA(1)==GENERIC) ) {
          generic_map_aspect( &_retv->generic_map_aspect );
        }
        else {
          if ( (setwd16[LA(1)]&0x80) ) {
          }
          else {FAIL(1,err70,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      {
        if ( (LA(1)==PORT) ) {
          port_map_aspect( &_retv->port_map_aspect );
        }
        else {
          if ( (LA(1)==SEMI_COLON) ) {
          }
          else {FAIL(1,err71,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      zzmatch(SEMI_COLON);
      if ( !guessing ) {
      
      //  We have to do this on the second pass, since configuration
      //  specifications haven't yet been type checked.
      _retv->_type_check_instantiated_unit();
      my_symbol_table->close_scope( _retv );
      }
 consume();
    }
    else {
      if ( (LA(1)==CONFIGURATION)
 ) {
        zzmatch(CONFIGURATION);
        if ( !guessing ) {
                token_text3 = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        
        _retv = new IIR_ComponentInstantiationStatement();
        copy_location( token_text3, _retv );
        _retv->set_label( label );
        my_symbol_table->open_scope( _retv );   
        _retv->_set_instantiation_type( IIR_CONFIGURATION_DECLARATION );
        }
 consume();
        if ( !guessing ) {
           component_name  = complex_name();

        } else {
          complex_name();
        }
        if ( !guessing ) {
        
        _retv->set_instantiated_unit( component_name );
        }
        {
          if ( (LA(1)==GENERIC) ) {
            generic_map_aspect( &_retv->generic_map_aspect );
          }
          else {
            if ( (setwd17[LA(1)]&0x1) ) {
            }
            else {FAIL(1,err72,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
        {
          if ( (LA(1)==PORT) ) {
            port_map_aspect( &_retv->port_map_aspect );
          }
          else {
            if ( (LA(1)==SEMI_COLON) ) {
            }
            else {FAIL(1,err73,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
        zzmatch(SEMI_COLON);
        if ( !guessing ) {
        
        // We have to do this on the second pass, since configuration
        // specifications haven't yet been type checked.
        _retv->_type_check_instantiated_unit();
        my_symbol_table->close_scope( _retv );
        }
 consume();
      }
      else {FAIL(1,err74,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd17, 0x2);
  return _retv;
}

IIR_ConcurrentConditionalSignalAssignment *
VHDLParser::conditional_signal_assignment(IIR_Label * label)
{
  IIR_ConcurrentConditionalSignalAssignment *   _retv;
  zzRULE;
  ANTLRTokenPtr le=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentConditionalSignalAssignment *  ))
  
  _retv = NULL;
  IIR *destination = NULL;
  IIR_Boolean guarded;
  IIR_DelayMechanism delay = IIR_INERTIAL_DELAY;
  IIR *reject = NULL;
  if ( !guessing ) {
     destination  = target();

  } else {
    target();
  }
  zzmatch(LESS_EQUAL);
  if ( !guessing ) {
    le = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
    { struct _rv51 _trv; _trv = options();

    guarded = _trv.guard; delay = _trv.delay_mech; reject  = _trv.reject_lim; }
  } else {
    options();
  }
  if ( !guessing ) {
  
  _retv = new IIR_ConcurrentConditionalSignalAssignment();
  _retv->set_label( label );
  copy_location( le,  _retv );
  }
  conditional_waveforms( &_retv->conditional_waveforms );
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv->set_target(destination);
  _retv->set_guarded(guarded);
  _retv->set_delay_mechanism(delay);
  _retv->set_reject_time_expression(reject);
  _retv->_type_check();
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd17, 0x4);
  return _retv;
}

IIR *
VHDLParser::target(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR_Aggregate *new_aggregate = NULL;
  zzGUESS
  if ( !zzrv && (setwd17[LA(1)]&0x8)
 ) {
    {
      if ( !guessing ) {
         _retv  = complex_name();

      } else {
        complex_name();
      }
    }
    zzGUESS_DONE
    {
      if ( !guessing ) {
         _retv  = complex_name();

      } else {
        complex_name();
      }
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (LA(1)==L_PAREN) ) {
      if ( !guessing ) {
         new_aggregate  = aggregate();

      } else {
        aggregate();
      }
      if ( !guessing ) {
      _retv = reduce_aggregate( new_aggregate );
      }
    }
    else {FAIL(1,err75,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd17, 0x10);
  return _retv;
}

IIR_Aggregate *
VHDLParser::aggregate(void)
{
  IIR_Aggregate *   _retv;
  zzRULE;
  ANTLRTokenPtr info=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Aggregate *  ))
  _retv = NULL;
  zzmatch(L_PAREN);
  if ( !guessing ) {
    info = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_Aggregate();
  copy_location( info, _retv );
  }
 consume();
  aggregate_entry(  _retv  );
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      aggregate_entry(  _retv  );
    }
  }
  zzmatch(R_PAREN); consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd17, 0x20);
  return _retv;
}

void
VHDLParser::aggregate_entry(IIR_Aggregate * aggregate_in)
{
  zzRULE;
  
  IIR_CaseStatementAlternative *formal_or_actual = NULL;
  IIR_CaseStatementAlternative *formal_part = NULL;
  IIR *actual_part = NULL;
  if ( !guessing ) {
      formal_or_actual   = choices();

  } else {
    choices();
  }
  {
    if ( (LA(1)==EQUAL_GREATER) ) {
      zzmatch(EQUAL_GREATER); consume();
      if ( !guessing ) {
          actual_part   = expression();

      } else {
        expression();
      }
    }
    else {
      if ( (setwd17[LA(1)]&0x40) ) {
      }
      else {FAIL(1,err76,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  if( actual_part != NULL ){
    formal_part = formal_or_actual;
    // and actual is already set
  }
  else{
    actual_part = formal_or_actual;
    // and formal is NULL by default. 
  }
  process_aggregate_with_choices( formal_part, actual_part, aggregate_in );
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd17, 0x80);
}

void
VHDLParser::conditional_waveforms(IIR_ConditionalWaveformList * list)
{
  zzRULE;
  
  IIR_ConditionalWaveform *wave = NULL;
  IIR *expr = NULL;
  if ( !guessing ) {
  
  wave = new IIR_ConditionalWaveform();
  list->append(wave);
  }
  concurrent_waveform( &wave->waveform );
  {
    if ( (LA(1)==WHEN)
 ) {
      zzmatch(WHEN); consume();
      if ( !guessing ) {
         expr  = condition();

      } else {
        condition();
      }
      if ( !guessing ) {
      wave->set_condition(expr);
      }
      {
        if ( (LA(1)==ELSE) ) {
          zzmatch(ELSE); consume();
          conditional_waveforms( list );
        }
        else {
          if ( (LA(1)==SEMI_COLON) ) {
          }
          else {FAIL(1,err77,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err78,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd18, 0x1);
}

IIR_ConcurrentSelectedSignalAssignment *
VHDLParser::selected_signal_assignment_statement(IIR_Label * label)
{
  IIR_ConcurrentSelectedSignalAssignment *   _retv;
  zzRULE;
  ANTLRTokenPtr with=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentSelectedSignalAssignment *  ))
  
  _retv = NULL;
  IIR *selector = NULL;
  IIR *destination = NULL;
  IIR_Boolean guard;
  IIR_DelayMechanism delay_mech = IIR_INERTIAL_DELAY;
  IIR *reject_lim = NULL;
  zzmatch(WITH);
  if ( !guessing ) {
    with = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     selector  = expression();

  } else {
    expression();
  }
  zzmatch(SELECT);
  if ( !guessing ) {
  
  _retv = new IIR_ConcurrentSelectedSignalAssignment();
  _retv->set_label( label );
  copy_location( with, _retv );
  }
 consume();
  if ( !guessing ) {
     destination  = target();

  } else {
    target();
  }
  zzmatch(LESS_EQUAL); consume();
  if ( !guessing ) {
    { struct _rv51 _trv; _trv = options();

    guard = _trv.guard; delay_mech = _trv.delay_mech; reject_lim   = _trv.reject_lim; }
  } else {
    options();
  }
  selected_waveforms( &_retv->selected_waveforms );
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv->set_target(destination);
  _retv->set_expression( selector );
  _retv->set_guarded( guard );
  _retv->set_delay_mechanism( delay_mech );
  _retv->set_reject_time_expression( reject_lim );
  _retv->_type_check();
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd18, 0x2);
  return _retv;
}

void
VHDLParser::selected_waveforms(IIR_SelectedWaveformList * list)
{
  zzRULE;
  
  IIR_SelectedWaveform *wave = NULL;
  IIR_CaseStatementAlternative *choice = NULL;
  if ( !guessing ) {
  wave = new IIR_SelectedWaveform();
  }
  concurrent_waveform( &wave->waveform );
  zzmatch(WHEN); consume();
  if ( !guessing ) {
     choice  = choices();

  } else {
    choices();
  }
  if ( !guessing ) {
  
  wave->set_choice( choice );
  list->append( wave );
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA);
      if ( !guessing ) {
      wave = new IIR_SelectedWaveform();
      }
 consume();
      concurrent_waveform( &wave->waveform );
      zzmatch(WHEN); consume();
      if ( !guessing ) {
          choice   = choices();

      } else {
        choices();
      }
      if ( !guessing ) {
      
      wave->set_choice( choice );
      list->append( wave );
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd18, 0x4);
}

VHDLParser::_rv51
VHDLParser::options(void)
{
  struct _rv51 _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(struct _rv51))
  
  _retv.guard = false;
  _retv.delay_mech = IIR_INERTIAL_DELAY;
  _retv.reject_lim = NULL;
  {
    if ( (LA(1)==GUARDED)
 ) {
      zzmatch(GUARDED);
      if ( !guessing ) {
      _retv.guard = TRUE;
      }
 consume();
    }
    else {
      if ( (setwd18[LA(1)]&0x8) ) {
      }
      else {FAIL(1,err79,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (setwd18[LA(1)]&0x10) ) {
      if ( !guessing ) {
        { struct _rv52 _trv; _trv = delay_mechanism();

        _retv.delay_mech = _trv.d; _retv.reject_lim  = _trv.e; }
      } else {
        delay_mechanism();
      }
    }
    else {
      if ( (setwd18[LA(1)]&0x20) ) {
      }
      else {FAIL(1,err80,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd18, 0x40);
  return _retv;
}

VHDLParser::_rv52
VHDLParser::delay_mechanism(void)
{
  struct _rv52 _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(struct _rv52))
  
  _retv.d = IIR_INERTIAL_DELAY;
  _retv.e = NULL;
  if ( (LA(1)==TRANSPORT) ) {
    zzmatch(TRANSPORT);
    if ( !guessing ) {
    _retv.d = IIR_TRANSPORT_DELAY;
    }
 consume();
  }
  else {
    if ( (setwd18[LA(1)]&0x80)
 ) {
      {
        if ( (LA(1)==REJECT_) ) {
          zzmatch(REJECT_); consume();
          if ( !guessing ) {
             _retv.e  = time_expression();

          } else {
            time_expression();
          }
        }
        else {
          if ( (LA(1)==INERTIAL) ) {
          }
          else {FAIL(1,err81,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      zzmatch(INERTIAL);
      if ( !guessing ) {
      _retv.d = IIR_INERTIAL_DELAY;
      }
 consume();
    }
    else {FAIL(1,err82,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd19, 0x1);
  return _retv;
}

IIR_ConcurrentStatement *
VHDLParser::generate_statement(IIR_Label * label)
{
  IIR_ConcurrentStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentStatement *  ))
  
  _retv = NULL;
  IIR_SimpleName *end_name = NULL;
  IIR_ArchitectureStatementList stmt_list;
  IIR_DeclarationList decl_list;
  if ( !guessing ) {
      _retv   = generate_scheme(  label  );

  } else {
    generate_scheme(  label  );
  }
  zzmatch(GENERATE); consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (setwd19[LA(1)]&0x2) && (setwd19[LA(2)]&0x4) ) {
      {
        IIR_DeclarationList dummy;
        block_declarative_part( &dummy );
        zzmatch(BEGIN_); consume();
      }
      zzGUESS_DONE
      block_declarative_part(  &decl_list  );
      zzmatch(BEGIN_); consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd19[LA(1)]&0x8) && (setwd19[LA(2)]&0x10) ) {
      }
      else {FAIL(2,err83,err84,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  architecture_statement_part( &stmt_list );
  if ( !guessing ) {
  
  IIR_ConcurrentGenerateForStatement *for_stmt = NULL;
  IIR_ConcurrentGenerateIfStatement *if_stmt = NULL;
  if( _retv->get_kind() == IIR_CONCURRENT_GENERATE_FOR_STATEMENT ){
    for_stmt = (IIR_ConcurrentGenerateForStatement *)_retv;
    IIR_List::_listcopy( for_stmt->concurrent_statement_part, stmt_list );
    IIR_List::_listcopy( for_stmt->block_declarative_part, decl_list );
    _retv = for_stmt;
  }
  else if ( _retv->get_kind() == IIR_CONCURRENT_GENERATE_IF_STATEMENT ){
    if_stmt = (IIR_ConcurrentGenerateIfStatement *)_retv;
    IIR_List::_listcopy( if_stmt->concurrent_statement_part, stmt_list );
    IIR_List::_listcopy( if_stmt->block_declarative_part, decl_list );
    _retv = if_stmt;
  }
  else {
    panic( "rule \"generation_scheme\" returned invalid node." );
  }
  }
  zzmatch(END); consume();
  zzmatch(GENERATE); consume();
  {
    if ( (setwd19[LA(1)]&0x20)
 ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( _retv->get_label(), end_name, "generate");
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err85,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv->_type_check();
  my_symbol_table->close_scope( _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd19, 0x40);
  return _retv;
}

IIR_ConcurrentStatement *
VHDLParser::generate_scheme(IIR_Label * label)
{
  IIR_ConcurrentStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr for_=NULL, if_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentStatement *  ))
  
  _retv = NULL;
  IIR_ConcurrentGenerateForStatement *generate_for_stmt = NULL;
  IIR_ConcurrentGenerateIfStatement *generate_if_stmt = NULL;
  IIR_Identifier *for_parameter = NULL;
  IIR_ScalarTypeDefinition *index_range = NULL;
  IIR *if_condition = NULL;
  if ( (LA(1)==FOR) ) {
    zzmatch(FOR);
    if ( !guessing ) {
        for_ = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    generate_for_stmt = new IIR_ConcurrentGenerateForStatement();
    my_symbol_table->open_scope( generate_for_stmt );
    generate_for_stmt->set_label( label );
    copy_location( for_, generate_for_stmt );
    _retv = generate_for_stmt;
    }
 consume();
    if ( !guessing ) {
        for_parameter   = identifier();

    } else {
      identifier();
    }
    zzmatch(IN); consume();
    if ( !guessing ) {
       index_range  = discrete_range();

    } else {
      discrete_range();
    }
    if ( !guessing ) {
    
    if( index_range != NULL ){
      IIR_ConstantDeclaration *parameter_decl = new IIR_ConstantDeclaration();
      IIR::copy_location( for_parameter, parameter_decl );
      parameter_decl->set_declarator( for_parameter );
      if( index_range->get_kind() == IIR_RANGE_TYPE_DEFINITION ){
        IIR_RangeTypeDefinition *temp =  (IIR_RangeTypeDefinition *)index_range;
        if( temp->get_right() != NULL ){
          index_range = IIR_ScalarTypeDefinition::_determine_discrete_type( temp );
          index_range = (IIR_ScalarTypeDefinition *)index_range->_construct_new_subtype( NULL, temp );
          parameter_decl->set_subtype( index_range );
          copy_location( for_, parameter_decl->get_subtype() );
          delete temp;
        }
      }
      else{
        parameter_decl->set_subtype( index_range );  
      }
      generate_for_stmt->set_generate_parameter_specification( parameter_decl );
      
      parameter_decl->_add_declaration();
    }
    }
  }
  else {
    if ( (LA(1)==IF) ) {
      zzmatch(IF);
      if ( !guessing ) {
            if_ = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      generate_if_stmt = new IIR_ConcurrentGenerateIfStatement();
      my_symbol_table->open_scope( generate_if_stmt );
      generate_if_stmt->set_label( label );
      copy_location( if_, generate_if_stmt );
      _retv = generate_if_stmt;
      }
 consume();
      if ( !guessing ) {
         if_condition  = condition();

      } else {
        condition();
      }
      if ( !guessing ) {
      generate_if_stmt->set_if_condition( if_condition );
      }
    }
    else {FAIL(1,err86,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd19, 0x80);
  return _retv;
}

void
VHDLParser::sequence_of_statements(IIR_SequentialStatementList * stmt_list)
{
  zzRULE;
  IIR_SequentialStatement *stmt = NULL;
  {
    while ( (setwd20[LA(1)]&0x1) ) {
      if ( !guessing ) {
         stmt  = sequential_statement();

      } else {
        sequential_statement();
      }
      if ( !guessing ) {
      stmt_list->append(stmt);
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd20, 0x2);
}

IIR_SequentialStatement *
VHDLParser::sequential_statement(void)
{
  IIR_SequentialStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SequentialStatement *  ))
  
  _retv = NULL;
  IIR_Label *label = NULL;
  {
    if ( (setwd20[LA(1)]&0x4) && 
(LA(2)==COLON) ) {
      if ( !guessing ) {
         label  = stmt_label();

      } else {
        stmt_label();
      }
    }
    else {
      if ( (setwd20[LA(1)]&0x8) && (setwd20[LA(2)]&0x10) ) {
      }
      else {FAIL(2,err87,err88,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
     _retv  = sequential_stmt(  label  );

  } else {
    sequential_stmt(  label  );
  }
  zzmatch(SEMI_COLON); consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd20, 0x20);
  return _retv;
}

IIR_SequentialStatement *
VHDLParser::sequential_stmt(IIR_Label * label)
{
  IIR_SequentialStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SequentialStatement *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR *name = NULL;
  if ( (LA(1)==WAIT) ) {
    if ( !guessing ) {
       _retv  = wait_statement(  label  );

    } else {
      wait_statement(  label  );
    }
  }
  else {
    if ( (LA(1)==ASSERT) ) {
      if ( !guessing ) {
         _retv  = assertion_statement(  label  );

      } else {
        assertion_statement(  label  );
      }
    }
    else {
      if ( (LA(1)==REPORT) ) {
        if ( !guessing ) {
           _retv  = report_statement(  label  );

        } else {
          report_statement(  label  );
        }
      }
      else {
        zzGUESS
        if ( !zzrv && (LA(1)==NULL_)
 ) {
          {
            zzmatch(NULL_); consume();
          }
          zzGUESS_DONE
          if ( !guessing ) {
             _retv  = null_statement(  label  );

          } else {
            null_statement(  label  );
          }
        }
        else {
          if ( !zzrv ) zzGUESS_DONE;
          zzGUESS
          if ( !zzrv && (setwd20[LA(1)]&0x40) && (setwd20[LA(2)]&0x80) ) {
            {
              if ( !guessing ) {
                 name  = target();

              } else {
                target();
              }
              zzmatch(LESS_EQUAL); consume();
            }
            zzGUESS_DONE
            if ( !guessing ) {
               _retv  = signal_assignment_statement(  label  );

            } else {
              signal_assignment_statement(  label  );
            }
          }
          else {
            if ( !zzrv ) zzGUESS_DONE;
            zzGUESS
            if ( !zzrv && (setwd21[LA(1)]&0x1) && (setwd21[LA(2)]&0x2) ) {
              {
                if ( !guessing ) {
                   name  = target();

                } else {
                  target();
                }
                zzmatch(COLON_EQUAL); consume();
              }
              zzGUESS_DONE
              if ( !guessing ) {
                 _retv  = variable_assignment_statement(  label  );

              } else {
                variable_assignment_statement(  label  );
              }
            }
            else {
              if ( !zzrv ) zzGUESS_DONE;
              zzGUESS
              if ( !zzrv && (setwd21[LA(1)]&0x4) && (setwd21[LA(2)]&0x8) ) {
                {
                  if ( !guessing ) {
                     name  = complex_name();

                  } else {
                    complex_name();
                  }
                  zzmatch(SEMI_COLON); consume();
                }
                zzGUESS_DONE
                if ( !guessing ) {
                   _retv  = procedure_call_statement(  label  );

                } else {
                  procedure_call_statement(  label  );
                }
              }
              else {
                if ( !zzrv ) zzGUESS_DONE;
                if ( (LA(1)==IF) ) {
                  if ( !guessing ) {
                     _retv  = if_statement(  label  );

                  } else {
                    if_statement(  label  );
                  }
                }
                else {
                  if ( !zzrv ) zzGUESS_DONE;
                  if ( (LA(1)==CASE)
 ) {
                    if ( !guessing ) {
                       _retv  = case_statement(  label  );

                    } else {
                      case_statement(  label  );
                    }
                  }
                  else {
                    if ( !zzrv ) zzGUESS_DONE;
                    if ( (setwd21[LA(1)]&0x10) ) {
                      if ( !guessing ) {
                         _retv  = loop_statement(  label  );

                      } else {
                        loop_statement(  label  );
                      }
                    }
                    else {
                      if ( !zzrv ) zzGUESS_DONE;
                      if ( (LA(1)==NEXT) ) {
                        if ( !guessing ) {
                           _retv  = next_statement(  label  );

                        } else {
                          next_statement(  label  );
                        }
                      }
                      else {
                        if ( !zzrv ) zzGUESS_DONE;
                        if ( (LA(1)==EXIT) ) {
                          if ( !guessing ) {
                             _retv  = exit_statement(  label  );

                          } else {
                            exit_statement(  label  );
                          }
                        }
                        else {
                          if ( !zzrv ) zzGUESS_DONE;
                          if ( (LA(1)==RETURN) ) {
                            if ( !guessing ) {
                               _retv  = return_statement(  label  );

                            } else {
                              return_statement(  label  );
                            }
                          }
                          else {
                            if ( !zzrv ) zzGUESS_DONE;
                            if ( (LA(1)==BREAK)
 ) {
                              if (!(lang_proc->processing_vhdl_ams())                                ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
                              if ( !guessing ) {
                                 _retv  = break_statement( label );

                              } else {
                                break_statement( label );
                              }
                            }
                            else {FAIL(2,err89,err90,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd21, 0x20);
  return _retv;
}

IIR_Label *
VHDLParser::stmt_label(void)
{
  IIR_Label *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Label *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = vhdl_label();

  } else {
    vhdl_label();
  }
  zzmatch(COLON);
  if ( !guessing ) {
  _retv->_add_declaration( );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd21, 0x40);
  return _retv;
}

IIR_WaitStatement *
VHDLParser::wait_statement(IIR_Label * label)
{
  IIR_WaitStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr wait=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_WaitStatement *  ))
  
  _retv = NULL;
  IIR* clause = NULL;
  zzmatch(WAIT);
  if ( !guessing ) {
    wait = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_WaitStatement();
  copy_location( wait, _retv );
  _retv->set_label( label );
  }
 consume();
  {
    if ( (LA(1)==ON) ) {
      sensitivity_clause( &_retv->sensitivity_list );
    }
    else {
      if ( (setwd21[LA(1)]&0x80) ) {
      }
      else {FAIL(1,err91,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==UNTIL) ) {
      if ( !guessing ) {
         clause  = condition_clause();

      } else {
        condition_clause();
      }
      if ( !guessing ) {
      _retv->set_condition_clause(clause);
      }
    }
    else {
      if ( (setwd22[LA(1)]&0x1) ) {
      }
      else {FAIL(1,err92,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==FOR)
 ) {
      if ( !guessing ) {
         clause  = timeout_clause();

      } else {
        timeout_clause();
      }
      if ( !guessing ) {
      _retv->set_timeout_clause(clause);
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err93,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd22, 0x2);
  return _retv;
}

void
VHDLParser::sensitivity_clause(IIR_DesignatorList * siglist)
{
  zzRULE;
  zzmatch(ON); consume();
  sensitivity_list(  siglist );
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd22, 0x4);
}

void
VHDLParser::sensitivity_list(IIR_DesignatorList * siglist)
{
  zzRULE;
  IIR_Name *name = NULL;
  if ( !guessing ) {
     name  = complex_name();

  } else {
    complex_name();
  }
  if ( !guessing ) {
  
  IIR_DesignatorExplicit *designator = new IIR_DesignatorExplicit();
  IIR::copy_location( name, designator );
  designator->set_name( name );
  siglist->append(designator);
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         name  = complex_name();

      } else {
        complex_name();
      }
      if ( !guessing ) {
      
      IIR_DesignatorExplicit *designator = new IIR_DesignatorExplicit();
      IIR::copy_location( name, designator );
      designator->set_name( name );
      siglist->append(designator);
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd22, 0x8);
}

IIR *
VHDLParser::condition_clause(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  _retv = NULL;
  zzmatch(UNTIL); consume();
  if ( !guessing ) {
     _retv  = condition();

  } else {
    condition();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd22, 0x10);
  return _retv;
}

IIR *
VHDLParser::condition(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = boolean_expression();

  } else {
    boolean_expression();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd22, 0x20);
  return _retv;
}

IIR *
VHDLParser::timeout_clause(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  _retv = NULL;
  zzmatch(FOR); consume();
  if ( !guessing ) {
     _retv  = time_expression();

  } else {
    time_expression();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd22, 0x40);
  return _retv;
}

IIR_AssertionStatement *
VHDLParser::assertion_statement(IIR_Label * label)
{
  IIR_AssertionStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_AssertionStatement *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = assertion(  label  );

  } else {
    assertion(  label  );
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd22, 0x80);
  return _retv;
}

IIR_AssertionStatement *
VHDLParser::assertion(IIR_Label * label)
{
  IIR_AssertionStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr assert=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_AssertionStatement *  ))
  
  _retv = NULL;
  IIR *clause = NULL;
  zzmatch(ASSERT);
  if ( !guessing ) {
    assert = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_AssertionStatement();
  copy_location( assert, _retv );
  _retv->set_label( label );
  }
 consume();
  if ( !guessing ) {
     clause  = condition();

  } else {
    condition();
  }
  if ( !guessing ) {
  _retv->set_assertion_condition(clause);
  }
  {
    if ( (LA(1)==REPORT) ) {
      zzmatch(REPORT); consume();
      if ( !guessing ) {
         clause  = expression();

      } else {
        expression();
      }
      if ( !guessing ) {
      _retv->set_report_expression(clause);
      }
    }
    else {
      if ( (setwd23[LA(1)]&0x1) ) {
      }
      else {FAIL(1,err94,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==SEVERITY)
 ) {
      zzmatch(SEVERITY); consume();
      if ( !guessing ) {
         clause  = expression();

      } else {
        expression();
      }
      if ( !guessing ) {
      _retv->set_severity_expression(clause);
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err95,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd23, 0x2);
  return _retv;
}

IIR_ReportStatement *
VHDLParser::report_statement(IIR_Label * label)
{
  IIR_ReportStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr report=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ReportStatement *  ))
  
  _retv = NULL;
  IIR *expr = NULL;
  zzmatch(REPORT);
  if ( !guessing ) {
    report = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ReportStatement();
  copy_location( report, _retv );
  _retv->set_label( label );
  }
 consume();
  if ( !guessing ) {
     expr  = expression();

  } else {
    expression();
  }
  if ( !guessing ) {
  _retv->set_report_expression(expr);
  }
  {
    if ( (LA(1)==SEVERITY) ) {
      zzmatch(SEVERITY); consume();
      if ( !guessing ) {
         expr  = expression();

      } else {
        expression();
      }
      if ( !guessing ) {
      _retv->set_severity_expression(expr);
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err96,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd23, 0x4);
  return _retv;
}

IIR_NullStatement *
VHDLParser::null_statement(IIR_Label * label)
{
  IIR_NullStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr null_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_NullStatement *  ))
  _retv = NULL;
  zzmatch(NULL_);
  if ( !guessing ) {
    null_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_NullStatement();
  copy_location( null_, _retv );
  _retv->set_label( label );
  _retv->_type_check();
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd23, 0x8);
  return _retv;
}

IIR_SignalAssignmentStatement *
VHDLParser::signal_assignment_statement(IIR_Label * label)
{
  IIR_SignalAssignmentStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr less_equal=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_SignalAssignmentStatement *  ))
  
  _retv = NULL;
  IIR *name = NULL;
  if ( !guessing ) {
     name  = target();

  } else {
    target();
  }
  zzmatch(LESS_EQUAL);
  if ( !guessing ) {
    less_equal = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     _retv  = sequential_signal_assign_stmt( name, label );

  } else {
    sequential_signal_assign_stmt( name, label );
  }
  if ( !guessing ) {
  
  copy_location( less_equal, _retv );
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd23, 0x10);
  return _retv;
}

IIR_VariableAssignmentStatement *
VHDLParser::variable_assignment_statement(IIR_Label * label)
{
  IIR_VariableAssignmentStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr colon_equal=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_VariableAssignmentStatement *  ))
  
  _retv = NULL;
  IIR *name = NULL;
  if ( !guessing ) {
     name  = target();

  } else {
    target();
  }
  zzmatch(COLON_EQUAL);
  if ( !guessing ) {
    colon_equal = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     _retv  = variable_assign_stmt( name, label );

  } else {
    variable_assign_stmt( name, label );
  }
  if ( !guessing ) {
  
  copy_location( colon_equal, _retv );
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd23, 0x20);
  return _retv;
}

IIR_ProcedureCallStatement *
VHDLParser::procedure_call_statement(IIR_Label * label)
{
  IIR_ProcedureCallStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ProcedureCallStatement *  ))
  
  _retv = NULL;
  IIR *name = NULL;
  if ( !guessing ) {
  
  _retv = new IIR_ProcedureCallStatement();
  _retv->set_label( label );
  }
  if ( !guessing ) {
     name  = complex_name();

  } else {
    complex_name();
  }
  if ( !guessing ) {
  
  IIR::copy_location( name,  _retv );
  _retv->set_procedure_name(name);
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd23, 0x40);
  return _retv;
}

IIR_SignalAssignmentStatement *
VHDLParser::sequential_signal_assign_stmt(IIR * dest,IIR_Label * label)
{
  IIR_SignalAssignmentStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SignalAssignmentStatement *  ))
  
  _retv = NULL;
  IIR_DelayMechanism d = IIR_INERTIAL_DELAY;
  IIR *e = NULL;
  if ( !guessing ) {
  
  _retv = new IIR_SignalAssignmentStatement();
  _retv->set_label( label );
  _retv->set_target( dest);
  }
  {
    if ( (setwd23[LA(1)]&0x80) ) {
      if ( !guessing ) {
        { struct _rv52 _trv; _trv = delay_mechanism();

        d = _trv.d; e  = _trv.e; }
      } else {
        delay_mechanism();
      }
    }
    else {
      if ( (setwd24[LA(1)]&0x1)
 ) {
      }
      else {FAIL(1,err97,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  _retv->set_delay_mechanism(d);
  _retv->set_reject_time_expression(e);
  }
  sequential_waveform( &_retv->waveform );
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd24, 0x2);
  return _retv;
}

IIR_VariableAssignmentStatement *
VHDLParser::variable_assign_stmt(IIR * dest,IIR_Label * label)
{
  IIR_VariableAssignmentStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_VariableAssignmentStatement *  ))
  
  _retv = NULL;
  IIR *expr = NULL;
  if ( !guessing ) {
  
  _retv = new IIR_VariableAssignmentStatement();
  _retv->set_label( label );
  _retv->set_target(dest);
  }
  if ( !guessing ) {
     expr  = expression();

  } else {
    expression();
  }
  if ( !guessing ) {
  _retv->set_expression(expr);
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd24, 0x4);
  return _retv;
}

void
VHDLParser::sequential_waveform(IIR_WaveformList * wavelist)
{
  zzRULE;
  IIR_WaveformElement *wave = NULL;
  if ( !guessing ) {
     wave  = waveform_element();

  } else {
    waveform_element();
  }
  if ( !guessing ) {
  wavelist->append(wave);
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         wave  = waveform_element();

      } else {
        waveform_element();
      }
      if ( !guessing ) {
      wavelist->append(wave);
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd24, 0x8);
}

void
VHDLParser::concurrent_waveform(IIR_WaveformList * wavelist)
{
  zzRULE;
  ANTLRTokenPtr unaffected=NULL;
  IIR_WaveformElement *wave = NULL;
  if ( (setwd24[LA(1)]&0x10) ) {
    sequential_waveform(  wavelist );
  }
  else {
    if ( (LA(1)==UNAFFECTED) ) {
      zzmatch(UNAFFECTED);
      if ( !guessing ) {
            unaffected = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      wave = new IIR_WaveformElement();
      copy_location( unaffected, wave );
      wave->set_value(NULL);
      wave->set_time(NULL);
      }
 consume();
    }
    else {FAIL(1,err98,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd24, 0x20);
}

IIR_WaveformElement *
VHDLParser::waveform_element(void)
{
  IIR_WaveformElement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_WaveformElement *  ))
  
  _retv = NULL;
  IIR *value = NULL;
  IIR *time = NULL;
  if ( !guessing ) {
     value  = expression();

  } else {
    expression();
  }
  {
    if ( (LA(1)==AFTER) ) {
      zzmatch(AFTER); consume();
      if ( !guessing ) {
         time  = expression();

      } else {
        expression();
      }
    }
    else {
      if ( (setwd24[LA(1)]&0x40)
 ) {
      }
      else {FAIL(1,err99,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  _retv = new IIR_WaveformElement();
  IIR::copy_location( value, _retv );
  _retv->set_value(value);
  _retv->set_time(time);
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd24, 0x80);
  return _retv;
}

IIR_IfStatement *
VHDLParser::if_statement(IIR_Label * label)
{
  IIR_IfStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr if_=NULL, else_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_IfStatement *  ))
  
  _retv = NULL;
  IIR *cond = NULL;
  IIR_SimpleName *end_name = NULL;
  IIR_Elsif *elsif = NULL;
  zzmatch(IF);
  if ( !guessing ) {
    if_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_IfStatement();
  _retv->set_label( label );
  copy_location( if_, _retv );
  }
 consume();
  if ( !guessing ) {
     cond  = condition();

  } else {
    condition();
  }
  if ( !guessing ) {
  _retv->set_condition(cond);
  }
  zzmatch(THEN); consume();
  sequence_of_statements( &_retv->then_sequence );
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==ELSIF) ) {
      {
        zzmatch(ELSIF); consume();
      }
      zzGUESS_DONE
      if ( !guessing ) {
         elsif  = elsif_stmt();

      } else {
        elsif_stmt();
      }
      if ( !guessing ) {
      _retv->set_elsif(elsif);
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd25[LA(1)]&0x1) ) {
      }
      else {FAIL(1,err100,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==ELSE) ) {
      zzmatch(ELSE);
      if ( !guessing ) {
            else_ = (ANTLRTokenPtr)LT(1);
      }
       consume();
      sequence_of_statements( &_retv->else_sequence );
    }
    else {
      if ( (LA(1)==END) ) {
      }
      else {FAIL(1,err101,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(END); consume();
  zzmatch(IF); consume();
  {
    if ( (setwd25[LA(1)]&0x2)
 ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( _retv->get_label(), end_name, "if statement" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err102,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd25, 0x4);
  return _retv;
}

IIR_Elsif *
VHDLParser::elsif_stmt(void)
{
  IIR_Elsif *   _retv;
  zzRULE;
  ANTLRTokenPtr elsif_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Elsif *  ))
  
  _retv = NULL;
  IIR *cond = NULL;
  IIR_Elsif *next_elsif = NULL;
  zzmatch(ELSIF);
  if ( !guessing ) {
    elsif_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_Elsif();
  copy_location( elsif_, _retv );
  }
 consume();
  if ( !guessing ) {
     cond  = condition();

  } else {
    condition();
  }
  zzmatch(THEN); consume();
  sequence_of_statements( &_retv->then_sequence_of_statements );
  if ( !guessing ) {
  _retv->set_condition(cond);
  }
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==ELSIF) ) {
      {
        zzmatch(ELSIF); consume();
      }
      zzGUESS_DONE
      if ( !guessing ) {
         next_elsif  = elsif_stmt();

      } else {
        elsif_stmt();
      }
      if ( !guessing ) {
      _retv->set_else_clause(next_elsif);
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd25[LA(1)]&0x8) ) {
      }
      else {FAIL(1,err103,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd25, 0x10);
  return _retv;
}

IIR_CaseStatement *
VHDLParser::case_statement(IIR_Label * label)
{
  IIR_CaseStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr case_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_CaseStatement *  ))
  
  _retv = NULL;
  IIR_SimpleName *end_name = NULL;
  IIR *expr = NULL;
  zzmatch(CASE);
  if ( !guessing ) {
    case_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_CaseStatement();
  _retv->set_label( label );
  copy_location( case_, _retv );
  }
 consume();
  if ( !guessing ) {
     expr  = expression();

  } else {
    expression();
  }
  zzmatch(IS);
  if ( !guessing ) {
  _retv->set_expression(expr);
  }
 consume();
  {
    int zzcnt=1;
    do {
      case_statement_alternative( &_retv->case_statement_alternatives );
    } while ( (LA(1)==WHEN) );
  }
  zzmatch(END); consume();
  zzmatch(CASE); consume();
  {
    if ( (setwd25[LA(1)]&0x20)
 ) {
      if ( !guessing ) {
          end_name   = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( _retv->get_label(), end_name, "case statement" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err104,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd25, 0x40);
  return _retv;
}

void
VHDLParser::case_statement_alternative(IIR_CaseStatementAlternativeList * alt_list)
{
  zzRULE;
  ANTLRTokenPtr when=NULL;
  IIR_CaseStatementAlternative *alt = NULL;
  zzmatch(WHEN);
  if ( !guessing ) {
    when = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     alt  = choices();

  } else {
    choices();
  }
  zzmatch(EQUAL_GREATER); consume();
  sequence_of_statements( &alt->sequence_of_statements );
  if ( !guessing ) {
  
  copy_location( when, alt );
  alt_list->append(alt);
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd25, 0x80);
}

IIR_CaseStatementAlternative *
VHDLParser::choices(void)
{
  IIR_CaseStatementAlternative *   _retv;
  zzRULE;
  ANTLRTokenPtr oth=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_CaseStatementAlternative *  ))
  
  _retv = NULL;
  IIR_Choice *ch = NULL;
  IIR_CaseStatementAlternativeByChoices *byChoices = NULL;
  IIR_CaseStatementAlternativeByExpression *byExpression = NULL;
  IIR_CaseStatementAlternativeByOthers *byOthers = NULL;
  if ( (setwd26[LA(1)]&0x1) ) {
    if ( !guessing ) {
    byExpression = new IIR_CaseStatementAlternativeByExpression();
    }
    if ( !guessing ) {
       ch  = choice();

    } else {
      choice();
    }
    if ( !guessing ) {
    
    byExpression->set_choice(ch);
    IIR::copy_location( ch, byExpression );
    _retv = byExpression;
    }
    {
      while ( (setwd26[LA(1)]&0x2) ) {
        zzsetmatch(CHOICE_set, CHOICE_errset);
        if ( !guessing ) {
        
        if (byChoices == NULL) {
          byChoices = new IIR_CaseStatementAlternativeByChoices();
          _retv = byChoices;
          byChoices->choices.append(ch);
          IIR::copy_location( ch, byChoices );
          delete byExpression;
        };
        }
 consume();
        if ( !guessing ) {
           ch  = choice();

        } else {
          choice();
        }
        if ( !guessing ) {
        
        byChoices->choices.append(ch);
        IIR::copy_location( ch, byChoices );
        }
      }
    }
  }
  else {
    if ( (LA(1)==OTHERS) ) {
      zzmatch(OTHERS);
      if ( !guessing ) {
            oth = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = new IIR_CaseStatementAlternativeByOthers();
      copy_location( oth, _retv );
      }
 consume();
    }
    else {FAIL(1,err107,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd26, 0x4);
  return _retv;
}

IIR_Choice *
VHDLParser::choice(void)
{
  IIR_Choice *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Choice *  ))
  
  _retv = NULL;
  IIR *expr = NULL;
  IIR_RangeTypeDefinition *range_type_def = NULL;
  IIR_ScalarTypeDefinition *scalar_type = NULL;
  IIR *dir = NULL;
  IIR *right = NULL;
  if ( !guessing ) {
     expr  = expression();

  } else {
    expression();
  }
  if ( !guessing ) {
  
  _retv = new IIR_Choice();
  IIR::copy_location( expr, _retv );
  _retv->set_value(expr);
  }
  {
    if ( (setwd26[LA(1)]&0x8)
 ) {
      if ( !guessing ) {
         dir  = direction();

      } else {
        direction();
      }
      if ( !guessing ) {
         right  = simple_expression();

      } else {
        simple_expression();
      }
      if ( !guessing ) {
      
      range_type_def = new IIR_RangeTypeDefinition();
      IIR::copy_location( dir, range_type_def );
      range_type_def->set_left(expr);
      range_type_def->set_direction( dir );
      range_type_def->set_right(right);
      scalar_type = IIR_ScalarTypeDefinition::_determine_discrete_type(range_type_def);
      scalar_type = 
      (IIR_ScalarTypeDefinition *)scalar_type->_construct_new_subtype( NULL, range_type_def );
      _retv->set_value( scalar_type );
      }
    }
    else {
      if ( (setwd26[LA(1)]&0x10) ) {
      }
      else {FAIL(1,err108,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd26, 0x20);
  return _retv;
}

IIR_SequentialStatement *
VHDLParser::loop_statement(IIR_Label * label)
{
  IIR_SequentialStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SequentialStatement *  ))
  zzGUESS_BLOCK
  _retv = NULL;
  zzGUESS
  if ( !zzrv && (LA(1)==FOR) ) {
    {
      zzmatch(FOR); consume();
    }
    zzGUESS_DONE
    if ( !guessing ) {
       _retv  = for_loop_statement(  label  );

    } else {
      for_loop_statement(  label  );
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd26[LA(1)]&0x40) ) {
      if ( !guessing ) {
         _retv  = while_loop_statement(  label  );

      } else {
        while_loop_statement(  label  );
      }
    }
    else {FAIL(1,err109,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd26, 0x80);
  return _retv;
}

IIR_ForLoopStatement *
VHDLParser::for_loop_statement(IIR_Label * label)
{
  IIR_ForLoopStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr for_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ForLoopStatement *  ))
  
  _retv = NULL;
  IIR_ConstantDeclaration *iterator = NULL;
  IIR_Identifier *id = NULL;
  IIR_ScalarTypeDefinition *temp_range = NULL;
  IIR_SimpleName *end_name = NULL;
  zzmatch(FOR);
  if ( !guessing ) {
    for_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     id  = identifier();

  } else {
    identifier();
  }
  zzmatch(IN); consume();
  if ( !guessing ) {
     temp_range  = discrete_range();

  } else {
    discrete_range();
  }
  zzmatch(LOOP);
  if ( !guessing ) {
  
  _retv = new IIR_ForLoopStatement();
  copy_location( for_, _retv );
  
    loop_statements.push( _retv );
  _retv->set_label( label );
  my_symbol_table->open_scope( _retv );
  
    iterator = new IIR_ConstantDeclaration();
  IIR::copy_location( id, iterator );
  
    IIR_TypeDefinition *constant_subtype = temp_range;
  if( constant_subtype != NULL ){
    ASSERT( constant_subtype->_is_scalar_type() == TRUE );
    iterator->set_subtype( (IIR_ScalarTypeDefinition *)constant_subtype );
  }
  
    iterator->set_declarator(id);
  iterator->_add_declaration();
  
    _retv->set_iteration_scheme(iterator);
  _retv->_type_check();
  }
 consume();
  sequence_of_statements( &_retv->sequence_of_statements );
  zzmatch(END); consume();
  zzmatch(LOOP); consume();
  {
    if ( (setwd27[LA(1)]&0x1) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( _retv->get_label(), end_name, "for loop statement" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON)
 ) {
      }
      else {FAIL(1,err110,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  my_symbol_table->close_scope( _retv );
  loop_statements.pop();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd27, 0x2);
  return _retv;
}

IIR_WhileLoopStatement *
VHDLParser::while_loop_statement(IIR_Label * label)
{
  IIR_WhileLoopStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr loop_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_WhileLoopStatement *  ))
  
  _retv = NULL;
  IIR *cond = NULL;
  IIR_SimpleName *end_name = NULL;
  {
    if ( (LA(1)==WHILE) ) {
      zzmatch(WHILE); consume();
      if ( !guessing ) {
         cond  = condition();

      } else {
        condition();
      }
    }
    else {
      if ( (LA(1)==LOOP) ) {
      }
      else {FAIL(1,err111,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(LOOP);
  if ( !guessing ) {
    loop_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_WhileLoopStatement();
  loop_statements.push( _retv );
  _retv->set_label( label );
  copy_location( loop_, _retv );
  _retv->set_while_condition(cond);
  }
 consume();
  sequence_of_statements( &_retv->sequence_of_statements );
  zzmatch(END); consume();
  zzmatch(LOOP); consume();
  {
    if ( (setwd27[LA(1)]&0x4) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( _retv->get_label(), end_name, "while loop statement" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err112,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  _retv->_type_check();
  loop_statements.pop();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd27, 0x8);
  return _retv;
}

IIR_NextStatement *
VHDLParser::next_statement(IIR_Label * label)
{
  IIR_NextStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr next=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_NextStatement *  ))
  
  _retv = NULL;
  IIR_Label *goto_label = NULL;
  IIR *expr = NULL;
  zzmatch(NEXT);
  if ( !guessing ) {
    next = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_NextStatement();
  _retv->set_label( label );
  copy_location( next, _retv );
  }
 consume();
  {
    if ( (setwd27[LA(1)]&0x10)
 ) {
      if ( !guessing ) {
         goto_label  = vhdl_label();

      } else {
        vhdl_label();
      }
      if ( !guessing ) {
      
      set<IIR_Declaration> *label_decls = NULL;
      IIR_TextLiteral *label_text = goto_label->get_declarator();
      label_decls = new set<IIR_Declaration>(*my_symbol_table->find_set( label_text )); 
      if( label_decls == NULL ){
        report_undefined_symbol( goto_label );
      }
      else{
        IIR_Declaration *current = label_decls->get_element();
        while( current != NULL ){
          if( current->get_kind() != IIR_LABEL ){
            label_decls->remove( current );
          }
          current = label_decls->get_next_element();
        }
        switch( label_decls->num_elements() ){
          case 0:{
            ostringstream err;
            err << "|" << *goto_label << "| was not defined as a label in this scope.";
            report_error( _retv, err.str() );
            // We don't need this temporary label any more...
            delete goto_label;
            goto_label = NULL;
            break;
          }
          case 1:{
          // We don't need this temporary label any more...
          delete goto_label;
          goto_label = (IIR_Label *)label_decls->get_element();
          break;
        }
        default:{
          report_ambiguous_error( goto_label, label_decls );
          break;
        }
      }
      
	if( goto_label != NULL ){
        IIR_Statement *next_statement  = goto_label->get_statement();
        if( next_statement->_is_iir_sequential_statement() == TRUE ){
          _retv->set_enclosing_loop( (IIR_SequentialStatement *)next_statement );
        }
        else{
          ostringstream err;
          err << "Next statements may only be used with sequential statements.  ";
          err << "|" << *goto_label << "| denotes a concurrent statement.";
          report_error ( _retv, err.str() );
        }
      }
    }
      }
    }
    else {
      if ( (setwd27[LA(1)]&0x20) ) {
      }
      else {FAIL(1,err113,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==WHEN) ) {
      zzmatch(WHEN); consume();
      if ( !guessing ) {
         expr  = condition();

      } else {
        condition();
      }
      if ( !guessing ) {
      _retv->set_condition(expr);
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err114,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  if( _retv->get_enclosing_loop() == NULL ){
    IIR_SequentialStatement *loop_statement = loop_statements.get_top_of_stack();
    _retv->set_enclosing_loop( loop_statement );
  }
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd27, 0x40);
  return _retv;
}

IIR_ExitStatement *
VHDLParser::exit_statement(IIR_Label * label)
{
  IIR_ExitStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr exit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ExitStatement *  ))
  
  _retv = NULL;
  IIR_Label *exit_label = NULL;
  IIR *expr = NULL;
  zzmatch(EXIT);
  if ( !guessing ) {
    exit = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ExitStatement();
  _retv->set_label( label );
  copy_location( exit, _retv );
  }
 consume();
  {
    if ( (setwd27[LA(1)]&0x80) ) {
      if ( !guessing ) {
         exit_label  = vhdl_label();

      } else {
        vhdl_label();
      }
      if ( !guessing ) {
      
      set<IIR_Declaration> *label_decls = NULL;
      IIR_TextLiteral *label_text = exit_label->get_declarator();
      label_decls = new set<IIR_Declaration>(*my_symbol_table->find_set( label_text )); 
      if( label_decls == NULL ){
        report_undefined_symbol( exit_label );
      }
      else{
        IIR_Declaration *current = label_decls->get_element();
        while( current != NULL ){
          if( current->get_kind() != IIR_LABEL ){
            label_decls->remove( current );
          }
          current = label_decls->get_next_element();
        }
        switch( label_decls->num_elements() ){
          case 0:{
            ostringstream err;
            err << "|" << *exit_label << "| was not defined as a label in this scope.";
            report_error( _retv, err.str() );
            // We don't need this temporary label any more...
            delete exit_label;
            exit_label = NULL;
            break;
          }
          case 1:{
          // We don't need this temporary label any more...
          delete exit_label;
          exit_label = (IIR_Label *)label_decls->get_element();
          break;
        }
        default:{
          report_ambiguous_error( exit_label, label_decls );
          break;
        }
      }
      
	if( exit_label != NULL ){
        IIR_Statement *exit_statement  = exit_label->get_statement();
        if( exit_statement->_is_iir_sequential_statement() == TRUE ){
          _retv->set_enclosing_loop( (IIR_SequentialStatement *)exit_statement );
        }
        else{
          ostringstream err;
          err << "Next statements may only be used with sequential statements.  ";
          err << "|" << *exit_label << "| denotes a concurrent statement.";
          report_error ( _retv, err.str() );
        }
      }
    }
      }
    }
    else {
      if ( (setwd28[LA(1)]&0x1)
 ) {
      }
      else {FAIL(1,err115,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==WHEN) ) {
      zzmatch(WHEN); consume();
      if ( !guessing ) {
         expr  = condition();

      } else {
        condition();
      }
      if ( !guessing ) {
      _retv->set_condition(expr);
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err116,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd28, 0x2);
  return _retv;
}

IIR_ReturnStatement *
VHDLParser::return_statement(IIR_Label * label)
{
  IIR_ReturnStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr return_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ReturnStatement *  ))
  
  _retv = NULL;
  IIR *expr = NULL;
  zzmatch(RETURN);
  if ( !guessing ) {
    return_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ReturnStatement();
  _retv->set_label( label );
  copy_location( return_, _retv );
  }
 consume();
  {
    if ( (setwd28[LA(1)]&0x4) ) {
      if ( !guessing ) {
         expr  = expression();

      } else {
        expression();
      }
      if ( !guessing ) {
      _retv->set_return_expression(expr);
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err117,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd28, 0x8);
  return _retv;
}

IIR_PackageDeclaration *
VHDLParser::package_declaration(void)
{
  IIR_PackageDeclaration *   _retv;
  zzRULE;
  ANTLRTokenPtr package=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_PackageDeclaration *  ))
  
  _retv = NULL;
  IIR_Identifier *package_name = NULL;
  IIR_Name *end_name = NULL;
  zzmatch(PACKAGE_);
  if ( !guessing ) {
    package = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_PackageDeclaration();
  copy_location( package, _retv );
  }
 consume();
  if ( !guessing ) {
     package_name  = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  
  _retv->set_declarator( package_name );
  _retv->_add_declaration_and_open_scope( );
  }
  zzmatch(IS); consume();
  package_declarative_part( &_retv->package_declarative_part );
  zzmatch(END); consume();
  {
    if ( (LA(1)==PACKAGE_)
 ) {
      zzmatch(PACKAGE_); consume();
    }
    else {
      if ( (setwd28[LA(1)]&0x10) ) {
      }
      else {FAIL(1,err118,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (setwd28[LA(1)]&0x20) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( package_name, end_name, "package" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err119,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv->_type_check();
  my_symbol_table->close_scope( _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd28, 0x40);
  return _retv;
}

void
VHDLParser::package_declarative_part(IIR_DeclarationList * list)
{
  zzRULE;
  {
    while ( (setwd28[LA(1)]&0x80) ) {
      package_declarative_item( list );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd29, 0x1);
}

void
VHDLParser::package_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  zzGUESS_BLOCK
  if ( (setwd29[LA(1)]&0x2)
 ) {
    subprogram_declaration(  decl_list  );
  }
  else {
    if ( (LA(1)==TYPE) ) {
      type_declaration(  decl_list  );
    }
    else {
      if ( (LA(1)==SUBTYPE) ) {
        subtype_declaration(  decl_list  );
      }
      else {
        if ( (LA(1)==CONSTANT) ) {
          constant_declaration(  decl_list  );
        }
        else {
          if ( (LA(1)==SIGNAL) ) {
            signal_declaration(  decl_list  );
          }
          else {
            if ( (LA(1)==SHARED)
 ) {
              shared_variable_declaration(  decl_list  );
            }
            else {
              if ( (LA(1)==FILE_) ) {
                file_declaration(  decl_list  );
              }
              else {
                if ( (LA(1)==ALIAS) ) {
                  alias_declaration(  decl_list  );
                }
                else {
                  if ( (LA(1)==COMPONENT) ) {
                    component_declaration(  decl_list  );
                  }
                  else {
                    if ( (LA(1)==ATTRIBUTE) ) {
                      attribute_declarative_item(  decl_list  );
                    }
                    else {
                      if ( (LA(1)==DISCONNECT)
 ) {
                        disconnection_specification(  decl_list  );
                      }
                      else {
                        if ( (LA(1)==USE) ) {
                          use_clause(  decl_list  );
                        }
                        else {
                          zzGUESS
                          if ( !zzrv && (setwd29[LA(1)]&0x4) ) {
                            {
                              if ( (LA(1)==NATURE) ) {
                                zzmatch(NATURE); consume();
                              }
                              else {
                                if ( (LA(1)==SUBNATURE) ) {
                                  zzmatch(SUBNATURE); consume();
                                }
                                else {
                                  if ( (LA(1)==TERMINAL)
 ) {
                                    zzmatch(TERMINAL); consume();
                                  }
                                  else {FAIL(1,err120,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                }
                              }
                            }
                            zzGUESS_DONE
                            if (!(lang_proc->processing_vhdl_ams())                              ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
                            {
                              if ( (LA(1)==NATURE) ) {
                                nature_declaration(  decl_list  );
                              }
                              else {
                                if ( (LA(1)==SUBNATURE) ) {
                                  subnature_declaration(  decl_list  );
                                }
                                else {
                                  if ( (LA(1)==TERMINAL) ) {
                                    terminal_declaration(  decl_list  );
                                  }
                                  else {FAIL(1,err121,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                }
                              }
                            }
                          }
                          else {
                            if ( !zzrv ) zzGUESS_DONE;
                            zzGUESS
                            if ( !zzrv && (LA(1)==GROUP) && (setwd29[LA(2)]&0x8) ) {
                              {
                                zzmatch(GROUP); consume();
                                zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset); consume();
                                zzmatch(COLON); consume();
                              }
                              zzGUESS_DONE
                              group_declaration(  decl_list  );
                            }
                            else {
                              if ( !zzrv ) zzGUESS_DONE;
                              if ( (LA(1)==GROUP) && 
(setwd29[LA(2)]&0x10) ) {
                                group_template_declaration(  decl_list  );
                              }
                              else {FAIL(2,err122,err123,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd29, 0x20);
}

IIR_PackageBodyDeclaration *
VHDLParser::package_body(IIR_LibraryDeclaration * library)
{
  IIR_PackageBodyDeclaration *   _retv;
  zzRULE;
  ANTLRTokenPtr package=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_PackageBodyDeclaration *  ))
  
  _retv = NULL;
  IIR_Name *end_name = NULL;
  IIR_Identifier *package_name = NULL;
  zzmatch(PACKAGE_);
  if ( !guessing ) {
    package = (ANTLRTokenPtr)LT(1);
  }
   consume();
  zzmatch(BODY);
  if ( !guessing ) {
  
  _retv = new IIR_PackageBodyDeclaration();
  copy_location( package, _retv );
  }
 consume();
  if ( !guessing ) {
      package_name   = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  
  _retv->set_declarator( package_name );
  _retv->_add_declaration_and_open_scope( );
  
    IIR_PackageDeclaration *my_decl = NULL;
  my_decl = library_manager::instance()->lookup_package( TRUE, package_name, library );
  
    if( my_decl != NULL ){
    if( debug_symbol_table == true ){
      cerr << "Making package declaration |" << *package_name << "| visible." << endl;
    }
    my_decl->_make_interface_visible( my_symbol_table );
    my_decl->set_package_body( _retv );
  }
  else{
    if( debug_symbol_table == true ){
      cerr <<"|" << *package_name << "| wasn't found." << endl;
    }
  }
  }
  zzmatch(IS); consume();
  package_body_declarative_part(  &_retv->package_declarative_part  );
  zzmatch(END); consume();
  {
    if ( (LA(1)==PACKAGE_) ) {
      zzmatch(PACKAGE_); consume();
      zzmatch(BODY); consume();
    }
    else {
      if ( (setwd29[LA(1)]&0x40) ) {
      }
      else {FAIL(1,err124,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (setwd29[LA(1)]&0x80) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( package_name, end_name, "package body");
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err125,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  my_symbol_table->close_scope( _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd30, 0x1);
  return _retv;
}

void
VHDLParser::package_body_declarative_part(IIR_DeclarationList * decl_list)
{
  zzRULE;
  {
    while ( (setwd30[LA(1)]&0x2)
 ) {
      package_body_declarative_item( decl_list );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd30, 0x4);
}

void
VHDLParser::package_body_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  zzGUESS_BLOCK
  if ( (setwd30[LA(1)]&0x8) ) {
    subprogram(  decl_list  );
  }
  else {
    if ( (LA(1)==TYPE) ) {
      type_declaration(  decl_list  );
    }
    else {
      if ( (LA(1)==SUBTYPE) ) {
        subtype_declaration(  decl_list  );
      }
      else {
        if ( (LA(1)==CONSTANT) ) {
          constant_declaration(  decl_list  );
        }
        else {
          if ( (LA(1)==SHARED)
 ) {
            shared_variable_declaration(  decl_list  );
          }
          else {
            if ( (LA(1)==FILE_) ) {
              file_declaration(  decl_list  );
            }
            else {
              if ( (LA(1)==ALIAS) ) {
                alias_declaration(  decl_list  );
              }
              else {
                if ( (LA(1)==USE) ) {
                  use_clause(  decl_list  );
                }
                else {
                  zzGUESS
                  if ( !zzrv && (LA(1)==GROUP) && (setwd30[LA(2)]&0x10) ) {
                    {
                      zzmatch(GROUP); consume();
                      zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset); consume();
                      zzmatch(COLON); consume();
                    }
                    zzGUESS_DONE
                    group_declaration(  decl_list  );
                  }
                  else {
                    if ( !zzrv ) zzGUESS_DONE;
                    if ( (LA(1)==GROUP) && 
(setwd30[LA(2)]&0x20) ) {
                      group_template_declaration(  decl_list  );
                    }
                    else {FAIL(2,err126,err127,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd30, 0x40);
}

void
VHDLParser::subprogram(IIR_DeclarationList * list)
{
  zzRULE;
  
  IIR_SubprogramDeclaration *new_subp_decl = NULL;
  IIR_Boolean added_declaration = FALSE;
  if ( !guessing ) {
      new_subp_decl   = subprogram_header();

  } else {
    subprogram_header();
  }
  {
    if ( (LA(1)==IS) ) {
      subprogram_body(  new_subp_decl  );
      if ( !guessing ) {
      
      added_declaration = TRUE;
      IIR_TypeDefinition *return_type = NULL;
      // This will be NULL if the subprogram is a procedure.
      return_type = new_subp_decl->get_subtype();
      
      IIR_Boolean found_return = 
      new_subp_decl->_type_check_return_statements( return_type );
      
      if( new_subp_decl->get_kind() == IIR_FUNCTION_DECLARATION && found_return == FALSE ){
        ostringstream err;
        err << "No return statement found in subprogram "
        << *new_subp_decl->get_declarator();;
        report_error( new_subp_decl, err.str(), WARNING );
      }
      new_subp_decl->_type_check();
      my_symbol_table->close_scope( new_subp_decl );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err128,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  list->append( new_subp_decl );
  if( added_declaration == FALSE ){
    my_symbol_table->add_subprogram_declaration( new_subp_decl, true );
    new_subp_decl->_type_check();
    my_symbol_table->close_scope( new_subp_decl );
  }
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd30, 0x80);
}

void
VHDLParser::subprogram_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  IIR_SubprogramDeclaration *decl = NULL;
  if ( !guessing ) {
     decl  = subprogram_header();

  } else {
    subprogram_header();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  my_symbol_table->add_subprogram_declaration( decl, true );
  decl->_type_check();
  my_symbol_table->close_scope( decl );
  
    list->append( decl );
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd31, 0x1);
}

IIR_SubprogramDeclaration *
VHDLParser::subprogram_header(void)
{
  IIR_SubprogramDeclaration *   _retv;
  zzRULE;
  ANTLRTokenPtr procedure=NULL, function=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_SubprogramDeclaration *  ))
  
  _retv = NULL;
  IIR_TextLiteral *subp_name = NULL;
  IIR_Pure purity = IIR_PURE_FUNCTION;
  IIR_TypeDefinition *subp_return_type = NULL;
  IIR_FunctionDeclaration *fun_decl = NULL;
  IIR_ProcedureDeclaration *proc_decl = NULL;
  if ( (LA(1)==PROCEDURE) ) {
    zzmatch(PROCEDURE);
    if ( !guessing ) {
        procedure = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    proc_decl = new IIR_ProcedureDeclaration();
    copy_location( procedure, proc_decl );
    }
 consume();
    if ( !guessing ) {
        subp_name   = designator();

    } else {
      designator();
    }
    if ( !guessing ) {
    proc_decl->set_declarator( subp_name );
    }
    {
      if ( (LA(1)==L_PAREN) ) {
        zzmatch(L_PAREN); consume();
        formal_parameter_list( &proc_decl->interface_declarations );
        zzmatch(R_PAREN); consume();
      }
      else {
        if ( (setwd31[LA(1)]&0x2)
 ) {
        }
        else {FAIL(1,err129,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
    if ( !guessing ) {
    _retv = proc_decl;
    }
  }
  else {
    if ( (setwd31[LA(1)]&0x4) ) {
      {
        if ( (setwd31[LA(1)]&0x8) ) {
          if ( !guessing ) {
             purity  = side_effects();

          } else {
            side_effects();
          }
        }
        else {
          if ( (LA(1)==FUNCTION) ) {
          }
          else {FAIL(1,err130,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      zzmatch(FUNCTION);
      if ( !guessing ) {
            function = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
          subp_name   = designator();

      } else {
        designator();
      }
      if ( !guessing ) {
      
      fun_decl = new IIR_FunctionDeclaration();
      fun_decl->set_declarator( subp_name );
      fun_decl->set_pure( purity );
      copy_location( function, fun_decl );
      }
      {
        if ( (LA(1)==L_PAREN) ) {
          zzmatch(L_PAREN); consume();
          formal_parameter_list( &fun_decl->interface_declarations );
          zzmatch(R_PAREN); consume();
        }
        else {
          if ( (LA(1)==RETURN)
 ) {
          }
          else {FAIL(1,err131,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      zzmatch(RETURN); consume();
      if ( !guessing ) {
          subp_return_type   = type_mark();

      } else {
        type_mark();
      }
      if ( !guessing ) {
      
      fun_decl->set_return_type( subp_return_type );
      _retv = fun_decl;
      }
    }
    else {FAIL(1,err132,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd31, 0x10);
  return _retv;
}

IIR_Pure
VHDLParser::side_effects(void)
{
  IIR_Pure   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Pure  ))
  if ( (LA(1)==PURE) ) {
    zzmatch(PURE);
    if ( !guessing ) {
    _retv = IIR_PURE_FUNCTION;
    }
 consume();
  }
  else {
    if ( (LA(1)==IMPURE) ) {
      zzmatch(IMPURE);
      if ( !guessing ) {
      _retv = IIR_IMPURE_FUNCTION;
      }
 consume();
    }
    else {FAIL(1,err133,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd31, 0x20);
  return _retv;
}

IIR_TextLiteral *
VHDLParser::designator(void)
{
  IIR_TextLiteral *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TextLiteral *  ))
  _retv = NULL;
  if ( (setwd31[LA(1)]&0x40) ) {
    if ( !guessing ) {
       _retv  = identifier();

    } else {
      identifier();
    }
  }
  else {
    if ( (LA(1)==STRING_LITERAL) ) {
      if ( !guessing ) {
         _retv  = operator_symbol();

      } else {
        operator_symbol();
      }
    }
    else {FAIL(1,err134,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd31, 0x80);
  return _retv;
}

IIR_StringLiteral *
VHDLParser::operator_symbol(void)
{
  IIR_StringLiteral *   _retv;
  zzRULE;
  ANTLRTokenPtr string_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_StringLiteral *  ))
  _retv = NULL;
  zzmatch(STRING_LITERAL);
  if ( !guessing ) {
    string_lit = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = (IIR_StringLiteral*)mytoken(string_lit)->getIIRPtr();
  _retv->_to_lower();
  copy_location( string_lit, _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd32, 0x1);
  return _retv;
}

void
VHDLParser::formal_parameter_list(IIR_InterfaceList * list)
{
  zzRULE;
  interface_list(  IIRScram_InterfaceDeclaration::PARAMETER_INTERFACE_LIST,  list );
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd32, 0x2);
}

void
VHDLParser::subprogram_body(IIR_SubprogramDeclaration * subp_decl)
{
  zzRULE;
  ANTLRTokenPtr is=NULL;
  
  IIR_TextLiteral *end_name = NULL;
  char *function_or_procedure = NULL;
  zzmatch(IS);
  if ( !guessing ) {
    is = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  subp_decl->_set_contains_body( TRUE );
  my_symbol_table->add_subprogram_declaration( subp_decl, true );
  
    if( subp_decl->get_kind() == IIR_PROCEDURE_DECLARATION ){
    function_or_procedure = "procedure";
  }
  else{
    ASSERT( subp_decl->get_kind() == IIR_FUNCTION_DECLARATION );
    function_or_procedure = "function"; 
  }
  }
 consume();
  subprogram_declarative_part(  & subp_decl->subprogram_declarations  );
  zzmatch(BEGIN_); consume();
  sequence_of_statements(  & subp_decl->subprogram_body  );
  zzmatch(END); consume();
  {
    if ( (LA(1)==FUNCTION)
 ) {
      zzmatch(FUNCTION); consume();
    }
    else {
      if ( (LA(1)==PROCEDURE) ) {
        zzmatch(PROCEDURE); consume();
      }
      else {
        if ( (setwd32[LA(1)]&0x4) ) {
        }
        else {FAIL(1,err135,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
  }
  {
    if ( (setwd32[LA(1)]&0x8) ) {
      if ( !guessing ) {
         end_name  = designator();

      } else {
        designator();
      }
      if ( !guessing ) {
      
      ASSERT( subp_decl->get_declarator() != NULL );
      ASSERT( function_or_procedure != NULL );
      check_name( subp_decl->get_declarator(), end_name, function_or_procedure );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err136,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd32, 0x10);
}

void
VHDLParser::subprogram_declarative_part(IIR_DeclarationList * dl)
{
  zzRULE;
  {
    while ( (setwd32[LA(1)]&0x20)
 ) {
      subprogram_declarative_item(   dl  );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd32, 0x40);
}

void
VHDLParser::subprogram_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  if ( (setwd32[LA(1)]&0x80) ) {
    subprogram(  decl_list  );
  }
  else {
    if ( (LA(1)==TYPE) ) {
      type_declaration(  decl_list  );
    }
    else {
      if ( (LA(1)==SUBTYPE) ) {
        subtype_declaration(  decl_list  );
      }
      else {
        if ( (LA(1)==CONSTANT) ) {
          constant_declaration(  decl_list  );
        }
        else {
          if ( (setwd33[LA(1)]&0x1)
 ) {
            variable_declaration(  decl_list  );
          }
          else {
            if ( (LA(1)==FILE_) ) {
              file_declaration(  decl_list  );
            }
            else {
              if ( (LA(1)==ALIAS) ) {
                alias_declaration(  decl_list  );
              }
              else {
                if ( (LA(1)==ATTRIBUTE) ) {
                  attribute_declarative_item(  decl_list  );
                }
                else {
                  if ( (LA(1)==USE) ) {
                    use_clause(  decl_list  );
                  }
                  else {FAIL(1,err137,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                }
              }
            }
          }
        }
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd33, 0x2);
}

IIR_Signature *
VHDLParser::signature(void)
{
  IIR_Signature *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Signature *  ))
  
  _retv = NULL;
  IIR_TypeDefinition *type_def = NULL;
  IIR_TypeDefinition *return_type = NULL;
  zzmatch(L_BRACKET);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_Signature();
  copy_location( start, _retv );
  }
 consume();
  {
    if ( (setwd33[LA(1)]&0x4)
 ) {
      if ( !guessing ) {
          type_def   = type_mark();

      } else {
        type_mark();
      }
      if ( !guessing ) {
      
      IIR_DesignatorExplicit *desig = new IIR_DesignatorExplicit();
      IIR::copy_location( type_def, desig );
      desig->set_name( type_def );
      _retv->argument_type_list.append( desig );
      }
      {
        while ( (LA(1)==COMMA) ) {
          zzmatch(COMMA); consume();
          if ( !guessing ) {
              type_def   = type_mark();

          } else {
            type_mark();
          }
          if ( !guessing ) {
          
          IIR_DesignatorExplicit *desig = new IIR_DesignatorExplicit();
          IIR::copy_location( type_def, desig );
          desig->set_name( type_def );
          _retv->argument_type_list.append( desig );
          }
        }
      }
    }
    else {
      if ( (setwd33[LA(1)]&0x8) ) {
      }
      else {FAIL(1,err138,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==RETURN) ) {
      zzmatch(RETURN); consume();
      if ( !guessing ) {
         return_type  = type_mark();

      } else {
        type_mark();
      }
      if ( !guessing ) {
      _retv->set_return_type( return_type );
      }
    }
    else {
      if ( (LA(1)==R_BRACKET) ) {
      }
      else {FAIL(1,err139,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(R_BRACKET); consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd33, 0x10);
  return _retv;
}

void
VHDLParser::attribute_declarative_item(IIR_DeclarationList * list)
{
  zzRULE;
  zzmatch(ATTRIBUTE); consume();
  {
    if ( (setwd33[LA(1)]&0x20) && 
(LA(2)==COLON) ) {
      attribute_declaration_tail(  list );
    }
    else {
      if ( (setwd33[LA(1)]&0x40) && (LA(2)==OF) ) {
        attribute_specification_tail(  list );
      }
      else {FAIL(2,err140,err141,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd33, 0x80);
}

void
VHDLParser::attribute_declaration_tail(IIR_DeclarationList * list)
{
  zzRULE;
  
  IIR_AttributeDeclaration *new_attribute_decl = NULL;
  IIR_Identifier *attribute_name = NULL;
  IIR_TypeDefinition *attribute_subtype = NULL;
  if ( !guessing ) {
  new_attribute_decl = new IIR_AttributeDeclaration();
  }
  if ( !guessing ) {
     attribute_name  = identifier();

  } else {
    identifier();
  }
  zzmatch(COLON); consume();
  if ( !guessing ) {
     attribute_subtype  = type_mark();

  } else {
    type_mark();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  IIR::copy_location( attribute_name, new_attribute_decl );
  new_attribute_decl->set_declarator( attribute_name );
  new_attribute_decl->set_subtype( attribute_subtype );
  list->append( new_attribute_decl );
  new_attribute_decl->_add_declaration( );
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd34, 0x1);
}

void
VHDLParser::attribute_specification_tail(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr of=NULL;
  
  IIR_AttributeSpecification *new_attr = NULL;
  IIR_Identifier *attr_name = NULL;
  IIR *attr_expression = NULL;
  if ( !guessing ) {
     attr_name  = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  new_attr = new IIR_AttributeSpecification();
  }
  zzmatch(OF);
  if ( !guessing ) {
    of = (ANTLRTokenPtr)LT(1);
  }
   consume();
  entity_specification(  new_attr  );
  zzmatch(IS); consume();
  if ( !guessing ) {
     attr_expression  = expression();

  } else {
    expression();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  copy_location( of, new_attr );
  new_attr->set_declarator( attr_name );
  new_attr->set_value( attr_expression );
  list->append(new_attr);
  // Type checking happens after the whole declarative region has been sucked in.
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd34, 0x2);
}

void
VHDLParser::attribute_specification(IIR_DeclarationList * list)
{
  zzRULE;
  zzmatch(ATTRIBUTE); consume();
  attribute_specification_tail(  list );
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd34, 0x4);
}

void
VHDLParser::entity_specification(IIR_AttributeSpecification * new_attr)
{
  zzRULE;
  
  IIR_Identifier *entity_class_identifier = NULL;
  IIR_Boolean (IIR_Declaration::*constraining_method )();
  IIR_Kind not_used;
  entity_name_list( &new_attr->entity_name_list );
  zzmatch(COLON); consume();
  if ( !guessing ) {
    { struct _rv113 _trv; _trv = entity_class();

    entity_class_identifier = _trv.identifier_part; not_used = _trv.kind_part; constraining_method  = _trv.constraining_function; }
  } else {
    entity_class();
  }
  if ( !guessing ) {
  
  new_attr->set_entity_class( entity_class_identifier );
  new_attr->_set_entity_constraint( constraining_method );
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd34, 0x8);
}

void
VHDLParser::entity_name_list(IIR_DesignatorList * list)
{
  zzRULE;
  ANTLRTokenPtr others=NULL, all=NULL;
  
  IIR_Designator *designator = NULL;
  IIR_Signature *sig = NULL;
  if ( (setwd34[LA(1)]&0x10) ) {
    if ( !guessing ) {
       designator  = entity_designator();

    } else {
      entity_designator();
    }
    if ( !guessing ) {
    list->append( designator );
    }
    {
      if ( (LA(1)==L_BRACKET) ) {
        if ( !guessing ) {
           sig  = signature();

        } else {
          signature();
        }
        if ( !guessing ) {
        
        if( designator->get_kind() != IIR_DESIGNATOR_EXPLICIT ){
          ostringstream err;
          err << "Non-explicit designators may not have signatures.";
          report_error( sig, err.str() );
        }
        else{
          ((IIR_DesignatorExplicit *)designator)->set_signature( sig );
        }
        }
      }
      else {
        if ( (setwd34[LA(1)]&0x20) ) {
        }
        else {FAIL(1,err142,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
    {
      while ( (LA(1)==COMMA)
 ) {
        zzmatch(COMMA); consume();
        if ( !guessing ) {
           designator  = entity_designator();

        } else {
          entity_designator();
        }
        {
          if ( (LA(1)==L_BRACKET) ) {
            if ( !guessing ) {
               sig  = signature();

            } else {
              signature();
            }
            if ( !guessing ) {
            
            if( designator->get_kind() != IIR_DESIGNATOR_EXPLICIT ){
              ostringstream err;
              err << "Non-explicit designators may not have signatures.";
              report_error( sig, err.str() );
            }
            else{
              ((IIR_DesignatorExplicit *)designator)->set_signature( sig );
            }
            }
          }
          else {
            if ( (setwd34[LA(1)]&0x40) ) {
            }
            else {FAIL(1,err143,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
        if ( !guessing ) {
        list->append( designator );
        }
      }
    }
  }
  else {
    if ( (LA(1)==OTHERS) ) {
      zzmatch(OTHERS);
      if ( !guessing ) {
            others = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      designator = new IIR_DesignatorByOthers();
      list->append( designator );
      copy_location( others, designator );
      }
 consume();
    }
    else {
      if ( (LA(1)==ALL) ) {
        zzmatch(ALL);
        if ( !guessing ) {
                all = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        
        designator = new IIR_DesignatorByAll();
        list->append( designator );
        copy_location( all, designator );
        }
 consume();
      }
      else {FAIL(1,err144,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd34, 0x80);
}

IIR_DesignatorExplicit *
VHDLParser::entity_designator(void)
{
  IIR_DesignatorExplicit *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_DesignatorExplicit *  ))
  
  _retv = NULL;
  IIR *name = NULL;
  if ( (setwd35[LA(1)]&0x1)
 ) {
    if ( !guessing ) {
    _retv = new IIR_DesignatorExplicit();
    }
    if ( !guessing ) {
        name   = simple_name();

    } else {
      simple_name();
    }
    if ( !guessing ) {
    
    IIR::copy_location( name, _retv );
    _retv->set_name( name );
    }
  }
  else {
    if ( (LA(1)==STRING_LITERAL) ) {
      if ( !guessing ) {
      _retv = new IIR_DesignatorExplicit();
      }
      if ( !guessing ) {
          name   = operator_symbol();

      } else {
        operator_symbol();
      }
      if ( !guessing ) {
      
      IIR::copy_location( name, _retv );
      _retv->set_name( name );
      }
    }
    else {FAIL(1,err145,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd35, 0x2);
  return _retv;
}

VHDLParser::_rv113
VHDLParser::entity_class(void)
{
  struct _rv113 _retv;
  zzRULE;
  ANTLRTokenPtr ent=NULL, arc=NULL, conf=NULL, pro=NULL, fun=NULL, pac=NULL, typ=NULL, sub=NULL, con=NULL, sig=NULL, var=NULL, com=NULL, lab=NULL, lit=NULL, uni=NULL, gro=NULL, fil=NULL, nature=NULL, subnature=NULL, quantity=NULL, terminal=NULL;
  PCCTS_PURIFY(_retv,sizeof(struct _rv113))
  _retv.identifier_part = NULL;
  if ( (LA(1)==ENTITY) ) {
    zzmatch(ENTITY);
    if ( !guessing ) {
        ent = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    _retv.identifier_part = IIR_Identifier::get( "entity", 6); 
    _retv.kind_part = IIR_ENTITY_DECLARATION;
    _retv.constraining_function = &IIR_Declaration::_is_iir_entity_declaration;
    }
 consume();
  }
  else {
    if ( (LA(1)==ARCHITECTURE) ) {
      zzmatch(ARCHITECTURE);
      if ( !guessing ) {
            arc = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv.identifier_part = IIR_Identifier::get( "architecture", 12); 
      _retv.kind_part = IIR_ARCHITECTURE_DECLARATION;
      _retv.constraining_function = &IIR_Declaration::_is_iir_architecture_declaration;
      }
 consume();
    }
    else {
      if ( (LA(1)==CONFIGURATION) ) {
        zzmatch(CONFIGURATION);
        if ( !guessing ) {
                conf = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        
        _retv.identifier_part = IIR_Identifier::get( "configuration", 13); 
        _retv.kind_part = IIR_CONFIGURATION_DECLARATION;
        _retv.constraining_function = &IIR_Declaration::_is_iir_configuration_declaration;
        }
 consume();
      }
      else {
        if ( (LA(1)==PROCEDURE)
 ) {
          zzmatch(PROCEDURE);
          if ( !guessing ) {
                    pro = (ANTLRTokenPtr)LT(1);
          }
          
          if ( !guessing ) {
          
          _retv.identifier_part = IIR_Identifier::get( "procedure", 9); 
          _retv.kind_part = IIR_PROCEDURE_DECLARATION;
          _retv.constraining_function = &IIR_Declaration::_is_iir_procedure_declaration;
          }
 consume();
        }
        else {
          if ( (LA(1)==FUNCTION) ) {
            zzmatch(FUNCTION);
            if ( !guessing ) {
                        fun = (ANTLRTokenPtr)LT(1);
            }
            
            if ( !guessing ) {
            
            _retv.identifier_part = IIR_Identifier::get( "function", 8); 
            _retv.kind_part = IIR_FUNCTION_DECLARATION;
            _retv.constraining_function = &IIR_Declaration::_is_iir_function_declaration;
            }
 consume();
          }
          else {
            if ( (LA(1)==PACKAGE_) ) {
              zzmatch(PACKAGE_);
              if ( !guessing ) {
                            pac = (ANTLRTokenPtr)LT(1);
              }
              
              if ( !guessing ) {
              
              _retv.identifier_part = IIR_Identifier::get( "package", 7); 
              _retv.kind_part = IIR_PACKAGE_DECLARATION;
              _retv.constraining_function = &IIR_Declaration::_is_iir_package_declaration;
              }
 consume();
            }
            else {
              if ( (LA(1)==TYPE) ) {
                zzmatch(TYPE);
                if ( !guessing ) {
                                typ = (ANTLRTokenPtr)LT(1);
                }
                
                if ( !guessing ) {
                
                _retv.identifier_part = IIR_Identifier::get( "type", 4); 
                _retv.kind_part = IIR_TYPE_DECLARATION;
                _retv.constraining_function = &IIR_Declaration::_is_iir_type_declaration;
                }
 consume();
              }
              else {
                if ( (LA(1)==SUBTYPE) ) {
                  zzmatch(SUBTYPE);
                  if ( !guessing ) {
                                    sub = (ANTLRTokenPtr)LT(1);
                  }
                  
                  if ( !guessing ) {
                  
                  _retv.identifier_part = IIR_Identifier::get( "subtype", 7); 
                  _retv.kind_part = IIR_SUBTYPE_DECLARATION;
                  _retv.constraining_function = &IIR_Declaration::_is_iir_subtype_declaration;
                  }
 consume();
                }
                else {
                  if ( (LA(1)==CONSTANT)
 ) {
                    zzmatch(CONSTANT);
                    if ( !guessing ) {
                                        con = (ANTLRTokenPtr)LT(1);
                    }
                    
                    if ( !guessing ) {
                    
                    _retv.identifier_part = IIR_Identifier::get( "constant", 8); 
                    _retv.kind_part = IIR_CONSTANT_DECLARATION;
                    // There are several "constant" nodes
                    _retv.constraining_function = &IIR_Declaration::_is_constant;
                    }
 consume();
                  }
                  else {
                    if ( (LA(1)==SIGNAL) ) {
                      zzmatch(SIGNAL);
                      if ( !guessing ) {
                                            sig = (ANTLRTokenPtr)LT(1);
                      }
                      
                      if ( !guessing ) {
                      
                      _retv.identifier_part = IIR_Identifier::get( "signal", 6); 
                      _retv.kind_part = IIR_SIGNAL_DECLARATION;
                      // There are several "signal" nodes
                      _retv.constraining_function = &IIR_Declaration::_is_signal;
                      }
 consume();
                    }
                    else {
                      if ( (LA(1)==VARIABLE) ) {
                        zzmatch(VARIABLE);
                        if ( !guessing ) {
                                                var = (ANTLRTokenPtr)LT(1);
                        }
                        
                        if ( !guessing ) {
                        
                        _retv.identifier_part = IIR_Identifier::get( "variable", 8); 
                        _retv.kind_part = IIR_VARIABLE_DECLARATION;
                        // There are several "variable" nodes
                        _retv.constraining_function = &IIR_Declaration::_is_variable;
                        }
 consume();
                      }
                      else {
                        if ( (LA(1)==COMPONENT) ) {
                          zzmatch(COMPONENT);
                          if ( !guessing ) {
                                                    com = (ANTLRTokenPtr)LT(1);
                          }
                          
                          if ( !guessing ) {
                          
                          _retv.identifier_part = IIR_Identifier::get( "component", 9); 
                          _retv.kind_part = IIR_COMPONENT_DECLARATION;
                          _retv.constraining_function = &IIR_Declaration::_is_iir_component_declaration;
                          }
 consume();
                        }
                        else {
                          if ( (LA(1)==LABEL) ) {
                            zzmatch(LABEL);
                            if ( !guessing ) {
                                                        lab = (ANTLRTokenPtr)LT(1);
                            }
                            
                            if ( !guessing ) {
                            
                            _retv.identifier_part = IIR_Identifier::get( "label", 5); 
                            _retv.kind_part = IIR_LABEL;
                            _retv.constraining_function = &IIR_Declaration::_is_iir_label;
                            }
 consume();
                          }
                          else {
                            if ( (LA(1)==LITERAL)
 ) {
                              zzmatch(LITERAL);
                              if ( !guessing ) {
                                                            lit = (ANTLRTokenPtr)LT(1);
                              }
                              
                              if ( !guessing ) {
                              
                              _retv.identifier_part = IIR_Identifier::get( "literal", 7); 
                              _retv.kind_part = IIR_LITERAL;
                              // There are several "literal" nodes
                              _retv.constraining_function = &IIR_Declaration::_is_literal;
                              }
 consume();
                            }
                            else {
                              if ( (LA(1)==UNITS) ) {
                                zzmatch(UNITS);
                                if ( !guessing ) {
                                                                uni = (ANTLRTokenPtr)LT(1);
                                }
                                
                                if ( !guessing ) {
                                
                                _retv.identifier_part = IIR_Identifier::get( "units", 5); 
                                _retv.kind_part = IIR_PHYSICAL_UNIT;
                                _retv.constraining_function = &IIR_Declaration::_is_iir_physical_unit;
                                }
 consume();
                              }
                              else {
                                if ( (LA(1)==GROUP) ) {
                                  zzmatch(GROUP);
                                  if ( !guessing ) {
                                                                    gro = (ANTLRTokenPtr)LT(1);
                                  }
                                  
                                  if ( !guessing ) {
                                  
                                  _retv.identifier_part = IIR_Identifier::get( "group", 5); 
                                  _retv.kind_part = IIR_GROUP_DECLARATION;
                                  _retv.constraining_function = &IIR_Declaration::_is_iir_group_declaration;
                                  }
 consume();
                                }
                                else {
                                  if ( (LA(1)==FILE_) ) {
                                    zzmatch(FILE_);
                                    if ( !guessing ) {
                                                                        fil = (ANTLRTokenPtr)LT(1);
                                    }
                                    
                                    if ( !guessing ) {
                                    
                                    _retv.identifier_part = IIR_Identifier::get( "file", 4); 
                                    _retv.kind_part = IIR_FILE_DECLARATION;
                                    // There are several "file" nodes
                                    _retv.constraining_function = &IIR_Declaration::_is_file;
                                    }
 consume();
                                  }
                                  else {
                                    if ( (setwd35[LA(1)]&0x4) ) {
                                      if (!(lang_proc->processing_vhdl_ams())                                        ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
                                      {
                                        if ( (LA(1)==NATURE)
 ) {
                                          zzmatch(NATURE);
                                          if ( !guessing ) {
                                                                                    nature = (ANTLRTokenPtr)LT(1);
                                          }
                                           consume();
                                        }
                                        else {
                                          if ( (LA(1)==SUBNATURE) ) {
                                            zzmatch(SUBNATURE);
                                            if ( !guessing ) {
                                                                                        subnature = (ANTLRTokenPtr)LT(1);
                                            }
                                             consume();
                                          }
                                          else {
                                            if ( (LA(1)==QUANTITY) ) {
                                              zzmatch(QUANTITY);
                                              if ( !guessing ) {
                                                                                            quantity = (ANTLRTokenPtr)LT(1);
                                              }
                                               consume();
                                            }
                                            else {
                                              if ( (LA(1)==TERMINAL) ) {
                                                zzmatch(TERMINAL);
                                                if ( !guessing ) {
                                                                                                terminal = (ANTLRTokenPtr)LT(1);
                                                }
                                                 consume();
                                              }
                                              else {FAIL(1,err146,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                            }
                                          }
                                        }
                                      }
                                    }
                                    else {FAIL(1,err147,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd35, 0x8);
  return _retv;
}

void
VHDLParser::configuration_specification(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr for_=NULL;
  
  IIR *component_name = NULL;
  IIR_ConfigurationSpecification *configuration_spec = NULL;
  scram_binding_info_t *binding_info = NULL;
  zzmatch(FOR);
  if ( !guessing ) {
    for_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  configuration_spec = new IIR_ConfigurationSpecification();
  copy_location( for_, configuration_spec );
  }
 consume();
  if ( !guessing ) {
      component_name   = component_specification(  &configuration_spec->instantiation_list  );

  } else {
    component_specification(  &configuration_spec->instantiation_list  );
  }
  if ( !guessing ) {
  configuration_spec->set_component_name( component_name );
  }
  if ( !guessing ) {
      binding_info   = binding_indication();

  } else {
    binding_indication();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  ASSERT( binding_info != NULL );
  configuration_spec->set_entity_aspect( binding_info->entity_aspect );
  if( binding_info->generic_map_aspect != NULL ){
    if( binding_info->generic_map_aspect->num_elements() > 0 ){
      configuration_spec->generic_map_aspect = 
      *binding_info->generic_map_aspect;
    }
  }
  if( binding_info->port_map_aspect != NULL ){
    if( binding_info->port_map_aspect->num_elements() > 0 ){
      configuration_spec->port_map_aspect = 
      *binding_info->port_map_aspect;
    }
  }
  // configuration specficiations can't be type checked until after all
  // of the statements in their containing declarative region have been
  // parsed, because we can provide specifications for labels that haven't
  // been (implicitly) declared yet.
  // configuration_spec->_type_check();
  list->append( configuration_spec );
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd35, 0x10);
}

IIR_Name *
VHDLParser::component_specification(IIR_DesignatorList * list)
{
  IIR_Name *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  _retv = NULL;
  instantiation_list(  list  );
  zzmatch(COLON); consume();
  if ( !guessing ) {
      _retv   = complex_name();

  } else {
    complex_name();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd35, 0x20);
  return _retv;
}

void
VHDLParser::instantiation_list(IIR_DesignatorList * list)
{
  zzRULE;
  ANTLRTokenPtr others=NULL, all=NULL;
  
  IIR_DesignatorExplicit *designator_explicit = NULL;
  IIR_Designator *designator = NULL;
  IIR_Name *component_name = NULL;
  if ( (setwd35[LA(1)]&0x40) ) {
    if ( !guessing ) {
        component_name   = simple_name();

    } else {
      simple_name();
    }
    if ( !guessing ) {
    
    designator_explicit = new IIR_DesignatorExplicit();
    IIR::copy_location( component_name, designator_explicit );
    designator_explicit->set_name( component_name );
    list->append( designator_explicit );
    }
    {
      while ( (LA(1)==COMMA)
 ) {
        zzmatch(COMMA); consume();
        if ( !guessing ) {
            component_name   = simple_name();

        } else {
          simple_name();
        }
        if ( !guessing ) {
        
        designator_explicit = new IIR_DesignatorExplicit();
        IIR::copy_location( component_name, designator_explicit );
        designator_explicit->set_name( component_name );
        list->append( designator_explicit );
        }
      }
    }
  }
  else {
    if ( (LA(1)==OTHERS) ) {
      zzmatch(OTHERS);
      if ( !guessing ) {
            others = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      designator = new IIR_DesignatorByOthers();
      copy_location( others,  designator );
      list->append( designator );
      }
 consume();
    }
    else {
      if ( (LA(1)==ALL) ) {
        zzmatch(ALL);
        if ( !guessing ) {
                all = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        
        designator = new IIR_DesignatorByAll();
        copy_location( all,  designator );
        list->append( designator );
        }
 consume();
      }
      else {FAIL(1,err148,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd35, 0x80);
}

scram_binding_info_t *
VHDLParser::binding_indication(void)
{
  scram_binding_info_t *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(scram_binding_info_t *  ))
  _retv = NULL;
  {
    _retv = new scram_binding_info_t();
    if ( (LA(1)==USE) ) {
      zzmatch(USE); consume();
      if ( !guessing ) {
         _retv->entity_aspect  = entity_aspect();

      } else {
        entity_aspect();
      }
    }
    else {
      if ( (setwd36[LA(1)]&0x1) ) {
      }
      else {FAIL(1,err149,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    _retv->generic_map_aspect = new IIR_AssociationList();
    if ( (LA(1)==GENERIC)
 ) {
      generic_map_aspect( _retv->generic_map_aspect );
    }
    else {
      if ( (setwd36[LA(1)]&0x2) ) {
      }
      else {FAIL(1,err150,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    _retv->port_map_aspect = new IIR_AssociationList();
    if ( (LA(1)==PORT) ) {
      port_map_aspect( _retv->port_map_aspect );
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err151,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd36, 0x4);
  return _retv;
}

IIR_LibraryUnit *
VHDLParser::entity_aspect(void)
{
  IIR_LibraryUnit *   _retv;
  zzRULE;
  ANTLRTokenPtr entity=NULL, configuration=NULL, open=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LibraryUnit *  ))
  
  _retv = NULL;
  IIR_Name *entity_name = NULL;
  IIR_SimpleName *arch_name = NULL;
  IIR_Name *configuration_name = NULL;
  if ( (LA(1)==ENTITY) ) {
    zzmatch(ENTITY);
    if ( !guessing ) {
        entity = (ANTLRTokenPtr)LT(1);
    }
     consume();
    if ( !guessing ) {
       entity_name  = selected_or_simple_name();

    } else {
      selected_or_simple_name();
    }
    if ( !guessing ) {
    
    if( entity_name != NULL ){
      _retv = library_manager::instance()->lookup_entity( TRUE, 
      entity_name,
      entity_name->_get_work_library() );
    }
    }
    {
      if ( (LA(1)==L_PAREN)
 ) {
        zzmatch(L_PAREN); consume();
        if ( !guessing ) {
           arch_name  = simple_name();

        } else {
          simple_name();
        }
        if ( !guessing ) {
        
        if( _retv != NULL ){
          ASSERT( _retv->_is_iir_entity_declaration() == TRUE );
          _retv = library_manager::instance()->lookup_architecture( TRUE, (IIR_EntityDeclaration *)_retv, arch_name );
        }
        }
        zzmatch(R_PAREN); consume();
      }
      else {
        if ( (setwd36[LA(1)]&0x8) ) {
        }
        else {FAIL(1,err152,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
  }
  else {
    if ( (LA(1)==CONFIGURATION) ) {
      zzmatch(CONFIGURATION);
      if ( !guessing ) {
            configuration = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         configuration_name  = complex_name();

      } else {
        complex_name();
      }
      if ( !guessing ) {
      
      if( configuration_name != NULL ){
        _retv = library_manager::instance()->lookup_configuration( TRUE, 
        configuration_name,
        configuration_name->_get_work_library() );
      }
      }
    }
    else {
      if ( (LA(1)==OPEN) ) {
        zzmatch(OPEN);
        if ( !guessing ) {
                open = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        _retv = NULL;
        }
 consume();
      }
      else {FAIL(1,err153,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd36, 0x10);
  return _retv;
}

void
VHDLParser::generic_map_aspect(IIR_AssociationList * alist)
{
  zzRULE;
  ANTLRTokenPtr generic=NULL;
  zzmatch(GENERIC);
  if ( !guessing ) {
    generic = (ANTLRTokenPtr)LT(1);
  }
   consume();
  zzmatch(MAP);
  if ( !guessing ) {
  copy_location( generic,  alist );
  }
 consume();
  zzmatch(L_PAREN); consume();
  association_list_in(  alist );
  zzmatch(R_PAREN); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd36, 0x20);
}

void
VHDLParser::port_map_aspect(IIR_AssociationList * alist)
{
  zzRULE;
  ANTLRTokenPtr port=NULL;
  zzmatch(PORT);
  if ( !guessing ) {
    port = (ANTLRTokenPtr)LT(1);
  }
   consume();
  zzmatch(MAP);
  if ( !guessing ) {
  copy_location( port,  alist );
  }
 consume();
  zzmatch(L_PAREN); consume();
  association_list_in(  alist );
  zzmatch(R_PAREN); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd36, 0x40);
}

void
VHDLParser::disconnection_specification(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr disconnect=NULL;
  
  IIR_DesignatorList *signal_list = NULL;
  IIR_TypeDefinition *signal_type = NULL;
  IIR *time_expression = NULL;
  zzmatch(DISCONNECT);
  if ( !guessing ) {
    disconnect = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
    { struct _rv122 _trv; _trv = guarded_signal_specification();

    signal_list = _trv.name_list; signal_type  = _trv.signal_type; }
  } else {
    guarded_signal_specification();
  }
  zzmatch(AFTER); consume();
  if ( !guessing ) {
      time_expression   = expression();

  } else {
    expression();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  IIR_DisconnectSpecification *new_spec = new IIR_DisconnectSpecification;
  copy_location( disconnect, new_spec );
  
    new_spec->set_type_mark( signal_type );
  new_spec->set_time_expression( time_expression );
  IIR_List::_listcopy( new_spec->guarded_signal_list, *signal_list );
  list->append( new_spec );
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd36, 0x80);
}

VHDLParser::_rv122
VHDLParser::guarded_signal_specification(void)
{
  struct _rv122 _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(struct _rv122))
  
  _retv.name_list = NULL;
  _retv.signal_type = NULL;
  if ( !guessing ) {
      _retv.name_list   = signal_list();

  } else {
    signal_list();
  }
  zzmatch(COLON); consume();
  if ( !guessing ) {
      _retv.signal_type   = type_mark();

  } else {
    type_mark();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd37, 0x1);
  return _retv;
}

IIR_DesignatorList *
VHDLParser::signal_list(void)
{
  IIR_DesignatorList *   _retv;
  zzRULE;
  ANTLRTokenPtr others=NULL, all=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_DesignatorList *  ))
  
  _retv = NULL;
  IIR *name = NULL;
  IIR_DesignatorExplicit *sig_name_explicit = NULL;
  IIR_DesignatorByOthers *sig_name_others = NULL;
  IIR_DesignatorByAll *sig_name_all = NULL;
  if ( (setwd37[LA(1)]&0x2) ) {
    if ( !guessing ) {
       name  = complex_name();

    } else {
      complex_name();
    }
    if ( !guessing ) {
    
    _retv = new IIR_DesignatorList();
    sig_name_explicit = new IIR_DesignatorExplicit();
    IIR::copy_location( name, sig_name_explicit );
    sig_name_explicit->set_name( name );
    _retv->append( sig_name_explicit );
    }
    {
      while ( (LA(1)==COMMA)
 ) {
        zzmatch(COMMA); consume();
        if ( !guessing ) {
            name   = complex_name();

        } else {
          complex_name();
        }
        if ( !guessing ) {
        
        sig_name_explicit = new IIR_DesignatorExplicit();
        IIR::copy_location( name, sig_name_explicit );
        sig_name_explicit->set_name( name );
        _retv->append( sig_name_explicit );
        }
      }
    }
  }
  else {
    if ( (LA(1)==OTHERS) ) {
      zzmatch(OTHERS);
      if ( !guessing ) {
            others = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      sig_name_others = new IIR_DesignatorByOthers();
      _retv->append( sig_name_others );
      copy_location( others,  _retv );
      }
 consume();
    }
    else {
      if ( (LA(1)==ALL) ) {
        zzmatch(ALL);
        if ( !guessing ) {
                all = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        
        sig_name_all = new IIR_DesignatorByAll();
        _retv->append( sig_name_all );
        copy_location( all,  _retv );
        }
 consume();
      }
      else {FAIL(1,err154,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd37, 0x4);
  return _retv;
}

void
VHDLParser::use_clause(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr use=NULL, comma=NULL;
  
  IIR_Name *name = NULL;
  IIR_UseClause *new_clause = NULL;
  zzmatch(USE);
  if ( !guessing ) {
    use = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  new_clause = new IIR_UseClause();
  copy_location( use, new_clause );
  }
 consume();
  if ( !guessing ) {
     name  = complex_name();

  } else {
    complex_name();
  }
  if ( !guessing ) {
  
  new_clause->set_selected_name( name );
  list->append( new_clause );
  new_clause->_type_check();
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA);
      if ( !guessing ) {
            comma = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
          name   = selected_name();

      } else {
        selected_name();
      }
      if ( !guessing ) {
      
      new_clause = new IIR_UseClause();
      copy_location( comma, new_clause );
      
      new_clause->set_selected_name( name );
      list->append( new_clause );
      new_clause->_type_check();
      }
    }
  }
  zzmatch(SEMI_COLON); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd37, 0x8);
}

IIR_ScalarTypeDefinition *
VHDLParser::scalar_type_definition(IIR_TypeDeclaration * type_decl)
{
  IIR_ScalarTypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ScalarTypeDefinition *  ))
  
  _retv = NULL;
  IIR_PhysicalTypeDefinition *new_physical_type = NULL;
  IIR_ScalarTypeDefinition *new_range_type = NULL;
  if ( (LA(1)==L_PAREN) ) {
    if ( !guessing ) {
        _retv   = enumeration_type_definition(  type_decl  );

    } else {
      enumeration_type_definition(  type_decl  );
    }
  }
  else {
    if ( (LA(1)==RANGE)
 ) {
      if ( !guessing ) {
         new_range_type  = range_constraint();

      } else {
        range_constraint();
      }
      if ( !guessing ) {
      
      if( new_range_type->get_kind() == IIR_RANGE_TYPE_DEFINITION ){
        IIR_RangeTypeDefinition *temp = (IIR_RangeTypeDefinition *)new_range_type;
        _retv = IIR_TypeDefinition::_construct_new_type( temp, type_decl );
      }
      else{
        _retv = new_range_type;
      }
      }
      {
        if ( (LA(1)==UNITS) ) {
          if ( !guessing ) {
             new_physical_type  = physical_type_definition();

          } else {
            physical_type_definition();
          }
          if ( !guessing ) {
          
          new_physical_type->set_left( _retv->get_left());
          new_physical_type->set_direction( _retv->get_direction());
          new_physical_type->set_right( _retv->get_right());
          new_physical_type->_set_declaration( type_decl );
          ASSERT( new_physical_type->get_base_type() != NULL );
          new_physical_type->get_base_type()->_set_declaration( type_decl );      
          _retv = new_physical_type;
          }
        }
        else {
          if ( (LA(1)==SEMI_COLON) ) {
          }
          else {FAIL(1,err155,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
    else {FAIL(1,err156,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd37, 0x10);
  return _retv;
}

IIR_EnumerationSubtypeDefinition *
VHDLParser::enumeration_type_definition(IIR_TypeDeclaration * type_decl)
{
  IIR_EnumerationSubtypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr info=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_EnumerationSubtypeDefinition *  ))
  
  IIR_EnumerationLiteral *lit = NULL;
  IIR_EnumerationLiteralList *literals = new IIR_EnumerationLiteralList();
  zzmatch(L_PAREN);
  if ( !guessing ) {
    info = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     lit  = enumeration_literal();

  } else {
    enumeration_literal();
  }
  if ( !guessing ) {
  literals->append(lit);
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         lit  = enumeration_literal();

      } else {
        enumeration_literal();
      }
      if ( !guessing ) {
      literals->append(lit);
      }
    }
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv = IIR_EnumerationTypeDefinition::_construct_new_type( literals, type_decl );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd37, 0x20);
  return _retv;
}

IIR_EnumerationLiteral *
VHDLParser::enumeration_literal(void)
{
  IIR_EnumerationLiteral *   _retv;
  zzRULE;
  ANTLRTokenPtr char_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_EnumerationLiteral *  ))
  
  _retv = NULL;
  IIR_Identifier *id = NULL;
  if ( (setwd37[LA(1)]&0x40) ) {
    if ( !guessing ) {
        id   = identifier();

    } else {
      identifier();
    }
    if ( !guessing ) {
    
    _retv = new IIR_EnumerationLiteral();
    _retv->set_declarator( id );
    IIR::copy_location( id, _retv );
    }
  }
  else {
    if ( (LA(1)==CHARACTER_LITERAL)
 ) {
      zzmatch(CHARACTER_LITERAL);
      if ( !guessing ) {
            char_lit = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = new IIR_EnumerationLiteral();
      copy_location( char_lit, _retv );
      _retv->set_declarator((IIR_CharacterLiteral*)mytoken(char_lit)->getIIRPtr());
      }
 consume();
    }
    else {FAIL(1,err157,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd37, 0x80);
  return _retv;
}

IIR_ScalarTypeDefinition *
VHDLParser::range_constraint(void)
{
  IIR_ScalarTypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr range_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ScalarTypeDefinition *  ))
  _retv = NULL;
  zzmatch(RANGE);
  if ( !guessing ) {
    range_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     _retv  = range();

  } else {
    range();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd38, 0x1);
  return _retv;
}

IIR_ScalarTypeDefinition *
VHDLParser::range(void)
{
  IIR_ScalarTypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ScalarTypeDefinition *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR *left = NULL;
  IIR *dir = NULL;
  IIR *right = NULL;
  IIR_Name *prefix = NULL;
  IIR_Attribute *range_attr = NULL;
  zzGUESS
  if ( !zzrv && (setwd38[LA(1)]&0x2) && (setwd38[LA(2)]&0x4) ) {
    {
      {
        if ( !guessing ) {
           prefix  = selected_name();

        } else {
          selected_name();
        }
        zzmatch(QUOTE); consume();
        {
          if ( (LA(1)==RANGE) ) {
            if ( !guessing ) {
                range_attr   = attribute_range(  prefix  );

            } else {
              attribute_range(  prefix  );
            }
          }
          else {
            if ( (LA(1)==REVERSE_RANGE) ) {
              if ( !guessing ) {
                  range_attr   = attribute_reverse_range(  prefix  );

              } else {
                attribute_reverse_range(  prefix  );
              }
            }
            else {FAIL(1,err158,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
      }
      if ( !guessing ) {
      
      _retv = range_attr->_build_range_type();
      delete range_attr;
      }
    }
    zzGUESS_DONE
    {
      {
        if ( !guessing ) {
           prefix  = selected_name();

        } else {
          selected_name();
        }
        zzmatch(QUOTE); consume();
        {
          if ( (LA(1)==RANGE) ) {
            if ( !guessing ) {
                range_attr   = attribute_range(  prefix  );

            } else {
              attribute_range(  prefix  );
            }
          }
          else {
            if ( (LA(1)==REVERSE_RANGE)
 ) {
              if ( !guessing ) {
                  range_attr   = attribute_reverse_range(  prefix  );

              } else {
                attribute_reverse_range(  prefix  );
              }
            }
            else {FAIL(1,err159,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
      }
      if ( !guessing ) {
      
      _retv = range_attr->_build_range_type();
      delete range_attr;
      }
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd38[LA(1)]&0x8) && (setwd38[LA(2)]&0x10) ) {
      if ( !guessing ) {
         left  = simple_expression();

      } else {
        simple_expression();
      }
      if ( !guessing ) {
         dir  = direction();

      } else {
        direction();
      }
      if ( !guessing ) {
         right  = simple_expression();

      } else {
        simple_expression();
      }
      if ( !guessing ) {
      
      _retv = new IIR_RangeTypeDefinition();
      IIR::copy_location( dir, _retv );
      _retv->set_left( left );
      _retv->set_direction( dir );
      _retv->set_right( right );
      }
    }
    else {FAIL(2,err160,err161,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd38, 0x20);
  return _retv;
}

IIR_PhysicalTypeDefinition *
VHDLParser::physical_type_definition(void)
{
  IIR_PhysicalTypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr units_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_PhysicalTypeDefinition *  ))
  
  _retv = NULL;
  IIR_PhysicalUnit *base_unit = NULL;
  IIR_Identifier *base_unit_identifier = NULL;
  IIR_Name *end_name = NULL;
  zzmatch(UNITS);
  if ( !guessing ) {
    units_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  IIR_PhysicalTypeDefinition *base_type = new IIR_PhysicalTypeDefinition();
  _retv = new IIR_PhysicalSubtypeDefinition();
  
    _retv->set_base_type( base_type );
  copy_location( units_, _retv );
  copy_location( units_, base_type );
  }
 consume();
  if ( !guessing ) {
     base_unit_identifier  = base_unit_declaration();

  } else {
    base_unit_declaration();
  }
  if ( !guessing ) {
  
  base_unit = new IIR_PhysicalUnit;
  IIR::copy_location( base_unit_identifier, base_unit );
  base_unit->set_declarator(base_unit_identifier);
  base_unit->_set_physical_type( _retv );
  base_unit->_add_declaration( );    
  
    IIR_IntegerLiteral *unity = new IIR_IntegerLiteral;
  unity->_set_mantissa("1", 1);
  base_unit->set_multiplier( unity );
  unity->_set_subtype( _retv );
  _retv->set_primary_unit( base_unit );
  }
  {
    while ( (setwd38[LA(1)]&0x40) ) {
      secondary_unit_declaration(  &(_retv->units)  );
    }
  }
  if ( !guessing ) {
  
  IIR_PhysicalUnit *current_unit = NULL;
  current_unit = _retv->units.first();
  while( current_unit != NULL ){
    current_unit->_set_physical_type( _retv );
    ASSERT( current_unit->get_multiplier() != NULL &&
    current_unit->get_multiplier()->get_kind() == IIR_PHYSICAL_LITERAL );
    ((IIR_PhysicalLiteral *)current_unit->get_multiplier())->set_subtype( _retv );
    current_unit = _retv->units.successor( current_unit );
  }
  }
  zzmatch(END); consume();
  zzmatch(UNITS); consume();
  {
    if ( (setwd38[LA(1)]&0x80) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      
      // Need to check this against the type declaration...
      // check_name( base_unit_identifier, end_name, "unit" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err162,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd39, 0x1);
  return _retv;
}

IIR_Identifier *
VHDLParser::base_unit_declaration(void)
{
  IIR_Identifier *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Identifier *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = identifier();

  } else {
    identifier();
  }
  zzmatch(SEMI_COLON); consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd39, 0x2);
  return _retv;
}

void
VHDLParser::secondary_unit_declaration(IIR_UnitList * list)
{
  zzRULE;
  ANTLRTokenPtr equal_=NULL;
  
  IIR_PhysicalUnit *new_unit = NULL;
  IIR_Identifier *unit_identifier = NULL;
  IIR_PhysicalLiteral *new_physical_literal = NULL;
  if ( !guessing ) {
     unit_identifier  = identifier();

  } else {
    identifier();
  }
  zzmatch(EQUAL);
  if ( !guessing ) {
    equal_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     new_physical_literal  = physical_literal();

  } else {
    physical_literal();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  new_unit = new IIR_PhysicalUnit();
  copy_location( equal_, new_unit );
  new_unit->set_declarator(unit_identifier);
  new_unit->set_multiplier(new_physical_literal);
  list->append(new_unit);
  new_unit->_add_declaration();
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd39, 0x4);
}

IIR_PhysicalLiteral *
VHDLParser::physical_literal(void)
{
  IIR_PhysicalLiteral *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_PhysicalLiteral *  ))
  
  _retv = NULL;
  IIR *numeric_value = NULL;
  IIR_SimpleName *unit_name = NULL;
  if ( !guessing ) {
  _retv = new IIR_PhysicalLiteral();
  }
  {
    if ( (setwd39[LA(1)]&0x8)
 ) {
      if ( !guessing ) {
         numeric_value  = integer_literal();

      } else {
        integer_literal();
      }
      if ( !guessing ) {
      _retv->set_abstract_literal(numeric_value);
      }
    }
    else {
      if ( (setwd39[LA(1)]&0x10) ) {
      }
      else {FAIL(1,err163,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
     unit_name  = simple_name();

  } else {
    simple_name();
  }
  if ( !guessing ) {
  
  IIR::copy_location( unit_name, _retv );
  set<IIR_Declaration> *unit_decls = NULL;
  unit_decls = unit_name->IIR_Name::_symbol_lookup( &IIR::_is_iir_physical_unit );
  if( unit_decls == NULL ){
    report_undefined_symbol( unit_name );
  }
  else{
    switch( unit_decls->num_elements() ){
      case 0:{
        report_undefined_symbol( unit_name );
        break;
      }
      case 1:{
        _retv->set_unit_name( (IIR_PhysicalUnit *)unit_decls->get_element() );
        break;
      }
      default:{
        cerr << "Internal error in VHDLParser::physical_literal" << endl;
        abort();
      }
    }
  }
  delete unit_decls;
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd39, 0x20);
  return _retv;
}

IIR_Literal *
VHDLParser::abstract_literal(void)
{
  IIR_Literal *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Literal *  ))
  _retv = NULL;
  if ( (setwd39[LA(1)]&0x40) ) {
    if ( !guessing ) {
       _retv  = integer_literal();

    } else {
      integer_literal();
    }
  }
  else {
    if ( (setwd39[LA(1)]&0x80) ) {
      if ( !guessing ) {
         _retv  = real_literal();

      } else {
        real_literal();
      }
    }
    else {FAIL(1,err164,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd40, 0x1);
  return _retv;
}

IIR_TypeDefinition *
VHDLParser::composite_type_definition(IIR_TypeDeclaration * type_decl)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  if ( (LA(1)==ARRAY) ) {
    if ( !guessing ) {
       _retv  = array_type_definition(  type_decl  );

    } else {
      array_type_definition(  type_decl  );
    }
  }
  else {
    if ( (LA(1)==RECORD)
 ) {
      if ( !guessing ) {
         _retv  = record_type_definition();

      } else {
        record_type_definition();
      }
    }
    else {FAIL(1,err165,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd40, 0x2);
  return _retv;
}

IIR_ArrayTypeDefinition *
VHDLParser::array_type_definition(IIR_TypeDeclaration * type_decl)
{
  IIR_ArrayTypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr array=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ArrayTypeDefinition *  ))
  
  _retv = NULL;
  IIR_ScalarTypeDefinition *index_subtype = NULL;
  IIR_TypeDefinition *element_subtype = NULL;
  IIR_ArrayTypeDefinition *prev_subtype = NULL;
  IIR_ArrayTypeDefinition *final_subtype = NULL;
  IIR_Boolean is_unconstrained = false;
  IIR_Boolean err_flag = false;
  zzmatch(ARRAY);
  if ( !guessing ) {
    array = (ANTLRTokenPtr)LT(1);
  }
   consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     index_subtype  = array_dimension();

  } else {
    array_dimension();
  }
  if ( !guessing ) {
  
  _retv = IIR_ArrayTypeDefinition::_construct_array_type( index_subtype, NULL, type_decl );
  if( _retv->_is_unconstrained_array_type() ){
    is_unconstrained = TRUE;
  }
  copy_location( array,  _retv );
  final_subtype = _retv;
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         index_subtype  = array_dimension();

      } else {
        array_dimension();
      }
      if ( !guessing ) {
      
      prev_subtype = final_subtype;
      final_subtype = IIR_ArraySubtypeDefinition::_construct_array_type( index_subtype, NULL, NULL );
      prev_subtype->set_element_subtype( final_subtype );
      ASSERT( prev_subtype->get_base_type() != NULL );
      ASSERT( prev_subtype->get_base_type()->_is_iir_array_type_definition() == TRUE );
      ((IIR_ArrayTypeDefinition *)prev_subtype->get_base_type())->set_element_subtype( final_subtype );
      if( is_unconstrained == TRUE ){
        if( final_subtype->_is_unconstrained_array_type() == FALSE ){
          err_flag = TRUE;
        }
      }
      else{
        if( final_subtype->_is_unconstrained_array_type() == TRUE ){
          err_flag = TRUE;	
        }
      }
      
      if( err_flag == TRUE ){
        ostringstream err;
        err << "All indexes of an array must be either constrained or unconstrained."
        << " They cannot be mixed.";
        report_error( index_subtype, err.str() );
      }
      }
    }
  }
  zzmatch(R_PAREN); consume();
  zzmatch(OF); consume();
  if ( !guessing ) {
     element_subtype  = subtype_indication();

  } else {
    subtype_indication();
  }
  if ( !guessing ) {
  
  if( element_subtype->_is_array_type() == TRUE ){
    element_subtype->set_is_element( TRUE );
  }
  
    final_subtype->set_element_subtype( element_subtype );
  if( final_subtype->get_base_type() != NULL ){
    ASSERT( final_subtype->get_base_type()->_is_iir_array_type_definition() == TRUE );
    ((IIR_ArrayTypeDefinition *)final_subtype->get_base_type())->set_element_subtype( element_subtype );
  }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd40, 0x4);
  return _retv;
}

IIR_ScalarTypeDefinition *
VHDLParser::array_dimension(void)
{
  IIR_ScalarTypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ScalarTypeDefinition *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR_ScalarTypeDefinition *temp_range = NULL;
  zzGUESS
  if ( !zzrv && (setwd40[LA(1)]&0x8) && (setwd40[LA(2)]&0x10) ) {
    {
      if ( !guessing ) {
         _retv  = index_subtype_definition();

      } else {
        index_subtype_definition();
      }
    }
    zzGUESS_DONE
    {
      if ( !guessing ) {
         _retv  = index_subtype_definition();

      } else {
        index_subtype_definition();
      }
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd40[LA(1)]&0x20) && (setwd40[LA(2)]&0x40) ) {
      {
        if ( !guessing ) {
           temp_range  = discrete_range();

        } else {
          discrete_range();
        }
      }
      if ( !guessing ) {
      
      if( temp_range != NULL && temp_range->get_kind() == IIR_RANGE_TYPE_DEFINITION ){
        _retv =
        IIR_ArrayTypeDefinition::_build_proper_index( (IIR_RangeTypeDefinition *)temp_range );
        // delete temp_range;
      }
      else{
        _retv = temp_range;
      }
      }
    }
    else {FAIL(2,err166,err167,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd40, 0x80);
  return _retv;
}

IIR_ScalarTypeDefinition *
VHDLParser::index_subtype_definition(void)
{
  IIR_ScalarTypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ScalarTypeDefinition *  ))
  
  _retv = NULL;
  IIR_TypeDefinition *type_designator = NULL;
  if ( !guessing ) {
     type_designator  = type_mark();

  } else {
    type_mark();
  }
  if ( !guessing ) {
  
  if( type_designator->_is_scalar_type() != TRUE ||
  type_designator->_is_discrete_type() != TRUE ){
    ostringstream err;
    err << "Array indexes must be discrete, scalar, types.";
    report_error( type_designator, err.str() );
    _retv = NULL;
  }
  }
  zzmatch(RANGE); consume();
  zzmatch(LESS_GREATER);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  IIR_RangeTypeDefinition temp_range;
  copy_location( start, &temp_range );
  
    temp_range.set_left( NULL );
  temp_range.set_right( NULL );
  temp_range.set_direction( NULL );
  IIR_TypeDefinition *subtype = NULL;
  subtype =  type_designator->_construct_new_subtype( NULL, &temp_range );
  subtype->_set_type_mark( type_designator );
  
    ASSERT( subtype->_is_scalar_type() == TRUE );
  _retv = (IIR_ScalarTypeDefinition *)subtype;
  
    copy_location( start, _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd41, 0x1);
  return _retv;
}

IIR_RecordTypeDefinition *
VHDLParser::record_type_definition(void)
{
  IIR_RecordTypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr record=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_RecordTypeDefinition *  ))
  
  _retv = NULL;
  IIR_Name *end_label = NULL;
  zzmatch(RECORD);
  if ( !guessing ) {
    record = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_RecordTypeDefinition();
  copy_location( record, _retv );
  my_symbol_table->open_scope( _retv );
  }
 consume();
  {
    int zzcnt=1;
    do {
      element_declaration( &_retv->element_declarations );
    } while ( (setwd41[LA(1)]&0x2) );
  }
  if ( !guessing ) {
  
  my_symbol_table->add_declaration( &_retv->element_declarations );
  my_symbol_table->close_scope( _retv );
  }
  zzmatch(END); consume();
  zzmatch(RECORD); consume();
  {
    if ( (setwd41[LA(1)]&0x4)
 ) {
      if ( !guessing ) {
         end_label  = simple_name();

      } else {
        simple_name();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err168,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd41, 0x8);
  return _retv;
}

void
VHDLParser::element_declaration(IIR_ElementDeclarationList * decl_list)
{
  zzRULE;
  ANTLRTokenPtr colon=NULL;
  
  IIR_ElementDeclaration *decl = NULL;
  IIR_Identifier *id = NULL;
  IIR_TypeDefinition *elem_subtype = NULL;
  IIR_IdentifierList *id_list = NULL;
  if ( !guessing ) {
  id_list = new IIR_IdentifierList();
  }
  identifier_list( id_list );
  zzmatch(COLON);
  if ( !guessing ) {
    colon = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     elem_subtype  = subtype_indication();

  } else {
    subtype_indication();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  id = id_list->first();
  
    while (id != NULL) {
    decl = new IIR_ElementDeclaration();
    IIR::copy_location( id, decl );
    decl->set_declarator(id);
    decl->set_subtype(elem_subtype);
    decl_list->append(decl);
    
      // need to remove instead of taking successor because current 
    // linked list class does not process duplicate members
    id_list->remove(id);
    id = id_list->first();
  }
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd41, 0x10);
}

IIR_AccessTypeDefinition *
VHDLParser::access_type_definition(IIR_TypeDeclaration * type_decl)
{
  IIR_AccessTypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr access=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_AccessTypeDefinition *  ))
  
  _retv = NULL;
  IIR_TypeDefinition *type_def = NULL;
  zzmatch(ACCESS);
  if ( !guessing ) {
    access = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     type_def  = subtype_indication();

  } else {
    subtype_indication();
  }
  if ( !guessing ) {
  
  _retv = IIR_AccessTypeDefinition::_construct_new_type( type_def, type_decl );
  copy_location(  access, _retv );
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd41, 0x20);
  return _retv;
}

IIR_FileTypeDefinition *
VHDLParser::file_type_definition(void)
{
  IIR_FileTypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr file_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_FileTypeDefinition *  ))
  
  _retv = NULL;
  IIR_TypeDefinition *type_def = NULL;
  zzmatch(FILE_);
  if ( !guessing ) {
    file_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  zzmatch(OF);
  if ( !guessing ) {
  
  _retv = new IIR_FileTypeDefinition();
  copy_location( file_, _retv );
  }
 consume();
  if ( !guessing ) {
     type_def  = type_mark();

  } else {
    type_mark();
  }
  if ( !guessing ) {
  _retv->set_type_mark(type_def);
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd41, 0x40);
  return _retv;
}

void
VHDLParser::type_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr type=NULL;
  
  IIR_TypeDeclaration *old_incomplete_type = NULL;
  IIR_Identifier *type_name = NULL;
  IIR_TypeDeclaration *type_decl = NULL;
  IIR_TypeDefinition *new_definition = NULL;
  zzmatch(TYPE);
  if ( !guessing ) {
    type = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     type_name  = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  
  old_incomplete_type = find_incomplete_type_declaration( type_name );
  type_decl = new IIR_TypeDeclaration();
  type_decl->set_declarator( type_name );
  copy_location( type, type_decl );
  }
  {
    if ( (LA(1)==IS) ) {
      zzmatch(IS); consume();
      if ( !guessing ) {
         new_definition  = type_definition(  type_decl  );

      } else {
        type_definition(  type_decl  );
      }
      if ( !guessing ) {
      
      new_definition->_set_declaration( type_decl );
      type_decl->set_type( new_definition );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err169,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  if( type_decl->get_type() == NULL ){
    IIRScram_IncompleteTypeDefinition *incomplete_type = new IIRScram_IncompleteTypeDefinition();
    incomplete_type->_set_designated_type_name( type_name );	
    type_decl->set_type( incomplete_type );
  }
  if( old_incomplete_type != NULL ){
    my_symbol_table->incomplete_type_fixup( old_incomplete_type, type_decl );
    // This was screwing up the case:
    // type a;
    // type a is access a;
    //       delete old_incomplete_type->get_type();
    old_incomplete_type->set_type( NULL );
  }
  
    list->append( type_decl );
  type_decl->_add_declaration();
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd41, 0x80);
}

IIR_TypeDefinition *
VHDLParser::type_definition(IIR_TypeDeclaration * type_decl)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  zzGUESS_BLOCK
  _retv = NULL;
  if ( (setwd42[LA(1)]&0x1) ) {
    if ( !guessing ) {
       _retv  = scalar_type_definition(  type_decl  );

    } else {
      scalar_type_definition(  type_decl  );
    }
  }
  else {
    if ( (setwd42[LA(1)]&0x2)
 ) {
      if ( !guessing ) {
         _retv  = composite_type_definition(  type_decl  );

      } else {
        composite_type_definition(  type_decl  );
      }
    }
    else {
      if ( (LA(1)==ACCESS) ) {
        if ( !guessing ) {
           _retv  = access_type_definition(  type_decl  );

        } else {
          access_type_definition(  type_decl  );
        }
      }
      else {
        if ( (LA(1)==FILE_) ) {
          if ( !guessing ) {
             _retv  = file_type_definition();

          } else {
            file_type_definition();
          }
        }
        else {
          zzGUESS
          if ( !zzrv && (LA(1)==PROTECTED) && (LA(2)==BODY) ) {
            {
              zzmatch(PROTECTED); consume();
              zzmatch(BODY); consume();
            }
            zzGUESS_DONE
            if (!(lang_proc->processing_vhdl_2001())              ) {zzfailed_pred("  lang_proc->processing_vhdl_2001()",1 /* user action */, {  lang_proc->report_not_vhdl_2001((ANTLRToken *)LT(1));  } );}
            if ( !guessing ) {
               _retv  = protected_type_body( type_decl );

            } else {
              protected_type_body( type_decl );
            }
          }
          else {
            if ( !zzrv ) zzGUESS_DONE;
            if ( (LA(1)==PROTECTED) && (setwd42[LA(2)]&0x4) ) {
              if (!(lang_proc->processing_vhdl_2001())                ) {zzfailed_pred("  lang_proc->processing_vhdl_2001()",1 /* user action */, {  lang_proc->report_not_vhdl_2001((ANTLRToken *)LT(1));  } );}
              if ( !guessing ) {
                 _retv  = protected_type_declaration( type_decl );

              } else {
                protected_type_declaration( type_decl );
              }
            }
            else {FAIL(2,err170,err171,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd42, 0x8);
  return _retv;
}

void
VHDLParser::subtype_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr subtype=NULL;
  
  IIR_TypeDefinition *type_definition = NULL;
  IIR_Identifier *subtype_name = NULL;
  IIR_SubtypeDeclaration *new_subtype_decl = NULL;
  zzmatch(SUBTYPE);
  if ( !guessing ) {
    subtype = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  new_subtype_decl = new IIR_SubtypeDeclaration();
  copy_location( subtype, new_subtype_decl );
  }
 consume();
  if ( !guessing ) {
     subtype_name  = identifier();

  } else {
    identifier();
  }
  zzmatch(IS); consume();
  if ( !guessing ) {
     type_definition  = subtype_indication();

  } else {
    subtype_indication();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  if( type_definition->_get_declaration() == NULL ){
    // Then, this is indeed a new type.
    type_definition->_set_declaration( new_subtype_decl );
  }
  else{
    // This wasn't a new type - it was soemthing like:
    // subtype foo is bar;
    // The LRM says "the subtype is the same as the type."  We're
    // going to copy the subtype for convenience - hopefully we're
    // not violating any semantics...
    IIR_TypeDefinition *temp_type = type_definition->_construct_new_subtype( 0, 0 );
    temp_type->_set_type_mark( type_definition );
    temp_type->_set_declaration( new_subtype_decl );
    type_definition = temp_type;
  }
  new_subtype_decl->set_declarator( subtype_name );
  new_subtype_decl->set_subtype( type_definition );
  list->append( new_subtype_decl );
  new_subtype_decl->_add_declaration();
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd42, 0x10);
}

IIR_TypeDefinition *
VHDLParser::subtype_indication(void)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  
  _retv = NULL;
  IIR_TypeDefinition *base_type = NULL;
  IIR_Name *resolution_function = NULL;
  IIR_TypeDefinition *new_constrained_type = NULL;
  IIR *tolerance = NULL;
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (setwd42[LA(1)]&0x20) && 
(setwd42[LA(2)]&0x40) ) {
      {
        if ( !guessing ) {
           resolution_function  = complex_name();

        } else {
          complex_name();
        }
        if ( !guessing ) {
            base_type   = type_mark();

        } else {
          type_mark();
        }
      }
      zzGUESS_DONE
      if ( !guessing ) {
         resolution_function  = complex_name();

      } else {
        complex_name();
      }
      if ( !guessing ) {
          base_type   = type_mark();

      } else {
        type_mark();
      }
      {
        if ( (setwd42[LA(1)]&0x80) ) {
          if ( !guessing ) {
              new_constrained_type   = constraint(  base_type, resolution_function  );

          } else {
            constraint(  base_type, resolution_function  );
          }
          if ( !guessing ) {
          
          if( new_constrained_type != NULL ){
            new_constrained_type->_set_type_mark( base_type );
          }
          }
        }
        else {
          if ( (setwd43[LA(1)]&0x1) ) {
          }
          else {FAIL(1,err172,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      if ( !guessing ) {
      
      // If there wasn't a constraint, and there was a resolution
      // function, we need to build a new subtype.  (If there was a
      // constraint, then constraint took care of it all.)
      if( new_constrained_type == NULL && resolution_function != NULL ){
      _retv = 
      base_type->_construct_new_subtype( resolution_function, NULL );
      _retv->_set_type_mark( base_type );
    }
    else{
    ASSERT( new_constrained_type != NULL );
    _retv = new_constrained_type;
  }
      }
      if ( !guessing ) {
      _retv->_type_check();
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd43[LA(1)]&0x2) && (setwd43[LA(2)]&0x4) ) {
        if ( !guessing ) {
            base_type   = type_mark();

        } else {
          type_mark();
        }
        {
          if ( (setwd43[LA(1)]&0x8) ) {
            if ( !guessing ) {
                new_constrained_type   = constraint(  base_type, NULL  );

            } else {
              constraint(  base_type, NULL  );
            }
            if ( !guessing ) {
            
            if( new_constrained_type != NULL ){
              new_constrained_type->_set_type_mark( base_type );
            }
            }
          }
          else {
            if ( (setwd43[LA(1)]&0x10)
 ) {
            }
            else {FAIL(1,err173,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
        if ( !guessing ) {
        
        if( new_constrained_type == NULL ){
          _retv = base_type;
        }
        else{
          _retv = new_constrained_type;
        }
        }
      }
      else {FAIL(2,err174,err175,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==TOLERANCE) && (setwd43[LA(2)]&0x20) ) {
      {
        zzmatch(TOLERANCE); consume();
      }
      zzGUESS_DONE
      if (!(lang_proc->processing_vhdl_ams())        ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
      zzmatch(TOLERANCE); consume();
      if ( !guessing ) {
         tolerance  = expression();

      } else {
        expression();
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd43[LA(1)]&0x40) && (setwd43[LA(2)]&0x80) ) {
      }
      else {FAIL(2,err176,err177,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  if( _retv != NULL ){
    _retv->_type_check();
  }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd44, 0x1);
  return _retv;
}

IIR_Name *
VHDLParser::selected_or_simple_name(void)
{
  IIR_Name *   _retv;
  zzRULE;
  ANTLRTokenPtr dot=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = simple_name();

  } else {
    simple_name();
  }
  {
    IIR_Name *suffix = NULL;
    while ( (LA(1)==DOT) ) {
      zzmatch(DOT);
      if ( !guessing ) {
            dot = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         suffix  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      
      IIR_SelectedName *new_name = NULL;
      new_name = new IIR_SelectedName();
      new_name->set_prefix( _retv );
      new_name->set_suffix( suffix );
      copy_location( dot, new_name );
      _retv = new_name;
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd44, 0x2);
  return _retv;
}

IIR_TypeDefinition *
VHDLParser::type_mark(void)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  
  _retv = NULL;
  IIR_Name *type_name = NULL;
  IIR_Name *attribute = NULL;
  if ( !guessing ) {
     type_name  = selected_or_simple_name();

  } else {
    selected_or_simple_name();
  }
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==QUOTE) ) {
      {
        zzmatch(QUOTE); consume();
      }
      zzGUESS_DONE
      if (!(lang_proc->processing_vhdl_ams())        ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
      zzmatch(QUOTE); consume();
      {
        if ( (LA(1)==ACROSS)
 ) {
          if ( !guessing ) {
             attribute  = attribute_across( attribute );

          } else {
            attribute_across( attribute );
          }
        }
        else {
          if ( (LA(1)==THROUGH) ) {
            if ( !guessing ) {
               attribute  = attribute_through( attribute );

            } else {
              attribute_through( attribute );
            }
          }
          else {FAIL(1,err178,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd44[LA(1)]&0x4) ) {
      }
      else {FAIL(1,err179,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  set<IIR_TypeDefinition> *type_set = type_name->_get_rval_set(&IIR::_is_type);
  if( type_set == NULL ){
    report_undefined_symbol( type_name );
  }
  else if( type_set->num_elements() > 1 ){
    report_ambiguous_error( type_name, type_set );
    panic("type_mark resolution failed in VHDLParser::type_mark");
  }
  else{
    // Then type_set is non-NULL has one element in it.
    _retv = type_set->get_element();
    if( _retv == NULL ){
      ostringstream err;
      err << "|" << *type_name << "| was not declared as a type in this scope";
      report_error( type_name, err.str() );
    }
    delete type_name;
  }
  delete type_set;
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd44, 0x8);
  return _retv;
}

IIR_TypeDefinition *
VHDLParser::constraint(IIR_TypeDefinition * type_def,IIR_Name * resolution_function)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  
  _retv = NULL;
  IIR_ScalarTypeDefinition *additional_constraint = NULL;
  if ( (LA(1)==RANGE) ) {
    if ( !guessing ) {
        additional_constraint   = range_constraint();

    } else {
      range_constraint();
    }
    if ( !guessing ) {
    
    ASSERT( type_def != NULL || parse_error == TRUE );
    if( type_def != NULL ){
      _retv = 
      type_def->_construct_new_subtype( resolution_function, additional_constraint );
    }
    //    delete (IIR_RangeTypeDefinition *)additional_constraint;
    }
  }
  else {
    if ( (LA(1)==L_PAREN) ) {
      if ( !guessing ) {
         _retv  = index_constraint(  type_def  );

      } else {
        index_constraint(  type_def  );
      }
      if ( !guessing ) {
      
      ASSERT( type_def != NULL || parse_error == TRUE );
      if( type_def != NULL && type_def->_is_array_type() == FALSE ){
      }
      }
    }
    else {FAIL(1,err180,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd44, 0x10);
  return _retv;
}

IIR_TypeDefinition *
VHDLParser::index_constraint(IIR_TypeDefinition * type_definition)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr l_paren=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  
  IIR_TypeDefinition *array_type = NULL;
  IIR_ScalarTypeDefinition *current_constraint = NULL;
  IIR_TypeDefinition *final_constrained_type = NULL;
  IIR_TypeDefinition *previous_constrained_type = NULL;
  
    IIR_TypeDefinition *final_unconstrained_type = NULL;
  IIR_TypeDefinition *previous_unconstrained_type = NULL;
  zzmatch(L_PAREN);
  if ( !guessing ) {
    l_paren = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  if( type_definition->_is_array_type() == TRUE ){
    array_type = type_definition;
  }
  }
 consume();
  if ( !guessing ) {
     current_constraint  = discrete_range();

  } else {
    discrete_range();
  }
  if ( !guessing ) {
  
  if( array_type == NULL ){
    ostringstream err;
    err << "Index constraints may only be applied to array types.";
    report_error( current_constraint, err.str() );
  }
  else{
    if( array_type->_is_unconstrained_array_type() == FALSE ){
      ostringstream err;
      err << "Index constraints may only be applied to unconstrained array types.";
      report_error( array_type, err.str() );
    }
    if( current_constraint != NULL ){
      _retv = array_type->_index_constrain_array( current_constraint );
      final_constrained_type = _retv;
      final_unconstrained_type = array_type;
    }
  }
  }
  {
    while ( (LA(1)==COMMA)
 ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         current_constraint  = discrete_range();

      } else {
        discrete_range();
      }
      if ( !guessing ) {
      
      if( array_type != NULL ){
        ASSERT( final_constrained_type->_is_array_type() == TRUE );
        ASSERT( final_unconstrained_type->_is_array_type() == TRUE );
        previous_constrained_type = final_constrained_type;
        previous_unconstrained_type = final_unconstrained_type;
        
        IIR_TypeDefinition *old_element_type = previous_unconstrained_type->_get_element_subtype();
        if( old_element_type->_is_array_type() == FALSE ||
        old_element_type->_is_anonymous() == FALSE ){
          ostringstream err;
          err << "Index constraints must be applied to array types.";
          report_error( array_type, err.str() );
          return _retv;
        }
        IIR_TypeDefinition *new_constrained_type = NULL;
        new_constrained_type = old_element_type->_index_constrain_array(current_constraint);
        previous_constrained_type->_set_element_subtype( new_constrained_type );
        final_constrained_type = new_constrained_type;
        final_unconstrained_type = previous_unconstrained_type->_get_element_subtype();
      }
      }
    }
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  
  if( array_type != NULL ){
    ASSERT( final_unconstrained_type->_is_array_type() == TRUE );
    final_constrained_type->_set_element_subtype( final_unconstrained_type->_get_element_subtype() );
  }
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd44, 0x20);
  return _retv;
}

void
VHDLParser::constant_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr constant=NULL;
  
  IIR_ConstantDeclaration *new_decl = NULL;
  IIR_IdentifierList *id_list = NULL;
  IIR_Identifier *id = NULL;
  IIR_TypeDefinition *type_def = NULL;
  IIR *initial_value = NULL;
  zzmatch(CONSTANT);
  if ( !guessing ) {
    constant = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  id_list = new IIR_IdentifierList();
  }
 consume();
  identifier_list( id_list );
  zzmatch(COLON); consume();
  if ( !guessing ) {
     type_def  = subtype_indication();

  } else {
    subtype_indication();
  }
  {
    if ( (LA(1)==COLON_EQUAL) ) {
      if ( !guessing ) {
         initial_value  = initialization();

      } else {
        initialization();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err181,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  id = id_list->first();
  while (id != NULL) {
    new_decl = new IIR_ConstantDeclaration();
    IIR::copy_location( id, new_decl );
    new_decl->set_declarator( id );
    if( initial_value != NULL ){
      new_decl->set_value( initial_value );
    }
    new_decl->set_subtype( type_def );
    
      new_decl->_add_declaration( );
    list->append( new_decl );
    new_decl->_type_check();
    
      // need to remove instead of taking successor because current 
    // linked list class does not process duplicate members
    id_list->remove(id);
    id = id_list->first();
  }
  delete id_list;
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd44, 0x40);
}

void
VHDLParser::identifier_list(IIR_IdentifierList * list)
{
  zzRULE;
  IIR_Identifier *id = NULL;
  if ( !guessing ) {
     id  = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  list->append(id);
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         id  = identifier();

      } else {
        identifier();
      }
      if ( !guessing ) {
      list->append(id);
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd44, 0x80);
}

IIR *
VHDLParser::initialization(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  _retv = NULL;
  zzmatch(COLON_EQUAL); consume();
  if ( !guessing ) {
     _retv  = expression();

  } else {
    expression();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd45, 0x1);
  return _retv;
}

void
VHDLParser::signal_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr signal=NULL;
  
  IIR_SignalDeclaration *new_signal = NULL;
  IIR_TypeDefinition *subtype = NULL;
  IIR_IdentifierList *id_list = NULL;
  IIR_SignalKind sig_kind = IIR_NO_SIGNAL_KIND;
  IIR *initial_value = NULL;
  IIR_Identifier *id = NULL;
  zzmatch(SIGNAL);
  if ( !guessing ) {
    signal = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  id_list = new IIR_IdentifierList();
  }
 consume();
  identifier_list( id_list );
  zzmatch(COLON); consume();
  if ( !guessing ) {
     subtype  = subtype_indication();

  } else {
    subtype_indication();
  }
  {
    if ( (setwd45[LA(1)]&0x2) ) {
      if ( !guessing ) {
         sig_kind  = signal_kind();

      } else {
        signal_kind();
      }
    }
    else {
      if ( (setwd45[LA(1)]&0x4)
 ) {
      }
      else {FAIL(1,err182,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==COLON_EQUAL) ) {
      if ( !guessing ) {
         initial_value  = initialization();

      } else {
        initialization();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err183,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  id = id_list->first();
  while (id != NULL) {
    new_signal = new IIR_SignalDeclaration();
    IIR::copy_location( id, new_signal );
    new_signal->set_declarator(id);
    new_signal->set_subtype( subtype );
    new_signal->set_signal_kind( sig_kind );
    new_signal->set_value( initial_value );
    new_signal->_type_check();
    
      new_signal->_add_declaration( );
    list->append(new_signal);
    
      // need to remove instead of taking successor because current 
    // linked list class does not process duplicate members
    id_list->remove(id);
    id = id_list->first();
  }
  delete id_list;
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd45, 0x8);
}

IIR_SignalKind
VHDLParser::signal_kind(void)
{
  IIR_SignalKind   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SignalKind  ))
  _retv = IIR_REGISTER_KIND;
  if ( (LA(1)==REGISTER) ) {
    zzmatch(REGISTER);
    if ( !guessing ) {
    _retv = IIR_REGISTER_KIND;
    }
 consume();
  }
  else {
    if ( (LA(1)==BUS) ) {
      zzmatch(BUS);
      if ( !guessing ) {
      _retv = IIR_BUS_KIND;
      }
 consume();
    }
    else {FAIL(1,err184,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd45, 0x10);
  return _retv;
}

void
VHDLParser::shared_variable_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  zzmatch(SHARED); consume();
  zzmatch(VARIABLE); consume();
  variable_declaration_body(  list, TRUE );
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd45, 0x20);
}

void
VHDLParser::variable_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  IIR_Boolean shared = FALSE;
  {
    if ( (LA(1)==SHARED)
 ) {
      zzmatch(SHARED);
      if ( !guessing ) {
      shared = TRUE;
      }
 consume();
    }
    else {
      if ( (LA(1)==VARIABLE) ) {
      }
      else {FAIL(1,err185,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(VARIABLE); consume();
  variable_declaration_body(  list, shared );
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd45, 0x40);
}

void
VHDLParser::variable_declaration_body(IIR_DeclarationList * list,bool shared)
{
  zzRULE;
  
  IIR_ObjectDeclaration *new_decl = NULL;
  IIR_IdentifierList *id_list = NULL;
  IIR_Identifier *id = NULL;
  IIR *initial_value = NULL;
  IIR_TypeDefinition *subtype = NULL;
  if ( !guessing ) {
  id_list = new IIR_IdentifierList();
  }
  identifier_list( id_list );
  zzmatch(COLON); consume();
  if ( !guessing ) {
      subtype   = subtype_indication();

  } else {
    subtype_indication();
  }
  {
    if ( (LA(1)==COLON_EQUAL) ) {
      if ( !guessing ) {
          initial_value   = initialization();

      } else {
        initialization();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err186,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  id = id_list->first();
  while (id != NULL) {
    if( shared == FALSE ){ 
      IIR_VariableDeclaration *new_var_decl =  new IIR_VariableDeclaration();
      new_var_decl->set_value( initial_value );
      IIR::copy_location( id, new_var_decl );
      new_decl = new_var_decl;
    }
    else {
      IIR_SharedVariableDeclaration *new_shared_decl = new IIR_SharedVariableDeclaration();
      IIR::copy_location( id, new_shared_decl );
      new_shared_decl->set_value( initial_value );
      new_decl = new_shared_decl;
    }
    
      new_decl->set_declarator( id );
    new_decl->set_subtype( subtype );
    new_decl->_type_check();
    
      new_decl->_add_declaration();
    list->append(new_decl);
    
      // need to remove instead of taking successor because current 
    // linked list class does not process duplicate members
    id_list->remove(id);
    id = id_list->first();
  }
  delete id_list;
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd45, 0x80);
}

void
VHDLParser::file_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr file_=NULL;
  
  IIR_FileDeclaration *new_file = NULL;
  IIR_IdentifierList *id_list = NULL;
  IIR_TypeDefinition *subtype = NULL;
  IIR_Identifier *id = NULL;
  IIR_DeclarationList *file_decl_list = NULL;
  IIR *open_information = NULL;
  IIR *logical_name = NULL;
  zzmatch(FILE_);
  if ( !guessing ) {
    file_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  id_list = new IIR_IdentifierList();
  }
 consume();
  identifier_list( id_list );
  zzmatch(COLON); consume();
  if ( !guessing ) {
     subtype  = subtype_indication();

  } else {
    subtype_indication();
  }
  {
    if ( (setwd46[LA(1)]&0x1) ) {
      if ( !guessing ) {
        { struct _rv160 _trv; _trv = file_open_information();

        open_information = _trv.open_information; logical_name  = _trv.logical_name; }
      } else {
        file_open_information();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON)
 ) {
      }
      else {FAIL(1,err187,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  id = id_list->first();
  while (id != NULL) {
    new_file = new IIR_FileDeclaration();
    new_file->set_declarator(id);
    new_file->set_subtype(subtype);
    new_file->set_file_open_expression( open_information );
    new_file->set_file_logical_name( logical_name );
    IIR::copy_location( id, new_file );
    new_file->_add_declaration();
    list->append(new_file); 
    // need to remove instead of taking successor because current 
    // linked list class does not process duplicate members
    id_list->remove(id);
    id = id_list->first();
  }
  delete id_list;
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd46, 0x2);
}

VHDLParser::_rv160
VHDLParser::file_open_information(void)
{
  struct _rv160 _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(struct _rv160))
  
  _retv.open_information = NULL;
  _retv.logical_name = NULL;
  {
    if ( (LA(1)==OPEN) ) {
      zzmatch(OPEN); consume();
      if ( !guessing ) {
         _retv.open_information  = expression();

      } else {
        expression();
      }
    }
    else {
      if ( (LA(1)==IS) ) {
      }
      else {FAIL(1,err188,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(IS); consume();
  if ( !guessing ) {
     _retv.logical_name  = file_logical_name();

  } else {
    file_logical_name();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd46, 0x4);
  return _retv;
}

IIR_Mode
VHDLParser::mode(void)
{
  IIR_Mode   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Mode  ))
  _retv = IIR_IN_MODE;
  if ( (LA(1)==IN) ) {
    zzmatch(IN);
    if ( !guessing ) {
    _retv = IIR_IN_MODE;
    }
 consume();
  }
  else {
    if ( (LA(1)==OUT) ) {
      zzmatch(OUT);
      if ( !guessing ) {
      _retv = IIR_OUT_MODE;
      }
 consume();
    }
    else {
      if ( (LA(1)==INOUT)
 ) {
        zzmatch(INOUT);
        if ( !guessing ) {
        _retv = IIR_INOUT_MODE;
        }
 consume();
      }
      else {
        if ( (LA(1)==BUFFER) ) {
          zzmatch(BUFFER);
          if ( !guessing ) {
          _retv = IIR_BUFFER_MODE;
          }
 consume();
        }
        else {
          if ( (LA(1)==LINKAGE) ) {
            zzmatch(LINKAGE);
            if ( !guessing ) {
            _retv = IIR_LINKAGE_MODE;
            }
 consume();
          }
          else {FAIL(1,err189,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd46, 0x8);
  return _retv;
}

IIR *
VHDLParser::file_logical_name(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = expression();

  } else {
    expression();
  }
  if ( !guessing ) {
  
  if( _retv != 0 ){
    IIR_TypeDefinition *string_type = StandardPackage::get_string_type();
    _retv = _retv->_semantic_transform( string_type );
    _retv->_type_check( string_type );
    _retv = _retv->_rval_to_decl( string_type );
  }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd46, 0x10);
  return _retv;
}

void
VHDLParser::interface_declaration(IIRScram_InterfaceDeclaration::_InterfaceListType ilt,IIR_List * list)
{
  zzRULE;
  
  InterfaceListObjectType obj_type = ILOT_UNSPECIFIED;
  IIR_IdentifierList *id_list = new IIR_IdentifierList();
  IIR_Mode modde = IIR_IN_MODE;
  IIR_TypeDefinition *subtype_ind = NULL;
  IIR_SignalKind signal_kind = IIR_NO_SIGNAL_KIND;
  IIR *initial_value = NULL;
  {
    if ( (setwd46[LA(1)]&0x20) ) {
      {
        if ( (setwd46[LA(1)]&0x40) ) {
          {
            if ( (LA(1)==CONSTANT)
 ) {
              zzmatch(CONSTANT);
              if ( !guessing ) {
              obj_type = ILOT_CONSTANT;
              }
 consume();
            }
            else {
              if ( (LA(1)==SIGNAL) ) {
                zzmatch(SIGNAL);
                if ( !guessing ) {
                obj_type = ILOT_SIGNAL;
                }
 consume();
              }
              else {
                if ( (LA(1)==VARIABLE) ) {
                  zzmatch(VARIABLE);
                  if ( !guessing ) {
                  obj_type = ILOT_VARIABLE;
                  }
 consume();
                }
                else {FAIL(1,err190,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
              }
            }
          }
        }
        else {
          if ( (setwd46[LA(1)]&0x80) ) {
          }
          else {FAIL(1,err191,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      identifier_list( id_list );
      zzmatch(COLON); consume();
      {
        if ( (setwd47[LA(1)]&0x1) ) {
          if ( !guessing ) {
             modde  = mode();

          } else {
            mode();
          }
        }
        else {
          if ( (setwd47[LA(1)]&0x2)
 ) {
          }
          else {FAIL(1,err192,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      if ( !guessing ) {
         subtype_ind  = subtype_indication();

      } else {
        subtype_indication();
      }
      {
        if ( (LA(1)==BUS) ) {
          zzmatch(BUS);
          if ( !guessing ) {
          signal_kind = IIR_BUS_KIND;
          }
 consume();
        }
        else {
          if ( (setwd47[LA(1)]&0x4) ) {
          }
          else {FAIL(1,err193,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      {
        if ( (LA(1)==COLON_EQUAL) ) {
          if ( !guessing ) {
             initial_value  = initialization();

          } else {
            initialization();
          }
        }
        else {
          if ( (setwd47[LA(1)]&0x8) ) {
          }
          else {FAIL(1,err194,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
    else {
      if ( (LA(1)==FILE_)
 ) {
        zzmatch(FILE_);
        if ( !guessing ) {
        obj_type = ILOT_FILE;
        }
 consume();
        identifier_list( id_list );
        zzmatch(COLON); consume();
        if ( !guessing ) {
           subtype_ind  = subtype_indication();

        } else {
          subtype_indication();
        }
      }
      else {
        if ( (setwd47[LA(1)]&0x10) ) {
          if (!(lang_proc->processing_vhdl_ams())            ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
          {
            if ( (LA(1)==TERMINAL) ) {
              zzmatch(TERMINAL);
              if ( !guessing ) {
              obj_type = ILOT_TERMINAL;
              }
 consume();
              identifier_list( id_list );
              zzmatch(COLON); consume();
              if ( !guessing ) {
                 subtype_ind  = subnature_indication();

              } else {
                subnature_indication();
              }
            }
            else {
              if ( (LA(1)==QUANTITY) ) {
                zzmatch(QUANTITY); consume();
                identifier_list( id_list );
                zzmatch(COLON); consume();
                {
                  if ( (LA(1)==IN) ) {
                    zzmatch(IN);
                    if ( !guessing ) {
                    modde = IIR_IN_MODE;
                    }
 consume();
                  }
                  else {
                    if ( (LA(1)==OUT)
 ) {
                      zzmatch(OUT);
                      if ( !guessing ) {
                      modde = IIR_OUT_MODE;
                      }
 consume();
                    }
                    else {
                      if ( (setwd47[LA(1)]&0x20) ) {
                      }
                      else {FAIL(1,err195,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                    }
                  }
                }
                if ( !guessing ) {
                   subtype_ind  = subtype_indication();

                } else {
                  subtype_indication();
                }
                {
                  if ( (LA(1)==COLON_EQUAL) ) {
                    if ( !guessing ) {
                       initial_value  = initialization();

                    } else {
                      initialization();
                    }
                  }
                  else {
                    if ( (setwd47[LA(1)]&0x40) ) {
                    }
                    else {FAIL(1,err196,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                  }
                }
              }
              else {FAIL(1,err197,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
            }
          }
        }
        else {FAIL(1,err198,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
  }
  if ( !guessing ) {
  
  switch ( ilt) {
    case IIRScram_InterfaceDeclaration::PORT_INTERFACE_LIST:
    if (obj_type == ILOT_UNSPECIFIED){
      obj_type = ILOT_SIGNAL;
    }
    if ((obj_type != ILOT_SIGNAL) && (obj_type != ILOT_TERMINAL)){
      report_error( "Interface declarations in port lists must be either of type signal or (in VHDL-AMS) terminal.\n",
      LT(1)->getLine(),
      my_design_file->get_name() );
      obj_type = ILOT_SIGNAL;
    }
    break;
    case IIRScram_InterfaceDeclaration::GENERIC_INTERFACE_LIST:
    if (obj_type == ILOT_UNSPECIFIED) {
      obj_type = ILOT_CONSTANT;
    }
    if (obj_type != ILOT_CONSTANT) {
      report_error( "Interface declarations in generic lists must be of type constant.", 
      LT(1)->getLine(),
      my_design_file->get_name());
      obj_type = ILOT_CONSTANT;
    }
    break;
    case IIRScram_InterfaceDeclaration::PARAMETER_INTERFACE_LIST:
    if ((modde != IIR_IN_MODE) && (modde != IIR_INOUT_MODE) && (modde != IIR_OUT_MODE)) {
      report_error("Parameter list interface declarations can only be in, inout, or out.",
      LT(1)->getLine(),
      my_design_file->get_name());
      modde = IIR_IN_MODE;
    }
    if (obj_type == ILOT_UNSPECIFIED) {
      if (modde == IIR_IN_MODE) {
        obj_type = ILOT_CONSTANT;
      } else {
        obj_type = ILOT_VARIABLE;
      }
    }
    break;
  }
  if ((signal_kind == IIR_BUS_KIND) && (obj_type != ILOT_SIGNAL)) {
    report_error("Only signal interface declarations can be defined as guarded (using the bus keyword).", 
    LT(1)->getLine(),
    my_design_file->get_name());
  }
  IIR_Identifier *id = NULL;
  for (id=id_list->first(); id!=NULL; id=id_list->successor(id)){
    IIR_InterfaceDeclaration *new_decl = NULL;
    switch (obj_type){
      case ILOT_TERMINAL:{
        new_decl = new IIR_TerminalInterfaceDeclaration();
        modde = IIR_UNKNOWN_MODE;
        break;
      }
      case ILOT_FILE:{
        new_decl = new IIR_FileInterfaceDeclaration();
        break;
      }
      case ILOT_CONSTANT:{
        new_decl = new IIR_ConstantInterfaceDeclaration();
        break;
      }
      case ILOT_VARIABLE:{
        new_decl = new IIR_VariableInterfaceDeclaration();
        break;
      }
      case ILOT_SIGNAL:{
        IIR_SignalInterfaceDeclaration *sig_decl = new IIR_SignalInterfaceDeclaration();
        sig_decl->set_signal_kind(signal_kind);
        new_decl = sig_decl;
        break;
      }
      default:
      report_error( id, "Unknown object type in interface declaration." );
      abort();
      break;
    }
    IIR::copy_location( id, new_decl );
    new_decl->set_subtype(subtype_ind);
    new_decl->set_declarator(id);
    new_decl->set_mode(modde);
    new_decl->set_value(initial_value);
    new_decl->_type_check(ilt);
    list->append(new_decl);
  }
  delete id_list;
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd47, 0x80);
}

void
VHDLParser::interface_list(IIRScram_InterfaceDeclaration::_InterfaceListType ilt,IIR_List * list)
{
  zzRULE;
  interface_declaration(  ilt, list );
  {
    while ( (LA(1)==SEMI_COLON) ) {
      zzmatch(SEMI_COLON); consume();
      interface_declaration(  ilt, list );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd48, 0x1);
}

void
VHDLParser::association_list_in(IIR_AssociationList * alist)
{
  zzRULE;
  IIR_AssociationElement *elem = NULL;
  if ( !guessing ) {
     elem  = association();

  } else {
    association();
  }
  if ( !guessing ) {
  alist->append(elem);
  }
  {
    while ( (LA(1)==COMMA)
 ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         elem  = association();

      } else {
        association();
      }
      if ( !guessing ) {
      alist->append(elem);
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd48, 0x2);
}

IIR_AssociationElement *
VHDLParser::association(void)
{
  IIR_AssociationElement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_AssociationElement *  ))
  
  _retv = NULL;
  IIR_AssociationElementByExpression *by_expression = NULL;
  IIR_AssociationElement *actual = NULL;
  if ( !guessing ) {
      _retv   = association_element();

  } else {
    association_element();
  }
  {
    if ( (LA(1)==EQUAL_GREATER) ) {
      zzmatch(EQUAL_GREATER); consume();
      if ( !guessing ) {
          actual   = association_element();

      } else {
        association_element();
      }
    }
    else {
      if ( (setwd48[LA(1)]&0x4) ) {
      }
      else {FAIL(1,err199,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  if( _retv->get_kind() == IIR_ASSOCIATION_ELEMENT_BY_EXPRESSION ){
    by_expression = (IIR_AssociationElementByExpression *)_retv;
    if (actual == NULL ){
      by_expression->set_actual( _retv->get_formal() );
      by_expression->set_formal( NULL );
    }
    else {
      // Then the second association holds the actual part in its 
      // "get_formal" method.
      by_expression->set_actual( actual->get_formal() );
#ifdef DEVLELOPER_ASSERTIONS
      ASSERT( actual->get_kind() == IIR_ASSOCIATION_ELEMENT_BY_EXPRESSION );
#endif	
      delete (IIR_AssociationElementByExpression *)actual;
    }
  }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd48, 0x8);
  return _retv;
}

IIR_AssociationElement *
VHDLParser::association_element(void)
{
  IIR_AssociationElement *   _retv;
  zzRULE;
  ANTLRTokenPtr open=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_AssociationElement *  ))
  
  _retv = NULL;
  IIR *expr = NULL;
  if ( (setwd48[LA(1)]&0x10) ) {
    if ( !guessing ) {
        expr   = expression();

    } else {
      expression();
    }
    if ( !guessing ) {
    
    _retv = new IIR_AssociationElementByExpression();
    _retv->set_formal( expr );
    IIR::copy_location( expr, _retv );
    }
  }
  else {
    if ( (LA(1)==OPEN) ) {
      zzmatch(OPEN);
      if ( !guessing ) {
            open = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = new IIR_AssociationElementOpen();
      _retv->set_formal( NULL );
      copy_location(open, _retv );
      }
 consume();
    }
    else {FAIL(1,err200,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd48, 0x20);
  return _retv;
}

void
VHDLParser::alias_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr alias=NULL;
  
  IIR_AliasDeclaration *new_decl = NULL;
  IIR_TextLiteral *designator = NULL;
  IIR_DesignatorExplicit *aliased_entity = NULL;
  IIR *aliased_entity_name = NULL;
  IIR_Signature *aliased_entity_signature = NULL;
  IIR_TypeDefinition *subtype = NULL;
  zzmatch(ALIAS);
  if ( !guessing ) {
    alias = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  new_decl = new IIR_AliasDeclaration();
  copy_location( alias,  new_decl );
  }
 consume();
  if ( !guessing ) {
     designator  = alias_designator();

  } else {
    alias_designator();
  }
  if ( !guessing ) {
  new_decl->set_declarator( designator );
  }
  {
    if ( (LA(1)==COLON)
 ) {
      zzmatch(COLON); consume();
      if ( !guessing ) {
         subtype  = alias_indication();

      } else {
        alias_indication();
      }
      if ( !guessing ) {
      new_decl->set_subtype( subtype );
      }
    }
    else {
      if ( (LA(1)==IS) ) {
      }
      else {FAIL(1,err201,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(IS); consume();
  if ( !guessing ) {
      aliased_entity_name   = complex_name();

  } else {
    complex_name();
  }
  if ( !guessing ) {
  new_decl->set_name( aliased_entity_name );
  }
  {
    if ( (LA(1)==L_BRACKET) ) {
      if ( !guessing ) {
          aliased_entity_signature   = signature();

      } else {
        signature();
      }
      if ( !guessing ) {
      
      aliased_entity = new IIR_DesignatorExplicit();
      aliased_entity->set_signature( aliased_entity_signature );
      aliased_entity->set_name( aliased_entity_name );
      new_decl->set_name( aliased_entity );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err202,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  new_decl->_type_check();
  list->append( new_decl );
  new_decl->_add_declaration();
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd48, 0x40);
}

IIR_TextLiteral *
VHDLParser::alias_designator(void)
{
  IIR_TextLiteral *   _retv;
  zzRULE;
  ANTLRTokenPtr char_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_TextLiteral *  ))
  _retv = NULL;
  if ( (setwd48[LA(1)]&0x80) ) {
    if ( !guessing ) {
       _retv  = identifier();

    } else {
      identifier();
    }
  }
  else {
    if ( (LA(1)==CHARACTER_LITERAL)
 ) {
      zzmatch(CHARACTER_LITERAL);
      if ( !guessing ) {
            char_lit = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = (IIR_TextLiteral*)mytoken(char_lit)->getIIRPtr();
      copy_location( char_lit, _retv );
      }
 consume();
    }
    else {
      if ( (LA(1)==STRING_LITERAL) ) {
        if ( !guessing ) {
           _retv  = operator_symbol();

        } else {
          operator_symbol();
        }
      }
      else {FAIL(1,err203,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd49, 0x1);
  return _retv;
}

IIR_TypeDefinition *
VHDLParser::alias_indication(void)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  zzGUESS_BLOCK
  IIR_TypeDefinition *base_type = NULL;
  zzGUESS
  if ( !zzrv && (setwd49[LA(1)]&0x2) && (setwd49[LA(2)]&0x4) ) {
    {
      if ( !guessing ) {
         base_type  = type_mark();

      } else {
        type_mark();
      }
      zzmatch(TOLERANCE); consume();
    }
    zzGUESS_DONE
    if (!(lang_proc->processing_vhdl_ams())      ) {zzfailed_pred("  lang_proc->processing_vhdl_ams()",1 /* user action */, {  lang_proc->report_not_vhdl_ams((ANTLRToken *)LT(1));  } );}
    if ( !guessing ) {
       _retv  = subnature_indication();

    } else {
      subnature_indication();
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd49[LA(1)]&0x8) && (setwd49[LA(2)]&0x10) ) {
      if ( !guessing ) {
         _retv  = subtype_indication();

      } else {
        subtype_indication();
      }
    }
    else {FAIL(2,err204,err205,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd49, 0x20);
  return _retv;
}

void
VHDLParser::component_declaration(IIR_DeclarationList * decl_list)
{
  zzRULE;
  ANTLRTokenPtr component=NULL;
  
  IIR_ComponentDeclaration *new_component = NULL;
  IIR_Identifier *start_identifier = NULL;
  IIR_Name *end_simple_name = NULL;
  zzmatch(COMPONENT);
  if ( !guessing ) {
    component = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  new_component = new IIR_ComponentDeclaration;
  copy_location( component, new_component );
  }
 consume();
  if ( !guessing ) {
     start_identifier  = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  
  new_component->set_declarator(start_identifier);
  new_component->_add_declaration_and_open_scope();
  }
  {
    if ( (LA(1)==IS) ) {
      zzmatch(IS); consume();
    }
    else {
      if ( (setwd49[LA(1)]&0x40)
 ) {
      }
      else {FAIL(1,err206,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==GENERIC) ) {
      generic_clause( &new_component->local_generic_clause );
    }
    else {
      if ( (setwd49[LA(1)]&0x80) ) {
      }
      else {FAIL(1,err207,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==PORT) ) {
      port_clause( &new_component->local_port_clause );
    }
    else {
      if ( (LA(1)==END) ) {
      }
      else {FAIL(1,err208,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(END); consume();
  zzmatch(COMPONENT); consume();
  {
    if ( (setwd50[LA(1)]&0x1)
 ) {
      if ( !guessing ) {
         end_simple_name  = simple_name();

      } else {
        simple_name();
      }
      if ( !guessing ) {
      check_name( start_identifier, end_simple_name, "component" );
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err209,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  decl_list->append( new_component );
  my_symbol_table->close_scope( new_component );
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd50, 0x2);
}

void
VHDLParser::generic_clause(IIR_GenericList * list)
{
  zzRULE;
  ANTLRTokenPtr generic=NULL;
  zzmatch(GENERIC);
  if ( !guessing ) {
    generic = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  copy_location( generic,  list );
  }
 consume();
  zzmatch(L_PAREN); consume();
  generic_list(  list );
  zzmatch(R_PAREN); consume();
  zzmatch(SEMI_COLON); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd50, 0x4);
}

void
VHDLParser::port_clause(IIR_PortList * list)
{
  zzRULE;
  ANTLRTokenPtr port=NULL;
  zzmatch(PORT);
  if ( !guessing ) {
    port = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  copy_location( port, list );
  }
 consume();
  zzmatch(L_PAREN); consume();
  port_list( list );
  zzmatch(R_PAREN); consume();
  zzmatch(SEMI_COLON); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd50, 0x8);
}

void
VHDLParser::generic_list(IIR_GenericList * list)
{
  zzRULE;
  interface_list( IIRScram_InterfaceDeclaration::GENERIC_INTERFACE_LIST, list );
  if ( !guessing ) {
  my_symbol_table->add_declaration( list );
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd50, 0x10);
}

void
VHDLParser::port_list(IIR_PortList * list)
{
  zzRULE;
  interface_list( IIRScram_InterfaceDeclaration::PORT_INTERFACE_LIST,list );
  if ( !guessing ) {
  my_symbol_table->add_declaration( list );
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd50, 0x20);
}

void
VHDLParser::group_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr keyword=NULL;
  
  IIR_Identifier *group_name = NULL;
  IIR_Name *group_template_name = NULL;
  IIR_GroupDeclaration *new_group_decl = new IIR_GroupDeclaration();
  zzmatch(GROUP);
  if ( !guessing ) {
    keyword = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     group_name  = identifier();

  } else {
    identifier();
  }
  zzmatch(COLON); consume();
  if ( !guessing ) {
      group_template_name   = selected_or_simple_name();

  } else {
    selected_or_simple_name();
  }
  if ( !guessing ) {
  
  if( group_template_name->_is_name() != TRUE ){
    // There is  no general purpose method for printing names yet.
    report_error("No group template by name [Internal error] found");
  }
  new_group_decl->set_group_template( group_template_name );
  }
  zzmatch(L_PAREN); consume();
  group_constituent_list(  &new_group_decl->group_constituent_list  );
  zzmatch(R_PAREN); consume();
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  new_group_decl->_add_declaration();
  list->append( new_group_decl );
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd50, 0x40);
}

void
VHDLParser::group_template_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr keyword=NULL;
  
  IIR_Identifier *group_name = NULL;
  IIR_GroupTemplateDeclaration *new_group_template_decl =  new IIR_GroupTemplateDeclaration();
  zzmatch(GROUP);
  if ( !guessing ) {
    keyword = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     group_name  = identifier();

  } else {
    identifier();
  }
  zzmatch(IS); consume();
  zzmatch(L_PAREN); consume();
  entity_class_entry_list(  &new_group_template_decl->entity_class_entry_list  );
  zzmatch(R_PAREN);
  if ( !guessing ) {
  
  new_group_template_decl->_add_declaration();
  list->append( new_group_template_decl );
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd50, 0x80);
}

void
VHDLParser::entity_class_entry_list(IIR_EntityClassEntryList * list)
{
  zzRULE;
  IIR_EntityClassEntry *ent_class_entry = NULL;
  if ( !guessing ) {
      ent_class_entry   = entity_class_entry();

  } else {
    entity_class_entry();
  }
  if ( !guessing ) {
  list->append( ent_class_entry );
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
          ent_class_entry   = entity_class_entry();

      } else {
        entity_class_entry();
      }
      if ( !guessing ) {
      list->append( ent_class_entry );
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd51, 0x1);
}

IIR_EntityClassEntry *
VHDLParser::entity_class_entry(void)
{
  IIR_EntityClassEntry *   _retv;
  zzRULE;
  ANTLRTokenPtr box=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_EntityClassEntry *  ))
  
  _retv = NULL;
  IIR_Identifier *not_used = NULL;
  IIR_Kind ent_class;
  IIR_Boolean (IIR_Declaration::*constraining_method )();
  if ( !guessing ) {
  _retv = new IIR_EntityClassEntry();
  }
  if ( !guessing ) {
    { struct _rv113 _trv; _trv = entity_class();

    not_used = _trv.identifier_part; ent_class = _trv.kind_part; constraining_method  = _trv.constraining_function; }
  } else {
    entity_class();
  }
  if ( !guessing ) {
  _retv->set_entity_kind( ent_class );
  }
  {
    if ( (LA(1)==LESS_GREATER) ) {
      zzmatch(LESS_GREATER);
      if ( !guessing ) {
            box = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      _retv->set_boxed( TRUE );
      }
 consume();
    }
    else {
      if ( (setwd51[LA(1)]&0x2) ) {
      }
      else {FAIL(1,err210,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd51, 0x4);
  return _retv;
}

void
VHDLParser::group_constituent_list(IIR_DesignatorList * list)
{
  zzRULE;
  IIR_GroupConstituent *current_constituent = NULL;
  if ( !guessing ) {
  list = new IIR_DesignatorList();
  }
  if ( !guessing ) {
      current_constituent   = group_constituent();

  } else {
    group_constituent();
  }
  if ( !guessing ) {
  
  IIR_DesignatorExplicit *list_element = new IIR_DesignatorExplicit();
  IIR::copy_location( current_constituent, list_element );
  list_element->set_name( current_constituent );
  list->append( list_element );
  }
  {
    while ( (LA(1)==COMMA)
 ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
          current_constituent   = group_constituent();

      } else {
        group_constituent();
      }
      if ( !guessing ) {
      
      IIR_DesignatorExplicit *list_element = new IIR_DesignatorExplicit();
      IIR::copy_location( current_constituent, list_element );
      list_element->set_name( current_constituent );
      list->append( list_element );
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd51, 0x8);
}

IIR_GroupConstituent *
VHDLParser::group_constituent(void)
{
  IIR_GroupConstituent *   _retv;
  zzRULE;
  ANTLRTokenPtr char_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_GroupConstituent *  ))
  zzGUESS_BLOCK
  IIR *name = NULL;
  zzGUESS
  if ( !zzrv && (LA(1)==CHARACTER_LITERAL) && (setwd51[LA(2)]&0x10) ) {
    {
      zzmatch(CHARACTER_LITERAL); consume();
    }
    zzGUESS_DONE
    zzmatch(CHARACTER_LITERAL);
    if ( !guessing ) {
        char_lit = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    IIR_Literal *lit = (IIR_Literal*)mytoken(char_lit)->getIIRPtr();
    copy_location( char_lit, lit );
    _retv = new IIR_GroupConstituent();
    _retv->set_name( lit );
    copy_location( char_lit, _retv );
    }
 consume();
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd51[LA(1)]&0x20) && (setwd51[LA(2)]&0x40) ) {
      if ( !guessing ) {
          name   = complex_name();

      } else {
        complex_name();
      }
      if ( !guessing ) {
      
      _retv = new IIR_GroupConstituent();
      _retv->set_name( name );
      }
    }
    else {FAIL(2,err211,err212,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd51, 0x80);
  return _retv;
}

IIR *
VHDLParser::boolean_expression(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  if ( !guessing ) {
     _retv  = expression();

  } else {
    expression();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd52, 0x1);
  return _retv;
}

IIR *
VHDLParser::time_expression(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  if ( !guessing ) {
     _retv  = expression();

  } else {
    expression();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd52, 0x2);
  return _retv;
}

IIR *
VHDLParser::expression(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  if ( !guessing ) {
     _retv  = relation();

  } else {
    relation();
  }
  if ( !guessing ) {
     wk  = expression_tail( _retv );

  } else {
    expression_tail( _retv );
  }
  if ( !guessing ) {
  if (wk!=NULL) {_retv = wk;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd52, 0x4);
  return _retv;
}

IIR *
VHDLParser::expression_tail(IIR * p)
{
  IIR *   _retv;
  zzRULE;
  ANTLRTokenPtr logic1_op=NULL, logic2_op=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  IIR_DyadicOperator *be = NULL;
  IIR *wk = NULL;
  _retv =  p;
  if ( (setwd52[LA(1)]&0x8) && (setwd52[LA(2)]&0x10) && !( LA(1)==1 && LA(2)==1) ) {
    {
      int zzcnt=1;
      zzGUESS_BLOCK
      do {
        zzGUESS
        if ( !zzrv && (setwd52[LA(1)]&0x20) && (setwd52[LA(2)]&0x40) ) {
          {
            zzsetmatch(AND_OR_XOR_XNOR_set, AND_OR_XOR_XNOR_errset); consume();
          }
          zzGUESS_DONE
          zzsetmatch(AND_OR_XOR_XNOR_set, AND_OR_XOR_XNOR_errset);
          if ( !guessing ) {
                    logic1_op = (ANTLRTokenPtr)LT(1);
          }
           consume();
          if ( !guessing ) {
             wk  = relation();

          } else {
            relation();
          }
          if ( !guessing ) {
          
          switch (logic1_op->getType()) {
            case AND: 
            be = new IIR_AndOperator();
            break;
            case OR: 
            be = new IIR_OrOperator();
            break;
            case XOR:
            be = new IIR_XorOperator();
            break;
            case XNOR:
            be = new IIR_XnorOperator();
            break;
            default: 
            //	    panic("rule \"expression_tail\" ");
            break;
          }
          copy_location( logic1_op, be );
          be->set_left_operand(_retv);
          be->set_right_operand(wk);
          _retv = be;
          }
        }
        /* MR10 ()+ */ else {
          /* MR10 ()+ */ if ( !zzrv ) zzGUESS_DONE;
          /* MR10 ()+ */ if ( zzcnt > 1 ) break;
          else {FAIL(2,err215,err216,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
        zzcnt++;
      } while ( 1 );
    }
  }
  else {
    if ( (setwd52[LA(1)]&0x80) && 
(setwd53[LA(2)]&0x1) ) {
      {
        zzGUESS_BLOCK
        zzGUESS
        if ( !zzrv && (setwd53[LA(1)]&0x2) && (setwd53[LA(2)]&0x4) ) {
          {
            zzsetmatch(NAND_NOR_set, NAND_NOR_errset); consume();
          }
          zzGUESS_DONE
          zzsetmatch(NAND_NOR_set, NAND_NOR_errset);
          if ( !guessing ) {
                    logic2_op = (ANTLRTokenPtr)LT(1);
          }
           consume();
          if ( !guessing ) {
             wk  = relation();

          } else {
            relation();
          }
          if ( !guessing ) {
          
          switch (logic2_op->getType()) {
            case NAND: 
            be = new IIR_NandOperator();
            break;
            case NOR: 
            be = new IIR_NorOperator();
            break;
            default: 
            //		report_error(add_op, "Internal Compiler Error");
            break;
          }
          copy_location( logic2_op, be );
          be->set_left_operand(_retv);
          be->set_right_operand(wk);
          _retv = be;
          }
        }
        else {
          if ( !zzrv ) zzGUESS_DONE;
          if ( (setwd53[LA(1)]&0x8) && (setwd53[LA(2)]&0x10) ) {
          }
          else {FAIL(2,err219,err220,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
    else {FAIL(2,err221,err222,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd53, 0x20);
  return _retv;
}

IIR *
VHDLParser::relation(void)
{
  IIR *   _retv;
  zzRULE;
  ANTLRTokenPtr rel_op=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR_DyadicOperator *be = NULL;
  IIR *wk = NULL;
  if ( !guessing ) {
     _retv  = shift_expression();

  } else {
    shift_expression();
  }
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (setwd53[LA(1)]&0x40) && (setwd53[LA(2)]&0x80) ) {
      {
        zzsetmatch(RELATIONAL_OPERATOR_set, RELATIONAL_OPERATOR_errset); consume();
      }
      zzGUESS_DONE
      zzsetmatch(RELATIONAL_OPERATOR_set, RELATIONAL_OPERATOR_errset);
      if ( !guessing ) {
            rel_op = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         wk  = shift_expression();

      } else {
        shift_expression();
      }
      if ( !guessing ) {
      
      switch (rel_op->getType()) {
        case EQUAL: 
        be = new IIR_EqualityOperator();
        break;
        case NOT_EQUAL: 
        be = new IIR_InequalityOperator();
        break;
        case LESS:
        be = new IIR_LessThanOperator();
        break;
        case LESS_EQUAL:
        be = new IIR_LessThanOrEqualOperator();
        break;
        case GREATER:
        be = new IIR_GreaterThanOperator();
        break;
        case GREATER_EQUAL:
        be = new IIR_GreaterThanOrEqualOperator();
        break;
        default: 
        //		report_error(add_op, "Internal Compiler Error");
        break;
      }
      copy_location( rel_op, be );
      be->set_left_operand(_retv);
      be->set_right_operand(wk);
      _retv = be;
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd54[LA(1)]&0x1) && (setwd54[LA(2)]&0x2) ) {
      }
      else {FAIL(2,err225,err226,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd54, 0x4);
  return _retv;
}

IIR *
VHDLParser::shift_expression(void)
{
  IIR *   _retv;
  zzRULE;
  ANTLRTokenPtr shift_op=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR_DyadicOperator *be = NULL;
  IIR *wk = NULL;
  if ( !guessing ) {
     _retv  = simple_expression();

  } else {
    simple_expression();
  }
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (setwd54[LA(1)]&0x8) && 
(setwd54[LA(2)]&0x10) ) {
      {
        zzsetmatch(SHIFT_OPERATOR_set, SHIFT_OPERATOR_errset); consume();
      }
      zzGUESS_DONE
      zzsetmatch(SHIFT_OPERATOR_set, SHIFT_OPERATOR_errset);
      if ( !guessing ) {
            shift_op = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         wk  = simple_expression();

      } else {
        simple_expression();
      }
      if ( !guessing ) {
      
      switch (shift_op->getType()) {
        case SLL: 
        be = new IIR_SLLOperator();
        break;
        case SLA: 
        be = new IIR_SLAOperator();
        break;
        case SRL: 
        be = new IIR_SRLOperator();
        break;
        case SRA: 
        be = new IIR_SRAOperator();
        break;
        case ROL: 
        be = new IIR_ROLOperator();
        break;
        case ROR: 
        be = new IIR_ROROperator();
        break;
        default: 
        //	        report_error(add_op, "Internal Compiler Error");
        break;
      }
      copy_location( shift_op, be );
      be->set_left_operand(_retv);
      be->set_right_operand(wk);
      _retv = be;
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd54[LA(1)]&0x20) && (setwd54[LA(2)]&0x40) ) {
      }
      else {FAIL(2,err229,err230,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd54, 0x80);
  return _retv;
}

IIR *
VHDLParser::simple_expression(void)
{
  IIR *   _retv;
  zzRULE;
  ANTLRTokenPtr sign_op=NULL, add_op=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR_DyadicOperator *be = NULL;
  IIR_MonadicOperator *ue = NULL;
  IIR *wk = NULL;
  IIR_Boolean sign_op_present = FALSE;
  {
    if ( (setwd55[LA(1)]&0x1) ) {
      zzsetmatch(SIGN_OPERATOR_set, SIGN_OPERATOR_errset);
      if ( !guessing ) {
            sign_op = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      sign_op_present = TRUE;
      }
 consume();
    }
    else {
      if ( (setwd55[LA(1)]&0x2) ) {
      }
      else {FAIL(1,err233,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
     _retv  = term();

  } else {
    term();
  }
  if ( !guessing ) {
  
  if( sign_op_present == TRUE ){
    switch (sign_op->getType()) {
      case PLUS: 
      ue = new IIR_IdentityOperator();
      break;
      case MINUS: 
      ue = new IIR_NegationOperator();
      break;
      default: 
      ASSERT( 0 );
      break;
    }
    copy_location( sign_op, ue );
    ue->set_operand(_retv);
    _retv = ue;
  }
  }
  {
    zzGUESS_BLOCK
    for (;;) {
      if ( !((setwd55[LA(1)]&0x4) && (setwd55[LA(2)]&0x8))) break;
      zzGUESS
      if ( !zzrv ) {
        {
          zzsetmatch(ADDING_OPERATOR_set, ADDING_OPERATOR_errset); consume();
        }
        zzGUESS_DONE
        zzsetmatch(ADDING_OPERATOR_set, ADDING_OPERATOR_errset);
        if ( !guessing ) {
                add_op = (ANTLRTokenPtr)LT(1);
        }
         consume();
        if ( !guessing ) {
           wk  = term();

        } else {
          term();
        }
        if ( !guessing ) {
        
        switch (add_op->getType()) {
          case PLUS: 
          be = new IIR_AdditionOperator();
          break;
          case MINUS: 
          be = new IIR_SubtractionOperator();
          break;
          case AMPERSAND:
          be = new IIR_ConcatenationOperator();
          break;
          default: 
          ASSERT( 0 );
          break;
        }
        copy_location( add_op, be );
        be->set_left_operand(_retv);
        be->set_right_operand(wk);
        _retv = be;
        }
      } else break; /* MR6 code for exiting loop "for sure" */
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd55, 0x10);
  return _retv;
}

IIR *
VHDLParser::term(void)
{
  IIR *   _retv;
  zzRULE;
  ANTLRTokenPtr mult_op=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR_DyadicOperator *be = NULL;
  IIR *wk = NULL;
  if ( !guessing ) {
     _retv  = factor();

  } else {
    factor();
  }
  {
    zzGUESS_BLOCK
    for (;;) {
      if ( !((setwd55[LA(1)]&0x20) && 
(setwd55[LA(2)]&0x40))) break;
      zzGUESS
      if ( !zzrv ) {
        {
          zzsetmatch(MULTIPLYING_OPERATOR_set, MULTIPLYING_OPERATOR_errset); consume();
        }
        zzGUESS_DONE
        zzsetmatch(MULTIPLYING_OPERATOR_set, MULTIPLYING_OPERATOR_errset);
        if ( !guessing ) {
                mult_op = (ANTLRTokenPtr)LT(1);
        }
         consume();
        if ( !guessing ) {
           wk  = factor();

        } else {
          factor();
        }
        if ( !guessing ) {
        
        switch (mult_op->getType()) {
          case MULTIPLY: 
          be = new IIR_MultiplicationOperator();
          break;
          case DIVIDE: 
          be = new IIR_DivisionOperator();
          break;
          case MOD: 
          be = new IIR_ModulusOperator();
          break;
          case REM: 
          be = new IIR_RemainderOperator();
          break;
          default: 
          //		report_error(add_op, "Internal Compiler Error");
          break;
        }
        copy_location( mult_op, be );
        be->set_left_operand(_retv);
        be->set_right_operand(wk);
        _retv = be;
        }
      } else break; /* MR6 code for exiting loop "for sure" */
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd55, 0x80);
  return _retv;
}

IIR *
VHDLParser::factor(void)
{
  IIR *   _retv;
  zzRULE;
  ANTLRTokenPtr exp=NULL, abs_not=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR_DyadicOperator *be = NULL;
  IIR_MonadicOperator *ue = NULL;
  IIR *wk = NULL;
  if ( (setwd56[LA(1)]&0x1) ) {
    if ( !guessing ) {
       _retv  = primary();

    } else {
      primary();
    }
    {
      zzGUESS_BLOCK
      zzGUESS
      if ( !zzrv && (LA(1)==EXPONENT) && (setwd56[LA(2)]&0x2) ) {
        {
          zzmatch(EXPONENT);
          if ( !guessing ) {
                    exp = (ANTLRTokenPtr)LT(1);
          }
           consume();
          if ( !guessing ) {
             wk  = primary();

          } else {
            primary();
          }
        }
        zzGUESS_DONE
        {
          zzmatch(EXPONENT);
          if ( !guessing ) {
                    exp = (ANTLRTokenPtr)LT(1);
          }
           consume();
          if ( !guessing ) {
             wk  = primary();

          } else {
            primary();
          }
        }
        if ( !guessing ) {
        
        be = new IIR_ExponentiationOperator();
        copy_location( exp, be );
        be->set_left_operand(_retv);
        be->set_right_operand(wk);
        _retv = be;
        }
      }
      else {
        if ( !zzrv ) zzGUESS_DONE;
        if ( (setwd56[LA(1)]&0x4) && (setwd56[LA(2)]&0x8) ) {
        }
        else {FAIL(2,err238,err239,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
  }
  else {
    if ( (setwd56[LA(1)]&0x10) ) {
      zzsetmatch(ABS_NOT_set, ABS_NOT_errset);
      if ( !guessing ) {
            abs_not = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         wk  = primary();

      } else {
        primary();
      }
      if ( !guessing ) {
      
      switch (abs_not->getType()) {
        case ABS: 
        ue = new IIR_AbsoluteOperator();
        break;
        case NOT:
        ue = new IIR_NotOperator();
        break;
        default: 
        //    report_error(add_op, "Internal Compiler Error");
        break;
      }
      copy_location( abs_not, ue );
      ue->set_operand(wk);      
      _retv = ue;
      }
    }
    else {FAIL(1,err242,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd56, 0x20);
  return _retv;
}

IIR *
VHDLParser::numeric_literal(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR_Literal *lit = NULL;
  IIR_Name *unit_name = NULL;
  if ( !guessing ) {
     lit  = abstract_literal();

  } else {
    abstract_literal();
  }
  if ( !guessing ) {
  _retv = lit;
  }
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (setwd56[LA(1)]&0x40)
 ) {
      {
        zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset); consume();
      }
      zzGUESS_DONE
      if ( !guessing ) {
         unit_name  = complex_name();

      } else {
        complex_name();
      }
      if ( !guessing ) {
      
      set<IIR_Declaration> *decl_set = unit_name->_symbol_lookup();
      if( decl_set == NULL ){
        report_undefined_symbol( unit_name );
      }
      IIR_Declaration *decl = resolve_if_one( decl_set, unit_name );
      if( decl != NULL ){
        if( decl->get_kind() != IIR_PHYSICAL_UNIT ){
          ostringstream err;
          err << *unit_name << " has not been declared as a physical unit in"
          << " this scope.";
          report_error( unit_name, err.str() );
        }
        else{
          IIR_PhysicalUnit *pu = (IIR_PhysicalUnit *)decl;
          IIR_PhysicalLiteral *phys_lit = new IIR_PhysicalLiteral();
          IIR::copy_location( unit_name, phys_lit );
          phys_lit->set_abstract_literal( lit ); 
          phys_lit->set_unit_name( pu );
          _retv = phys_lit;
        }
      }
      else{
        panic("Resolution failed in numeric literal");
      }
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd56[LA(1)]&0x80) ) {
      }
      else {FAIL(1,err243,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd57, 0x1);
  return _retv;
}

IIR *
VHDLParser::literal(void)
{
  IIR *   _retv;
  zzRULE;
  ANTLRTokenPtr char_lit=NULL, string_lit=NULL, bit_string_lit=NULL, null_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR_EnumerationLiteral *eliteral = NULL;
  if ( (setwd57[LA(1)]&0x2) ) {
    if ( !guessing ) {
        _retv   = numeric_literal();

    } else {
      numeric_literal();
    }
  }
  else {
    if ( (LA(1)==CHARACTER_LITERAL) ) {
      zzmatch(CHARACTER_LITERAL);
      if ( !guessing ) {
            char_lit = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      eliteral = new IIR_EnumerationLiteral();
      copy_location( char_lit, eliteral );
      eliteral->set_declarator( (IIR_TextLiteral*)mytoken(char_lit)->getIIRPtr() );          
      _retv = eliteral;
      }
 consume();
    }
    else {
      if ( (LA(1)==STRING_LITERAL) ) {
        zzmatch(STRING_LITERAL);
        if ( !guessing ) {
                string_lit = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        
        _retv = (IIR_StringLiteral*)mytoken(string_lit)->getIIRPtr();
        copy_location( string_lit, _retv );
        }
 consume();
      }
      else {
        if ( (LA(1)==BIT_STRING_LITERAL)
 ) {
          zzmatch(BIT_STRING_LITERAL);
          if ( !guessing ) {
                    bit_string_lit = (ANTLRTokenPtr)LT(1);
          }
          
          if ( !guessing ) {
          
          _retv = (IIR_BitStringLiteral*)mytoken(bit_string_lit)->getIIRPtr();
          copy_location( bit_string_lit, _retv );
          }
 consume();
        }
        else {
          if ( (LA(1)==NULL_) ) {
            zzmatch(NULL_);
            if ( !guessing ) {
                        null_lit = (ANTLRTokenPtr)LT(1);
            }
            
            if ( !guessing ) {
            
            _retv = IIR_StringLiteral::get( "null", 4); 
            copy_location( null_lit, _retv );
            }
 consume();
          }
          else {FAIL(1,err244,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd57, 0x4);
  return _retv;
}

IIR *
VHDLParser::primary(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR_Aggregate *new_aggregate = NULL;
  zzGUESS
  if ( !zzrv && (setwd57[LA(1)]&0x8) && (setwd57[LA(2)]&0x10) ) {
    {
      zzmatch(STRING_LITERAL); consume();
      zzmatch(L_PAREN); consume();
    }
    zzGUESS_DONE
    if ( !guessing ) {
       _retv  = complex_name();

    } else {
      complex_name();
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    zzGUESS
    if ( !zzrv && (setwd57[LA(1)]&0x20) && (setwd57[LA(2)]&0x40) ) {
      {
        if ( !guessing ) {
           _retv  = literal();

        } else {
          literal();
        }
      }
      zzGUESS_DONE
      {
        if ( !guessing ) {
           _retv  = literal();

        } else {
          literal();
        }
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd57[LA(1)]&0x80) && (setwd58[LA(2)]&0x1) ) {
        if ( !guessing ) {
           _retv  = complex_name();

        } else {
          complex_name();
        }
      }
      else {
        if ( !zzrv ) zzGUESS_DONE;
        if ( (LA(1)==NEW)
 ) {
          if ( !guessing ) {
             _retv  = allocator();

          } else {
            allocator();
          }
        }
        else {
          if ( !zzrv ) zzGUESS_DONE;
          if ( (LA(1)==L_PAREN) ) {
            if ( !guessing ) {
                new_aggregate   = aggregate();

            } else {
              aggregate();
            }
            if ( !guessing ) {
            _retv = reduce_aggregate( new_aggregate );
            }
          }
          else {FAIL(2,err245,err246,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd58, 0x2);
  return _retv;
}

IIR_AssociationList *
VHDLParser::association_list_out(void)
{
  IIR_AssociationList *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_AssociationList *  ))
  
  _retv = NULL;
  IIR_AssociationElement *expr = NULL;
  if ( !guessing ) {
     expr  = element_association();

  } else {
    element_association();
  }
  if ( !guessing ) {
  
  _retv = new IIR_AssociationList();
  _retv->append(expr);
  //    IIR::copy_location( expr, $list );
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         expr  = element_association();

      } else {
        element_association();
      }
      if ( !guessing ) {
      _retv->append(expr);
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd58, 0x4);
  return _retv;
}

IIR_Allocator *
VHDLParser::allocator(void)
{
  IIR_Allocator *   _retv;
  zzRULE;
  ANTLRTokenPtr new_=NULL, new__=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Allocator *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR_TypeDefinition *type = NULL;
  IIR_Name *qualified_expression = NULL;
  zzGUESS
  if ( !zzrv && (LA(1)==NEW) && (setwd58[LA(2)]&0x8) ) {
    {
      zzmatch(NEW);
      if ( !guessing ) {
            new_ = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         type  = subtype_indication();

      } else {
        subtype_indication();
      }
      if ( !guessing ) {
      
      _retv = new IIR_Allocator();
      copy_location( new_, _retv );
      _retv->set_type_mark(type);
      }
    }
    zzGUESS_DONE
    {
      zzmatch(NEW);
      if ( !guessing ) {
            new_ = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         type  = subtype_indication();

      } else {
        subtype_indication();
      }
      if ( !guessing ) {
      
      _retv = new IIR_Allocator();
      copy_location( new_, _retv );
      _retv->set_type_mark(type);
      }
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (LA(1)==NEW) && (setwd58[LA(2)]&0x10) ) {
      {
        zzmatch(NEW);
        if ( !guessing ) {
                new__ = (ANTLRTokenPtr)LT(1);
        }
         consume();
        if ( !guessing ) {
            qualified_expression   = complex_name();

        } else {
          complex_name();
        }
        if ( !guessing ) {
        
        if( qualified_expression->get_kind() == IIR_USER_ATTRIBUTE ){
          _retv = new IIR_Allocator();
          copy_location( new__, _retv );
          IIR_UserAttribute *as_attr = (IIR_UserAttribute *)qualified_expression;
          
	set<IIR_TypeDefinition> *allocator_types = qualified_expression->_get_rval_set();
          if( allocator_types == NULL ){
            report_undefined_symbol( qualified_expression );
          }
          
	switch( allocator_types->num_elements() ){
            case 0:{
              // This shouldn't be possible.
              ASSERT(0);
              break;
            }
            case 1:{
            IIR_TypeDefinition *allocator_type = allocator_types->get_element();
            _retv->set_type_mark( allocator_type );
            
	  IIR *initializer = as_attr->get_suffix();
            if( initializer != NULL ){
            initializer = initializer->_semantic_transform( allocator_type );
            initializer->_type_check( allocator_type );
            initializer = initializer->_rval_to_decl( allocator_type );
          }
          
	  _retv->set_value( initializer );
          
	  break;
        }
        default:{
        report_ambiguous_error( qualified_expression, allocator_types );
        break;
      }
    }
  }
  else{
  ostringstream err;
  err << "Allocators apply to subtypes, and qualifed expressions. |" << *qualified_expression
  << "| is neither.";
  report_error( qualified_expression, err.str() );
}
        }
      }
    }
    else {FAIL(2,err247,err248,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd58, 0x20);
  return _retv;
}

IIR_AssociationElement *
VHDLParser::element_association(void)
{
  IIR_AssociationElement *   _retv;
  zzRULE;
  ANTLRTokenPtr line_info=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_AssociationElement *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR *expr = NULL;
  IIR_CaseStatementAlternative *alt = NULL;
  zzGUESS
  if ( !zzrv && (setwd58[LA(1)]&0x40) && 
(setwd58[LA(2)]&0x80) ) {
    {
      if ( !guessing ) {
         alt  = choices();

      } else {
        choices();
      }
      zzmatch(EQUAL_GREATER);
      if ( !guessing ) {
            line_info = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         expr  = expression();

      } else {
        expression();
      }
    }
    zzGUESS_DONE
    {
      if ( !guessing ) {
         alt  = choices();

      } else {
        choices();
      }
      zzmatch(EQUAL_GREATER);
      if ( !guessing ) {
            line_info = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         expr  = expression();

      } else {
        expression();
      }
    }
    if ( !guessing ) {
    
    switch( alt->get_kind() ){
      case IIR_CASE_STATEMENT_ALTERNATIVE_BY_OTHERS:{
        IIR_AssociationElementByExpression *by_expr = new IIR_AssociationElementByExpression();
        by_expr->set_actual( expr );
        IIR_OthersInitialization *others = new IIR_OthersInitialization();
        others->set_expression( expr );
        by_expr->set_formal( others );
        delete (IIR_CaseStatementAlternativeByOthers *)alt;
        _retv = by_expr;
        break;
      }
      case IIR_CASE_STATEMENT_ALTERNATIVE_BY_EXPRESSION:{
        IIR_AssociationElementByExpression *by_expr = new IIR_AssociationElementByExpression();
        IIR_CaseStatementAlternativeByExpression *case_by_expression = 
        (IIR_CaseStatementAlternativeByExpression *)alt;
        
      by_expr->set_actual( expr );
        by_expr->set_formal( case_by_expression->get_choice()->get_value() );
        
      delete case_by_expression;
        
      _retv = by_expr;
        break;
      }
      default:{
        panic("Default case reached in VHDLParser::element_association");
      }
    }
    copy_location( line_info, _retv );
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd59[LA(1)]&0x1) && (setwd59[LA(2)]&0x2) ) {
      if ( !guessing ) {
         _retv  = association();

      } else {
        association();
      }
    }
    else {FAIL(2,err249,err250,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd59, 0x4);
  return _retv;
}

IIR_Name *
VHDLParser::complex_name(void)
{
  IIR_Name *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = attribute_name();

  } else {
    attribute_name();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd59, 0x8);
  return _retv;
}

IIR_Name *
VHDLParser::attribute_name(void)
{
  IIR_Name *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = selected_name();

  } else {
    selected_name();
  }
  {
    while ( (LA(1)==QUOTE) ) {
      zzmatch(QUOTE); consume();
      if ( !guessing ) {
         _retv  = attribute( _retv );

      } else {
        attribute( _retv );
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd59, 0x10);
  return _retv;
}

IIR_Name *
VHDLParser::attribute(IIR_Name * prefix)
{
  IIR_Name *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR *wk = NULL;
  IIR_Aggregate *initializer = NULL;
  zzGUESS
  if ( !zzrv && (setwd59[LA(1)]&0x20) ) {
    {
      if ( !guessing ) {
         wk  = selected_name();

      } else {
        selected_name();
      }
    }
    zzGUESS_DONE
    if ( !guessing ) {
       _retv  = attribute_user_defined( prefix );

    } else {
      attribute_user_defined( prefix );
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (LA(1)==ABOVE) ) {
      if ( !guessing ) {
         _retv  = attribute_above( prefix );

      } else {
        attribute_above( prefix );
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (LA(1)==ACTIVE)
 ) {
        if ( !guessing ) {
           _retv  = attribute_active( prefix );

        } else {
          attribute_active( prefix );
        }
      }
      else {
        if ( !zzrv ) zzGUESS_DONE;
        if ( (LA(1)==ASCENDING) ) {
          if ( !guessing ) {
             _retv  = attribute_ascending( prefix );

          } else {
            attribute_ascending( prefix );
          }
        }
        else {
          if ( !zzrv ) zzGUESS_DONE;
          if ( (LA(1)==BASE) ) {
            if ( !guessing ) {
               _retv  = attribute_base( prefix );

            } else {
              attribute_base( prefix );
            }
          }
          else {
            if ( !zzrv ) zzGUESS_DONE;
            if ( (LA(1)==CONTRIBUTION) ) {
              if ( !guessing ) {
                 _retv  = attribute_contribution( prefix );

              } else {
                attribute_contribution( prefix );
              }
            }
            else {
              if ( !zzrv ) zzGUESS_DONE;
              if ( (LA(1)==DELAYED) ) {
                if ( !guessing ) {
                   _retv  = attribute_delayed( prefix );

                } else {
                  attribute_delayed( prefix );
                }
              }
              else {
                if ( !zzrv ) zzGUESS_DONE;
                if ( (LA(1)==DOT_)
 ) {
                  if ( !guessing ) {
                     _retv  = attribute_dot( prefix );

                  } else {
                    attribute_dot( prefix );
                  }
                }
                else {
                  if ( !zzrv ) zzGUESS_DONE;
                  if ( (LA(1)==DRIVING_VALUE) ) {
                    if ( !guessing ) {
                       _retv  = attribute_driving_value( prefix );

                    } else {
                      attribute_driving_value( prefix );
                    }
                  }
                  else {
                    if ( !zzrv ) zzGUESS_DONE;
                    if ( (LA(1)==DRIVING) ) {
                      if ( !guessing ) {
                         _retv  = attribute_driving( prefix );

                      } else {
                        attribute_driving( prefix );
                      }
                    }
                    else {
                      if ( !zzrv ) zzGUESS_DONE;
                      if ( (LA(1)==EVENT) ) {
                        if ( !guessing ) {
                           _retv  = attribute_event( prefix );

                        } else {
                          attribute_event( prefix );
                        }
                      }
                      else {
                        if ( !zzrv ) zzGUESS_DONE;
                        if ( (LA(1)==HIGH) ) {
                          if ( !guessing ) {
                             _retv  = attribute_high( prefix );

                          } else {
                            attribute_high( prefix );
                          }
                        }
                        else {
                          if ( !zzrv ) zzGUESS_DONE;
                          if ( (LA(1)==IMAGE)
 ) {
                            if ( !guessing ) {
                               _retv  = attribute_image( prefix );

                            } else {
                              attribute_image( prefix );
                            }
                          }
                          else {
                            if ( !zzrv ) zzGUESS_DONE;
                            if ( (LA(1)==INSTANCE_NAME) ) {
                              if ( !guessing ) {
                                 _retv  = attribute_instance_name( prefix );

                              } else {
                                attribute_instance_name( prefix );
                              }
                            }
                            else {
                              if ( !zzrv ) zzGUESS_DONE;
                              if ( (LA(1)==LAST_ACTIVE) ) {
                                if ( !guessing ) {
                                   _retv  = attribute_last_active( prefix );

                                } else {
                                  attribute_last_active( prefix );
                                }
                              }
                              else {
                                if ( !zzrv ) zzGUESS_DONE;
                                if ( (LA(1)==LAST_EVENT) ) {
                                  if ( !guessing ) {
                                     _retv  = attribute_last_event( prefix );

                                  } else {
                                    attribute_last_event( prefix );
                                  }
                                }
                                else {
                                  if ( !zzrv ) zzGUESS_DONE;
                                  if ( (LA(1)==LAST_VALUE) ) {
                                    if ( !guessing ) {
                                       _retv  = attribute_last_value( prefix );

                                    } else {
                                      attribute_last_value( prefix );
                                    }
                                  }
                                  else {
                                    if ( !zzrv ) zzGUESS_DONE;
                                    if ( (LA(1)==LEFTOF)
 ) {
                                      if ( !guessing ) {
                                         _retv  = attribute_leftof( prefix );

                                      } else {
                                        attribute_leftof( prefix );
                                      }
                                    }
                                    else {
                                      if ( !zzrv ) zzGUESS_DONE;
                                      if ( (LA(1)==LEFT) ) {
                                        if ( !guessing ) {
                                           _retv  = attribute_left( prefix );

                                        } else {
                                          attribute_left( prefix );
                                        }
                                      }
                                      else {
                                        if ( !zzrv ) zzGUESS_DONE;
                                        if ( (LA(1)==LENGTH) ) {
                                          if ( !guessing ) {
                                             _retv  = attribute_length( prefix );

                                          } else {
                                            attribute_length( prefix );
                                          }
                                        }
                                        else {
                                          if ( !zzrv ) zzGUESS_DONE;
                                          if ( (LA(1)==LOW) ) {
                                            if ( !guessing ) {
                                               _retv  = attribute_low( prefix );

                                            } else {
                                              attribute_low( prefix );
                                            }
                                          }
                                          else {
                                            if ( !zzrv ) zzGUESS_DONE;
                                            if ( (LA(1)==LTF) ) {
                                              if ( !guessing ) {
                                                 _retv  = attribute_ltf( prefix );

                                              } else {
                                                attribute_ltf( prefix );
                                              }
                                            }
                                            else {
                                              if ( !zzrv ) zzGUESS_DONE;
                                              if ( (LA(1)==PATH_NAME)
 ) {
                                                if ( !guessing ) {
                                                   _retv  = attribute_path_name( prefix );

                                                } else {
                                                  attribute_path_name( prefix );
                                                }
                                              }
                                              else {
                                                if ( !zzrv ) zzGUESS_DONE;
                                                if ( (LA(1)==POS) ) {
                                                  if ( !guessing ) {
                                                     _retv  = attribute_pos( prefix );

                                                  } else {
                                                    attribute_pos( prefix );
                                                  }
                                                }
                                                else {
                                                  if ( !zzrv ) zzGUESS_DONE;
                                                  if ( (LA(1)==PRED) ) {
                                                    if ( !guessing ) {
                                                       _retv  = attribute_pred( prefix );

                                                    } else {
                                                      attribute_pred( prefix );
                                                    }
                                                  }
                                                  else {
                                                    if ( !zzrv ) zzGUESS_DONE;
                                                    if ( (LA(1)==RANGE) ) {
                                                      if ( !guessing ) {
                                                         _retv  = attribute_range( prefix );

                                                      } else {
                                                        attribute_range( prefix );
                                                      }
                                                    }
                                                    else {
                                                      if ( !zzrv ) zzGUESS_DONE;
                                                      if ( (LA(1)==REFERENCE) ) {
                                                        if ( !guessing ) {
                                                           _retv  = attribute_reference( prefix );

                                                        } else {
                                                          attribute_reference( prefix );
                                                        }
                                                      }
                                                      else {
                                                        if ( !zzrv ) zzGUESS_DONE;
                                                        if ( (LA(1)==RIGHTOF)
 ) {
                                                          if ( !guessing ) {
                                                             _retv  = attribute_rightof( prefix );

                                                          } else {
                                                            attribute_rightof( prefix );
                                                          }
                                                        }
                                                        else {
                                                          if ( !zzrv ) zzGUESS_DONE;
                                                          if ( (LA(1)==RIGHT) ) {
                                                            if ( !guessing ) {
                                                               _retv  = attribute_right( prefix );

                                                            } else {
                                                              attribute_right( prefix );
                                                            }
                                                          }
                                                          else {
                                                            if ( !zzrv ) zzGUESS_DONE;
                                                            if ( (LA(1)==REVERSE_RANGE) ) {
                                                              if ( !guessing ) {
                                                                 _retv  = attribute_reverse_range( prefix );

                                                              } else {
                                                                attribute_reverse_range( prefix );
                                                              }
                                                            }
                                                            else {
                                                              if ( !zzrv ) zzGUESS_DONE;
                                                              if ( (LA(1)==SIMPLE_NAME) ) {
                                                                if ( !guessing ) {
                                                                   _retv  = attribute_simple_name( prefix );

                                                                } else {
                                                                  attribute_simple_name( prefix );
                                                                }
                                                              }
                                                              else {
                                                                if ( !zzrv ) zzGUESS_DONE;
                                                                if ( (LA(1)==STABLE) ) {
                                                                  if ( !guessing ) {
                                                                     _retv  = attribute_stable( prefix );

                                                                  } else {
                                                                    attribute_stable( prefix );
                                                                  }
                                                                }
                                                                else {
                                                                  if ( !zzrv ) zzGUESS_DONE;
                                                                  if ( (LA(1)==SUCC)
 ) {
                                                                    if ( !guessing ) {
                                                                       _retv  = attribute_succ( prefix );

                                                                    } else {
                                                                      attribute_succ( prefix );
                                                                    }
                                                                  }
                                                                  else {
                                                                    if ( !zzrv ) zzGUESS_DONE;
                                                                    if ( (LA(1)==TRANSACTION) ) {
                                                                      if ( !guessing ) {
                                                                         _retv  = attribute_transaction( prefix );

                                                                      } else {
                                                                        attribute_transaction( prefix );
                                                                      }
                                                                    }
                                                                    else {
                                                                      if ( !zzrv ) zzGUESS_DONE;
                                                                      if ( (LA(1)==QUIET) ) {
                                                                        if ( !guessing ) {
                                                                           _retv  = attribute_quiet( prefix );

                                                                        } else {
                                                                          attribute_quiet( prefix );
                                                                        }
                                                                      }
                                                                      else {
                                                                        if ( !zzrv ) zzGUESS_DONE;
                                                                        if ( (LA(1)==VALUE) ) {
                                                                          if ( !guessing ) {
                                                                             _retv  = attribute_value( prefix );

                                                                          } else {
                                                                            attribute_value( prefix );
                                                                          }
                                                                        }
                                                                        else {
                                                                          if ( !zzrv ) zzGUESS_DONE;
                                                                          if ( (LA(1)==VAL) ) {
                                                                            if ( !guessing ) {
                                                                               _retv  = attribute_val( prefix );

                                                                            } else {
                                                                              attribute_val( prefix );
                                                                            }
                                                                          }
                                                                          else {
                                                                            if ( !zzrv ) zzGUESS_DONE;
                                                                            if ( (LA(1)==ZTF)
 ) {
                                                                              if ( !guessing ) {
                                                                                 _retv  = attribute_ztf( prefix );

                                                                              } else {
                                                                                attribute_ztf( prefix );
                                                                              }
                                                                            }
                                                                            else {
                                                                              if ( !zzrv ) zzGUESS_DONE;
                                                                              if ( (LA(1)==L_PAREN) ) {
                                                                                {
                                                                                  if ( !guessing ) {
                                                                                     initializer  = aggregate();

                                                                                  } else {
                                                                                    aggregate();
                                                                                  }
                                                                                }
                                                                                if ( !guessing ) {
                                                                                
                                                                                IIR_UserAttribute *new_attr = new IIR_UserAttribute();
                                                                                IIR::copy_location( prefix, new_attr );
                                                                                new_attr->set_prefix( prefix );
                                                                                new_attr->set_suffix( reduce_aggregate( initializer ) );
                                                                                _retv = new_attr;
                                                                                }
                                                                              }
                                                                              else {FAIL(1,err251,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                                                                            }
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd59, 0x40);
  return _retv;
}

IIR_UserAttribute *
VHDLParser::attribute_user_defined(IIR * p)
{
  IIR_UserAttribute *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_UserAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  if ( !guessing ) {
     wk  = selected_name();

  } else {
    selected_name();
  }
  if ( !guessing ) {
  
  _retv = new IIR_UserAttribute();
  IIR::copy_location( wk, _retv );
  _retv->set_prefix(p);
  _retv->set_suffix(wk);
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd59, 0x80);
  return _retv;
}

IIR_AboveAttribute *
VHDLParser::attribute_above(IIR * p)
{
  IIR_AboveAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_AboveAttribute *  ))
  
  _retv = NULL;
  IIR *expr = NULL;
  zzmatch(ABOVE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_AboveAttribute();
  copy_location(start,_retv);
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     expr  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv->set_suffix(expr);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd60, 0x1);
  return _retv;
}

IIR_AcrossAttribute *
VHDLParser::attribute_across(IIR * p)
{
  IIR_AcrossAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_AcrossAttribute *  ))
  _retv = NULL;
  zzmatch(ACROSS);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_AcrossAttribute();
  copy_location (start,_retv);
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd60, 0x2);
  return _retv;
}

IIR_ActiveAttribute *
VHDLParser::attribute_active(IIR * p)
{
  IIR_ActiveAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ActiveAttribute *  ))
  _retv = NULL;
  zzmatch(ACTIVE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ActiveAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd60, 0x4);
  return _retv;
}

IIR_AscendingAttribute *
VHDLParser::attribute_ascending(IIR * prefix)
{
  IIR_AscendingAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_AscendingAttribute *  ))
  
  _retv = NULL;
  IIR *expr = NULL;
  zzmatch(ASCENDING);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_AscendingAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(prefix);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         expr  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(expr);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd60[LA(1)]&0x8) ) {
      }
      else {FAIL(1,err252,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd60, 0x10);
  return _retv;
}

IIR_BaseAttribute *
VHDLParser::attribute_base(IIR * p)
{
  IIR_BaseAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_BaseAttribute *  ))
  _retv = NULL;
  zzmatch(BASE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_BaseAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd60, 0x20);
  return _retv;
}

IIR_ContributionAttribute *
VHDLParser::attribute_contribution(IIR * p)
{
  IIR_ContributionAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ContributionAttribute *  ))
  _retv = NULL;
  zzmatch(CONTRIBUTION);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ContributionAttribute();
  copy_location (start,_retv);
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd60, 0x40);
  return _retv;
}

IIR_DelayedAttribute *
VHDLParser::attribute_delayed(IIR * p)
{
  IIR_DelayedAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_DelayedAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(DELAYED);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_DelayedAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd60[LA(1)]&0x80)
 ) {
      }
      else {FAIL(1,err253,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd61, 0x1);
  return _retv;
}

IIR_DotAttribute *
VHDLParser::attribute_dot(IIR * p)
{
  IIR_DotAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_DotAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(DOT_);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_DotAttribute();
  copy_location(start,_retv);
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd61, 0x2);
  return _retv;
}

IIR_DrivingValueAttribute *
VHDLParser::attribute_driving_value(IIR * p)
{
  IIR_DrivingValueAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_DrivingValueAttribute *  ))
  _retv = NULL;
  zzmatch(DRIVING_VALUE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_DrivingValueAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd61, 0x4);
  return _retv;
}

IIR_DrivingAttribute *
VHDLParser::attribute_driving(IIR * p)
{
  IIR_DrivingAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_DrivingAttribute *  ))
  _retv = NULL;
  zzmatch(DRIVING);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_DrivingAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd61, 0x8);
  return _retv;
}

IIR_EventAttribute *
VHDLParser::attribute_event(IIR * p)
{
  IIR_EventAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_EventAttribute *  ))
  _retv = NULL;
  zzmatch(EVENT);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_EventAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd61, 0x10);
  return _retv;
}

IIR_HighAttribute *
VHDLParser::attribute_high(IIR * p)
{
  IIR_HighAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_HighAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(HIGH);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_HighAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd61[LA(1)]&0x20) ) {
      }
      else {FAIL(1,err254,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd61, 0x40);
  return _retv;
}

IIR_ImageAttribute *
VHDLParser::attribute_image(IIR * p)
{
  IIR_ImageAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ImageAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(IMAGE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ImageAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     wk  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv->set_suffix(wk);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd61, 0x80);
  return _retv;
}

IIR_InstanceNameAttribute *
VHDLParser::attribute_instance_name(IIR * p)
{
  IIR_InstanceNameAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_InstanceNameAttribute *  ))
  _retv = NULL;
  zzmatch(INSTANCE_NAME);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_InstanceNameAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd62, 0x1);
  return _retv;
}

IIR_LastActiveAttribute *
VHDLParser::attribute_last_active(IIR * p)
{
  IIR_LastActiveAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LastActiveAttribute *  ))
  _retv = NULL;
  zzmatch(LAST_ACTIVE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_LastActiveAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd62, 0x2);
  return _retv;
}

IIR_LastEventAttribute *
VHDLParser::attribute_last_event(IIR * p)
{
  IIR_LastEventAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LastEventAttribute *  ))
  _retv = NULL;
  zzmatch(LAST_EVENT);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_LastEventAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd62, 0x4);
  return _retv;
}

IIR_LastValueAttribute *
VHDLParser::attribute_last_value(IIR * p)
{
  IIR_LastValueAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LastValueAttribute *  ))
  _retv = NULL;
  zzmatch(LAST_VALUE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_LastValueAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd62, 0x8);
  return _retv;
}

IIR_LeftOfAttribute *
VHDLParser::attribute_leftof(IIR * p)
{
  IIR_LeftOfAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LeftOfAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(LEFTOF);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_LeftOfAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     wk  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv->set_suffix(wk);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd62, 0x10);
  return _retv;
}

IIR_LeftAttribute *
VHDLParser::attribute_left(IIR * p)
{
  IIR_LeftAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LeftAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(LEFT);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_LeftAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd62[LA(1)]&0x20) ) {
      }
      else {FAIL(1,err255,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd62, 0x40);
  return _retv;
}

IIR_LengthAttribute *
VHDLParser::attribute_length(IIR * p)
{
  IIR_LengthAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LengthAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(LENGTH);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_LengthAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN)
 ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd62[LA(1)]&0x80) ) {
      }
      else {FAIL(1,err256,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd63, 0x1);
  return _retv;
}

IIR_LowAttribute *
VHDLParser::attribute_low(IIR * p)
{
  IIR_LowAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LowAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(LOW);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_LowAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd63[LA(1)]&0x2) ) {
      }
      else {FAIL(1,err257,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd63, 0x4);
  return _retv;
}

IIR_LTFAttribute *
VHDLParser::attribute_ltf(IIR * p)
{
  IIR_LTFAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_LTFAttribute *  ))
  
  _retv = NULL;
  IIR* numer;
  IIR* denom;
  zzmatch(LTF);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_LTFAttribute();
  copy_location( start,_retv);
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     numer  = expression();

  } else {
    expression();
  }
  zzmatch(COMMA); consume();
  if ( !guessing ) {
     denom  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  
  _retv->set_num(numer);
  _retv->set_den(denom);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd63, 0x8);
  return _retv;
}

IIR_PathNameAttribute *
VHDLParser::attribute_path_name(IIR * p)
{
  IIR_PathNameAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_PathNameAttribute *  ))
  _retv = NULL;
  zzmatch(PATH_NAME);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_PathNameAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd63, 0x10);
  return _retv;
}

IIR_PosAttribute *
VHDLParser::attribute_pos(IIR * p)
{
  IIR_PosAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_PosAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(POS);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_PosAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     wk  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv->set_suffix(wk);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd63, 0x20);
  return _retv;
}

IIR_PredAttribute *
VHDLParser::attribute_pred(IIR * p)
{
  IIR_PredAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_PredAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(PRED);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_PredAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     wk  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv->set_suffix(wk);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd63, 0x40);
  return _retv;
}

IIR_RangeAttribute *
VHDLParser::attribute_range(IIR * p)
{
  IIR_RangeAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_RangeAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(RANGE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_RangeAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd63[LA(1)]&0x80)
 ) {
      }
      else {FAIL(1,err258,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd64, 0x1);
  return _retv;
}

IIR_ReferenceAttribute *
VHDLParser::attribute_reference(IIR * p)
{
  IIR_ReferenceAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ReferenceAttribute *  ))
  _retv = NULL;
  zzmatch(REFERENCE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ReferenceAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd64, 0x2);
  return _retv;
}

IIR_RightOfAttribute *
VHDLParser::attribute_rightof(IIR * p)
{
  IIR_RightOfAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_RightOfAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(RIGHTOF);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_RightOfAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     wk  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv->set_suffix(wk);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd64, 0x4);
  return _retv;
}

IIR_RightAttribute *
VHDLParser::attribute_right(IIR * p)
{
  IIR_RightAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_RightAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(RIGHT);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_RightAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd64[LA(1)]&0x8) ) {
      }
      else {FAIL(1,err259,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd64, 0x10);
  return _retv;
}

IIR_ReverseRangeAttribute *
VHDLParser::attribute_reverse_range(IIR * p)
{
  IIR_ReverseRangeAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ReverseRangeAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(REVERSE_RANGE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ReverseRangeAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd64[LA(1)]&0x20) ) {
      }
      else {FAIL(1,err260,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd64, 0x40);
  return _retv;
}

IIR_SimpleNameAttribute *
VHDLParser::attribute_simple_name(IIR * p)
{
  IIR_SimpleNameAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimpleNameAttribute *  ))
  _retv = NULL;
  zzmatch(SIMPLE_NAME);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_SimpleNameAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd64, 0x80);
  return _retv;
}

IIR_StableAttribute *
VHDLParser::attribute_stable(IIR * p)
{
  IIR_StableAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_StableAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(STABLE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_StableAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN)
 ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd65[LA(1)]&0x1) ) {
      }
      else {FAIL(1,err261,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd65, 0x2);
  return _retv;
}

IIR_SuccAttribute *
VHDLParser::attribute_succ(IIR * p)
{
  IIR_SuccAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_SuccAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(SUCC);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_SuccAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     wk  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv->set_suffix(wk);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd65, 0x4);
  return _retv;
}

IIR_ThroughAttribute *
VHDLParser::attribute_through(IIR * p)
{
  IIR_ThroughAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ThroughAttribute *  ))
  _retv = NULL;
  zzmatch(THROUGH);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ThroughAttribute();
  copy_location( start,_retv);
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd65, 0x8);
  return _retv;
}

IIR_TransactionAttribute *
VHDLParser::attribute_transaction(IIR * p)
{
  IIR_TransactionAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_TransactionAttribute *  ))
  _retv = NULL;
  zzmatch(TRANSACTION);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_TransactionAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd65, 0x10);
  return _retv;
}

IIR_QuietAttribute *
VHDLParser::attribute_quiet(IIR * p)
{
  IIR_QuietAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_QuietAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(QUIET);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_QuietAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd65[LA(1)]&0x20) ) {
      }
      else {FAIL(1,err262,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd65, 0x40);
  return _retv;
}

IIR_ValueAttribute *
VHDLParser::attribute_value(IIR * p)
{
  IIR_ValueAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ValueAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(VALUE);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ValueAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==L_PAREN) ) {
      {
        zzmatch(L_PAREN); consume();
      }
      zzGUESS_DONE
      zzmatch(L_PAREN); consume();
      if ( !guessing ) {
         wk  = expression();

      } else {
        expression();
      }
      zzmatch(R_PAREN);
      if ( !guessing ) {
      _retv->set_suffix(wk);
      }
 consume();
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd65[LA(1)]&0x80)
 ) {
      }
      else {FAIL(1,err263,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd66, 0x1);
  return _retv;
}

IIR_ValAttribute *
VHDLParser::attribute_val(IIR * p)
{
  IIR_ValAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ValAttribute *  ))
  
  _retv = NULL;
  IIR *wk = NULL;
  zzmatch(VAL);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ValAttribute();
  copy_location( start, _retv );
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     wk  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  _retv->set_suffix(wk);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd66, 0x2);
  return _retv;
}

IIR_ZTFAttribute *
VHDLParser::attribute_ztf(IIR * p)
{
  IIR_ZTFAttribute *   _retv;
  zzRULE;
  ANTLRTokenPtr start=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ZTFAttribute *  ))
  
  _retv = NULL;
  IIR* numer = NULL;
  IIR* denom = NULL;
  IIR* s_period = NULL;
  IIR* delay = NULL;
  zzmatch(ZTF);
  if ( !guessing ) {
    start = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ZTFAttribute();
  copy_location( start,_retv);
  _retv->set_prefix(p);
  }
 consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     numer  = expression();

  } else {
    expression();
  }
  zzmatch(COMMA); consume();
  if ( !guessing ) {
     denom  = expression();

  } else {
    expression();
  }
  zzmatch(COMMA); consume();
  if ( !guessing ) {
     s_period  = expression();

  } else {
    expression();
  }
  zzmatch(COMMA); consume();
  if ( !guessing ) {
     delay  = expression();

  } else {
    expression();
  }
  zzmatch(R_PAREN);
  if ( !guessing ) {
  
  _retv->set_num(numer);
  _retv->set_den(denom);
  _retv->set_t(s_period);
  _retv->set_initial_delay(delay);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd66, 0x4);
  return _retv;
}

IIR_Name *
VHDLParser::selected_name(void)
{
  IIR_Name *   _retv;
  zzRULE;
  ANTLRTokenPtr dot=NULL, all=NULL, paren=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  
  _retv = NULL;
  IIR_SelectedName *selected_name = NULL;
  IIR_IndexedName *ind_name = NULL;
  IIR *index_spec = NULL;
  IIR *by_all = NULL;
  if ( !guessing ) {
     _retv  = indexed_name( NULL );

  } else {
    indexed_name( NULL );
  }
  {
    while ( (LA(1)==DOT) ) {
      zzmatch(DOT);
      if ( !guessing ) {
            dot = (ANTLRTokenPtr)LT(1);
      }
       consume();
      {
        
        if ( (setwd66[LA(1)]&0x8) ) {
          if ( !guessing ) {
          
          selected_name = new IIR_SelectedName();
          copy_location( dot, selected_name);
          selected_name->set_prefix( _retv );
          _retv = selected_name;
          }
          if ( !guessing ) {
             _retv  = indexed_name( _retv );

          } else {
            indexed_name( _retv );
          }
        }
        else {
          if ( (LA(1)==ALL) ) {
            zzmatch(ALL);
            if ( !guessing ) {
                        all = (ANTLRTokenPtr)LT(1);
            }
            
            if ( !guessing ) {
            
            selected_name = new IIR_SelectedName();
            copy_location( dot, selected_name );
            selected_name->set_prefix( _retv );
            by_all = new IIR_DesignatorByAll();
            copy_location( all, by_all );
            selected_name->set_suffix( by_all );
            _retv = selected_name;
            }
 consume();
            {
              while ( (LA(1)==L_PAREN) ) {
                zzmatch(L_PAREN);
                if ( !guessing ) {
                                paren = (ANTLRTokenPtr)LT(1);
                }
                 consume();
                if ( !guessing ) {
                   index_spec  = index_specifier();

                } else {
                  index_specifier();
                }
                if ( !guessing ) {
                
                ind_name = new IIR_IndexedName();
                copy_location( paren, ind_name );
                ind_name->set_prefix( _retv );
                ind_name->set_suffix(index_spec);
                _retv = ind_name;
                }
                zzmatch(R_PAREN); consume();
              }
            }
          }
          else {FAIL(1,err264,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd66, 0x10);
  return _retv;
}

IIR_Name *
VHDLParser::indexed_name(IIR_Name * prefix)
{
  IIR_Name *   _retv;
  zzRULE;
  ANTLRTokenPtr paren=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  
  _retv = NULL;
  IIR_IndexedName *ind_name = NULL;
  IIR *index_spec = NULL;
  if ( !guessing ) {
     _retv  = name();

  } else {
    name();
  }
  if ( !guessing ) {
  
  if ( prefix != NULL) {
    prefix->_set_suffix(_retv);
    _retv =  prefix;
  };
  }
  {
    while ( (LA(1)==L_PAREN)
 ) {
      zzmatch(L_PAREN);
      if ( !guessing ) {
            paren = (ANTLRTokenPtr)LT(1);
      }
       consume();
      if ( !guessing ) {
         index_spec  = index_specifier();

      } else {
        index_specifier();
      }
      if ( !guessing ) {
      
      ind_name = new IIR_IndexedName();
      copy_location( paren, ind_name );
      ind_name->set_prefix( _retv );
      ind_name->set_suffix(index_spec);
      _retv = ind_name;
      }
      zzmatch(R_PAREN); consume();
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd66, 0x20);
  return _retv;
}

IIR *
VHDLParser::index_specifier(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR *expr, *dir = NULL;
  IIR_AssociationList *list = NULL;
  IIR_ScalarTypeDefinition *temp_range = NULL;
  IIR_ScalarTypeDefinition *scalar_type = NULL;
  zzGUESS
  if ( !zzrv && (setwd66[LA(1)]&0x40) && (setwd66[LA(2)]&0x80) ) {
    {
      if ( !guessing ) {
         expr  = expression();

      } else {
        expression();
      }
      if ( !guessing ) {
         dir  = direction();

      } else {
        direction();
      }
    }
    zzGUESS_DONE
    if ( !guessing ) {
        temp_range   = discrete_range();

    } else {
      discrete_range();
    }
    if ( !guessing ) {
    
    if( temp_range != NULL && temp_range->get_kind() == IIR_RANGE_TYPE_DEFINITION ){
      IIR_RangeTypeDefinition *temp = (IIR_RangeTypeDefinition *)temp_range;
      scalar_type = IIR_ScalarTypeDefinition::_determine_discrete_type( temp );
      _retv = scalar_type->_construct_new_subtype( NULL, temp );
      delete temp;
    }
    else{
      _retv = temp_range;
    }
    }
    {
      if ( (LA(1)==EQUAL_GREATER) ) {
        zzmatch(EQUAL_GREATER); consume();
        if ( !guessing ) {
           expr  = expression();

        } else {
          expression();
        }
      }
      else {
        if ( (LA(1)==R_PAREN) ) {
        }
        else {FAIL(1,err265,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd67[LA(1)]&0x1) && (setwd67[LA(2)]&0x2) ) {
      if ( !guessing ) {
         list  = association_list_out();

      } else {
        association_list_out();
      }
      if ( !guessing ) {
      _retv = reduce_association_list( list );
      }
    }
    else {FAIL(2,err266,err267,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd67, 0x4);
  return _retv;
}

IIR *
VHDLParser::slice_specifier(void)
{
  IIR *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR *  ))
  
  _retv = NULL;
  IIR_ScalarTypeDefinition *index_constraint = NULL;
  IIR_ScalarTypeDefinition *scalar_type = NULL;
  if ( !guessing ) {
     index_constraint  = discrete_range();

  } else {
    discrete_range();
  }
  if ( !guessing ) {
  
  if( index_constraint != NULL && index_constraint->get_kind() == IIR_RANGE_TYPE_DEFINITION ){
    IIR_RangeTypeDefinition *temp =  (IIR_RangeTypeDefinition *)index_constraint;
    scalar_type = IIR_ScalarTypeDefinition::_determine_discrete_type( temp );
    scalar_type = (IIR_ScalarTypeDefinition *)scalar_type->_construct_new_subtype( 0, temp );
    _retv = scalar_type;
    delete temp;
  }
  else{
    _retv = index_constraint;
  }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd67, 0x8);
  return _retv;
}

IIR_Name *
VHDLParser::name(void)
{
  IIR_Name *   _retv;
  zzRULE;
  ANTLRTokenPtr string_lit=NULL, character_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Name *  ))
  
  _retv = NULL;
  IIR_StringLiteral *string_literal = NULL;
  IIR_CharacterLiteral *character_literal = NULL;
  if ( (setwd67[LA(1)]&0x10)
 ) {
    if ( !guessing ) {
       _retv  = simple_name();

    } else {
      simple_name();
    }
  }
  else {
    if ( (LA(1)==STRING_LITERAL) ) {
      zzmatch(STRING_LITERAL);
      if ( !guessing ) {
            string_lit = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      string_literal = (IIR_StringLiteral*)mytoken(string_lit)->getIIRPtr();
      string_literal->_to_lower();
      copy_location( string_lit, string_literal );
      _retv = new IIR_SimpleName();
      _retv->set_prefix(string_literal);
      copy_location( string_lit, _retv );
      }
 consume();
    }
    else {
      if ( (LA(1)==CHARACTER_LITERAL) ) {
        zzmatch(CHARACTER_LITERAL);
        if ( !guessing ) {
                character_lit = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        
        character_literal = (IIR_CharacterLiteral*)mytoken(character_lit)->getIIRPtr();
        copy_location( character_lit, character_literal );
        _retv = new IIR_SimpleName();
        _retv->set_prefix(character_literal);
        copy_location( character_lit, _retv );
        }
 consume();
      }
      else {FAIL(1,err268,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd67, 0x20);
  return _retv;
}

IIR_SimpleName *
VHDLParser::simple_name(void)
{
  IIR_SimpleName *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimpleName *  ))
  
  _retv = NULL;
  IIR_Identifier *id = NULL;
  if ( !guessing ) {
      id   = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  
  _retv = new IIR_SimpleName();
  _retv->set_prefix( id );
  IIR::copy_location( id, _retv );
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd67, 0x40);
  return _retv;
}

IIR_Literal *
VHDLParser::alpha_literals(void)
{
  IIR_Literal *   _retv;
  zzRULE;
  ANTLRTokenPtr bit_string_lit=NULL, char_lit=NULL, string_lit=NULL, null_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Literal *  ))
  _retv = NULL;
  if ( (LA(1)==BIT_STRING_LITERAL) ) {
    zzmatch(BIT_STRING_LITERAL);
    if ( !guessing ) {
        bit_string_lit = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    _retv = (IIR_BitStringLiteral*)mytoken(bit_string_lit)->getIIRPtr();
    copy_location( bit_string_lit, _retv);
    }
 consume();
  }
  else {
    if ( (LA(1)==CHARACTER_LITERAL) ) {
      zzmatch(CHARACTER_LITERAL);
      if ( !guessing ) {
            char_lit = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = (IIR_Literal*)mytoken(char_lit)->getIIRPtr();
      copy_location( char_lit,  _retv );
      }
 consume();
    }
    else {
      if ( (LA(1)==STRING_LITERAL)
 ) {
        zzmatch(STRING_LITERAL);
        if ( !guessing ) {
                string_lit = (ANTLRTokenPtr)LT(1);
        }
        
        if ( !guessing ) {
        
        _retv = (IIR_StringLiteral*)mytoken(string_lit)->getIIRPtr();
        copy_location( string_lit, _retv );
        }
 consume();
      }
      else {
        if ( (LA(1)==NULL_) ) {
          zzmatch(NULL_);
          if ( !guessing ) {
                    null_lit = (ANTLRTokenPtr)LT(1);
          }
          
          if ( !guessing ) {
          
          _retv = IIR_StringLiteral::get( "null", 4 );
          copy_location( null_lit, _retv );
          }
 consume();
        }
        else {FAIL(1,err269,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd67, 0x80);
  return _retv;
}

IIR_Identifier *
VHDLParser::physical_type_name(void)
{
  IIR_Identifier *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Identifier *  ))
  _retv = NULL;
  if ( !guessing ) {
     _retv  = identifier();

  } else {
    identifier();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd68, 0x1);
  return _retv;
}

IIR_ScalarTypeDefinition *
VHDLParser::discrete_range(void)
{
  IIR_ScalarTypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ScalarTypeDefinition *  ))
  zzGUESS_BLOCK
  
  _retv = NULL;
  IIR_TypeDefinition *base_type = NULL;
  zzGUESS
  if ( !zzrv && (setwd68[LA(1)]&0x2) && (setwd68[LA(2)]&0x4) ) {
    {
      if ( !guessing ) {
          _retv   = range();

      } else {
        range();
      }
    }
    zzGUESS_DONE
    {
      if ( !guessing ) {
          _retv   = range();

      } else {
        range();
      }
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    if ( (setwd68[LA(1)]&0x8) && (setwd68[LA(2)]&0x10) ) {
      if ( !guessing ) {
          base_type   = subtype_indication();

      } else {
        subtype_indication();
      }
      if ( !guessing ) {
      
      if( base_type != NULL ){
        if( base_type->_is_discrete_type() == FALSE ){
          ostringstream err;
          err << "|" << *base_type << "| is not a discrete type.";
          report_error( base_type, err.str() );
        }
        else{
          ASSERT( base_type->_is_scalar_type() == TRUE );
          _retv = (IIR_ScalarTypeDefinition *)base_type;
        }
      }
      }
    }
    else {FAIL(2,err270,err271,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd68, 0x20);
  return _retv;
}

IIR_EnumerationLiteral *
VHDLParser::direction(void)
{
  IIR_EnumerationLiteral *   _retv;
  zzRULE;
  ANTLRTokenPtr to_=NULL, downto_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_EnumerationLiteral *  ))
  _retv = NULL;
  if ( (LA(1)==TO) ) {
    zzmatch(TO);
    if ( !guessing ) {
        to_ = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    _retv = StandardPackage::get_true_literal( );
    copy_location( to_, _retv );
    }
 consume();
  }
  else {
    if ( (LA(1)==DOWNTO)
 ) {
      zzmatch(DOWNTO);
      if ( !guessing ) {
            downto_ = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = StandardPackage::get_false_literal( );
      copy_location( downto_, _retv );
      }
 consume();
    }
    else {FAIL(1,err272,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd68, 0x40);
  return _retv;
}

IIR_Label *
VHDLParser::vhdl_label(void)
{
  IIR_Label *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_Label *  ))
  
  _retv = NULL;
  IIR_Identifier *id = NULL;
  if ( !guessing ) {
     id  = identifier();

  } else {
    identifier();
  }
  if ( !guessing ) {
  
  _retv = new IIR_Label();
  _retv->set_declarator(id);
  IIR::copy_location( id, _retv );
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd68, 0x80);
  return _retv;
}

IIR_IntegerLiteral *
VHDLParser::integer_literal(void)
{
  IIR_IntegerLiteral *   _retv;
  zzRULE;
  ANTLRTokenPtr integer_lit=NULL, based_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_IntegerLiteral *  ))
  _retv = NULL;
  if ( (LA(1)==DECIMAL_INTEGER_LITERAL) ) {
    zzmatch(DECIMAL_INTEGER_LITERAL);
    if ( !guessing ) {
        integer_lit = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    _retv = (IIR_IntegerLiteral*)mytoken(integer_lit)->getIIRPtr();
    copy_location( integer_lit, _retv );
    }
 consume();
  }
  else {
    if ( (LA(1)==BASED_INTEGER_LITERAL) ) {
      zzmatch(BASED_INTEGER_LITERAL);
      if ( !guessing ) {
            based_lit = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = (IIR_IntegerLiteral*)mytoken(based_lit)->getIIRPtr();
      copy_location( based_lit, _retv );
      }
 consume();
    }
    else {FAIL(1,err273,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd69, 0x1);
  return _retv;
}

IIR_FloatingPointLiteral *
VHDLParser::real_literal(void)
{
  IIR_FloatingPointLiteral *   _retv;
  zzRULE;
  ANTLRTokenPtr real_lit=NULL, based_lit=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_FloatingPointLiteral *  ))
  _retv = NULL;
  if ( (LA(1)==DECIMAL_FLOATING_POINT_LITERAL) ) {
    zzmatch(DECIMAL_FLOATING_POINT_LITERAL);
    if ( !guessing ) {
        real_lit = (ANTLRTokenPtr)LT(1);
    }
    
    if ( !guessing ) {
    
    _retv = (IIR_FloatingPointLiteral*)mytoken(real_lit)->getIIRPtr();
    copy_location( real_lit, _retv );
    }
 consume();
  }
  else {
    if ( (LA(1)==BASED_FLOATING_POINT_LITERAL) ) {
      zzmatch(BASED_FLOATING_POINT_LITERAL);
      if ( !guessing ) {
            based_lit = (ANTLRTokenPtr)LT(1);
      }
      
      if ( !guessing ) {
      
      _retv = (IIR_FloatingPointLiteral*)mytoken(based_lit)->getIIRPtr();
      copy_location( based_lit, _retv );
      }
 consume();
    }
    else {FAIL(1,err274,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd69, 0x2);
  return _retv;
}

IIR_Identifier *
VHDLParser::identifier(void)
{
  IIR_Identifier *   _retv;
  zzRULE;
  ANTLRTokenPtr id=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_Identifier *  ))
  _retv = NULL;
  zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset);
  if ( !guessing ) {
    id = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = (IIR_Identifier*)mytoken(id)->getIIRPtr();
  copy_location( id, _retv );
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd69, 0x4);
  return _retv;
}

void
VHDLParser::nature_declaration(IIR_DeclarationList * decl_list)
{
  zzRULE;
  ANTLRTokenPtr nature=NULL;
  
  IIR_Identifier *nature_id = NULL;
  IIR_NatureDeclaration *nature_decl = NULL;
  IIR_NatureDefinition *nature_def = NULL;
  zzmatch(NATURE);
  if ( !guessing ) {
    nature = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     nature_id  = identifier();

  } else {
    identifier();
  }
  zzmatch(IS);
  if ( !guessing ) {
  
  nature_decl = new IIR_NatureDeclaration();
  copy_location(nature, nature_decl);
  }
 consume();
  if ( !guessing ) {
     nature_def  = nature_definition( nature_decl );

  } else {
    nature_definition( nature_decl );
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  nature_def->_set_declaration(nature_decl);
  nature_decl->set_declarator(nature_id);
  nature_decl->set_nature(nature_def);
  nature_decl->_add_declaration();
  nature_decl->_type_check();
  decl_list->append(nature_decl); 
  if( (nature_def->get_kind() != IIR_ARRAY_SUBNATURE_DEFINITION) && (nature_def->get_kind() != IIR_ARRAY_NATURE_DEFINITION) )
  decl_list->append(nature_decl->_get_reference_terminal());
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd69, 0x8);
}

IIR_NatureDefinition *
VHDLParser::nature_definition(IIR_NatureDeclaration * nature_decl)
{
  IIR_NatureDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_NatureDefinition *  ))
  if ( (setwd69[LA(1)]&0x10)
 ) {
    if ( !guessing ) {
       _retv  = scalar_nature_definition( nature_decl );

    } else {
      scalar_nature_definition( nature_decl );
    }
  }
  else {
    if ( (LA(1)==ARRAY) ) {
      if ( !guessing ) {
         _retv  = array_nature_definition( nature_decl );

      } else {
        array_nature_definition( nature_decl );
      }
    }
    else {
      if ( (LA(1)==RECORD) ) {
        record_nature_definition();
      }
      else {FAIL(1,err275,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd69, 0x20);
  return _retv;
}

void
VHDLParser::terminal_declaration(IIR_DeclarationList * decl_list)
{
  zzRULE;
  ANTLRTokenPtr terminal=NULL;
  
  IIR_IdentifierList *id_list = NULL;
  IIR_TerminalDeclaration *new_decl = NULL;
  IIR_NatureDefinition *nature_def = NULL;
  IIR_Identifier *id = NULL;
  zzmatch(TERMINAL);
  if ( !guessing ) {
    terminal = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  id_list = new IIR_IdentifierList();
  }
 consume();
  identifier_list( id_list );
  zzmatch(COLON); consume();
  if ( !guessing ) {
     nature_def  = subnature_indication();

  } else {
    subnature_indication();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  id = id_list->first();
  while (id != NULL) {
    new_decl = new IIR_TerminalDeclaration();
    new_decl->set_declarator(id);
    new_decl->set_nature(nature_def);   
    new_decl->set_subtype(nature_def);
    new_decl->_type_check();
    IIR::copy_location( id,new_decl);
    new_decl->_add_declaration();
    decl_list->append( new_decl );
    id_list->remove(id);
    id = id_list->first();
  }
  delete id_list;
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd69, 0x40);
}

void
VHDLParser::quantity_declaration(IIR_DeclarationList * decl_list)
{
  zzRULE;
  ANTLRTokenPtr quantity=NULL;
  zzmatch(QUANTITY);
  if ( !guessing ) {
    quantity = (ANTLRTokenPtr)LT(1);
  }
   consume();
  quantity_declaration_tail(  decl_list );
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd69, 0x80);
}

void
VHDLParser::quantity_declaration_tail(IIR_DeclarationList * decl_list)
{
  zzRULE;
  zzGUESS_BLOCK
  
  IIR_IdentifierList *id_list= new IIR_IdentifierList();
  IIR_TypeDefinition *type_def = NULL;
  IIR *initial_value = NULL;
  IIR *magnitude = NULL;
  IIR *phase = NULL;
  IIR *noise = NULL;
  zzGUESS
  if ( !zzrv && (setwd70[LA(1)]&0x1) && (setwd70[LA(2)]&0x2) ) {
    {
      identifier_list( id_list );
      zzmatch(COLON); consume();
      if ( !guessing ) {
         type_def  = subtype_indication();

      } else {
        subtype_indication();
      }
      {
        if ( (LA(1)==COLON_EQUAL) ) {
          if ( !guessing ) {
             initial_value  = initialization();

          } else {
            initialization();
          }
        }
        else {
          if ( (LA(1)==SEMI_COLON)
 ) {
          }
          else {FAIL(1,err276,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
      zzmatch(SEMI_COLON); consume();
    }
    zzGUESS_DONE
    free_quantity_declaration(  decl_list );
    if ( !guessing ) {
    delete id_list;
    }
  }
  else {
    if ( !zzrv ) zzGUESS_DONE;
    zzGUESS
    if ( !zzrv && (setwd70[LA(1)]&0x4) && (setwd70[LA(2)]&0x8) ) {
      {
        identifier_list( id_list );
        zzmatch(COLON); consume();
        if ( !guessing ) {
           type_def  = subtype_indication();

        } else {
          subtype_indication();
        }
        {
          if ( (setwd70[LA(1)]&0x10) ) {
            if ( !guessing ) {
              { struct _rv266 _trv; _trv = source_aspect();

              magnitude = _trv.magnitude_expr; phase = _trv.phase_expr; noise  = _trv.noise_expr; }
            } else {
              source_aspect();
            }
          }
          else {
            if ( (LA(1)==SEMI_COLON) ) {
            }
            else {FAIL(1,err277,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
        zzmatch(SEMI_COLON); consume();
      }
      zzGUESS_DONE
      source_quantity_declaration(  decl_list );
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd70[LA(1)]&0x20) && (setwd70[LA(2)]&0x40) ) {
        branch_quantity_declaration(  decl_list );
      }
      else {FAIL(2,err278,err279,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd70, 0x80);
}

void
VHDLParser::free_quantity_declaration(IIR_DeclarationList * decl_list)
{
  zzRULE;
  
  IIR_FreeQuantityDeclaration *new_decl;
  IIR_IdentifierList *id_list = new IIR_IdentifierList();
  IIR_Identifier *id = NULL;
  IIR_TypeDefinition *type_def = NULL;
  IIR *initial_value = NULL;
  identifier_list( id_list );
  zzmatch(COLON); consume();
  if ( !guessing ) {
     type_def  = subtype_indication();

  } else {
    subtype_indication();
  }
  {
    if ( (LA(1)==COLON_EQUAL)
 ) {
      if ( !guessing ) {
         initial_value  = initialization();

      } else {
        initialization();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err280,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  id = id_list->first();
  while (id != NULL) {
    new_decl = new IIR_FreeQuantityDeclaration();
    IIR::copy_location( id, new_decl );
    new_decl->set_declarator( id );
    new_decl->set_value( initial_value );
    new_decl->set_subtype( type_def );
    new_decl->_add_declaration();
    new_decl->_type_check();
    decl_list->append(new_decl);
    id_list->remove( id );
    id = id_list->first();
  }
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd71, 0x1);
}

void
VHDLParser::branch_quantity_declaration(IIR_DeclarationList * decl_list)
{
  zzRULE;
  
  IIR_BranchQuantityDeclaration *new_decl = new IIR_BranchQuantityDeclaration();
  IIR_BranchQuantityDeclaration *new_quan = NULL;
  IIR *across = NULL;
  IIR *through = NULL;
  IIR *quan_name = NULL;
  IIR *plus_terminal = NULL;
  IIR *minus_terminal = NULL;
  IIR *across_value = NULL;
  IIR *across_tolerance = NULL;
  IIR *through_tolerance = NULL;
  IIR_Designator *designator = NULL;
  IIR_Declaration *terminal_plus_decl = NULL;
  IIR_Declaration *terminal_minus_decl = NULL;
  IIR *nature_decl = NULL;
  set<IIR_Declaration>* plus_terminal_decl_set;
  set<IIR_Declaration>* minus_terminal_decl_set;
  set<IIR>* nature_decl_set;
  IIR_IdentifierList *id_list = NULL;
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (setwd71[LA(1)]&0x2) && (setwd71[LA(2)]&0x4) ) {
      {
        identifier_list( id_list );
        {
          if ( (LA(1)==TOLERANCE) ) {
            if ( !guessing ) {
               across_tolerance  = tolerance_aspect();

            } else {
              tolerance_aspect();
            }
          }
          else {
            if ( (setwd71[LA(1)]&0x8) ) {
            }
            else {FAIL(1,err281,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
        {
          if ( (LA(1)==COLON_EQUAL)
 ) {
            if ( !guessing ) {
               across_value  = initialization();

            } else {
              initialization();
            }
          }
          else {
            if ( (LA(1)==ACROSS) ) {
            }
            else {FAIL(1,err282,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
          }
        }
        zzmatch(ACROSS); consume();
      }
      zzGUESS_DONE
      if ( !guessing ) {
        { struct _rv262 _trv; _trv = across_aspect( &new_decl->across_aspect_identifier_list );

        across_tolerance = _trv.across_tolerance; across  = _trv.across_value; }
      } else {
        across_aspect( &new_decl->across_aspect_identifier_list );
      }
      if ( !guessing ) {
      
      new_decl->set_across_aspect_expression(across);
      new_decl->set_across_aspect_tolerance(across_tolerance);
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd71[LA(1)]&0x10) && (setwd71[LA(2)]&0x20) ) {
      }
      else {FAIL(2,err283,err284,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (setwd71[LA(1)]&0x40) && (setwd71[LA(2)]&0x80) ) {
      if ( !guessing ) {
        { struct _rv263 _trv; _trv = through_aspect( &new_decl->through_aspect_designator_list );

        through_tolerance = _trv.through_tolerance; through  = _trv.through_value; }
      } else {
        through_aspect( &new_decl->through_aspect_designator_list );
      }
      if ( !guessing ) {
      
      new_decl->set_through_aspect_expression(through);
      new_decl->set_through_aspect_tolerance(through_tolerance);
      }
    }
    else {
      if ( (setwd72[LA(1)]&0x1) && (setwd72[LA(2)]&0x2) ) {
      }
      else {FAIL(2,err285,err286,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
    { struct _rv264 _trv; _trv = terminal_aspect();

    plus_terminal = _trv.plus_terminal; minus_terminal  = _trv.minus_terminal; }
  } else {
    terminal_aspect();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  if(plus_terminal){
    plus_terminal_decl_set = plus_terminal->_symbol_lookup();
  }
  if (plus_terminal_decl_set->num_elements() == 0) {
    report_undefined_symbol(plus_terminal);
  }
  else {
    terminal_plus_decl = plus_terminal_decl_set->get_element();
    new_decl->set_plus_terminal_name(plus_terminal);
  }
  if (minus_terminal == NULL){
    IIR_Declaration* plus_terminal_decl = plus_terminal_decl_set->get_element();
    IIR_TypeDefinition* terminal_nature = plus_terminal_decl->get_subtype();
    IIR_Declaration* nature_decl ;
    nature_decl = terminal_nature->_get_declaration();
    terminal_minus_decl = ((IIR_Declaration*)((IIR_NatureDeclaration*)nature_decl)->_get_reference_terminal());
    new_decl->set_minus_terminal_name(terminal_minus_decl);
  }
  else {
    minus_terminal_decl_set = minus_terminal->_symbol_lookup();
    terminal_minus_decl = minus_terminal_decl_set->get_element();
    new_decl->set_minus_terminal_name(terminal_minus_decl);
  }
  designator = new_decl->across_aspect_identifier_list.first();
  while (designator != NULL) {
    quan_name = ((IIR_DesignatorExplicit *)designator)->get_name();
    new_quan = new IIR_BranchQuantityDeclaration();
    IIR::copy_location( quan_name, new_quan );
    new_quan->set_declarator((IIR_Identifier *)quan_name);
    new_quan->set_across_aspect_expression(across);
    new_quan->set_plus_terminal_name(terminal_plus_decl);
    new_quan->set_minus_terminal_name(terminal_minus_decl);
    new_quan->set_across_aspect_tolerance(across_tolerance);
    IIR_TypeDefinition* nature_definition = terminal_plus_decl->get_subtype();
    IIR_TypeDefinition* minus_nature_definition = terminal_minus_decl->get_subtype();
    IIR_TypeDefinition* typedefn = NULL;
    typedefn = ((IIR_ScalarNatureDefinition*)nature_definition)->get_across();
    new_quan->set_subtype(typedefn);
    new_quan->across_aspect_identifier_list.append(designator);
    new_quan->_add_declaration();
    decl_list->append(new_quan);
    designator = new_decl->across_aspect_identifier_list.successor(designator);
    new_quan->_type_check();
  }
  }
 consume();
  if ( !guessing ) {
  
  designator = new_decl->through_aspect_designator_list.first();
  while (designator != NULL) {
    quan_name = ((IIR_DesignatorExplicit *)designator)->get_name();
    new_quan = new IIR_BranchQuantityDeclaration();
    IIR::copy_location( quan_name, new_quan );
    new_quan->set_declarator((IIR_Identifier *)quan_name);
    new_quan->set_through_aspect_expression(through);
    new_quan->set_plus_terminal_name(terminal_plus_decl);
    new_quan->set_minus_terminal_name(terminal_minus_decl);
    new_quan->set_through_aspect_tolerance(through_tolerance);
    IIR_TypeDefinition* nature_definition = terminal_plus_decl->get_subtype();
    IIR_TypeDefinition* minus_nature_definition = terminal_minus_decl->get_subtype();
    IIR_TypeDefinition* typedefn = NULL;
    typedefn = ((IIR_ScalarNatureDefinition*)nature_definition)->get_through();
    new_quan->set_subtype(typedefn);
    new_quan->through_aspect_designator_list.append(designator);
    new_quan->_add_declaration();
    decl_list->append(new_quan);
    designator = new_decl->through_aspect_designator_list.successor(designator);
    new_quan->_type_check();
  }
  delete new_decl;
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd72, 0x4);
}

void
VHDLParser::source_quantity_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  
  IIR_SourceQuantityDeclaration *new_decl = NULL;
  IIR_IdentifierList *id_list = NULL; 
  id_list = new IIR_IdentifierList();
  IIR_TypeDefinition *type_def = NULL;
  IIR* mag_exp = NULL;  
  IIR* ph_exp= NULL;
  IIR* noise_exp = NULL;
  IIR_Identifier *id = NULL;
  set<IIR_Declaration>* mag_exp_set;
  set<IIR_Declaration>* ph_exp_set;
  set<IIR_Declaration>* noise_exp_set;
  identifier_list( id_list );
  zzmatch(COLON); consume();
  if ( !guessing ) {
     type_def  = subtype_indication();

  } else {
    subtype_indication();
  }
  if ( !guessing ) {
    { struct _rv266 _trv; _trv = source_aspect();

    mag_exp = _trv.magnitude_expr; ph_exp = _trv.phase_expr; noise_exp  = _trv.noise_expr; }
  } else {
    source_aspect();
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  if (noise_exp==NULL) {
    if (mag_exp) {
      mag_exp_set = mag_exp->_symbol_lookup();
    }
    if (mag_exp_set->num_elements() == 0) {
      report_undefined_symbol(mag_exp);
    }
    if (ph_exp) {
      ph_exp_set = ph_exp->_symbol_lookup();
    }
    if (ph_exp_set->num_elements() == 0) {
      report_undefined_symbol(ph_exp);
    }
  } 
  else {
    if (noise_exp) {
      noise_exp_set = noise_exp->_symbol_lookup();
    }
    if (noise_exp_set->num_elements() == 0) {
      report_undefined_symbol(noise_exp);
    }
  }
  id = id_list->first();
  while (id != NULL) {
    new_decl = new IIR_SourceQuantityDeclaration();
    IIR::copy_location( id, new_decl );
    new_decl->set_declarator(id);
    new_decl->set_magnitude_expression(mag_exp);
    new_decl->set_phase_expression(ph_exp);
    new_decl->set_noise_expression(noise_exp);
    new_decl->set_subtype(type_def);
    my_symbol_table->add_declaration( new_decl );
    list->append(new_decl);
    id_list->remove(id);  
    id = id_list->first();
  }
  }
 consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd72, 0x8);
}

VHDLParser::_rv262
VHDLParser::across_aspect(IIR_DesignatorList * across_list)
{
  struct _rv262 _retv;
  zzRULE;
  ANTLRTokenPtr across_=NULL;
  PCCTS_PURIFY(_retv,sizeof(struct _rv262))
  
  _retv.across_tolerance = NULL;
  IIR_IdentifierList *id_list = new IIR_IdentifierList();
  IIR_Identifier *id = NULL;;
  _retv.across_value = NULL;
  identifier_list( id_list );
  if ( !guessing ) {
  
  id = id_list->first();
  while( id != NULL){
    IIR_DesignatorExplicit *designator = new IIR_DesignatorExplicit();
    designator->set_name(id);
    across_list->append(designator);
    id_list->remove(id);
    id = id_list->first();
  }
  }
  {
    if ( (LA(1)==TOLERANCE)
 ) {
      if ( !guessing ) {
         _retv.across_tolerance  = tolerance_aspect();

      } else {
        tolerance_aspect();
      }
    }
    else {
      if ( (setwd72[LA(1)]&0x10) ) {
      }
      else {FAIL(1,err287,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==COLON_EQUAL) ) {
      if ( !guessing ) {
         _retv.across_value  = initialization();

      } else {
        initialization();
      }
    }
    else {
      if ( (LA(1)==ACROSS) ) {
      }
      else {FAIL(1,err288,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(ACROSS);
  if ( !guessing ) {
    across_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd72, 0x20);
  return _retv;
}

VHDLParser::_rv263
VHDLParser::through_aspect(IIR_DesignatorList * through_list)
{
  struct _rv263 _retv;
  zzRULE;
  ANTLRTokenPtr through_=NULL;
  PCCTS_PURIFY(_retv,sizeof(struct _rv263))
  
  _retv.through_tolerance = NULL;
  IIR_IdentifierList *id_list = new IIR_IdentifierList();;
  IIR_Identifier *id = NULL;
  IIR *initial_value = NULL;
  _retv.through_value = NULL;
  identifier_list( id_list );
  if ( !guessing ) {
  
  id = id_list->first();
  while( id != NULL ) {
    IIR_DesignatorExplicit *designator = new IIR_DesignatorExplicit();
    designator->set_name(id);
    through_list->append(designator);
    id_list->remove(id);
    id = id_list->first();
  }
  }
  {
    if ( (LA(1)==TOLERANCE) ) {
      if ( !guessing ) {
         _retv.through_tolerance  = tolerance_aspect();

      } else {
        tolerance_aspect();
      }
    }
    else {
      if ( (setwd72[LA(1)]&0x40)
 ) {
      }
      else {FAIL(1,err289,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==COLON_EQUAL) ) {
      if ( !guessing ) {
         _retv.through_value  = initialization();

      } else {
        initialization();
      }
    }
    else {
      if ( (LA(1)==THROUGH) ) {
      }
      else {FAIL(1,err290,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(THROUGH);
  if ( !guessing ) {
    through_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd72, 0x80);
  return _retv;
}

VHDLParser::_rv264
VHDLParser::terminal_aspect(void)
{
  struct _rv264 _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(struct _rv264))
  _retv.minus_terminal = NULL;
  if ( !guessing ) {
      _retv.plus_terminal   = simple_name();

  } else {
    simple_name();
  }
  {
    if ( (LA(1)==TO) ) {
      zzmatch(TO); consume();
      if ( !guessing ) {
          _retv.minus_terminal   = simple_name();

      } else {
        simple_name();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err291,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd73, 0x1);
  return _retv;
}

IIR*
VHDLParser::tolerance_aspect(void)
{
  IIR*   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR*  ))
  _retv = NULL;
  zzmatch(TOLERANCE); consume();
  if ( !guessing ) {
     _retv  = expression();

  } else {
    expression();
  }
  if ( !guessing ) {
  
  ostringstream err;
  err << "Tolerances in branch quantity declarations are not yet supported. "
  << "Using default tolerances. ";
  report_error( _retv, err.str(), WARNING );
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd73, 0x2);
  return _retv;
}

VHDLParser::_rv266
VHDLParser::source_aspect(void)
{
  struct _rv266 _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(struct _rv266))
  
  _retv.magnitude_expr = NULL;
  _retv.phase_expr = NULL;
  _retv.noise_expr = NULL;
  if ( (LA(1)==NOISE)
 ) {
    zzmatch(NOISE); consume();
    if ( !guessing ) {
       _retv.noise_expr  = simple_expression();

    } else {
      simple_expression();
    }
  }
  else {
    if ( (LA(1)==SPECTRUM) ) {
      zzmatch(SPECTRUM); consume();
      if ( !guessing ) {
         _retv.magnitude_expr  = simple_expression();

      } else {
        simple_expression();
      }
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         _retv.phase_expr  = simple_expression();

      } else {
        simple_expression();
      }
    }
    else {FAIL(1,err292,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd73, 0x4);
  return _retv;
}

void
VHDLParser::step_limit_specification(IIR_DeclarationList * decl_list)
{
  zzRULE;
  
  IIR_Name *type_name = NULL;
  IIR_TypeDefinition *type_def = NULL;
  IIR *expr = NULL;
  zzmatch(LIMIT); consume();
  {
    if ( (setwd73[LA(1)]&0x8) ) {
      if ( !guessing ) {
         type_name  = selected_or_simple_name();

      } else {
        selected_or_simple_name();
      }
      {
        while ( (LA(1)==COMMA) ) {
          zzmatch(COMMA); consume();
          if ( !guessing ) {
             type_name  = selected_or_simple_name();

          } else {
            selected_or_simple_name();
          }
        }
      }
    }
    else {
      if ( (LA(1)==OTHERS) ) {
        zzmatch(OTHERS); consume();
      }
      else {
        if ( (LA(1)==ALL)
 ) {
          zzmatch(ALL); consume();
        }
        else {FAIL(1,err293,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
      }
    }
  }
  zzmatch(COLON); consume();
  if ( !guessing ) {
     type_def  = type_mark();

  } else {
    type_mark();
  }
  zzmatch(WITH); consume();
  if ( !guessing ) {
     expr  = expression();

  } else {
    expression();
  }
  zzmatch(SEMI_COLON); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd73, 0x10);
}

IIR_ScalarNatureDefinition *
VHDLParser::scalar_nature_definition(IIR_NatureDeclaration * nature_decl)
{
  IIR_ScalarNatureDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_ScalarNatureDefinition *  ))
  
  _retv = NULL;
  IIR_TypeDefinition *across_type_def = NULL;
  IIR_TypeDefinition *through_type_def = NULL;
  IIR_Identifier *reference_terminal_name = NULL;
  IIR* across_tolerance = NULL;
  IIR* through_tolerance = NULL;
  if ( !guessing ) {
     across_type_def  = type_mark();

  } else {
    type_mark();
  }
  zzmatch(ACROSS);
  if ( !guessing ) {
  
  _retv = new IIR_ScalarNatureDefinition();
  _retv->set_across(across_type_def);
  _retv->floating_point_type_check(across_type_def);
  }
 consume();
  if ( !guessing ) {
     through_type_def  = type_mark();

  } else {
    type_mark();
  }
  zzmatch(THROUGH);
  if ( !guessing ) {
  
  _retv->set_through(through_type_def);
  _retv->floating_point_type_check(through_type_def);
  }
 consume();
  if ( !guessing ) {
     reference_terminal_name  = identifier();

  } else {
    identifier();
  }
  zzmatch(REFERENCE);
  if ( !guessing ) {
  
  IIR_TerminalDeclaration *reference_terminal = NULL;
  reference_terminal = new IIR_TerminalDeclaration();
  reference_terminal->set_declarator(reference_terminal_name);
  _retv->set_reference_terminal(reference_terminal);
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd73, 0x20);
  return _retv;
}

IIR_ArrayNatureDefinition *
VHDLParser::array_nature_definition(IIR_NatureDeclaration * nature_decl)
{
  IIR_ArrayNatureDefinition *   _retv;
  zzRULE;
  ANTLRTokenPtr array_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ArrayNatureDefinition *  ))
  
  _retv = NULL;
  IIR_ScalarTypeDefinition *index_subtype = NULL;
  IIR_NatureDefinition *element_subtype = NULL;
  IIR_ArrayNatureDefinition *prev_subtype = NULL;
  IIR_ArrayNatureDefinition *final_subtype = NULL;
  IIR_Boolean is_unconstrained = false;
  IIR_Boolean err_flag = false;
  zzmatch(ARRAY);
  if ( !guessing ) {
    array_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  zzmatch(L_PAREN); consume();
  if ( !guessing ) {
     index_subtype  = array_dimension();

  } else {
    array_dimension();
  }
  if ( !guessing ) {
  
  _retv = IIR_ArrayNatureDefinition::_construct_array_type( index_subtype, NULL, nature_decl );
  if( _retv->_is_unconstrained_array_type() ){
    
      is_unconstrained = TRUE;
  }
  copy_location(array_, _retv);
  final_subtype = _retv;
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         index_subtype  = array_dimension();

      } else {
        array_dimension();
      }
      if ( !guessing ) {
      
      prev_subtype = final_subtype;
      final_subtype = IIR_ArraySubnatureDefinition::_construct_array_type( index_subtype, NULL, NULL );
      prev_subtype->set_element_subtype( final_subtype );
      ASSERT( prev_subtype->get_base_type() != NULL );
      ASSERT( prev_subtype->get_base_type()->_is_iir_array_type_definition() == TRUE );
      ((IIR_ArrayNatureDefinition *)prev_subtype->get_base_type())->set_element_subtype( final_subtype );
      if( is_unconstrained == TRUE ){
        if( final_subtype->_is_unconstrained_array_type() == FALSE ){
          err_flag = TRUE;
        }
      }
      else{
        if( final_subtype->_is_unconstrained_array_type() == TRUE ){
          err_flag = TRUE;	
        }
      }
      
      if( err_flag == TRUE ){
        ostringstream err;
        err << "All indexes of an array must be either constrained or unconstrained."
        << " They cannot be mixed.";
        report_error( index_subtype, err.str() );
      }
      }
    }
  }
  zzmatch(R_PAREN); consume();
  zzmatch(OF); consume();
  if ( !guessing ) {
     element_subtype  = subnature_indication();

  } else {
    subnature_indication();
  }
  if ( !guessing ) {
  
  if( element_subtype->_is_array_type() == TRUE ){
    element_subtype->set_is_element( TRUE );
  }
  final_subtype->set_element_subtype(element_subtype);
  if( final_subtype->get_base_type() != NULL ){
    ASSERT( final_subtype->get_base_type()->_is_iir_array_type_definition() == TRUE );
    ((IIR_ArrayNatureDefinition *)final_subtype->get_base_type())->set_element_subtype( element_subtype );
  }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd73, 0x40);
  return _retv;
}

void
VHDLParser::record_nature_definition(void)
{
  zzRULE;
  ANTLRTokenPtr record=NULL;
  IIR_Name *end_name = NULL;
  zzmatch(RECORD);
  if ( !guessing ) {
    record = (ANTLRTokenPtr)LT(1);
  }
   consume();
  {
    int zzcnt=1;
    do {
      nature_element_declaration();
    } while ( (setwd73[LA(1)]&0x80) );
  }
  zzmatch(END); consume();
  zzmatch(RECORD); consume();
  {
    if ( (setwd74[LA(1)]&0x1) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err294,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd74, 0x2);
}

void
VHDLParser::nature_element_declaration(void)
{
  zzRULE;
  ANTLRTokenPtr colon=NULL;
  
  IIR_IdentifierList *id_list = NULL;
  IIR_TypeDefinition *elem_subtype = NULL;
  if ( !guessing ) {
  id_list = new IIR_IdentifierList();
  }
  identifier_list( id_list );
  zzmatch(COLON);
  if ( !guessing ) {
    colon = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     elem_subtype  = subnature_indication();

  } else {
    subnature_indication();
  }
  zzmatch(SEMI_COLON); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd74, 0x4);
}

void
VHDLParser::subnature_declaration(IIR_DeclarationList * list)
{
  zzRULE;
  ANTLRTokenPtr subnature=NULL;
  
  IIR_TypeDefinition *type_definition = NULL;
  IIR_Identifier *subnature_name = NULL;
  //IIR_SubnatureDeclaration *new_subnature_decl = NULL;
  zzmatch(SUBNATURE);
  if ( !guessing ) {
    subnature = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     subnature_name  = identifier();

  } else {
    identifier();
  }
  zzmatch(IS); consume();
  if ( !guessing ) {
     type_definition  = subnature_indication();

  } else {
    subnature_indication();
  }
  zzmatch(SEMI_COLON); consume();
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd74, 0x8);
}

IIR_NatureDefinition *
VHDLParser::subnature_indication(void)
{
  IIR_NatureDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_NatureDefinition *  ))
  
  _retv = NULL;
  IIR_NatureDefinition *base_type = NULL;
  IIR_TypeDefinition *new_constrained_type = NULL;
  IIR *tolerance_expression = NULL;
  IIR *across_expression = NULL;
  if ( !guessing ) {
     base_type  = nature_mark();

  } else {
    nature_mark();
  }
  {
    if ( (LA(1)==L_PAREN)
 ) {
      if ( !guessing ) {
         new_constrained_type  = index_constraint( base_type );

      } else {
        index_constraint( base_type );
      }
      if ( !guessing ) {
      
      if( new_constrained_type != NULL ){
        new_constrained_type->_set_type_mark( base_type );
      }
      }
    }
    else {
      if ( (setwd74[LA(1)]&0x10) ) {
      }
      else {FAIL(1,err295,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  if( new_constrained_type == NULL){
    _retv = base_type;
  }
  else{
    _retv = (IIR_NatureDefinition *)new_constrained_type;
  }
  }
  {
    if ( (LA(1)==TOLERANCE) ) {
      zzmatch(TOLERANCE); consume();
      if ( !guessing ) {
         tolerance_expression  = expression();

      } else {
        expression();
      }
      zzmatch(ACROSS); consume();
      if ( !guessing ) {
         across_expression  = expression();

      } else {
        expression();
      }
      zzmatch(THROUGH); consume();
    }
    else {
      if ( (setwd74[LA(1)]&0x20) ) {
      }
      else {FAIL(1,err296,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  if (_retv != NULL){
    _retv->_type_check();
  }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd74, 0x40);
  return _retv;
}

IIR_NatureDefinition *
VHDLParser::nature_mark(void)
{
  IIR_NatureDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_NatureDefinition *  ))
  
  _retv = NULL;
  IIR_Name *nature_name = NULL;
  if ( !guessing ) {
     nature_name  = selected_or_simple_name();

  } else {
    selected_or_simple_name();
  }
  if ( !guessing ) {
  
  set<IIR_TypeDefinition> *nature_set = nature_name->_get_rval_set();
  if( nature_set == NULL )  {
    report_undefined_symbol(nature_name);
  }
  else if( nature_set->num_elements() > 1 ){
    report_ambiguous_error(nature_name, nature_set);
    panic("nature_mark resolution failed in VHDLParser::nature_mark");
  }
  else {
    _retv = (IIR_NatureDefinition *)(nature_set->get_element());
    if( _retv == NULL ){
      ostringstream err;
      err << "|" << *nature_name << "| was not declared as a nature in this scope";
      report_error( nature_name, err.str() );
    }
    delete nature_name;
  }
  delete nature_set;
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd74, 0x80);
  return _retv;
}

IIR_ConcurrentBreakStatement *
VHDLParser::concurrent_break_statement(IIR_Label * label)
{
  IIR_ConcurrentBreakStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr concurrent_break_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_ConcurrentBreakStatement *  ))
  
  _retv = NULL;
  IIR *when_expression = NULL;
  zzmatch(BREAK);
  if ( !guessing ) {
    concurrent_break_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_ConcurrentBreakStatement();
  _retv->set_label(label);
  copy_location(concurrent_break_,_retv);
  }
 consume();
  {
    if ( (setwd75[LA(1)]&0x1) ) {
      break_list( &_retv->concurrent_break_list );
    }
    else {
      if ( (setwd75[LA(1)]&0x2)
 ) {
      }
      else {FAIL(1,err297,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==ON) ) {
      sensitivity_clause( &_retv->sensitivity_list );
    }
    else {
      if ( (setwd75[LA(1)]&0x4) ) {
      }
      else {FAIL(1,err298,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==WHEN) ) {
      zzmatch(WHEN); consume();
      if ( !guessing ) {
         when_expression  = condition();

      } else {
        condition();
      }
      if ( !guessing ) {
      _retv->set_condition(when_expression);
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err299,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  _retv->_type_check();
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd75, 0x8);
  return _retv;
}

void
VHDLParser::set_of_simultaneous_statements(IIR_ArchitectureStatementList * stmts)
{
  zzRULE;
  {
    while ( (setwd75[LA(1)]&0x10)
 ) {
      simultaneous_statement(  stmts );
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd75, 0x20);
}

void
VHDLParser::simultaneous_statement(IIR_ArchitectureStatementList * stmts)
{
  zzRULE;
  
  IIR_SimultaneousStatement *new_stmt = NULL;
  IIR_Label *label = NULL;;
  {
    if ( (setwd75[LA(1)]&0x40) && (LA(2)==COLON) ) {
      if ( !guessing ) {
         label  = stmt_label();

      } else {
        stmt_label();
      }
    }
    else {
      if ( (setwd75[LA(1)]&0x80) && (setwd76[LA(2)]&0x1) ) {
      }
      else {FAIL(2,err300,err301,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
     new_stmt  = simultaneous_stmt( label );

  } else {
    simultaneous_stmt( label );
  }
  if ( !guessing ) {
  stmts->append(new_stmt);
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd76, 0x2);
}

IIR_SimultaneousStatement *
VHDLParser::simultaneous_stmt(IIR_Label * label)
{
  IIR_SimultaneousStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimultaneousStatement *  ))
  if ( (setwd76[LA(1)]&0x4) && (setwd76[LA(2)]&0x8) ) {
    if ( !guessing ) {
       _retv  = simple_simultaneous_statement( label );

    } else {
      simple_simultaneous_statement( label );
    }
  }
  else {
    if ( (LA(1)==IF) ) {
      if ( !guessing ) {
         _retv  = simultaneous_if_statement( label );

      } else {
        simultaneous_if_statement( label );
      }
    }
    else {
      if ( (LA(1)==CASE)
 ) {
        if ( !guessing ) {
           _retv  = simultaneous_case_statement( label );

        } else {
          simultaneous_case_statement( label );
        }
      }
      else {
        if ( (LA(1)==PROCEDURAL) ) {
          if ( !guessing ) {
             _retv  = simultaneous_procedural_statement( label );

          } else {
            simultaneous_procedural_statement( label );
          }
        }
        else {
          if ( (LA(1)==NULL_) && (LA(2)==SEMI_COLON) ) {
            if ( !guessing ) {
               _retv  = simultaneous_null_statement( label );

            } else {
              simultaneous_null_statement( label );
            }
          }
          else {FAIL(2,err302,err303,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
        }
      }
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd76, 0x10);
  return _retv;
}

IIR_SimpleSimultaneousStatement *
VHDLParser::simple_simultaneous_statement(IIR_Label * label)
{
  IIR_SimpleSimultaneousStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr double_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimpleSimultaneousStatement *  ))
  
  _retv = NULL;
  IIR *left_expression = NULL;
  IIR *right_expression = NULL;
  IIR *tolerance_expression = NULL;
  if ( !guessing ) {
     left_expression  = simple_expression();

  } else {
    simple_expression();
  }
  zzmatch(EQUAL_EQUAL);
  if ( !guessing ) {
    double_ = (ANTLRTokenPtr)LT(1);
  }
   consume();
  if ( !guessing ) {
     right_expression  = simple_expression();

  } else {
    simple_expression();
  }
  {
    if ( (LA(1)==TOLERANCE) ) {
      zzmatch(TOLERANCE); consume();
      if ( !guessing ) {
         tolerance_expression  = expression();

      } else {
        expression();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err304,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  
  _retv = new IIR_SimpleSimultaneousStatement();
  copy_location(double_,_retv);
  _retv->set_label(label);
  _retv->set_left_expression(left_expression);
  _retv->set_right_expression(right_expression);
  _retv->set_tolerance_aspect(tolerance_expression);
  _retv->_type_check();
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd76, 0x20);
  return _retv;
}

IIR_SimultaneousIfStatement *
VHDLParser::simultaneous_if_statement(IIR_Label * label)
{
  IIR_SimultaneousIfStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr if_=NULL, else_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimultaneousIfStatement *  ))
  
  _retv = NULL;
  IIR *if_condition = NULL;
  IIR_SimpleName *end_name = NULL;
  IIR_SimultaneousElsif *simul_elsif = NULL;
  zzmatch(IF);
  if ( !guessing ) {
    if_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_SimultaneousIfStatement();
  _retv->set_label(label);
  copy_location(if_,_retv);
  }
 consume();
  if ( !guessing ) {
     if_condition  = condition();

  } else {
    condition();
  }
  if ( !guessing ) {
  _retv->set_condition(if_condition);
  }
  zzmatch(USE); consume();
  set_of_simultaneous_statements( &_retv->then_statement_list );
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==ELSIF)
 ) {
      {
        zzmatch(ELSIF); consume();
      }
      zzGUESS_DONE
      if ( !guessing ) {
         simul_elsif  = simultaneous_elsif();

      } else {
        simultaneous_elsif();
      }
      if ( !guessing ) {
      _retv->set_elsif(simul_elsif);
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd76[LA(1)]&0x40) ) {
      }
      else {FAIL(1,err305,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==ELSE) ) {
      zzmatch(ELSE);
      if ( !guessing ) {
            else_ = (ANTLRTokenPtr)LT(1);
      }
       consume();
      set_of_simultaneous_statements( &_retv->else_statement_list );
    }
    else {
      if ( (LA(1)==END) ) {
      }
      else {FAIL(1,err306,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(END); consume();
  zzmatch(USE); consume();
  {
    if ( (setwd76[LA(1)]&0x80) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON)
 ) {
      }
      else {FAIL(1,err307,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON);
  if ( !guessing ) {
  _retv->_type_check();
  }
 consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd77, 0x1);
  return _retv;
}

IIR_SimultaneousElsif *
VHDLParser::simultaneous_elsif(void)
{
  IIR_SimultaneousElsif *   _retv;
  zzRULE;
  ANTLRTokenPtr sim_elsif_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimultaneousElsif *  ))
  
  _retv = NULL;
  IIR* cond = NULL;
  IIR_SimultaneousElsif* next_elsif = NULL;
  zzmatch(ELSIF);
  if ( !guessing ) {
    sim_elsif_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_SimultaneousElsif();
  copy_location(sim_elsif_,_retv);
  }
 consume();
  if ( !guessing ) {
     cond  = condition();

  } else {
    condition();
  }
  zzmatch(USE); consume();
  set_of_simultaneous_statements( &_retv->then_sequence_of_statements );
  if ( !guessing ) {
  _retv->set_condition(cond);
  }
  {
    zzGUESS_BLOCK
    zzGUESS
    if ( !zzrv && (LA(1)==ELSIF) ) {
      {
        zzmatch(ELSIF); consume();
      }
      zzGUESS_DONE
      if ( !guessing ) {
         next_elsif  = simultaneous_elsif();

      } else {
        simultaneous_elsif();
      }
      if ( !guessing ) {
      _retv->set_else_clause(next_elsif);
      }
    }
    else {
      if ( !zzrv ) zzGUESS_DONE;
      if ( (setwd77[LA(1)]&0x2) ) {
      }
      else {FAIL(1,err308,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd77, 0x4);
  return _retv;
}

IIR_SimultaneousStatement *
VHDLParser::simultaneous_case_statement(IIR_Label * label)
{
  IIR_SimultaneousStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimultaneousStatement *  ))
  
  _retv = NULL;
  IIR *selector = NULL;
  IIR_CaseStatementAlternative *alt = NULL;
  IIR_SimpleName *end_name = NULL;
  zzmatch(CASE); consume();
  if ( !guessing ) {
     selector  = expression();

  } else {
    expression();
  }
  zzmatch(USE); consume();
  {
    int zzcnt=1;
    do {
      zzmatch(WHEN); consume();
      if ( !guessing ) {
         alt  = choices();

      } else {
        choices();
      }
      zzmatch(EQUAL_GREATER); consume();
      set_of_simultaneous_statements( NULL );
    } while ( (LA(1)==WHEN) );
  }
  zzmatch(END); consume();
  zzmatch(CASE); consume();
  {
    if ( (setwd77[LA(1)]&0x8) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON)
 ) {
      }
      else {FAIL(1,err309,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON); consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd77, 0x10);
  return _retv;
}

IIR_SimultaneousStatement *
VHDLParser::simultaneous_procedural_statement(IIR_Label * label)
{
  IIR_SimultaneousStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimultaneousStatement *  ))
  
  _retv = NULL;
  IIR_SimpleName *end_name = NULL;
  zzmatch(PROCEDURAL); consume();
  {
    if ( (LA(1)==IS) ) {
      zzmatch(IS); consume();
    }
    else {
      if ( (setwd77[LA(1)]&0x20) ) {
      }
      else {FAIL(1,err310,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    while ( (setwd77[LA(1)]&0x40) ) {
      procedural_declarative_item( NULL );
    }
  }
  zzmatch(BEGIN_); consume();
  sequence_of_statements( NULL );
  zzmatch(END); consume();
  zzmatch(PROCEDURAL); consume();
  {
    if ( (setwd77[LA(1)]&0x80) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON)
 ) {
      }
      else {FAIL(1,err311,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  zzmatch(SEMI_COLON); consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd78, 0x1);
  return _retv;
}

void
VHDLParser::procedural_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  zzGUESS_BLOCK
  if ( (setwd78[LA(1)]&0x2) ) {
    subprogram( decl_list );
  }
  else {
    if ( (LA(1)==TYPE) ) {
      type_declaration( decl_list );
    }
    else {
      if ( (LA(1)==SUBTYPE) ) {
        subtype_declaration( decl_list );
      }
      else {
        if ( (LA(1)==CONSTANT) ) {
          constant_declaration( decl_list );
        }
        else {
          if ( (setwd78[LA(1)]&0x4)
 ) {
            variable_declaration( decl_list );
          }
          else {
            if ( (LA(1)==ALIAS) ) {
              alias_declaration( decl_list );
            }
            else {
              if ( (LA(1)==ATTRIBUTE) ) {
                attribute_declarative_item( decl_list );
              }
              else {
                if ( (LA(1)==USE) ) {
                  use_clause( decl_list );
                }
                else {
                  zzGUESS
                  if ( !zzrv && (LA(1)==GROUP) && (setwd78[LA(2)]&0x8) ) {
                    {
                      zzmatch(GROUP); consume();
                      zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset); consume();
                      zzmatch(COLON); consume();
                    }
                    zzGUESS_DONE
                    group_declaration( decl_list );
                  }
                  else {
                    if ( !zzrv ) zzGUESS_DONE;
                    if ( (LA(1)==GROUP) && 
(setwd78[LA(2)]&0x10) ) {
                      group_template_declaration( decl_list );
                    }
                    else {FAIL(2,err312,err313,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd78, 0x20);
}

IIR_SimultaneousStatement *
VHDLParser::simultaneous_null_statement(IIR_Label * label)
{
  IIR_SimultaneousStatement *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_SimultaneousStatement *  ))
  _retv = NULL;
  zzmatch(NULL_); consume();
  zzmatch(SEMI_COLON); consume();
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd78, 0x40);
  return _retv;
}

void
VHDLParser::break_list(IIR_BreakList * list)
{
  zzRULE;
  IIR_BreakElement *element = NULL;
  if ( !guessing ) {
     element  = break_element();

  } else {
    break_element();
  }
  if ( !guessing ) {
  list->append(element);
  }
  {
    while ( (LA(1)==COMMA) ) {
      zzmatch(COMMA); consume();
      if ( !guessing ) {
         element  = break_element();

      } else {
        break_element();
      }
      if ( !guessing ) {
      list->append(element);
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd78, 0x80);
}

IIR_BreakElement*
VHDLParser::break_element(void)
{
  IIR_BreakElement*   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_BreakElement*  ))
  
  _retv = NULL;
  IIR_Name* quantity_name = NULL;
  IIR_Name* selector_quantity_name = NULL;
  IIR* expr = NULL;
  {
    if ( (LA(1)==FOR) ) {
      zzmatch(FOR); consume();
      if ( !guessing ) {
         selector_quantity_name  = complex_name();

      } else {
        complex_name();
      }
      zzmatch(USE); consume();
    }
    else {
      if ( (setwd79[LA(1)]&0x1) ) {
      }
      else {FAIL(1,err314,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
     quantity_name  = complex_name();

  } else {
    complex_name();
  }
  zzmatch(EQUAL_GREATER); consume();
  if ( !guessing ) {
     expr  = expression();

  } else {
    expression();
  }
  if ( !guessing ) {
  
  _retv = new IIR_BreakElement();
  _retv->set_quantity_name(quantity_name);
  _retv->set_selector_quantity_name(selector_quantity_name);
  _retv->set_expression(expr);
  _retv->set_line_number(LT(1)->getLine());
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd79, 0x2);
  return _retv;
}

IIR_BreakStatement *
VHDLParser::break_statement(IIR_Label * label)
{
  IIR_BreakStatement *   _retv;
  zzRULE;
  ANTLRTokenPtr break_=NULL;
  PCCTS_PURIFY(_retv,sizeof(IIR_BreakStatement *  ))
  
  _retv = NULL;
  IIR *break_condition = NULL;
  zzmatch(BREAK);
  if ( !guessing ) {
    break_ = (ANTLRTokenPtr)LT(1);
  }
  
  if ( !guessing ) {
  
  _retv = new IIR_BreakStatement;
  copy_location(break_,_retv);
  }
 consume();
  {
    if ( (setwd79[LA(1)]&0x4) ) {
      break_list( &_retv->break_list );
    }
    else {
      if ( (setwd79[LA(1)]&0x8)
 ) {
      }
      else {FAIL(1,err315,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  {
    if ( (LA(1)==WHEN) ) {
      zzmatch(WHEN); consume();
      if ( !guessing ) {
         break_condition  = condition();

      } else {
        condition();
      }
      if ( !guessing ) {
      _retv->set_condition(break_condition);
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err316,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  if ( !guessing ) {
  
  _retv->set_label(label);
  _retv->_type_check();
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd79, 0x10);
  return _retv;
}

IIR_TypeDefinition *
VHDLParser::protected_type_declaration(IIR_TypeDeclaration * type_decl)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  
  _retv = NULL;
  IIR_Name *end_name = NULL;
  zzmatch(PROTECTED); consume();
  {
    while ( (setwd79[LA(1)]&0x20) ) {
      protected_type_declarative_item( NULL );
    }
  }
  zzmatch(END); consume();
  zzmatch(PROTECTED); consume();
  {
    if ( (setwd79[LA(1)]&0x40) ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON)
 ) {
      }
      else {FAIL(1,err317,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd79, 0x80);
  return _retv;
}

void
VHDLParser::protected_type_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  if ( (setwd80[LA(1)]&0x1) ) {
    subprogram_declaration( decl_list );
  }
  else {
    if ( (LA(1)==ATTRIBUTE) ) {
      attribute_specification( decl_list );
    }
    else {
      if ( (LA(1)==USE) ) {
        use_clause( decl_list );
      }
      else {FAIL(1,err318,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd80, 0x2);
}

IIR_TypeDefinition *
VHDLParser::protected_type_body(IIR_TypeDeclaration * type_decl)
{
  IIR_TypeDefinition *   _retv;
  zzRULE;
  PCCTS_PURIFY(_retv,sizeof(IIR_TypeDefinition *  ))
  
  _retv = NULL;
  IIR_Name *end_name = NULL;
  zzmatch(PROTECTED); consume();
  zzmatch(BODY); consume();
  {
    while ( (setwd80[LA(1)]&0x4) ) {
      protected_type_body_declarative_item( NULL );
    }
  }
  zzmatch(END); consume();
  zzmatch(PROTECTED); consume();
  zzmatch(BODY); consume();
  {
    if ( (setwd80[LA(1)]&0x8)
 ) {
      if ( !guessing ) {
         end_name  = simple_name();

      } else {
        simple_name();
      }
    }
    else {
      if ( (LA(1)==SEMI_COLON) ) {
      }
      else {FAIL(1,err319,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
    }
  }
  return _retv;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd80, 0x10);
  return _retv;
}

void
VHDLParser::protected_type_body_declarative_item(IIR_DeclarationList * decl_list)
{
  zzRULE;
  zzGUESS_BLOCK
  if ( (setwd80[LA(1)]&0x20) ) {
    subprogram( decl_list );
  }
  else {
    if ( (LA(1)==TYPE) ) {
      type_declaration( decl_list );
    }
    else {
      if ( (LA(1)==SUBTYPE) ) {
        subtype_declaration( decl_list );
      }
      else {
        if ( (LA(1)==CONSTANT)
 ) {
          constant_declaration( decl_list );
        }
        else {
          if ( (setwd80[LA(1)]&0x40) ) {
            variable_declaration( decl_list );
          }
          else {
            if ( (LA(1)==FILE_) ) {
              file_declaration( decl_list );
            }
            else {
              if ( (LA(1)==ALIAS) ) {
                alias_declaration( decl_list );
              }
              else {
                if ( (LA(1)==ATTRIBUTE) ) {
                  attribute_declarative_item( decl_list );
                }
                else {
                  if ( (LA(1)==USE)
 ) {
                    use_clause( decl_list );
                  }
                  else {
                    zzGUESS
                    if ( !zzrv && (LA(1)==GROUP) && (setwd80[LA(2)]&0x80) ) {
                      {
                        zzmatch(GROUP); consume();
                        zzsetmatch(IDENTIFIER_set, IDENTIFIER_errset); consume();
                        zzmatch(COLON); consume();
                      }
                      zzGUESS_DONE
                      group_declaration( decl_list );
                    }
                    else {
                      if ( !zzrv ) zzGUESS_DONE;
                      if ( (LA(1)==GROUP) && (setwd81[LA(2)]&0x1) ) {
                        group_template_declaration( decl_list );
                      }
                      else {FAIL(2,err320,err321,&zzMissSet,&zzMissText,&zzBadTok,&zzBadText,&zzErrk); goto fail;}
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return;
fail:
  if ( guessing ) zzGUESS_FAIL;
  syn(zzBadTok, (ANTLRChar *)"", zzMissSet, zzMissTok, zzErrk);
  resynch(setwd81, 0x2);
}
