/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.util;

import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.compat.StringBuilder;
import scala.runtime.BoxedChar;
import scala.runtime.BoxedInt;
import scala.runtime.BoxedUnit;
import scala.tools.nsc.util.Position$;
import scala.tools.nsc.util.SourceFile;

public class Position
implements ScalaObject {
    private int tabInc;
    private int offset;
    private SourceFile source;

    public Position(SourceFile sourceFile, int n) {
        this.source = sourceFile;
        this.offset = n;
        this.tabInc = 8;
    }

    public String toString() {
        Object object;
        Position position = this.inUltimateSource();
        Position position2 = this;
        if (position != null ? !position.equals(position2) : position2 != null) {
            return this.inUltimateSource().toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.source() != null) {
            stringBuilder.append(this.source().file().path());
            if (this.hasOffset()) {
                stringBuilder.append(this.line());
                stringBuilder.append(':');
                stringBuilder.append(this.column());
            }
            object = BoxedUnit.UNIT;
        } else {
            object = stringBuilder.append("::" + BoxedInt.box(this.offset()));
        }
        return stringBuilder.toString();
    }

    public String lineContent() {
        return !this.hasOffset() ? "NO_LINE" : this.source().lineToString(this.line() - Position$.MODULE$.FIRSTLINE());
    }

    public String dbgString() {
        String string;
        StringBuffer stringBuffer;
        block7: {
            stringBuffer = new StringBuffer().append((Object)"source: ").append(this.source() != null ? this.source().path() : this.source()).append((Object)" ");
            if (!this.isLine()) {
                if (!this.hasOffset()) {
                    string = "NOP";
                } else {
                    if (this.offset() < this.source().content().length) {
                        String string2 = "offset=" + BoxedInt.box(this.offset()) + " line=" + BoxedInt.box(this.line());
                        String string3 = "";
                        while (true) {
                            if (this.offset() + string3.length() >= this.source().content().length || string3.length() >= 10) {
                                string = string2 + " c[0..9]=\"" + string3 + "\"";
                                break block7;
                            }
                            string3 = string3 + BoxedChar.box(this.source().content()[this.offset() + string3.length()]);
                        }
                    }
                    string = "out-of-bounds-" + BoxedInt.box(this.offset());
                }
            } else {
                string = "line-" + BoxedInt.box(this.line());
            }
        }
        return stringBuffer.append((Object)string).toString();
    }

    public Position inUltimateSource() {
        return this.source().positionInUltimateSource(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int column() {
        if (!this.hasOffset()) {
            return 0;
        }
        int n = 1;
        int n2 = this.source().offsetToLine(this.offset());
        int n3 = this.source().lineToOffset(n2);
        boolean bl = true;
        while (true) {
            if (!bl) {
                int n4 = n;
                return n4;
            }
            if (n3 != this.offset()) {
                n = this.source().content()[n3] != '\t' ? ++n : (n - 1) / this.tabInc() * this.tabInc() + this.tabInc() + 1;
            } else {
                bl = false;
            }
            ++n3;
        }
    }

    public int line() {
        return !this.hasOffset() ? (!this.isLine() ? Position$.MODULE$.NOLINE() : Position$.MODULE$.offsetToLine(this.offset())) : this.source().offsetToLine(this.offset()) + Position$.MODULE$.FIRSTLINE();
    }

    private boolean isLine() {
        return this.offset() < Position$.MODULE$.NOPOS();
    }

    private boolean hasOffset() {
        return this.offset() > Position$.MODULE$.NOPOS();
    }

    private int tabInc() {
        return this.tabInc;
    }

    public int offset() {
        return this.offset;
    }

    public SourceFile source() {
        return this.source;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

