/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.util;

import ch.epfl.lamp.compiler.msil.PEFile;
import java.io.PrintStream;

public final class PESection {
    private final PEFile file;
    private final long sectionStart;
    public final String name;
    public final int virtAddr;
    public final int virtSize;
    public final int realAddr;
    public final int realSize;
    public final int flags;
    private static final byte[] buf = new byte[8];

    public PESection(PEFile pEFile) {
        int n;
        this.file = pEFile;
        this.sectionStart = pEFile.pos();
        pEFile.read(buf);
        for (n = 7; n >= 0 && 0 == buf[n]; --n) {
        }
        this.name = new String(buf, 0, n + 1);
        this.virtSize = pEFile.readInt();
        this.virtAddr = pEFile.readInt();
        this.realSize = pEFile.readInt();
        this.realAddr = pEFile.readInt();
        pEFile.skip(12);
        this.flags = pEFile.readInt();
    }

    public void dump(PrintStream printStream) {
        printStream.println("Section name:    " + this.name + " (name.length=" + this.name.length() + ")");
        printStream.println("Virtual Address: 0x" + PEFile.int2hex(this.virtAddr));
        printStream.println("Virtual Size:    0x" + PEFile.int2hex(this.virtSize));
        printStream.println("Real Address:    0x" + PEFile.int2hex(this.realAddr));
        printStream.println("Real Size:       0x" + PEFile.int2hex(this.realSize));
        printStream.println("Flags:           0x" + PEFile.int2hex(this.flags));
    }
}

