/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.io.j2me.datagram;

import com.sun.cldc.io.GeneralBase;
import com.sun.cldc.io.j2me.datagram.Protocol;
import java.io.IOException;
import javax.microedition.io.Datagram;

public class DatagramObject
extends GeneralBase
implements Datagram {
    private static final int MAX_HOST_LENGTH = 256;
    Protocol parent;
    byte[] buf;
    int off = 0;
    int len;
    int ipNumber;
    String host;
    int port;
    int pointer;

    public DatagramObject(Protocol parent, byte[] buf, int len) {
        this.parent = parent;
        this.setData(buf, 0, len);
    }

    public String getAddress() {
        if (this.host == null) {
            if (this.ipNumber == 0) {
                return null;
            }
            try {
                byte[] tmp = new byte[256];
                this.parent.getHostByAddr(this.ipNumber, tmp);
                this.host = new String(tmp).trim();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "datagram://" + this.host + ":" + this.port;
    }

    public byte[] getData() {
        return this.buf;
    }

    public int getOffset() {
        return this.off;
    }

    public int getLength() {
        return this.len;
    }

    public synchronized void setAddress(String addr) throws IOException {
        this.ipNumber = 0;
        if (!addr.startsWith("datagram://")) {
            throw new IllegalArgumentException("Invalid datagram address" + addr);
        }
        String address = addr.substring(11);
        try {
            this.host = Protocol.getAddress(address);
            this.port = Protocol.getPort(address);
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("Invalid datagram address" + addr);
        }
    }

    public synchronized void setAddress(Datagram reference) {
        DatagramObject ref = (DatagramObject)reference;
        this.host = ref.host;
        this.port = ref.port;
        this.ipNumber = 0;
    }

    public synchronized void setData(byte[] buf, int offset, int length) {
        if (length < 0 || offset < 0 || length + offset > buf.length) {
            throw new IllegalArgumentException("Illegal length or offset");
        }
        this.buf = buf;
        this.off = offset;
        this.len = length;
    }

    public void setLength(int length) {
        this.setData(this.buf, this.off, length);
    }

    public void reset() {
        this.setData(this.buf, 0, 0);
        this.pointer = 0;
    }

    public long skip(long n) {
        int min = Math.min((int)n, this.len - this.pointer);
        this.pointer += min;
        return min;
    }

    public int read() throws IOException {
        if (this.pointer >= this.len) {
            return -1;
        }
        return this.buf[this.off + this.pointer++] & 0xFF;
    }

    public void write(int ch) throws IOException {
        if (this.pointer >= this.buf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buf[this.pointer++] = (byte)ch;
        this.off = 0;
        this.len = this.pointer;
    }
}

