/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

import com.sun.midp.Configuration;
import com.sun.midp.lcdui.InputMethodClient;

public abstract class InputMethodHandler {
    private static InputMethodHandler thisIM;

    public static InputMethodHandler getInputMethodHandler() {
        if (thisIM != null) {
            return thisIM;
        }
        thisIM = InputMethodHandler.getInputMethodHandlerImpl();
        return thisIM;
    }

    private static InputMethodHandler getInputMethodHandlerImpl() {
        try {
            String n = Configuration.getProperty("com.sun.lcdui.inputMethodHandler");
            if (n != null) {
                Class<?> c = Class.forName(n);
                return (InputMethodHandler)c.newInstance();
            }
            String loc = Configuration.getProperty("microedition.locale");
            if (loc != null) {
                String cls = "com.sun.midp.lcdui.i18n.DefaultInputMethodHandler_";
                while (true) {
                    try {
                        Class<?> c = Class.forName(cls + loc);
                        return (InputMethodHandler)c.newInstance();
                    }
                    catch (Throwable t) {
                        int pos = loc.lastIndexOf(95);
                        if (pos == -1) break;
                        loc = loc.substring(0, pos);
                        continue;
                    }
                    break;
                }
            }
            Class<?> c = Class.forName("com.sun.midp.lcdui.DefaultInputMethodHandler");
            return (InputMethodHandler)c.newInstance();
        }
        catch (Throwable t) {
            System.out.println(t);
            throw new Error("Textbox input method was not initialized.");
        }
    }

    public abstract void setFocus(boolean var1);

    public abstract void setInputMethodClient(InputMethodClient var1);

    public abstract void clearInputMethodClient(InputMethodClient var1);

    public abstract boolean keyPressed(int var1);

    public abstract boolean keyReleased(int var1);

    public abstract boolean keyRepeated(int var1);

    public abstract void endComposition();

    public abstract String[] supportedInputModes();
}

