#include "tools.h"
void pzagemv_(trans, M, N, alpha, A, IA, JA, descA, X, IX, JX, descX, incX, 
              beta, Y, IY, JY, descY, incY)
F_CHAR trans;
int *M;
int *N;
double *alpha;
DCOMPLEX *A;
int *IA;
int *JA;
int *descA;
double *X;
int *IX;
int *JX;
int *descX;
int *incX;
double *beta;
double *Y;
int *IY;
int *JY;
int *descY;
int  *incY;
/*
 * Purpose
 * =======
 *
 * PZAGEMV performs the distributed matrix-vector operations
 *
 *     sub( Y ) := alpha*op( sub( abs( A ) ) ) * sub( abs( X ) )  +
 *                 beta*sub( abs( Y ) )
 *
 *  where op may be transpose or conjugate transpose, and
 *
 *        sub( A ) denotes A(IA:IA+M-1,JA:JA+N-1),
 *
 *        sub (X ) denotes
 *                    if (TRANS = 'N')
 *                       X(IX:IX,JX:JX+N-1), if INX = M_X
 *                       X(IX:IX+N-1,JX:JX), if INCX = 1 and INCX <> M_X,
 *                    else
 *                       X(IX:IX,JX:JX+M-1), if INCX = M_X,
 *                       X(IX:IX+M-1,JX:JX), if INCX = 1 and INCX <> M_X,
 *                    end if
 *
 *        sub( Y ) denotes
 *                    if (TRANS = 'N')
 *                       Y(IY:IY,JY:JY+M-1), if INCY = M_Y,
 *                       Y(IY:IY+M-1,JY:JY), if INCY = 1 and INCY <> M_Y,
 *                    else
 *                       Y(IY:IY,JY:JY+N-1), if INCY = M_Y,
 *                       Y(IY:IY+N-1,JY:JY), if INCY = 1 and INCY <> M_Y,
 *                    end if
 *
 *  alpha and beta are scalars, and sub( X ) and sub( Y ) are distributed
 *  vectors and sub( A ) is a M-by-N distributed submatrix.
 *
 *  Notes
 *  =====
 *  A description vector is associated with each 2D block-cyclicly dis-
 *  tributed matrix.  This vector stores the information required to
 *  establish the mapping between a matrix entry and its corresponding
 *  process and memory location.
 *
 *  In the following comments, the character _ should be read as
 *  "of the distributed matrix".  Let A be a generic term for any 2D
 *  block cyclicly distributed matrix.  Its description vector is DESC_A:
 *
 *  NOTATION        STORED IN     EXPLANATION
 *  --------------- ------------- ---------------------------------------
 *  M_A    (global) desc_A[M_]    The number of rows in the distributed
 *                                matrix.
 *  N_A    (global) desc_A[N_]    The number of columns in the distribu-
 *                                ted matrix.
 *  MB_A   (global) desc_A[MB_]   The blocking factor used to distribute
 *                                the rows of the matrix.
 *  NB_A   (global) desc_A[NB_]   The blocking factor used to distribute
 *                                the columns of the matrix.
 *  RSRC_A (global) desc_A[RSRC_] The process row over which the first
 *                                row of the matrix is distributed.
 *  CSRC_A (global) desc_A[CSRC_] The process column over which the first
 *                                column of the matrix is distributed.
 *  CTXT_A (global) desc_A[CTXT_] The BLACS context handle, indicating
 *                                the global context of the operation on
 *                                the matrix.  The context is global, but the
 *                                context handle may vary across processes.
 *  LLD_A  (local)  desc_A[LLD_]  The leading dimension of the local
 *                                array storing the local blocks of the
 *                                distributed matrix A.
 *                                LLD_A >= MAX(1,LOCp(M_A)).
 *
 *  Let K be the number of rows or columns of a distributed matrix,
 *  and assume that its process grid has dimension p x q.
 *  LOCp( K ) denotes the number of elements of K that a process
 *  would receive if K were distributed over the p processes of its
 *  process column.
 *  Similarly, LOCq( K ) denotes the number of elements of K that a
 *  process would receive if K were distributed over the q processes of
 *  its process row.
 *  The values of LOCp() and LOCq() may be determined via a call to the
 *  ScaLAPACK tool function, NUMROC.
 *          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
 *          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
 *
 *  Because vectors are a subclass of matrices, a distributed vector is
 *  considered to be a distributed matrix.
 *
 *  Parameters
 *  ==========
 *
 *  N       (global input) pointer to DOUBLE COMPLEX.
 *          The length of the distributed vectors to be operated on.  N >= 0.
 *
 *  TRANS   (global input) pointer to CHARACTER
 *          On entry, TRANS specifies what op( ) indicates as follows:
 *
 *          if TRANS = 'N' or 'n',
 *             op( A ) = A
 *          else if TRANS = 'T' or 't',
 *             op( A ) = A'
 *          else if TRANS = 'C' or 'c',
 *            op( A ) = conjg( A' )
 *  M       (global input) pointer to INTEGER
 *          The number of rows to be operated on; i.e the number of rows
 *          of the distributed submatrix sub( A ). M >= 0.
 *
 *  N       (global input) pointer to INTEGER
 *          The number of columns to be operated on; i.e the number of
 *          columns of the distributed submatrix sub( A ). N >= 0.
 *
 *  ALPHA   (global input) pointer to DOUBLE COMPLEX
 *          On entry, ALPHA specifies the scalar alpha.
 *
 *  X       (local input) DOUBLE COMPLEX array containing the local pieces
 *          of a distributed matrix of dimension of at least
 *              ( (JX-1)*M_X + IX + ( N - 1 )*abs( INCX ) )
 *          This array contains the entries of the distributed vector
 *          sub( X ).
 *
 *  IX      (global input) pointer to INTEGER
 *          The global row index of the distributed matrix X which points
 *          to the first row of the submatrix to operated on.
 *
 *  JX      (global input) pointer to INTEGER
 *          The global column index of the distributed matrix X which points
 *          to the first column of the submatrix to operated on.
 *
 *  DESCX   (global and local input) INTEGER array of dimension 8.
 *          The array descriptor of the distributed matrix X.
 *
 *  INCX    (global input) pointer to INTEGER
 *          The global increment for the elements of X. Only two values
 *          of INCX are supported in this version, namely 1 and M_X.
 *
 *  Y       (local input) DOUBLE COMPLEX array containing the local pieces
 *          of a distributed matrix of dimension of at least
 *              ( (JY-1)*M_Y + IY + ( N - 1 )*abs( INCY ) )
 *          This array contains the entries of the distributed vector
 *          sub( Y ).
 *
 *  IY      (global input) pointer to INTEGER
 *          The global row index of the distributed matrix Y which points
 *          to the first row of the submatrix to operated on.
 *
 *  JY      (global input) pointer to INTEGER
 *          The global column index of the distributed matrix Y which points
 *          to the first column of the submatrix to operated on.
 *
 *  DESCY   (global and local input) INTEGER array of dimension 8.
 *          The array descriptor of the distributed matrix Y.
 *
 *  INCY    (global input) pointer to INTEGER
 *          The global increment for the elements of Y. Only two values
 *          of INCY are supported in this version, namely 1 and M_Y.
 *
 *  A       (local input) DOUBLE COMPLEX pointer into local memory to an array
 *          of dimension ( LLD_A, LOCq(JA+N-1) ) containing the local pieces
 *          of the distributed matrix sub( A )
 *
 *  IA      (global input) pointer to INTEGER
 *          The global row index of the distributed matrix A which points
 *          to the first row of the submatrix to operated on.
 *
 *  JA      (global input) pointer to INTEGER
 *          The global column index of the distributed matrix A which points
 *          to the first column of the submatrix to operated on.
 *
 *  DESCA   (global and local input) INTEGER array of dimension 8.
 *          The array descriptor of the distributed matrix A.
 *
 *  ===========================================================================
 */
{
/*
 * .. External routines ..
 */
   void CpzagemvA();
   void CpzagemvAt();

   char Ctrans;
   int info;

   Ctrans = *F2C_CHAR(trans);
   Ctrans = Mlowcase(Ctrans);

   if (Ctrans == 'n')
   {
      CpzagemvA(*M, *N, *alpha, A, *IA-1, *JA-1, descA, X, *IX-1, *JX-1,
                descX, *incX, *beta, Y, *IY-1, *JY-1, descY, *incY);
   }
   else if ( (Ctrans == 't') || (Ctrans == 'c') )
   {
      CpzagemvAt(trans, *M, *N, *alpha, A, *IA-1, *JA-1, descA, X,
                 *IX-1, *JX-1, descX, *incX, *beta, Y, *IY-1, *JY-1, descY,
                 *incY);
   }
   else
   {
      info = -1;
      pberror_(&descA[CTXT_], "PZGEMV", &info);
   }
}
