//////////////////////////////////////////////////////////////////////
//
//  FILE:       sc_upgrade.cpp
//              Scid upgrade (v2 to v3) utility program.
//
//  Part of:    Scid (Shane's Chess Information Database)
//  Version:    2.8
//
//  Notice:     Copyright (c) 2001  Shane Hudson.  All rights reserved.
//
//  Author:     Shane Hudson (shane@cosc.canterbury.ac.nz)
//
//////////////////////////////////////////////////////////////////////

#include "common.h"
#include "index.h"
#include "namebase.h"
#include "misc.h"
#include "date.h"
#include "game.h"
#include "gfile.h"
#include "bytebuf.h"
#include "textbuf.h"
#include "tree.h"
#include "progbar.h"

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#ifndef WIN32
#include <strings.h>
#endif

// GLOBALS:

char * progname;
char * filename = NULL;
errorT err;

ProgBar * global_ProgBar = new ProgBar (stdout);


// updateProgress: Update the global progress bar
void
updateProgress (void * pdata, uint count, uint total)
{
    global_ProgBar->Update (count * 100 / total);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// usage():
//      Print usage information and exit the program.
//
void
usage (void)
{
    fprintf (stderr, "Usage: %s <old-scid-database>\n", progname);
    fprintf (stderr, "This utility converts an old (version 2) Scid\n");
    fprintf (stderr, "database (suffix .si) to version 3 (suffix .si3)\n");
}


//////////////////////////////////////////////////////////////////////
//  EOF: sc_upgrade.cpp
//////////////////////////////////////////////////////////////////////
