# swedish.tcl:
# Text for menu names and status bar help messages in Swedish.
# Part of Scid (Shane's Chess Information Database).
# Contributed by Martin Skjldebrand, martin@hauntedhousesw.com

addLanguage W Swedish 1

proc setLanguage_W {} {

# File menu:
menuText W File "Arkiv" 0
menuText W FileNew "Ny..." 0 {Skapa en ny Scid databas}
menuText W FileOpen "ppna..." 0 {pnna en befintlig Scid databas}
menuText W FileClose "Stng" 0 {Stng den aktiva Scid databasen}
menuText W FileFinder "Sk filer" 4 {ppna skdialogen}
menuText W FileBookmarks "Bokmrken" 0 {Hantera bokmrken (genvg: Ctrl+B)}
menuText W FileBookmarksAdd "Nytt bokmrke" 0 \
  {Markera den aktiva stllningen i partiet}
menuText W FileBookmarksFile "Spara bokmrke" 0 \
  {Spara bokmrket fr den aktiva stllningen i partiet}
menuText W FileBookmarksEdit "Redigera bokmrken..." 0 \
  {Redigera bokmrken}
menuText W FileBookmarksList "Visa bokmrken som lista" 19 \
  {Visar bokmrkena som lista, inte undermenyer}
menuText W FileBookmarksSub "Visa bokmrken i undermenyer" 17 \
  {Visar bokmrkena som undermenyer, inte lista}
menuText W FileMaint "Databasverktyg" 0 {Scids databasverktyg}
menuText W FileMaintWin "Verktygsfnster" 0 \
  {ppna/ stng verktygsfnstret}
menuText W FileMaintCompact "Komprimera databasen..." 0 \
  {Komprimera databasen, avlgsna raderade partier och oanvnda namn}
menuText W FileMaintClass "Klassificera partier enligt ECO..." 2 \
  {Klassificera om alla partier enligt ECO-systemet}
menuText W FileMaintSort "Sortera databasen..." 0 \
  {Sortera partierna i den aktiva databasen}
menuText W FileMaintDelete "Radera dubbletter..." 0 \
  {Sk dubbletter och markera de som raderingsbara}
menuText W FileMaintTwin "Sk dubbletter" 0 \
  {ppna/ stng dubblettfnstret}
menuText W FileMaintName "Stavningskontroll" 0 {Namnredigering och stavningskontroll}
menuText W FileMaintNameEditor "Redigera namn" 0 \
  {ppna/stng namnredigeringsfnstret}
menuText W FileMaintNamePlayer "Stavningskontrollera namn..." 22 \
  {Stavningskontrollera namn utifrn rttstavningsfilen}
menuText W FileMaintNameEvent "Stavningskontrollera evenemang..." 21 \
  {Stavningskontrollera evenmang utifrn rttstavningsfilen}
menuText W FileMaintNameSite "Stavningskontrollera platser..." 21 \
  {Stavningskontrollera platser utifrn rttstavningsfilen}
menuText W FileMaintNameRound "Stavningskontrollera ronder..." 21 \
  {Stavningskontrollera ronder utifrn rttstavningsfilen}
menuText W FileReadOnly "Enbart ls databas..." 8 \
  {ppna databasen utan redigeringsmjligheter}
menuText W FileExit "Avsluta" 0 {Avsluta Scid}

# Edit menu:
menuText W Edit "Redigera" 0
menuText W EditAdd "Lgg till variant" 0 {Skapa en variant vid denna stllning}
menuText W EditDelete "Radera variant" 0 {Radera en variant vid denna stllning}
menuText W EditFirst "Skapa huvudvariant" 6 \
  {Gr en av varianterna till huvudvariant}
menuText W EditMain "Skapa nytt textdrag" 11 \
  {Gr en av varianterna till partifortsttning}
menuText W EditTrial "Testa variant" 6 \
  {Starta/ stoppa testlge, undersk en ide p brdet}
menuText W EditStrip "Ta bort" 3 {Avlgsna kommentarer eller varianter frn partiet}
menuText W EditStripComments "Kommentarer" 0 \
  {Avlgsna alla kommentarer och noteringar frn partiet}
menuText W EditStripVars "Varianter" 0 {Avlgsna alla varinter frn partiet}
menuText W EditReset "Tm Clipbase" 1 \
  {Tmmer den temporra databasen}
menuText W EditCopy "Kopiera partiet till Clipbase" 21 \
  {Kopierar det aktuella partiet till Clipbase}
menuText W EditPaste "Klistra in det senaste Clipbasepartiet" 8 \
  {Klistrar in det senaste tillagda i Clipbase i den aktiva databasen}
menuText W EditSetup "Skapa stllning..." 0 \
  {Skapa en utgngsstllning fr aktuellt parti}
menuText W EditPasteBoard "Klista in utgngsstllning" 10 \
  {Klistra in stllningen frn aktuellt parti i den temporra databasen}

# Game menu:
menuText W Game "Partier" 0
menuText W GameNew "Nytt parti" 0 \
  {terstll brdet infr ett nytt parti (raderar alla ndringar)}
menuText W GameFirst "Ladda det frsta partiet" 10 {Laddar det frsta partiet i filtret}
menuText W GamePrev "Ladda fregende parti" 7 {Ladda fregende parti i filtret}
menuText W GameReload "Brja om partiet" 0 \
  {terstll partiet (raderar alla ndringar)}
menuText W GameNext "Ladda nsta parti" 6 {Ladda nsta parti i filtret}
menuText W GameLast "Ladda det sista partiet" 10 {Ladda det sista partiet i filtret}
menuText W GameNumber "Ladda parti nummer..." 6 \
  {Ladda ett parti genom att ange dess nummer}
menuText W GameReplace "Spara: Erstt parti..." 7 \
  {Spara partiet och erstt tidigare version}
menuText W GameAdd "Spara: Nytt parti..." 1 \
  {Spara ett nytt parti}
menuText W GameDeepest "Identifiera ppningen" 0 \
  {G till den mest detaljerade stllningen i ECO boken}
menuText W GameGotoMove "G till drag nummer..." 8 \
  {G till ett specifikt drag i partiet}
menuText W GameNovelty "Hitta nyhet..." 7 \
  {Hitta det frsta draget i partiet som inte spelats tidigare}

# Search Menu:
menuText W Search "Sk" 0
menuText W SearchReset "terstll skfilter" 0 {terstll skfiltret s att alla partiet ingr}
menuText W SearchNegate "Omvnt filter" 0 {Ta med partier som utesluts av filtret}
menuText W SearchCurrent "Aktuell position..." 8 {Sk partier med aktuell position p brdet}
menuText W SearchHeader "I huvud..." 2 {Anvnd fast information (spelare, evenemang, plats, mm)}
menuText W SearchMaterial "Material/stllning..." 0 {Skning baserad p material eller stllning}
menuText W SearchUsing "Anvnd skfil..." 10 {Anvnd en fil med lagrade skvillkor}

# Windows menu:
menuText W Windows "Fnster" 0
menuText W WindowsComment "Kommentarseditor" 0 {ppna/ stng kommentarseditorn}
menuText W WindowsGList "Partilista" 5 {ppna/ stng partilistan}
menuText W WindowsPGN "PGN fnster" 0 \
  {ppna/ stng PGN fnstret}
menuText W WindowsTmt "Turneringar" 0 {Lista turneringar}
menuText W WindowsSwitcher "Databasvxlaren" 0 \
  {ppna/ stng databasvxlaren}
menuText W WindowsMaint "Verktygsfnster" 0 \
  {ppna/ stng verktygsfnstret}
menuText W WindowsECO "ECO fnster" 0 {ppna/ stng ECO blddraren}
menuText W WindowsRepertoire "Repertoireditor" 0 \
  {ppna/ stng spelppningsfnstret}
menuText W WindowsStats "Statistikfnster" 0 \
  {ppna/ stng statistikfnstret}
menuText W WindowsTree "Trdfnster" 2 {ppna/ stng varianttrdets fnster}
menuText W WindowsTB "Slutspelsdatabas" 2 \
  {ppna/ stng slutspelsdatabasfnstret}

# Tools menu:
menuText W Tools "Verktyg" 0
menuText W ToolsAnalysis "Analysmotor..." 6 \
  {Starta/ stoppa en analysmotor}
menuText W ToolsAnalysis2 "Analysmotor 2..." 12 \
  {Starta/ stoppa en andra analysmotor}
menuText W ToolsCross "Resultattabell" 0 {Visa en resultattabell fr den aktuella turneringen}
menuText W ToolsEmail "Eposthanterare" 0 \
  {ppna/ stng eposthanteraren}
menuText W ToolsOpReport "ppningsrapport" 0 \
  {Skapa en ppningsrapport utifrn den aktuella stllningen}
menuText W ToolsPInfo "Spelarinformation"  0 \
  {ppna/ uppdatera spelarinformation}
menuText W ToolsRating "Rankingdiagram" 0 \
  {Skapa ett ranking diagram fr spelarna i partiet}
menuText W ToolsScore "Resultatdiagram" 8 {Visa resultatdiagrammet}
menuText W ToolsExpCurrent "Exportera aktuellt parti" 1 \
  {Spara aktuellt parti till en textfil}
menuText W ToolsExpCurrentPGN "Exportera till PGN..." 15 \
  {Spara aktuellt parti till en PGN-fil}
menuText W ToolsExpCurrentHTML "Exportera till HTML..." 15 \
  {Spara aktuellt parti till en HTML-fil}
menuText W ToolsExpCurrentLaTeX "Exportera till LaTeX..." 15 \
  {Spara aktuellt parti till en LaTeX-fil}
menuText W ToolsExpFilter "Exportera alla filtrerade partier" 15 \
  {Spara alla filterade partier till en textfil}
menuText W ToolsExpFilterPGN "Exportera till PGN..." 15 \
  {Spara alla filterade partier till en PGN-fil}
menuText W ToolsExpFilterHTML "Exportera till HTML..." 15 \
  {Spara alla filterade partier till en HTML-fil}
menuText W ToolsExpFilterLaTeX "Exportera till LaTeX..." 15 \
  {Spara alla filterade partier till en LaTeX-fil}
menuText W ToolsImportOne "Importera ett parti i PGN-format..." 0 \
  {Importera ett parti i PGN-format}
menuText W ToolsImportFile "Importera flera partier i PGN-format..." 16 \
  {Importera flera partier i PGN-format frn en fil}

# Options menu:
menuText W Options "Alternativ" 2
menuText W OptionsSize "Brdstorlek" 0 {ndra brdets storlek}
menuText W OptionsPieces "Pjsutseende" 1 {ndra pjsernas utseende} 
menuText W OptionsColors "Frger..." 0 {ndra brdets frger}
menuText W OptionsExport "Export" 0 {ndra exportalternativ}
menuText W OptionsFonts "Typsnitt" 0 {ndra typsnitt}
menuText W OptionsFontsRegular "Normal" 0 {ndra det normala typsnittet}
menuText W OptionsFontsSmall "Liten" 0 {ndra det lilla typsnittet}
menuText W OptionsFontsFixed "Fixerad" 0 {ndra det fixerade typsnittet}
menuText W OptionsGInfo "Partiinformation" 0 {Alternativ fr partiinformation}
menuText W OptionsLanguage "Sprk" 0 {Vlj sprk}
menuText W OptionsMoves "Drag" 0 {Alternativ fr dragangivelse}
menuText W OptionsMovesAsk "Frga fre erstt drag" 0 \
  {Frga innan du erstter befintliga drag}
menuText W OptionsMovesDelay "Frdrjning vid automatspel..." 1 \
  {Ange frdrjning mellan dragen nr datorn spelar sjlv}
menuText W OptionsMovesCoord "Koordinater" 0 \
  {Acceptera koordinater ("g1f3") vid dragangivelse}
menuText W OptionsMovesSuggest "Visa freslagna drag" 0 \
  {Visa/ Dlj freslagna drag}
menuText W OptionsMovesKey "Tangentkomplettering" 0 \
  {Stt p/ stng av dragkomplettering vid tangentinmatning}
menuText W OptionsNumbers "Talformat" 3 {Vlj hur tal visas}
menuText W OptionsStartup "Start" 3 {Vlj vilka fnster som ska ppnas vid start}
menuText W OptionsWindows "Fnster" 1 {Fnsteralternativ}
menuText W OptionsWindowsIconify "Minimera automatiskt" 5 \
  {Minimera alla fnster nr huvufnstret minimeras}
menuText W OptionsWindowsRaise "Autofokus" 0 \
  {Visa ter vissa fnster (t ex. resultatrknare) automatiskt nr de dljs}
menuText W OptionsToolbar "Verktygsflt" 0 \
  {Visa/ dlj huvudfnstrets verktygsflt}
menuText W OptionsECO "Ladda ECO fil..." 7 {Ladda ECO-klassificeringen vid start}
menuText W OptionsSpell "Ladda Rttstavningsfil..." 7 \
  {Ladda rttstavningsfilen vid start}
menuText W OptionsTable "Katalog fr slutspelsdatabaser..." 0 \
  {Vlj en fil som innehller en slutspelsdatabas; alla vriga filer i samma katalog kommer att anvndas}
menuText W OptionsSave "Spara alternativ" 7 \
  "Spara alla alternativ till en instllnignsfil"
menuText W OptionsAutoSave "Autospara vid avslut" 1 \
  {Spara alla alternativ nr du avslutar Scid}

# Help menu:
menuText W Help "Hjlp" 0
menuText W HelpIndex "Index" 0 {Hjlpsystemets innehllsfrteckning}
menuText W HelpGuide "Snabbguide" 0 {Visa snabbguiden}
menuText W HelpHints "Tips" 0 {Visa tips}
menuText W HelpContact "Kontaktinformation" 0 {Visa kontaktinformation}
menuText W HelpTip "Dagens tips" 0 {Anvndbara Scid tips}
menuText W HelpStartup "Startfnster" 5 {Visa startfnstret}
menuText W HelpAbout "Om Scid" 0 {Information om Scid}

# Game info box popup menu:
menuText W GInfoHideNext "Dlj nsta drag" 0
menuText W GInfoMaterial "Visa materialvrden" 0
menuText W GInfoFEN "Visa FEN" 5
menuText W GInfoMarks "Visa frgade flt och pilar" 22 
menuText W GInfoWrap "Radbrytning" 0
menuText W GInfoFullComment "Visa fullstndiga kommentarer" 18
menuText W GInfoTBNothing "Slutspelsdatabaser: inget" 20
menuText W GInfoTBResult "Slutspelsdatabaser: endast resultat" 28
menuText W GInfoTBAll "Slutspelsdatabaser: resultat och bsta drag" 33
menuText W GInfoDelete "terta/Radera detta parti" 0
menuText W GInfoMark "(Av-)Markera detta parti" 5

# Main window buttons:
helpMsg W .button.start {G till brjan av partiet  (tangent: Home)}
helpMsg W .button.end {G till slutet av partiet  (tangent: End)}
helpMsg W .button.back {Back ett drag (tangent: Vnsterpil)}
helpMsg W .button.forward {G fram ett drag  (tangent: Hgerpil)}
helpMsg W .button.intoVar {G in i variant (genvg: v)}
helpMsg W .button.exitVar {G ur variant  (genvg: z)}
helpMsg W .button.flip {Rotera brdet  (genvg: .)}
helpMsg W .button.coords {Sl av eller p koordinater  (genvg: 0)}
helpMsg W .button.autoplay {Autospel  (tangent: Ctrl+Z)}

# General buttons:
translate W Back {Tillbaka}
translate W Cancel {Avbryt}
translate W Clear {Rensa}
translate W Close {Stng}
translate W Defaults {Standard}
translate W Delete {Radera}
translate W Graph {Diagram}
translate W Help {Hjlp}
translate W Import {Importera}
translate W Index {Index}
translate W LoadGame {Ladda parti}
translate W BrowseGame {Blddra genom partier}
translate W MergeGame {Sl samman partier}
translate W Preview {Frhandsgranska}
translate W Revert {ngra inmatning}
translate W Save {Spara}
translate W Search {Sk}
translate W Stop {Stoppa}
translate W Store {Spara}
translate W Update {Uppdatera}
translate W ChangeOrient {ndra fnstrets orientering}
translate W None {Ingen}
translate W First {Frsta}
translate W Current {Aktuella}
translate W Last {Sista}

# General messages:
translate W game {parti}
translate W games {partier}
translate W move {drag}
translate W moves {drag}
translate W all {alla}
translate W Yes {Ja}
translate W No {Nej}
translate W Both {Bda}
translate W King {Kung}
translate W Queen {Dam}
translate W Rook {Torn}
translate W Bishop {Lpare}
translate W Knight {Springare}
translate W Pawn {Bonde}
translate W White {Vit}
translate W Black {Svart}
translate W Player {Spelare}
translate W Rating {Ranking}
translate W RatingDiff {Rankingskillnad (Vit - Svart)}
translate W Event {Evenemang}
translate W Site {Plats}
translate W Country {Land}
translate W IgnoreColors {Ignorera frger}
translate W Date {Datum}
translate W EventDate {Evenmangsdatum}
translate W Year {r}
translate W Month {Mnad}
translate W Months {Januari Februari Mars April Maj Juni
  Juli Augusti September Oktober November December}
translate W Days {Sn Mn Tis Ons Tors Fre Lr}
translate W YearToToday {Idag}
translate W Result {Resultat}
translate W Round {Rond}
translate W Length {Lngd}
translate W ECOCode {ECO kod}
translate W ECO {ECO}
translate W Deleted {Raderad}
translate W SearchResults {Skresultat}
translate W OpeningTheDatabase {ppnar databas}
translate W Database {Databas}
translate W Filter {Filter}
translate W noGames {inga partier}
translate W allGames {alla partier}
translate W empty {tom}
translate W clipbase {temporr databas}
translate W score {resultat}
translate W StartPos {Utgngsstllning}
translate W Total {Totalt}

# Game information:
translate W twin {dubblett}
translate W deleted {raderad}
translate W comment {kommentar}
translate W hidden {dold}
translate W LastMove {Senaste draget}
translate W NextMove {Nsta}
translate W GameStart {Utgngsstllning}
translate W LineStart {Varianten brjar}
translate W GameEnd {Slutstllning}
translate W LineEnd {Varianten slut}

# Player information:
translate W PInfoAll {Resultat fr <b>alla</b> partier}
translate W PInfoFilter {Resultat fr <b>filtrerade</b> partier}
translate W PInfoAgainst {Resultat mot}
translate W PInfoMostWhite {De vanligaste ppningarna som vit}
translate W PInfoMostBlack {De vanligaste ppningarna som svart}
translate W PInfoRating {Rankinghistoria}
translate W PInfoBio {Biografisk information}

# Tablebase information:
translate W Draw {Remi}
translate W stalemate {patt}
translate W withAllMoves {med alla drag}
translate W withAllButOneMove {med alla drag utom ett}
translate W with {med}
translate W only {bara}
translate W lose {frlust}
translate W loses {frluster}
translate W allOthersLose {alla andra frlorar}
translate W matesIn {med matt i}
translate W hasCheckmated {har satt matt}
translate W longest {lngst}

# Tip of the day:
translate W Tip {Tips}
translate W TipAtStartup {Tips vid start}

# Tree window menus:
menuText W TreeFile "Fil" 0
menuText W TreeFileSave "Spara cachefil" 0 {Spara trdcache (.stc) filen}
menuText W TreeFileFill "Fyll cache fil" 0 \
  {Fyll cachefilen med vanliga ppningar}
menuText W TreeFileBest "Lista bsta partier" 0 {Visa lista ver de bstra partierna i trdet}
menuText W TreeFileGraph "Diagramfnster" 0 {Visa diagrammet fr denna gren i trdet}
menuText W TreeFileCopy "Kopiera trd till urklipp" 1 \
  {Kopierar trdrelaterad statistik till urklipp}
menuText W TreeFileClose "Stng trdfnstret" 0 {Stng trdfnstret}
menuText W TreeSort "Sortera" 0
menuText W TreeSortAlpha "Alfabetiskt" 0
menuText W TreeSortECO "ECO kod" 0
menuText W TreeSortFreq "Frekvens" 0
menuText W TreeSortScore "Resultat" 0
menuText W TreeOpt "Options" 0
menuText W TreeOptLock "Ls" 0 {Ls/ ls upp trdet fr den aktuella databasen}
menuText W TreeOptTraining "Trna" 0 {Stt p/ stng av trningslge}
menuText W TreeOptAutosave "Spara cache filen automatiskt" 0 \
  {Spara cache filen automatiskt nr trdfnstret stngs}
menuText W TreeHelp "Hjlp" 0
menuText W TreeHelpTree "Trdhjlp" 0
menuText W TreeHelpIndex "Hjlp index" 0
translate W SaveCache {Spara cache}
translate W Training {Trna}
translate W LockTree {Ls}
translate W TreeLocked {Lst}
translate W TreeBest {Bst}
translate W TreeBestGames {Bsta partier i trdet}

# Finder window:
menuText W FinderFile "Fil" 0
menuText W FinderFileSubdirs "Sk i underkataloger" 0
menuText W FinderFileClose "Stng File Finder" 0
menuText W FinderSort "Sortera" 0
menuText W FinderSortType "Typ" 0
menuText W FinderSortSize "Storlek" 0
menuText W FinderSortMod "Frndrad" 0
menuText W FinderSortName "Namn" 0
menuText W FinderSortPath "Skvg" 0
menuText W FinderTypes "Typer" 0
menuText W FinderTypesScid "Scid databaser" 0
menuText W FinderTypesOld "Scid databaser i ldre format" 0
menuText W FinderTypesPGN "PGN filer" 0
menuText W FinderTypesEPD "EPD filer" 0
menuText W FinderTypesRep "ppningsfiler" 0
menuText W FinderHelp "Hjlp" 0
menuText W FinderHelpFinder "Hjlp fr File Finder" 0
menuText W FinderHelpIndex "Hjlpindex" 0
translate W FileFinder {File Finder}
translate W FinderDir {Katalog}
translate W FinderDirs {Kataloger}
translate W FinderFiles {Filer}
translate W FinderUpDir {upp}

# Tournament finder:
menuText W TmtFile "Fil" 0
menuText W TmtFileUpdate "Uppdatera" 0
menuText W TmtFileClose "Stng turneringshanteraren" 0
menuText W TmtSort "Sortera" 0
menuText W TmtSortDate "Datum" 0
menuText W TmtSortPlayers "Spelare" 0
menuText W TmtSortGames "Partier" 0
menuText W TmtSortElo "Elo" 0
menuText W TmtSortSite "Plats" 0
menuText W TmtSortEvent "Evenemang" 1
menuText W TmtSortWinner "Vinnare" 0
translate W TmtLimit "Listbegrnsningar"
translate W TmtMeanElo "Lgsta snitt Elo"
translate W TmtNone "Inga turneringar hittades."

# Graph windows:
menuText W GraphFile "Fil" 0
menuText W GraphFileColor "Spara som Postscript (frg)" 8
menuText W GraphFileGrey "Spara som Postscript (grskala)" 8
menuText W GraphFileClose "Stng fnster" 6
menuText W GraphOptions "Alternativ" 0
menuText W GraphOptionsWhite "Vit" 0
menuText W GraphOptionsBlack "Svart" 0
menuText W GraphOptionsBoth "Bda" 1
menuText W GraphOptionsPInfo "Spelarinformation" 0

# Analysis window:
translate W AddVariation {Lgg till variant}
translate W AddMove {Lgg till drag}
translate W Annotate {Kommentera}
translate W AnalysisCommand {Analysera}
translate W PreviousChoices {Fregende val}
translate W AnnotateTime {Ange tid mellan drag i sekunder}
translate W AnnotateWhich {Lgg till varianter}
translate W AnnotateAll {fr bda sidors drag}
translate W AnnotateWhite {Endast vits drag}
translate W AnnotateBlack {Endast svarts drag}
translate W AnnotateNotBest {Nr partidraget inte r det bsta}

# Analysis Engine open dialog:
translate W EngineList {Lista ver schackprogram}
translate W EngineName {Namn}
translate W EngineCmd {Startkommando}
translate W EngineArgs {Parametrar} 
translate W EngineDir {Katalog}
translate W EngineElo {Elo}
translate W EngineTime {Datum}
translate W EngineNew {Ny}
translate W EngineEdit {Redigera}
translate W EngineRequired {Fet stil indikerar obligatoriska flt; vriga flt r frivilliga} 

# Stats window menus:
menuText W StatsFile "Fil" 0
menuText W StatsFilePrint "Skriv ut till fil..." 0
menuText W StatsFileClose "Stng fnster" 0
menuText W StatsOpt "Alternativ" 0

# PGN window menus:
menuText W PgnFile "Fil" 0
menuText W PgnFilePrint "Skriv ut till..." 0
menuText W PgnFileClose "Stng PGN fnster" 0
menuText W PgnOpt "Presentation" 0
menuText W PgnOptColor "Frg" 0
menuText W PgnOptShort "Kort (3-raders) huvud" 0
menuText W PgnOptSymbols "Symbolbaserad kommentar" 1
menuText W PgnOptIndentC "Indragna kommentarer" 0
menuText W PgnOptIndentV "Indragna varianter" 7
menuText W PgnOptColumn "Spaltstil (ett drag per rad)" 1
menuText W PgnOptSpace "Utrymme efter dragnummer" 1
menuText W PgnColor "Frger" 0
menuText W PgnColorHeader "Huvud..." 0
menuText W PgnColorAnno "Noteringar..." 0
menuText W PgnColorComments "Kommentarer..." 0
menuText W PgnColorVars "Varianter..." 0
menuText W PgnColorBackground "Bakgrund..." 0
menuText W PgnHelp "Hjlp" 0
menuText W PgnHelpPgn "PGN hjlp" 0
menuText W PgnHelpIndex "Index" 0

# Crosstable window menus:
menuText W CrosstabFile "Fil" 0
menuText W CrosstabFileText "Skriv ut till textfil..." 9
menuText W CrosstabFileHtml "Skriv ut till HTML-fil..." 9
menuText W CrosstabFileLaTeX "Skriv ut till LaTeX-fil..." 9
menuText W CrosstabFileClose "Stng resultattabellsfnstret" 0
menuText W CrosstabEdit "Redigera" 0
menuText W CrosstabEditEvent "Evenemang" 0
menuText W CrosstabEditSite "Plats" 0
menuText W CrosstabEditDate "Datum" 0
menuText W CrosstabOpt "Presentation" 0
menuText W CrosstabOptAll "Alla-mter-alla" 0
menuText W CrosstabOptSwiss "Schweizer" 0
menuText W CrosstabOptKnockout "Knock Out" 0
menuText W CrosstabOptAuto "Auto" 1
menuText W CrosstabOptAges "lder i r" 8
menuText W CrosstabOptNats "Nationalitet" 0
menuText W CrosstabOptRatings "Ranking" 0
menuText W CrosstabOptTitles "Titlar" 0
menuText W CrosstabOptBreaks "Tie-break pong" 4
menuText W CrosstabOptColors "Frg (endast Schweizer)" 0
menuText W CrosstabOptGroup "Gruppresultat" 0
menuText W CrosstabSort "Sortera" 0
menuText W CrosstabSortName "Namn" 0
menuText W CrosstabSortRating "Ranking" 0
menuText W CrosstabSortScore "Resultat" 0
menuText W CrosstabColor "Frg" 0
menuText W CrosstabColorPlain "Ren text" 0
menuText W CrosstabColorHyper "Hypertext" 0
menuText W CrosstabHelp "Hjlp" 0
menuText W CrosstabHelpCross "Hjlp fr resultattabell" 0
menuText W CrosstabHelpIndex "Hjlpindex" 0
translate W SetFilter {Bestm filter}
translate W AddToFilter {Utka filter}
translate W Swiss {Schweizer}

# Opening report window menus:
menuText W OprepFile "Fil" 0
menuText W OprepFileText "Skriv ut till textfil..." 9
menuText W OprepFileHtml "Skriv ut till HTML-fil..." 9
menuText W OprepFileLaTeX "Skriv ut till LaTeX-fil..." 9
menuText W OprepFileOptions "Alternativ..." 0
menuText W OprepFileClose "Stng rapportfnstret" 0
menuText W OprepHelp "Hjlp" 0
menuText W OprepHelpReport "Hjlp fr ppningsrapporter" 0
menuText W OprepHelpIndex "Hjlpindex" 0

# Repertoire editor:
menuText W RepFile "Fil" 0
menuText W RepFileNew "Ny" 0
menuText W RepFileOpen "ppna..." 0
menuText W RepFileSave "Spara..." 0
menuText W RepFileSaveAs "Spara som..." 5
menuText W RepFileClose "Stng fnster" 0
menuText W RepEdit "Redigera" 0
menuText W RepEditGroup "Lgg till grupp" 4
menuText W RepEditInclude "Lgg till inkluderad variant" 4
menuText W RepEditExclude "Lgg till exkluderad variant" 4
menuText W RepView "Visa" 0
menuText W RepViewExpand "Expandera alla grupper" 0
menuText W RepViewCollapse "Implodera alla grupper" 0
menuText W RepSearch "Sk" 0
menuText W RepSearchAll "Hela ppningsrepertoaren..." 0
menuText W RepSearchDisplayed "Endast visade varianter..." 0
menuText W RepHelp "Hjlp" 0
menuText W RepHelpRep "Hjlp fr spelppningsrepertoar" 0
menuText W RepHelpIndex "Hjlpindex" 0
translate W RepSearch "Sk i spelppningsrepertoar"
translate W RepIncludedLines "inkluderade varianter"
translate W RepExcludedLines "exkluderade varianter"
translate W RepCloseDialog {Du har osparade ndringar i repertoaren.

Vill du verkligen fortstta och frlora dina frndringar?
}

# Header search:
translate W HeaderSearch {Sk i partihuvud}
translate W GamesWithNoECO {Partier utan ECO kod?}
translate W GameLength {Partilngd}
translate W FindGamesWith {Hitta flaggade partier}
translate W StdStart {Normal utgngsstllning}
translate W Promotions {Frvandlingar}
translate W Comments {Kommentarer}
translate W Variations {Varianter}
translate W Annotations {Noteringar}
translate W DeleteFlag {Raderingsflagga}
translate W WhiteOpFlag {Vits ppning}
translate W BlackOpFlag {Svarts ppning}
translate W MiddlegameFlag {Mittspel}
translate W EndgameFlag {Slutspel}
translate W NoveltyFlag {Nyhet}
translate W PawnFlag {Bondestruktur}
translate W TacticsFlag {Taktiska stllningar}
translate W QsideFlag {Damflygelsinitiativ}
translate W KsideFlag {Kungsflygelsinitiativ}
translate W BrilliancyFlag {Utmrkt parti}
translate W BlunderFlag {Bortsttningar}
translate W UserFlag {Anvndare}
translate W PgnContains {PGN innehller text}

# Game list window:
translate W GlistNumber {Nummer}
translate W GlistWhite {Vit}
translate W GlistBlack {Svart}
translate W GlistWElo {Elo, v}
translate W GlistBElo {Elo, sv}
translate W GlistEvent {Evenemang}
translate W GlistSite {Plats}
translate W GlistRound {Rond}
translate W GlistDate {Datum}
translate W GlistYear {r}
translate W GlistEDate {Startdatum}
translate W GlistResult {Resultat}
translate W GlistLength {Lngd}
translate W GlistCountry {Land}
translate W GlistECO {ECO}
translate W GlistOpening {ppning}
translate W GlistEndMaterial {Slutmaterial}
translate W GlistDeleted {Raderad}
translate W GlistFlags {Flaggor}
translate W GlistVars {Varianter}
translate W GlistComments {Kommentarer}
translate W GlistAnnos {Noteringar}
translate W GlistStart {Start}
translate W GlistGameNumber {Partinummer}
translate W GlistFindText {Sk text}
translate W GlistMoveField {Drag}
translate W GlistEditField {Konfiguration}
translate W GlistAddField {Lgg till}
translate W GlistDeleteField {Ta bort}
translate W GlistWidth {Bredd}
translate W GlistAlign {Justering}
translate W GlistColor {Frg}
translate W GlistSep {Separator}

# Maintenance window:
translate W DatabaseName {Databasnamn:}
translate W TypeIcon {Ikontyp:}
translate W NumOfGames {Partier:}
translate W NumDeletedGames {Raderade partier:}
translate W NumFilterGames {Partier i filter:}
translate W YearRange {Tidsperiod:}
translate W RatingRange {Rankingintervall:}
translate W Flag {Flagga}
translate W DeleteCurrent {Radera aktuellt parti}
translate W DeleteFilter {Radera partierna i filteret}
translate W DeleteAll {Radera alla partier}
translate W UndeleteCurrent {terta aktuellt parti}
translate W UndeleteFilter {terta partierna i filtret}
translate W UndeleteAll {terta alla partier}
translate W DeleteTwins {Radera dubbletter}
translate W MarkCurrent {Markera aktuellt parti}
translate W MarkFilter {Markera partierna i filtret}
translate W MarkAll {Markera alla partier}
translate W UnmarkCurrent {Avmarkera aktuellt parti}
translate W UnmarkFilter {Avmarkera partierna i filtret}
translate W UnmarkAll {Avmarkera alla partier}
translate W Spellchecking {Rttstava}
translate W Players {Spelare}
translate W Events {Evenmang}
translate W Sites {Platser}
translate W Rounds {Ronder}
translate W DatabaseOps {Databashantering}
translate W ReclassifyGames {ECO-klassificera partier}
translate W CompactDatabase {Komprimera databasen}
translate W SortDatabase {Sortera databasen}
translate W AddEloRatings {Lgg till Elo ranking}
translate W AutoloadGame {Ladda partinummer automatiskt}
translate W Cleaner {Snygga till databasen}
translate W CleanerHelp {
Databasstdaren i Scid genomfr allt det underhll av databasen du kan vlja nedan p den aktiva databasen.

De nuvarande instllningarna i ECO-klassificering och Radera dubbletter kommer att appliceras om du vljer dessa tgrder.
}
translate W CleanerConfirm {
Nr du vl startat Databasstdaren kan du inte avbryta den!

P en stor databas kan detta ta ett bra tag. Tidstgngen beror p valda tgrder och deras instllningar.

r du sker p att du vill pbrja databasunderhllet nu?
}

# Comment editor:
translate W AnnotationSymbols  {Symboler:}
translate W Comment {Kommentar:}

# Board search:
translate W BoardSearch {Positionsskningar}
translate W FilterOperation {Hantering av aktuellt filter:}
translate W FilterAnd {AND (Restriktivt filter)}
translate W FilterOr {OR (Ackumulativt filter)}
translate W FilterIgnore {IGNORE (Anvnd ej filter)}
translate W SearchType {Sktyp:}
translate W SearchBoardExact {Exakt position (alla pjser p samma rutor)}
translate W SearchBoardPawns {Bnder (samma material, alla bnder p samma rutor)}
translate W SearchBoardFiles {Filer (samma material, alla bnder p samma filer)}
translate W SearchBoardAny {Obestmt (samma material, bnder och pjser p valfria rutor)}
translate W LookInVars {Sk i varianter}

# Material search:
translate W MaterialSearch {Materialskning}
translate W Material {Material}
translate W Patterns {Stllningar}
translate W Zero {Inga/-en}
translate W Any {Flera}
translate W CurrentBoard {Aktuell stllning}
translate W CommonEndings {Vanliga slutspel}
translate W CommonPatterns {Vanliga stllningar}
translate W MaterialDiff {Skillnad i material}
translate W squares {flt}
translate W SameColor {Samma frg}
translate W OppColor {Motsatt frg}
translate W Either {Antingen eller}
translate W MoveNumberRange {Dragintervall}
translate W MatchForAtLeast {Trffa minst}
translate W HalfMoves {halvdrag}

# Game saving:
translate W Today {Idag}
translate W ClassifyGame {Klassificera parti}

# Setup position:
translate W EmptyBoard {Tm brdet}
translate W InitialBoard {Utgngsstllning}
translate W SideToMove {Frg vid draget}
translate W MoveNumber {Antal drag}
translate W Castling {Rockad}
translate W EnPassentFile {En Passent fil}
translate W ClearFen {Rensa FEN}
translate W PasteFen {Klistra in FEN}

# Replace move dialog:
translate W ReplaceMove {Erstt drag}
translate W AddNewVar {Lgg till ny variant}
translate W ReplaceMoveMessage {Det finns redan ett drag i denna stllning.

Du kan erstta detta drag, och frlora samtliga fljande, eller lgga till ditt drag som en ny variant.

(Om du stnger av "Frga fre erstt drag" i Alternativ:Drag menyn slipper du denna frga i framtiden.)}

# Make database read-only dialog:
translate W ReadOnlyDialog {Om du ger denna databas endast lsbar kan du inte gra ngra ndringar i den.
Inga partier kan sparas eller ersttas, och du kan inte ndra flaggor fr raderbara partier.
Alla sorteringsinstllningar eller ECO-klassificeringar kommer att vara temporra.

Du kan gra den skrivbar igen genom att helt enkelt stnga och ppna den igen.

Vill du verkligen ange att databasen endast ska vara lsbar?}

# Clear game dialog:
translate W ClearGameDialog {Detta parti har ndrats.

Vill du verkligen fortstta och frlora ndringarna?
}

# Exit dialog:
translate W ExitDialog {Vill du verkligen avsluta Scid?}

# Import window:
translate W PasteCurrentGame {Klistra in aktuellt parti}
translate W ImportHelp1 {Ange eller klistra in ett parti i PGN-format i omrdet ovan.}
translate W ImportHelp2 {Eventuella felaktigheter kommer att anges hr.}

# ECO Browser:
translate W ECOAllSections {alla ECO avdelningar}
translate W ECOSection {ECO avdelning}
translate W ECOSummary {Sammanfattning fr}
translate W ECOFrequency {Underkodsfrekvens fr}

# Opening Report:
translate W OprepTitle {ppningsrapport}
translate W OprepReport {Rapport}
translate W OprepGenerated {Skapad av}
translate W OprepStatsHist {Statistik och historik}
translate W OprepStats {Statistik}
translate W OprepStatAll {Rapporterade partier}
translate W OprepStatBoth {Bda med ranking}
translate W OprepStatSince {Sedan}
translate W OprepOldest {De ldsta partierna}
translate W OprepNewest {De yngsta partierna}
translate W OprepPopular {Aktuell popularitet}
translate W OprepFreqAll {Frekvens totalt:   }
translate W OprepFreq1   {Under det senaste ret: }
translate W OprepFreq5   {Under de 5 senaste ren: }
translate W OprepFreq10  {Under de 10 senaste ren: }
translate W OprepEvery {en gng var %u parti}
translate W OprepUp {kat %u%s gentemot samtliga r}
translate W OprepDown {minskat %u%s gentemot samtlliga r}
translate W OprepSame {ingen frndring gentemot samtliga r}
translate W OprepMostFrequent {Spelas mest av}
translate W OprepRatingsPerf {Ranking och resultat}
translate W OprepAvgPerf {Genomsnittranking och resultat}
translate W OprepWRating {Vits ranking}
translate W OprepBRating {Svarts ranking}
translate W OprepWPerf {Vits resultat}
translate W OprepBPerf {Svarts resultat}
translate W OprepHighRating {Partierna med hgst genomsnittranking}
translate W OprepTrends {Resultattrender}
translate W OprepResults {Lngd och frekvens}
translate W OprepLength {Partiets lngd}
translate W OprepFrequency {Frekvens}
translate W OprepWWins {Vita vinster: }
translate W OprepBWins {Svarta vinster: }
translate W OprepDraws {Remier:      }
translate W OprepWholeDB {hela databasen}
translate W OprepShortest {Kortaste vinster}
# translate W OprepShortWhite {De kortaste vita vinsterna}
# translate W OprepShortBlack {De kortaste svarta vinsterna}
translate W OprepMovesThemes {Drag och teman}
translate W OprepMoveOrders {Dragordning fr att n rapportstllningen}
translate W OprepMoveOrdersOne \
  {Stllningen nddes bara genom en dragordning:}
translate W OprepMoveOrdersAll \
  {Det fanns %u dragordningar som ledde fram denna stllning:}
translate W OprepMoveOrdersMany \
  {Det fanns %u dragordningar som ledde fram denna stllning. De %u vanligaste r:}
translate W OprepMovesFrom {Drag frn rapportstllningen}
translate W OprepThemes {Positionella teman}
translate W OprepThemeDescription {Antal teman vid drag %u}
translate W OprepThemeSameCastling {Rockad p samma flygel}
translate W OprepThemeOppCastling {Rockad p olika flyglar}
translate W OprepThemeNoCastling {Ingen har gjort rockad}
translate W OprepThemeKPawnStorm {Bondestorm p kungsflygeln}
translate W OprepThemeQueenswap {Dambyte}
translate W OprepThemeIQP {Isolerad dambonde}
translate W OprepThemeWP567 {Vita bonde p 5/6/7e raden}
translate W OprepThemeBP234 {Svart bonde p 2/3/4e raden}
translate W OprepThemeOpenCDE {ppen c/d/e linje}
translate W OprepTheme1BishopPair {Endast den ena sidan har lparparet}
translate W OprepEndgames {Slutspel}
translate W OprepReportGames {Antal partier i rapporten}
translate W OprepAllGames    {Samtliga partier}
translate W OprepEndClass {Material i slutstllningen}
translate W OprepTheoryTable {Teorisammanstllning}
translate W OprepTableComment {Skapad frn de %u hgst rankade partierna.}
translate W OprepExtraMoves {Ytterligare antal drag i notfrteckningen}
translate W OprepMaxGames {Maximalt antal partier i sammanstllningen}

# Game selection dialogs:
translate W SelectAllGames {Alla partier i databasen}
translate W SelectFilterGames {Endast partierna i filtret}
translate W SelectTournamentGames {Endast partierna i den aktuella turneringen}
translate W SelectOlderGames {Endast ldre partier}

# Delete Twins window:
translate W TwinsNote {Partier mste minst ha samma spelare fr att kunna identifieras som dubbletter samt uppfylla andra kriterier du kan ange nedan. Nr dubbletter hittas raderas det kortare partiet.
Tips: det bsta r att anvnda rttstavningen innan dubblettjmfrelsen eftersom detta frbttrar mjligheten fr upptckt av dubbletter.}
translate W TwinsCriteria {Kriterium: Dubbletter mste ha...}
translate W TwinsWhich {Ange vilka partier som ska jmfras}
translate W TwinsColors {Samma frger?}
translate W TwinsEvent {Samma evenemang?}
translate W TwinsSite {Samma plats?}
translate W TwinsRound {Samma rond?}
translate W TwinsYear {Samma r?}
translate W TwinsMonth {Samma mnad?}
translate W TwinsDay {Samma dag?}
translate W TwinsResult {Samma resultat?}
translate W TwinsECO {SammaECO kod?}
translate W TwinsMoves {Samma drag?}
translate W TwinsPlayers {Jmfr spelarnas namn:}
translate W TwinsPlayersExact {Exakt kopia}
translate W TwinsPlayersPrefix {Endast de 4 frsta bokstverna}
translate W TwinsWhen {Nr dubbletter raderas}
translate W TwinsSkipShort {Ignorera alla partier som r kortare n 5 drag?}
translate W TwinsUndelete {terta alla partier frst?}
translate W TwinsSetFilter {Filtrera alla raderade dubbletter?}
translate W TwinsComments {Spara alltid partier med kommentarer?}
translate W TwinsVars {Spara alltid partier med varianter?}
translate W TwinsDelete {Radera partier}

# Name editor window:
translate W NameEditType {Typ av namn att redigera}
translate W NameEditSelect {Partier att redigera}
translate W NameEditReplace {Erstt}
translate W NameEditWith {med}
translate W NameEditMatches {Matchar: Tryck Ctrl+1 till Ctrl+9 fr att vlja}

# Classify window:
translate W Classify {Klassificera}
translate W ClassifyWhich {ECO-klassificera vilka partier}
translate W ClassifyAll {Alla partier (skriv ver gamla ECO koder)}
translate W ClassifyYear {Alla partier spelade under det senaste ret}
translate W ClassifyMonth {Alla partier spelade den senaste mnaden}
translate W ClassifyNew {Endast partier som nnu ej klassificerats}
translate W ClassifyCodes {ECO koder som ska anvndas}
translate W ClassifyBasic {Enbart standardkoder ("B12", ...)}
translate W ClassifyExtended {Scid extensioner ("B12j", ...)}

# Compaction:
translate W NameFile {Namnfil}
translate W GameFile {Partifil}
translate W Names {Namn}
translate W Unused {Ej anvnd}
translate W SizeKb {Storlek (kb)}
translate W CurrentState {Aktuell status}
translate W AfterCompaction {Efter komprimering}
translate W CompactNames {Namn, komprimera namnfil}
translate W CompactGames {Partier, komprimera partifil}

# Sorting:
translate W SortCriteria {Kriterium}
translate W AddCriteria {Lgg till kriterium}
translate W CommonSorts {Normal sortering}
translate W Sort {Sortering}

# Exporting:
translate W AddToExistingFile {Lgg till partier till en existerande fil?}
translate W ExportComments {Exportera kommentarer?}
translate W ExportVariations {Exportera varianter?}
translate W IndentComments {Dra in kommentarer?}
translate W IndentVariations {Dra in varianter?}
translate W ExportColumnStyle {Kolumnstil (ett drag per rad)?}
translate W ExportSymbolStyle {Symbolbaserade kommentarer:}

# Goto game/move dialogs:
translate W LoadGameNumber {Ange partiets nummer:}
translate W GotoMoveNumber {G till drag nummer:}

# Copy games dialog:
translate W CopyGames {kopiera partier}
translate W CopyConfirm {
 Vill du verkligen kopiera
 de [thousands $nGamesToCopy] filtrerade partierna
 ur databasen "$fromName"
 till databasen "$targetName"?
}
translate W CopyErr {Kan ej kopiera partier}
translate W CopyErrSource {klldatabasen}
translate W CopyErrTarget {mldatabasen}
translate W CopyErrNoGames {har inga partier i filtret}
translate W CopyErrReadOnly {kan bara lsas}
translate W CopyErrNotOpen {r ej ppen}

# Colors:
translate W LightSquares {Ljusa flt}
translate W DarkSquares {Mrka flt}
translate W SelectedSquares {Valda flt}
translate W SuggestedSquares {Freslagna flt}
translate W WhitePieces {Vita pjser}
translate W BlackPieces {Svarta pjser}
translate W WhiteBorder {Vit kantlinje}
translate W BlackBorder {Svart kantlinje}

# Novelty window:
translate W FindNovelty {Hitta nyhet}
translate W Novelty {Nyhet}
translate W NoveltyInterrupt {Nyhetsskningen avbrts}
translate W NoveltyNone {Inga nyheter hittades i detta parti}
translate W NoveltyHelp {
Scid kommer att frska hitta det frsta draget som leder till en position som inte annars finns i denna databas eller i spelppingsboken baserad p ECO.
}

# Upgrading databases:
translate W Upgrading {Uppdaterar}
translate W ConfirmOpenNew {
Denna databas r i ett gammal format (Scid 2) och kan inte ppnas i Scid 3, men en databas i det nya formatet (Scid 3) har redan skapats.

Vill du ppna den senare databasen istllet?
}
translate W ConfirmUpgrade {
Denna databas r i ett gammal format (Scid 2). En databas i det nyare formatet mste skapas innan den kan anvndas i Scid 3.

Genom att uppdatera skapas en databas i det nya formatet med samma innehll; uppdateringen ndrar ingenting i den gamla databasen.

Detta kan ta ett tag men behver bara gras en gng. Om du tycker det tar alltfr lng tid kan du avbryta processen.

Vill du uppdatera denna databas nu?
}

}
# end of swedish.tcl
