/* Manage configuration variables:
   Auto-generate GUI to configure these variables, all of which are python dictionaries

   C. Steenberg 7/12/2000
*/

#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <Python.h>

#include "../sg_dataset.h"
#include "sg.h"
#include "sg_config.h"
#include "python_main.h"


GtkWidget *dialog;
static gint return_value;
gchar *edit_string=NULL;
gboolean edit_busy=FALSE, config_busy=FALSE,ok_pressed=FALSE,config_destroy=FALSE;

gboolean edit_string_dialog (gchar *string);
void def_modules_apply(GtkWidget *wlist);
void def_paths_apply(GtkWidget *wlist);
void def_list_change(GtkWidget *wlist);
void config_cancel(GtkWidget *widget);



sg_config_info py_var_info[]={
        { DIALOG_SEP,NULL,NULL,NULL,NULL,"Configuration"},
        { NOTEBOOK_START,NULL,NULL,NULL,NULL,NULL},
        { PAGE_SEP,NULL,NULL,NULL,NULL,"Module paths"},
        { DICT_LIST, "path", "module",&def_paths_apply,NULL,"Filesystem paths to search for modules"},
        { PAGE_SEP,NULL,NULL,NULL,NULL,"Startup"},
        { DICT_LIST, "startup", "module",&def_modules_apply,NULL,"Modules to import upon startup"},
        { NOTEBOOK_END,NULL,NULL,NULL,NULL,NULL},
        { END_CONFIG,NULL,NULL,NULL,NULL,NULL}
};

gint dict_list_add_pressed (GtkWidget *widget, gpointer data)
{ GtkWidget *wlist;

  if (edit_busy) return;
  wlist=(GtkWidget *)data;
  if (edit_string_dialog(NULL) && strlen(edit_string)>0)
   gtk_clist_append(GTK_CLIST(wlist), &edit_string);
  if (edit_string)
  {   g_free(edit_string);
      edit_string=NULL;
  }

   
  return;
}

void dict_list_edit_pressed (GtkWidget *widget, gpointer data)
{ GtkWidget *wlist;
  GList *selection;
  gint row;
  gchar *text;

  if (edit_busy) return;
  wlist=(GtkWidget *)data;
  selection = GTK_CLIST(wlist)->selection;
  if(!selection) return;

  row = GPOINTER_TO_INT(selection->data);

  gtk_clist_get_text (GTK_CLIST(wlist),row,0,&text);
  if (!edit_string_dialog(text))
    return;
  if (edit_string && strlen(edit_string)>0)
   { gtk_clist_remove(GTK_CLIST(wlist), row);
     gtk_clist_insert(GTK_CLIST(wlist), row,&edit_string);
   }

  if (edit_string)
  {   g_free(edit_string);
      edit_string=NULL;
  }

  return;
}


void dict_list_del_pressed (GtkWidget *widget, gpointer data)
{ GtkWidget *wlist;
  GList *selection;
  gint row;

  if (edit_busy) return;
  wlist=(GtkWidget *)data;

  selection = GTK_CLIST(wlist)->selection;
  if(!selection) return;

  row = GPOINTER_TO_INT(selection->data);
  gtk_clist_remove(GTK_CLIST(wlist), row);

  return;
}


void def_list_change(GtkWidget *wlist)
{ gint i,num=-1;
  gchar *text,*group,*name;
  PyObject *dict=NULL;
  for  (i=0;py_var_info[i].type!=END_CONFIG;i++)
   if (py_var_info[i].data_out==wlist)
   {  dict=sg_config_get_value(py_var_info[i].config_name,py_var_info[i].config_group);
      break;
   }

  if (!dict) return;

  PyDict_Clear(dict);

  for (i=0;gtk_clist_get_text(GTK_CLIST(wlist),i,0,&text)>0;i++)
     PyDict_SetItemString(dict,text,Py_None);

   
}

/* Set up search paths */
void sg_set_module_paths(PyObject *dict){
     PyObject *items;

     items=PyDict_Keys(dict);
     PyDict_SetItemString (sys_dict, "path", items);
     Py_XDECREF(items);
}


void def_paths_apply(GtkWidget *wlist)
{ gint i,num=-1;
  gchar *text;
  PyObject *dict=NULL;

  for  (i=0;py_var_info[i].type!=END_CONFIG;i++)
   if (py_var_info[i].data_out==wlist)
    {
      dict=sg_config_get_value(py_var_info[i].config_name,py_var_info[i].config_group);
      break;
    }

  num=i;
  if (!dict) return;

  PyDict_Clear(dict);

  for (i=0;gtk_clist_get_text(GTK_CLIST(wlist),i,0,&text)>0;i++)
      PyDict_SetItemString(dict,text,Py_None);

  sg_config_exec_commit(sg_config_get_config(py_var_info[num].config_name,py_var_info[num].config_group));

}


void def_modules_apply(GtkWidget *wlist)
{ PyObject *keys,*key_name,*item,*dict;
  gint i,j,newflag=SG_MODULE_LOAD_MAIN,flag;
  gchar *text;

  dict=sg_config_get_value("startup", "module");
  keys=PyDict_Keys(dict);
  for (j=0;j<PyList_GET_SIZE (keys);j++)
   { key_name=PyList_GetItem (keys,j);
     flag=(gint)PyInt_AsLong (PyDict_GetItem (dict,key_name));
     if (! (flag&SG_MODULE_LOAD_REQ))
       PyDict_DelItem(dict,key_name);

   }

  for (i=0;gtk_clist_get_text(GTK_CLIST(wlist),i,0,&text)>0;i++)
   { item=PyDict_GetItemString(dict,text);
     if (!item)
      PyDict_SetItemString(dict,text,PyInt_FromLong ((long)newflag));
   }
  sg_config_exec_commit(sg_config_get_config("startup", "module"));

}
#ifdef WITH_GNOME
static void setting_changed(GtkWidget *widget, gpointer data)
{ GnomeDialog *dialog;
  if (GNOME_IS_DIALOG(data))
    dialog=GNOME_DIALOG(data);
  else return;
  gnome_dialog_set_sensitive(GNOME_DIALOG(dialog),0,TRUE);
  gnome_dialog_set_sensitive(GNOME_DIALOG(dialog),1,TRUE);
}
#else
static void setting_changed(GtkWidget *widget, gpointer data)
{
  
}
#endif

void config_apply(GtkWidget *widget, gpointer data)
{ gint i;
  GtkSignalFunc func;
  GtkWidget *wlist;
  sg_config_info *my_var_info;

  my_var_info=(sg_config_info*)data;
  for  (i=0;my_var_info[i].type!=END_CONFIG;i++)
  { 
    switch (my_var_info[i].type)
    { case DICT_LIST: if (my_var_info[i].data_in){
           func=(GtkSignalFunc)my_var_info[i].data_in;
           wlist=(GtkWidget *)my_var_info[i].data_out;
           if (func) func(wlist);
          }
          break;
      case DICT_MENU:
         { sg_menu_info *menu_info;
           GtkWidget *widget;
           menu_info=(sg_menu_info*)my_var_info[i].data_in;
           widget=(GtkWidget *)my_var_info[i].data_out;
           func=(GtkSignalFunc)menu_info->apply_func;
           if (func) func(GTK_WIDGET(widget));
         }
         break;
      case DICT_INT_BOUND:
      case DICT_INT_BOUND_SLIDER:
      case DICT_BOOLEAN:
      { sg_bound_int_info *int_info;
           GtkWidget *widget;
           int_info=(sg_bound_int_info*)my_var_info[i].data_in;
           widget=(GtkWidget *)my_var_info[i].data_out;
           func=(GtkSignalFunc)int_info->apply_func;
           if (func) func(GTK_WIDGET(widget),&my_var_info[i]);
         }
         break;
      default:
     }
  } 
#ifdef WITH_GNOME
gnome_dialog_set_sensitive(GNOME_DIALOG(dialog),0,FALSE);
gnome_dialog_set_sensitive(GNOME_DIALOG(dialog),1,FALSE);
#endif
}

void config_ok(GtkWidget *widget, gpointer data)
{ config_destroy=TRUE;
  config_busy=FALSE;
  config_apply(widget,data);
  config_cancel(widget);
}

void config_cancel(GtkWidget *widget)
{ config_destroy=TRUE;
  config_busy=FALSE;
  if (GTK_IS_WIDGET(dialog)) gtk_widget_destroy(dialog);
  sg_dialog_kill(widget);
}

void
notebook_page_switch (GtkNotebook *notebook,
                      GtkNotebookPage *page,
                      gint page_num,
                      gpointer user_data)
{ sg_config_info *var_info;
  if (config_destroy) return; /* Avoid spurious switches when the dialog is being destroyed */
  var_info=(sg_config_info *)user_data;
  var_info->data_in=GINT_TO_POINTER (page_num);
}



void python_config_dialog(GtkWidget *widget, gpointer data)
{
    sg_create_config_dialog(py_var_info,&config_apply, &config_ok);
}

void sg_create_config_dialog(sg_config_info *var_info,
     gpointer apply_callback,gpointer ok_callback)
{ GtkWidget *notebook, *page, *vbox, *hbox, *button, *frame, *container,
            *table;
  gint i,table_y;
  gchar *msg;  

  if (config_busy) return;
  config_busy=TRUE;
  config_destroy=FALSE;
#ifdef WITH_GNOME

  msg=strdup("Configuration");

  dialog=gnome_dialog_new (msg,
                           GNOME_STOCK_BUTTON_OK,
                           GNOME_STOCK_BUTTON_APPLY, 
                           GNOME_STOCK_BUTTON_CLOSE,
                           NULL);
  gnome_dialog_button_connect(GNOME_DIALOG(dialog),0,
             GTK_SIGNAL_FUNC (ok_callback),(gpointer)var_info);
  gnome_dialog_button_connect(GNOME_DIALOG(dialog),1,
             GTK_SIGNAL_FUNC (apply_callback),(gpointer)var_info);
  gnome_dialog_button_connect(GNOME_DIALOG(dialog),2,
                                     config_cancel,GTK_OBJECT(dialog));
  gnome_dialog_set_sensitive(GNOME_DIALOG(dialog),0,FALSE);
  gnome_dialog_set_sensitive(GNOME_DIALOG(dialog),1,FALSE);
  vbox = GNOME_DIALOG(dialog)->vbox;
#else


  dialog=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW(dialog),"Configuration");

  /* Create widgets */
  vbox = gtk_vbox_new (FALSE,5);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  hbox = gtk_hbox_new (TRUE,5);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);  
  
  button=sg_stock_button("Button_Close");
  gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, TRUE, 5);  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (config_cancel),
                      GTK_OBJECT(dialog));

  button=sg_stock_button("Button_Apply");
  gtk_box_pack_end (GTK_BOX (hbox), button, TRUE, TRUE, 5);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (apply_callback),
                      (gpointer)var_info);

  button=sg_stock_button("Button_Ok");
  gtk_box_pack_end (GTK_BOX (hbox), button, TRUE, TRUE, 5);  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (ok_callback),
                      (gpointer)var_info);
  gtk_widget_show_all(vbox);

#endif
  sg_dialog_new(dialog);

  gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
                      GTK_SIGNAL_FUNC (config_cancel),
                      NULL);

  for  (i=0;var_info[i].type!=END_CONFIG;i++)
  { switch (var_info[i].type)
  { case DIALOG_SEP:
#ifdef WITH_GNOME
      gtk_window_set_title (&GNOME_DIALOG(dialog)->window,var_info[i].name);
      gtk_window_set_transient_for(&GNOME_DIALOG(dialog)->window,&GNOME_APP(main_window)->parent_object);
      gtk_window_set_modal (&GNOME_DIALOG(dialog)->window,TRUE);
#else
      gtk_window_set_title (GTK_WINDOW(dialog),var_info[i].name);
      gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(main_window));
      gtk_window_set_modal(GTK_WINDOW(dialog),TRUE);
#endif
                     break;
  case NOTEBOOK_START: notebook=gtk_notebook_new();
                       gtk_box_pack_start (GTK_BOX (vbox), notebook, FALSE, FALSE, 0);
                       break;
  case NOTEBOOK_END: gtk_signal_connect (GTK_OBJECT (notebook), "switch-page",
                     GTK_SIGNAL_FUNC (notebook_page_switch),
                     (gpointer)&var_info[i]);
                     gtk_widget_show_all(notebook);
                     gtk_notebook_set_page (GTK_NOTEBOOK(notebook),
                       GPOINTER_TO_INT (var_info[i].data_in));
                     break;
  case PAGE_SEP: page=gtk_vbox_new(FALSE,5);
                     container=page;
                     gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
                                              page,gtk_label_new(var_info[i].name));
                     break;

    case FRAME_START: if (page){
                       frame=gtk_frame_new(var_info[i].name);
                       gtk_box_pack_start (GTK_BOX (page), frame, TRUE, TRUE, 5);
                       container=table=gtk_table_new(2,1,FALSE);
                       gtk_container_add(GTK_CONTAINER(frame),table);
                       gtk_widget_show(table);
                       table_y=0;
                     }
                     break;
    case FRAME_END: if (page) container=page;
                     break;
    case DICT_LIST: if (container){
                       GtkWidget *wlist,*label,*sw,*hbox,*vbox;
                       PyObject *keys, *key_name,*dict;
                       gchar *name;
                       gint j;
                       GList *list=NULL;

                       hbox=gtk_hbox_new(FALSE,5);
                       if (GTK_IS_BOX(container)) 
                         gtk_box_pack_start (GTK_BOX (container), hbox, TRUE, TRUE, 5);
                       sw = gtk_scrolled_window_new (NULL, NULL);
                       gtk_widget_set_usize(sw, 320, 160);
                       gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
                         GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
                       gtk_box_pack_start (GTK_BOX (hbox), sw, TRUE, TRUE, 5);

                       wlist=gtk_clist_new_with_titles(1,&var_info[i].name);
                       var_info[i].data_out=(gpointer)wlist;
                       gtk_clist_set_auto_sort(GTK_CLIST(wlist),TRUE);
                       gtk_clist_set_column_resizeable (GTK_CLIST(wlist),0,TRUE);
                       gtk_clist_freeze(GTK_CLIST(wlist));
                       dict=sg_config_get_value(var_info[i].config_name,var_info[i].config_group);
                       keys=PyDict_Keys(sg_config_get_value(var_info[i].config_name,var_info[i].config_group));
                       for (j=0;j<PyList_GET_SIZE (keys);j++)
                        { key_name=PyList_GetItem (keys,j);
                          name=PyString_AsString (key_name);
                          gtk_clist_append(GTK_CLIST(wlist), &name);
                        }
                       gtk_clist_thaw(GTK_CLIST(wlist));
                       if (strlen(var_info[i].name)>0)
                           gtk_clist_column_titles_show(GTK_CLIST(wlist));
                       else
                         gtk_clist_column_titles_hide(GTK_CLIST(wlist));
                       gtk_container_add(GTK_CONTAINER(sw), wlist);
                       gtk_widget_show(wlist);

                       vbox=gtk_vbox_new(FALSE,5);
                       gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 5);

                       button=gtk_button_new_with_label("Add");
                       gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 5);
                       gtk_signal_connect(GTK_OBJECT(button),"clicked",
                                   (GtkSignalFunc) dict_list_add_pressed,
                                   (gpointer) wlist);
                       gtk_signal_connect(GTK_OBJECT(button),"clicked",
                                   GTK_SIGNAL_FUNC(setting_changed),
                                   (gpointer) dialog);

                       button=gtk_button_new_with_label("Edit");
                       gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 5);
                       gtk_signal_connect(GTK_OBJECT(button),"clicked",
                                   (GtkSignalFunc) dict_list_edit_pressed,
                                   (gpointer) wlist);
                       gtk_signal_connect(GTK_OBJECT(button),"clicked",
                                   GTK_SIGNAL_FUNC(setting_changed),
                                   (gpointer) dialog);


                       button=gtk_button_new_with_label("Delete");
                       gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 5);
                       gtk_signal_connect(GTK_OBJECT(button),"clicked",
                                   (GtkSignalFunc) dict_list_del_pressed,
                                   (gpointer) wlist);
                       gtk_signal_connect(GTK_OBJECT(button),"clicked",
                                   GTK_SIGNAL_FUNC(setting_changed),
                                   (gpointer) dialog);

    }
    break;
    case DICT_MENU:if (container){
                       GtkWidget *hbox,*format_combo,*label;
                       GtkSignalFunc func;
                       PyObject *keys, *key_name;
                       gchar *name;
                       gint j;
                       GList *list=NULL;
                       sg_menu_info *menu_info;
                       label=gtk_label_new(var_info[i].name);
                       if (GTK_IS_BOX(container)) {
                         hbox=gtk_hbox_new(FALSE,5);
                         gtk_box_pack_start (GTK_BOX (container), hbox, FALSE, FALSE, 5);
                         gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 5);
                       }
                       else if (GTK_IS_TABLE(container))
                         gtk_table_attach_defaults(GTK_TABLE(container),label,0,1,table_y,table_y+1);

                       format_combo = gtk_combo_new();
                       var_info[i].data_out=(gpointer)format_combo;
                       menu_info=(sg_menu_info*)var_info[i].data_in;
                       sg_combo_set_items(GTK_COMBO(format_combo), menu_info->options);
                       if (GTK_IS_BOX(container)) {
                         gtk_box_pack_start (GTK_BOX (hbox), format_combo, FALSE, FALSE, 5);
                       }
                       else if (GTK_IS_TABLE(container)){
                         gtk_table_attach(GTK_TABLE(container),format_combo,1,2,table_y,table_y+1,
                         GTK_FILL|GTK_EXPAND, GTK_FILL,5, 5);
                         table_y++;
                       }

                       func=(GtkSignalFunc)menu_info->init_func;
                       if (func) func(GTK_WIDGET(format_combo),&var_info[i]);
                       gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(format_combo)->entry),FALSE);
                       gtk_signal_connect(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(format_combo)->entry)),"changed",
                                         GTK_SIGNAL_FUNC(setting_changed),(gpointer)dialog);

    }
    break;
    case DICT_BOOLEAN:if (container){
                       GtkWidget *hbox,*check_item,*label;
                       GtkSignalFunc func;
                       PyObject *keys, *key_name;
                       gchar *name;
                       gint j;
                       GList *list=NULL;
                       sg_bound_int_info *menu_info;

                       label=gtk_label_new(var_info[i].name);
                       menu_info=(sg_bound_int_info*)var_info[i].data_in;
                       if (GTK_IS_BOX(container)) {
                         hbox=gtk_hbox_new(FALSE,5);
                         gtk_box_pack_start (GTK_BOX (container), hbox, FALSE, FALSE, 5);
                         gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 5);
                       }
                       else if (GTK_IS_TABLE(container))
                         gtk_table_attach_defaults(GTK_TABLE(container),label,0,1,table_y,table_y+1);

                       check_item = gtk_check_button_new();
                       var_info[i].data_out=(gpointer)check_item;
                       if (GTK_IS_BOX(container)) {
                         gtk_box_pack_start (GTK_BOX (hbox), check_item, FALSE, FALSE, 5);
                       }
                       else if (GTK_IS_TABLE(container)){
                         gtk_table_attach(GTK_TABLE(container),check_item,1,2,table_y,table_y+1,
                         GTK_FILL|GTK_EXPAND, GTK_FILL,5, 5);
                         table_y++;
                       }
                       func=(GtkSignalFunc)menu_info->init_func;
                       if (func) func(GTK_WIDGET(check_item),&var_info[i]);
                       gtk_signal_connect(GTK_OBJECT(check_item),"toggled",
                                         GTK_SIGNAL_FUNC(setting_changed),(gpointer)dialog);

    }
    break;

    case DICT_INT_BOUND :if (container){
                       GtkWidget *hbox,*len_entry,*label;
                       GtkSignalFunc func;
                       gint j;
                       GtkAdjustment *adj;
                       GList *list=NULL;
                       sg_bound_int_info *info;
                       
                       label=gtk_label_new(var_info[i].name);
                       if (GTK_IS_BOX(container)) {
                         hbox=gtk_hbox_new(FALSE,5);
                         gtk_box_pack_start (GTK_BOX (container), hbox, FALSE, FALSE, 5);
                         gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 5);
                       }
                       else if (GTK_IS_TABLE(container))
                         gtk_table_attach_defaults(GTK_TABLE(container),label,0,1,table_y,table_y+1);


                       info=(sg_bound_int_info*)var_info[i].data_in;
                       adj = (GtkAdjustment *)gtk_adjustment_new(0., info->min, info->max, 1., 0., 0.);
                       len_entry = gtk_spin_button_new(adj, 0, 0);   
                       var_info[i].data_out=(gpointer)len_entry;
                       gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(len_entry), TRUE);
                       gtk_spin_button_set_digits(GTK_SPIN_BUTTON(len_entry), 0);

                       if (GTK_IS_BOX(container)) {
                         gtk_box_pack_start (GTK_BOX (hbox), len_entry, FALSE, FALSE, 5);
                       }
                       else if (GTK_IS_TABLE(container)){
                         gtk_table_attach(GTK_TABLE(container),len_entry,1,2,table_y,table_y+1,
                         GTK_FILL|GTK_EXPAND, GTK_FILL,5, 5);
                         table_y++;
                       }

                       func=(GtkSignalFunc)info->init_func;
                       if (func) func(GTK_WIDGET(len_entry),&var_info[i]);
                       gtk_signal_connect(GTK_OBJECT(adj),"value_changed",
                                         GTK_SIGNAL_FUNC(setting_changed),(gpointer)dialog);

                       }
                      break;
                      
    case DICT_INT_BOUND_SLIDER :if (container){
                       GtkWidget *hbox,*len_entry,*label;
                       GtkSignalFunc func;
                       gint j;
                       GtkAdjustment *adj;
                       GList *list=NULL;
                       sg_bound_int_info *info;
                       label=gtk_label_new(var_info[i].name);
                       if (GTK_IS_BOX(container)) {
                         hbox=gtk_hbox_new(FALSE,5);
                         gtk_box_pack_start (GTK_BOX (container), hbox, FALSE, FALSE, 5);
                         gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 5);
                       }
                       else if (GTK_IS_TABLE(container))
                         gtk_table_attach_defaults(GTK_TABLE(container),label,0,1,table_y,table_y+1);

                       info=(sg_bound_int_info*)var_info[i].data_in;
                       adj = (GtkAdjustment *)gtk_adjustment_new(0., info->min, info->max, 1., 0., 0.);
                       len_entry = gtk_hscale_new(adj);   

                       var_info[i].data_out=(gpointer)len_entry;

                       gtk_scale_set_digits(GTK_SCALE(len_entry), 0);
                       if (GTK_IS_BOX(container)) {
                         gtk_box_pack_start (GTK_BOX (hbox), len_entry, FALSE, FALSE, 5);
                       }
                       else if (GTK_IS_TABLE(container)){
                         gtk_table_attach(GTK_TABLE(container),len_entry,1,2,table_y,table_y+1,
                         GTK_FILL|GTK_EXPAND, GTK_FILL,5, 5);
                         table_y++;
                       }
                       func=(GtkSignalFunc)info->init_func;
                       if (func) func(GTK_WIDGET(len_entry),&var_info[i]);
                       gtk_signal_connect(GTK_OBJECT(adj),"value_changed",
                                         GTK_SIGNAL_FUNC(setting_changed),(gpointer)dialog);

                      }

    break;

    default:
    }
  }

  gtk_widget_show(dialog);
}


static void
mw_destroy( GtkWidget *widget, gpointer data)
{ GtkWidget *window;

  window=(GtkWidget *) data;
  if (!ok_pressed) gtk_main_quit ();

  return;
}

static gboolean
end_ok(gpointer data, GtkWidget *widget )
{ GtkWidget *entry,*w;
  gchar *text;

  if (edit_string)
  {   g_free(edit_string);
      edit_string=NULL;
  }
  entry=(GtkWidget *)data;
  text=gtk_entry_get_text(GTK_ENTRY(entry));

  if (text)
      edit_string=g_strdup(text);
  ok_pressed=TRUE;
  gtk_main_quit();
  
  return_value = TRUE;
  return TRUE;
}


gboolean edit_string_dialog (gchar *string)
{
  GtkWidget *window = NULL;
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *ok_button, *cancel_button;
  GtkWidget *action_area;
  GtkWidget *table;
  GtkWidget *entry;
  gchar text[100];

  if (edit_busy) return FALSE;  

  edit_busy=TRUE;
  window=gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
  gtk_window_set_transient_for(GTK_WINDOW(window),GTK_WINDOW(dialog));
  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
  return_value=FALSE;

  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);
  gtk_container_add (GTK_CONTAINER (window), main_box);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (main_box), frame, FALSE, FALSE, 5);

  table = gtk_table_new(2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  entry = gtk_entry_new();
  gtk_table_attach_defaults(GTK_TABLE(table), entry, 1, 4, 1, 2);
  if (string)
    { gtk_window_set_title (GTK_WINDOW(window),"Edit string");
      gtk_entry_set_text(GTK_ENTRY(entry),string);
    }
  else
      gtk_window_set_title (GTK_WINDOW(window),"New string");


  /* Action Area */
  action_area = gtk_hbutton_box_new ();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(action_area), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(action_area), 5);
  gtk_box_pack_end (GTK_BOX (main_box), action_area, FALSE, FALSE, 0);
  gtk_widget_show (action_area);

  ok_button = gtk_button_new_with_label ("OK");
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), ok_button, TRUE, TRUE, 0);
  gtk_widget_grab_focus (entry);
  gtk_widget_show (ok_button);
  ok_pressed=FALSE;

  cancel_button = gtk_button_new_with_label ("Cancel");
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (action_area), cancel_button, TRUE, TRUE, 0);
  gtk_widget_show (cancel_button);

  /* connect signals */
  gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             (gpointer) window);

  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (end_ok),
                             (gpointer) entry);
  gtk_signal_connect_object (GTK_OBJECT (entry), "activate",
                             GTK_SIGNAL_FUNC (end_ok),
                             (gpointer) entry);


  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (mw_destroy),
                      (gpointer)window);

  /* Show widgets */

  gtk_widget_show_all (window);

  /* wait until dialog get destroyed */
  gtk_main();
  if (GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
  edit_busy=FALSE;
  return return_value;
}
