//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.


// Declarations:


// Code:

// Demo file for US76 atmosphere model
// Use gp_atmUS76 to reproduce temperature,
// pressure and density plots (help figure)

Z = 0:50:100e3;       //altitude in meters (1000km is the limit of validity of US76 model, we plot to 100km)
[T,P,D] = CL_mod_atmUS76(Z);

Z = Z/1000; //convert to km to plot
P = P/1000;  //convert to kilo pascals to plot

//PLOT
f = scf();
f.immediate_drawing="off";
f.visible = "off"; 

//TEMPERATURE
subplot(1,3,1);
plot2d(T,Z,2);
a = gca();
a.x_label.text = 'Temperature [K]';
a.y_label.text = 'Altitude [km]';
a.data_bounds = [min(T),min(Z);max(T),max(Z)];

//PRESSURE
subplot(1,3,2);
plot2d(P,Z,2);
a = gca();
a.x_label.text = 'Pressure [KPa]';
a.y_label.text = 'Altitude [km]';
a.data_bounds = [min(P),min(Z);max(P),max(Z)];
a.title.text = 'The 1976 US Standard atmosphere model';
a.title.font_size = 2;

//DENSITY
subplot(1,3,3);
plot2d(D,Z,2);
a = gca();
a.x_label.text = 'Density [kg/m3]';
a.y_label.text = 'Altitude [km]';
a.data_bounds = [min(D),min(Z);max(D),max(Z)];

for i=1:3
  a=gca();
  subplot(1,3,i);
  a.box = "on"; 
  a.sub_ticks = [0,0];
  a.grid = [1,1];
  a.title.font_size = 2;
  a.x_label.font_size = 1;
  a.y_label.font_size = 1;
  a.margins = [0.25,0.05,0.1,0.1];
  a.children.children.thickness = 2;
end

f.immediate_drawing="on";
f.visible = "on"; 

