//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function  [angle] = CL__sc2angle(x,y)
// Sinus and cosinus to angle
//
// Calling Sequence
// [angle] = CL__sc2angle(x,y)
//
// Description
// <itemizedlist><listitem>
// calculates an angle given its cosinus <emphasis role="bold">x</emphasis> and sinus <emphasis role="bold">y</emphasis>.
// </listitem>
// </itemizedlist>
//
// Parameters
// x: cosinus (1xN)
// y: sinus (1xN)
// angle: angle with cos(angle)=x and sin(angle)=y. (1xN) [rad]
//
// Authors
// CNES - DCT/SB
//
// Bibliography
// 1 CNES - MSLIB FORTRAN 90, Volume U (mu_angle2)
//
// Examples
// angle = CL__sc2angle(cos(%pi/4),sin(%pi/4))
//

// Declarations:


// Code:

// Renvoie 0 si x et y sont simultanément nuls
angle = CL_rMod(atan(y, x),0,2*%pi);

endfunction
