/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_change_user(char * fname)
{
  int * sql_pointer_in = NULL;
  int * user = NULL;
  int * password = NULL;
  int * db = NULL;
  char * cuser = NULL, * cpassword = NULL, * cdb = NULL;
  MYSQL * mysql_ptr = NULL;
  void * ptr_in = NULL;
  SciErr _SciErr;
  double result;

  CheckRhs(4,4);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
  getPointer(pvApiCtx, sql_pointer_in, &ptr_in);
  mysql_ptr = (MYSQL *)ptr_in;

  if (mysql_ptr==NULL)
    {
      Scierror(999,"%s: problem with the mysql pointer\n", fname);
      return 0;
    }

  _SciErr = getVarAddressFromPosition(pvApiCtx, 2, &user);
  getAllocatedSingleString(pvApiCtx, user, &cuser);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &password);
  getAllocatedSingleString(pvApiCtx, password, &cpassword);

  if (Rhs>=4)
    {

      _SciErr = getVarAddressFromPosition(pvApiCtx, 4, &db);
      if (!isEmptyMatrix(pvApiCtx, db))
	{
	  getAllocatedSingleString(pvApiCtx, db, &cdb);
	}
      else
	{
	  cdb = NULL;
	}
    }
  else
    {
      cdb = NULL;
    }

  result = (double)mysql_change_user(mysql_ptr, cuser, cpassword, cdb);

  createScalarDouble(pvApiCtx, Rhs+1, result);

  LhsVar(1) = Rhs + 1;

  if (cuser)     freeAllocatedSingleString(cuser);
  if (cpassword) freeAllocatedSingleString(cpassword);
  if (cdb)       freeAllocatedSingleString(cdb);

  return 0;
}
