/** @file scim_rawcode_imengine.h
 * definition of RawCode related classes.
 */

/* 
 * Smart Common Input Method
 * 
 * Copyright (c) 2002 James Su <suzhe@turbolinux.com.cn>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_rawcode_imengine.h,v 1.2 2004/06/12 11:05:17 suzhe Exp $
 */

#if !defined (__SCIM_RAWCODE_SERVER_H)
#define __SCIM_RAWCODE_SERVER_H

using namespace scim;

class RawCodeFactory : public IMEngineFactoryBase
{
    WideString m_name;

    friend class RawCodeInstance;

public:
    RawCodeFactory ();
    RawCodeFactory (const WideString & name, const String & languages);
    virtual ~RawCodeFactory ();

    virtual WideString  get_name () const;
    virtual WideString  get_authors () const;
    virtual WideString  get_credits () const;
    virtual WideString  get_help () const;
    virtual String      get_uuid () const;
    virtual String      get_icon_file () const;
    virtual String      get_language () const;

    virtual IMEngineInstancePointer create_instance (const String& encoding, int id = -1);

private:
    int get_maxlen (const String &encoding);
};

class RawCodeInstance : public IMEngineInstanceBase
{
    Pointer <RawCodeFactory> m_factory;

    CommonLookupTable m_lookup_table;
    WideString        m_preedit_string;

    Property          m_status_property;

    bool              m_unicode;
    bool              m_forward;
    bool              m_focused;

    unsigned int      m_max_preedit_len;

    IConvert m_iconv;

public:
    RawCodeInstance (RawCodeFactory *factory,
                     const String& encoding,
                     int id = -1);
    virtual ~RawCodeInstance ();

    virtual bool process_key_event (const KeyEvent& key);
    virtual void move_preedit_caret (unsigned int pos);
    virtual void select_candidate (unsigned int item);
    virtual void update_lookup_table_page_size (unsigned int page_size);
    virtual void lookup_table_page_up ();
    virtual void lookup_table_page_down ();
    virtual void reset ();
    virtual void focus_in ();
    virtual void focus_out ();
    virtual void trigger_property (const String &property);

private:
    int create_lookup_table (int start = 0);
    void process_preedit_string ();

    void initialize_properties ();
    void refresh_status_property ();

    String get_multibyte_string (const WideString& preedit);
    ucs4_t get_unicode_value (const WideString& preedit);
};

#endif
/*
vi:ts=4:nowrap:ai:expandtab
*/

