'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH Tnm::syslog n "April 1999" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tnm::syslog \- Write messages to the system logger.

.SH DESCRIPTION
The Tnm::syslog command writes messages to the local system logging
facility.  On Unix platforms, the message is written to the syslog
daemon. On Windows platforms, the message is written to the Windows
event logging facility.

Every message has an associated priority level. Allowed
priority levels are:
.TP 16
.SB emergency
A panic condition.  This is normally broadcast to all users.
.TP
.SB alert
A condition that should be corrected immediately,
such as a corrupted system database.
.TP
.SB critical
Critical conditions, such as hard device errors.
.TP
.SB error
Errors messages.
.TP
.SB warning
Warning messages.
.TP
.SB notice
Conditions that are not error conditions,
but that may require special handling.
.TP
.SB info
Informational messages.
.TP
.SB debug
Messages that contain information
normally of use only when debugging a program.
.PP
Not all system logging facilities support all priority levels. The Tnm
extension will automatically convert the priorities listed above into
levels understood by the local system logging facility if needed.

.SH DNS COMMAND
.TP
\fBTnm::syslog\fR [\fIoptions\fR]
Invoking the \fBTnm::syslog\fR command with options but without any
command arguments allows to retrieve and change the default
values. See the description of supported options below. Default values
are bound to a Tcl interpreter which allows to have multiple Tcl
interpreter with different defaults.

.TP
\fBTnm::syslog\fR [\fIoptions\fR] \fIlevel\fR \fImessage\fR
The \fBTnm::syslog\fR command writes a \fImessage\fR to the system
logging facility. Further processing of the message depends on the
priority \fIlevel\fR of the message and the configuration of the
system logging facility.

.SH SYSLOG OPTIONS
.TP
.BI "-ident " string
The \fB-ident\fR option defines the identification \fIstring\fR of the
event source. The default value is the string \fIscotty\fR.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
